sort_the_traits <- function (phylotree,traits_to_sort){
  
  # there is a problem with function sort() when working with species id of the shape "t33"  
  id_species_withT <- phylotree$tip.label
  species_id_numbersOnly <- NULL
  for(i in 1:length(phylotree$tip.label)){
    
    all_species_id <- strsplit(id_species_withT,split="t")
    species_id_numbersOnly <- c(species_id_numbersOnly,as.numeric(all_species_id[[i]][2]))
  }
  species_id_new <- NULL
  for(i in 1:length(phylotree$tip.label)){
    species_id_new <- c(species_id_new, paste0("t",sort(species_id_numbersOnly)[i]))
  }
  
  table_traits_sp <- as.data.frame(cbind(species_id_new,traits_to_sort))
  
  
  sorted_traits <- table_traits_sp[order(match(table_traits_sp$species_id_new,id_species_withT)),]
  

  return(as.character(sorted_traits$traits_to_sort))
}

prepare_q_matrix <- function(all_area_combination,matrices_names,q_expansion,q_contraction){
  qs <- matrix(0,ncol=ncol(all_area_combination),nrow = ncol(all_area_combination))
  for(iji in 1:ncol(all_area_combination)){
    
    taken_sub_area <- all_area_combination[,iji]
    
    if(iji != ncol(all_area_combination)){
      taken_sub_area <- taken_sub_area[-which(is.na(taken_sub_area))]
    }
    
    for(ij in 1:ncol(all_area_combination)){
      vector_all_area_combination <- all_area_combination[,ij]
      
      if(ij != ncol(all_area_combination)){
        vector_all_area_combination <-
          vector_all_area_combination[-which(is.na(vector_all_area_combination))]
        
      }
      
      if(length(taken_sub_area) == (length(vector_all_area_combination)-1)){
        matches <- 0
        for(jj in 1:length(taken_sub_area)){
          
          if(any(taken_sub_area[jj]==vector_all_area_combination)){
            matches <- matches + 1
          }
        }
        
        if(matches == length(taken_sub_area)){
          
          state_id_complement1 <- find_stateID(vector_all_area_combination,all_area_combination)
          state_id_complement2 <- find_stateID(taken_sub_area,all_area_combination)
          qs[state_id_complement1,state_id_complement2] <- q_expansion
          qs[state_id_complement2,state_id_complement1] <- q_contraction
          
        } 
        
      }
    }
  }
  
  colnames(qs) <- matrices_names
  rownames(qs) <- matrices_names
  diag(qs) <- NA
  return(qs)
}







prepare_full_lambdas_vicariance <- function (areas,id_rate_anagenetic,id_rate_cladogenetic){
  all_matrices <- list()
  
  all_area_combination <- NULL
  for(i in 1:length(areas)){
    combination_from_function <- combn(areas,i)
    all_area_combination <- cbind(all_area_combination,combination_from_function)
    all_area_combination <- rbind(all_area_combination,NA)
    
  }
  all_area_combination <- all_area_combination[-nrow(all_area_combination),]
  
  
  all_area_combination
  matrices_names <- NULL
  for( i in 1: (ncol(all_area_combination)-1)){
    matrices_names <- c(matrices_names,paste0(all_area_combination[,i][-which(is.na(all_area_combination[,i]))],
                                              collapse=""))
    
  }
  matrices_names <- c(matrices_names,paste0(all_area_combination[,ncol(all_area_combination)],
                                            collapse=""))
  
  
  
  for (i in 1:ncol(all_area_combination)){
    
    one_lambda <- matrix(0,ncol=ncol(all_area_combination),nrow = ncol(all_area_combination))
    
    state <- all_area_combination[,i]
    if (i == nrow(one_lambda)){ # it is the cosmopolitan state
      state_No_NA <- state
      
    } else {
      state_No_NA <- state[-which(is.na(state))]
    }
    number_regions_state <-  length(state_No_NA)
    if(number_regions_state == 1){ 
      
      state_id_taken_sub_area <- find_stateID(state_No_NA,all_area_combination) 
      
      one_lambda[state_id_taken_sub_area,state_id_taken_sub_area] <- id_rate_anagenetic
      
    }
    if(number_regions_state > 1){
      
      sub_area_combination <- NULL
      for(ii in 1:(length(state_No_NA) - 1)){
        subcombination_from_function <- combn(state_No_NA,ii)
        sub_area_combination <- cbind(sub_area_combination,subcombination_from_function)
        sub_area_combination <- rbind(sub_area_combination,NA)
        
      }
      #sub_area_combination <- sub_area_combination[-nrow(sub_area_combination),]
      
      for(iii in 1:ncol(sub_area_combination)){
        
        taken_sub_area <- sub_area_combination[,iii]
        
        taken_sub_area <- taken_sub_area[-which(is.na(taken_sub_area))]
        
        all_complement_areas <- unique(c(taken_sub_area,state_No_NA))
        
        complementary_area <-  all_complement_areas[(length(taken_sub_area) + 1):length(all_complement_areas)]
        
        state_id_complement <- find_stateID(complementary_area,all_area_combination)
        state_id_taken_sub_area <- find_stateID(taken_sub_area,all_area_combination)
        one_lambda[state_id_complement,state_id_taken_sub_area] <- id_rate_cladogenetic 
        
      }
    }
    colnames(one_lambda) <- matrices_names
    rownames(one_lambda) <- matrices_names
    
    
    one_lambda[lower.tri(one_lambda)] <- 0
    
    
    all_matrices[[i]]  <- one_lambda
    
  }
  
  
  names(all_matrices) <- matrices_names
  return(list(all_matrices = all_matrices,
              matrices_names = matrices_names,
              all_area_combination = all_area_combination))
  
}





find_stateID <- function(region_to_compare,all_area_combination){
  
  if(length(region_to_compare)==nrow(all_area_combination)){# it is the cosmopolitan state
    state_id <- ncol(all_area_combination)
  } else {
    
    for( i in 1:ncol(all_area_combination)){
      the_state_No_NA <- all_area_combination[,i]
      the_state_No_NA <- the_state_No_NA[-which(is.na(the_state_No_NA))]
      if(length(the_state_No_NA)==length(region_to_compare)){
        
        if(all(sort(region_to_compare) == sort(the_state_No_NA))){
          state_id <- i
        }
        
      }
    }
  }
  return(state_id)
  
}


give_table_nodes_full_reconst <- function(phylotree_full,phylotree_recons,table_ancestral_area_artificial){
  survivor_species <- NULL
  
  for(j in 1:length(phylotree_full$tip.label)){
    if(any(phylotree_full$tip.label[j] == phylotree_recons$tip.label)){
      survivor_species <- c(survivor_species,phylotree_full$tip.label[j])
    }
  }
  length(survivor_species)
  
  phy2 <- phylobase::phylo4(phylotree_full)
  id_internal_nodes <- as.vector(table_ancestral_area_artificial[order(table_ancestral_area_artificial$branching.times.phy_artificial.,decreasing = TRUE),1])
  subclade_size <- NULL
  node_full <- NULL
  node_recons <- NULL
  ancens_real_full <- NULL
  for(i in 1:length(id_internal_nodes)){
    internal_node_focal_full <- as.numeric(id_internal_nodes[i])
    
    all_children <- sort(get.descendants(phy2, internal_node_focal_full))
    
    survivor_children <- NULL
    for(ij in 1:length(all_children)){
      if(any(all_children[ij] == survivor_species)){
        survivor_children <- c(survivor_children,all_children[ij])
      } 
      
    }
    # cat("survi: ",length(survivor_children),"\n")
    
    if(length(survivor_children) > 1){ 
      # some nodes produces subclades that all members went extinct. Or, one survival cannot be compared to 
      # any node of the reconstructed one.
      
      node_full <- c(node_full,internal_node_focal_full)  
      node_recons <- c(node_recons,getMRCA(phylotree_recons, survivor_children))
      ancens_real_full <- c(ancens_real_full,
                            table_ancestral_area_artificial[which(internal_node_focal_full == table_ancestral_area_artificial$the_nodes),3])
      
    }
    
  }
  
  table_nodes_full_recons <- data.frame(node_full,node_recons,ancens_real_full)
  
  unique_nodes <- unique(table_nodes_full_recons$node_recons)
  
  keep_rows <- NULL
  for(i in 1:length(unique_nodes)){
    keep_rows <- c(keep_rows,which(unique_nodes[i]==table_nodes_full_recons$node_recons)[1])
    
  }
  table_nodes_full_recons <- table_nodes_full_recons[keep_rows,]
  
  
  return(table_nodes_full_recons)
  
}


