#  Example of the usage of cla_secsse_loglik. I am not sure if all those 
# packages are needed 

rm(list=ls(all=TRUE))
source("functionstoSimulateCrown.R")
source("maintoSimulateCrown.R")
source("additional_tools.R")
library(secsse)
library(DDD)
library(deSolve)
library(apTreeshape)
library(foreach)
library(phytools)
#library(gtools)
library(Matrix)
library(nodiv)
#set.seed(68)


areas <- c("A", "B", "C","D")

ancestral_state <- NULL # "ABCD" # "ABCD" # it can be NULL
rate_anagenetic <- 0.01
rate_cladogenetic <- 0.01

the_mu <- 0.005# per individual area
q_expansion <- 0.001
q_contraction <- 0.001

timeSimul <- 450
nsimul <- 1 # the number of simulations to run 



matrices <- prepare_full_lambdas_vicariance(areas,rate_anagenetic,rate_cladogenetic)
lambdas <- matrices$all_matrices
all_area_combination <- matrices$all_area_combination
matrices_names <- matrices$matrices_names
qs <- prepare_q_matrix(all_area_combination,matrices_names,q_expansion,q_contraction)
all_states <- matrices_names
states <- matrices$matrices_names
max_cycles <- 20000000
maxSpec <- 10000 


sucess <- 0
phylotrees_full <- list()
phylotrees_recons <- list()
traitdata <- list()
initialState_used <- list()
all_table_ancestral_area_artificial <- list()
all_Ltable_and_traits <- list()
while(length(phylotrees_recons) < nsimul){
  simulDATA <- Cla_SecSSE_simul(ancestral_state,states,lambdas,the_mu,timeSimul,max_cycles,qs,maxSpec,the_traits_to_sim)
  if(class(simulDATA$phy_recons)=="phylo"){
    sucess <- sucess+1
    phylotrees_full[[sucess]]<-simulDATA$phy_full
    phylotrees_recons[[sucess]]<-simulDATA$phy_recons
    traitdata[[sucess]]<-simulDATA$speciesTraits
    initialState_used[[sucess]]<-simulDATA$initialState
    all_Ltable_and_traits[[sucess]] <- simulDATA$Ltable_and_traits
    all_table_ancestral_area_artificial [[sucess]] <- simulDATA$table_ancestral_area_artificial
    cat("we have so far",sucess,"complete datasets","\n")
  }
  
}
simulated_data <- list(phylotrees_full = phylotrees_full,
                       phylotrees_recons = phylotrees_recons,
                       traitdata = traitdata,
                       initialState_used = initialState_used,
                       all_Ltable_and_traits=all_Ltable_and_traits,
                       all_table_ancestral_area_artificial = all_table_ancestral_area_artificial)


saveRDS(simulated_data, paste0("data_simulated.RDS"))






Ltable_and_traits <- simulDATA$Ltable_and_traits
phylotree_full <- simulDATA$phy_full
phylotree_recons <- simulDATA$phy_recons
species_presence <- simulDATA$speciesTraits
table_ancestral_area_artificial <- simulDATA$table_ancestral_area_artificial




simulated_data <- readRDS("data_simulated.RDS")


for(ijk in 1:4){
   phylotree_full <- simulated_data$phylotrees_full[[ijk]]
  phylotree_recons <- simulated_data$phylotrees_recons[[ijk]]
  species_presence <- simulated_data$traitdata[[ijk]]
  initialState_used <- simulated_data$initialState_used[[ijk]]
 Ltable_and_traits <- simulated_data$all_Ltable_and_traits[[ijk]]
  table_ancestral_area_artificial <- simulated_data$all_table_ancestral_area_artificial[[ijk]]
  
  


phylotree <- phylotree_recons


the_nodes <- names(branching.times(phylotree))
table_ancestral_area <- data.frame(the_nodes,branching.times(phylotree),ances_state = NA)
for(i in 1:nrow(table_ancestral_area)){
  
  if(any(round(table_ancestral_area[i,2],digits = 5) ==round(Ltable_and_traits[,1],digits = 5))){
    anc_state <- Ltable_and_traits[which(round(table_ancestral_area[i,2],digits = 5) ==round(Ltable_and_traits[,1],digits = 5)),5]
      table_ancestral_area[i,3] <- as.character(anc_state)
    } 
}



plot.phylo(phylotree,edge.color = "gray54",font = 1,cex = 0.3,
           label.offset = 1,no.margin = TRUE,edge.width = 2.2, main=paste(ijk))

tiplabels(species_presence)
nodelabels(table_ancestral_area$ances_state)



### FULL tree




plot.phylo(phylotree_full,edge.color = "gray54",font = 1,cex = 0.3,
           label.offset = 1,no.margin = TRUE,edge.width = 2.2)


species_presence_extinction_included <- NULL
for(i in 1:length(phylotree_full$tip.label)){
 if(any(phylotree_full$tip.label[i]==phylotree_recons$tip.label)){ 
   
   species_presence_extinction_included <- c(species_presence_extinction_included,
                                             species_presence[which(phylotree_full$tip.label[i]==phylotree_recons$tip.label)])
 } else{
   
   species_presence_extinction_included <- c(species_presence_extinction_included,"extinct")
 }
  
}


species_presence_extinction_included


tiplabels(species_presence_extinction_included)
nodelabels(table_ancestral_area_artificial$ances_state)

}
  
  
  
  
  
 
###############################################












# here, I artificially create a phylogeny like there were no extinction. This is to get the ancestral node state


# extinct_to_remove_fromartificial <- NULL
# for(i in 1:nrow(table_ancestral_area_artificial)){
#      line_see_extinct <- which(round(table_ancestral_area_artificial[i,2],digits = 5) == round(Ltable_and_traits[,1],digits = 5))
#      cat(line_see_extinct,"\n")
#     if(Ltable_and_traits[line_see_extinct,4]!= -1){
#       cat("here")
#       extinct_to_remove_fromartificial <- c(extinct_to_remove_fromartificial,i)
#     }
#       
# }
# 
# table_ancestral_area_artificial <- table_ancestral_area_artificial[-extinct_to_remove_fromartificial,]
# 


