library(secsse)
library(ape)
library(geiger)
library(BioGeoBEARS)
library(ape)
library(phytools)
library(stringr)
library(deSolve)
library(apTreeshape)
library(phytools)
library(Matrix)
library(lemad)
library(DDD)
library(phylocanvas)
library(phylobase)
library(nodiv)
try_this_extinction <- 0.005



output <- readRDS(file=paste0("lemad_ext_",try_this_extinction,".RDS"))
amazilia_tree <- read.tree("humm_phylo.nex")


amazilia_distribution <- read.csv(file="humm_distribution.csv")


single_otu <- amazilia_distribution$species

to_remove_tree <- NULL
for(i in 1:length(amazilia_tree$tip.label)){
  
  if(any(amazilia_tree$tip.label[i] == single_otu) == FALSE ){
    to_remove_tree <- c(to_remove_tree,amazilia_tree$tip.label[i])
  }
}

amazilia_tree <- drop.tip(amazilia_tree,to_remove_tree)
amazilia_distribution$region <- toupper(amazilia_distribution$region)

amazilia_distribution <- amazilia_distribution[order(match(amazilia_distribution$species,amazilia_tree$tip.label)),]

(amazilia_distribution$species) == (amazilia_tree$tip.label)


probabilities_at_node <- output$ancestral_states

all_areas <- c("A","B","C")

all_states <- give_me_states_combination(all_areas,num_max_multiregion = 3)
highest_prob_state_lemad <- NULL
for(ij in 1:nrow(probabilities_at_node)){
  
  id_order_state_highest <- which(max(probabilities_at_node[ij,])==probabilities_at_node[ij,])[1]
  # cat(id_order_state_highest,"\n")
  highest_prob_state_lemad <- c(highest_prob_state_lemad,all_states[id_order_state_highest])
}


tip_state <- as.character(amazilia_distribution$region)

colors_for_tips <- NULL
for(i in 1:length(tip_state)){
  
  if(tip_state[i] == "A"){
    colors_for_tips <- c(colors_for_tips,"darkolivegreen")
  }
  
  if(tip_state[i] == "B"){
    colors_for_tips <- c(colors_for_tips,"blue2")
  }
  if(tip_state[i] == "C"){
    colors_for_tips <- c(colors_for_tips,"darkorange")
  }
  if(tip_state[i] == "AB"){
    colors_for_tips <- c(colors_for_tips,"deeppink")
  }
  if(tip_state[i] == "AC"){
    colors_for_tips <- c(colors_for_tips,"cadetblue4")
  }
  if(tip_state[i] == "BC"){
    colors_for_tips <- c(colors_for_tips,"aquamarine3")
  }
  if(tip_state[i] == "ABC"){
    colors_for_tips <- c(colors_for_tips,"black")
  }
  
}


colors_for_nodes <- NULL
for(i in 1:length(highest_prob_state_lemad)){
  
  if(highest_prob_state_lemad[i] == "A"){
    colors_for_nodes <- c(colors_for_nodes,"darkolivegreen")
  }
  
  if(highest_prob_state_lemad[i] == "B"){
    colors_for_nodes <- c(colors_for_nodes,"blue2")
  }
  if(highest_prob_state_lemad[i] == "C"){
    colors_for_nodes <- c(colors_for_nodes,"darkorange")
  }
  if(highest_prob_state_lemad[i] == "AB"){
    colors_for_nodes <- c(colors_for_nodes,"deeppink")
  }
  if(highest_prob_state_lemad[i] == "AC"){
    colors_for_nodes <- c(colors_for_nodes,"cadetblue4")
  }
  if(highest_prob_state_lemad[i] == "BC"){
    colors_for_nodes <- c(colors_for_nodes,"aquamarine3")
  }
  if(highest_prob_state_lemad[i] == "ABC"){
    colors_for_nodes <- c(colors_for_nodes,"black")
  }
  
}
par(mar = c(2, .2, .2, .2))
fake_letters <- rep("A",65)
plot.phylo(amazilia_tree,show.tip.label = TRUE,cex=0.7,label.offset=0.7)
nodelabels(fake_letters,bg = colors_for_nodes,
           frame="circle",cex=0.7,col=colors_for_nodes)
fake_letters2 <- rep("A",66)
tiplabels(fake_letters2,bg = colors_for_tips,
           frame="circle",cex=0.7,col=colors_for_tips)
title(paste0("Lemad ext_",try_this_extinction),cex.main=2)
axisPhylo(side = 1, root.time = NULL, backward = TRUE)

#nodelabels(highest_prob_state_lemad,bg = "lightgreen",cex=0.9)






#tiplabels(amazilia_distribution$region,bg = "lightgreen",cex=0.4)
#abline(v=15, lty=3,lwd=3,col="red")
#abline(h=15, lty=3,lwd=3,col="red")
#points(14.5,48,col="red",pch=18,cex=4)


# for DIvalike
divalike <- readRDS("divalike_amazilia.RDS")
colors_for_nodes_diva <- NULL
for(i in 1:length(divalike)){
  
  if(divalike[i] == "A"){
    colors_for_nodes_diva <- c(colors_for_nodes_diva,"darkolivegreen")
  }
  
  if(divalike[i] == "B"){
    colors_for_nodes_diva <- c(colors_for_nodes_diva,"blue2")
  }
  if(divalike[i] == "C"){
    colors_for_nodes_diva <- c(colors_for_nodes_diva,"darkorange")
  }
  if(divalike[i] == "AB"){
    colors_for_nodes_diva <- c(colors_for_nodes_diva,"deeppink")
  }
  if(divalike[i] == "AC"){
    colors_for_nodes_diva <- c(colors_for_nodes_diva,"cadetblue4")
  }
  if(divalike[i] == "BC"){
    colors_for_nodes_diva <- c(colors_for_nodes_diva,"aquamarine3")
  }
  if(divalike[i] == "ABC"){
    colors_for_nodes_diva <- c(colors_for_nodes_diva,"black")
  }
  
}

par(mar = c(2, .2, .2, .2))
fake_letters <- rep("A",65)
plot.phylo(amazilia_tree,direction = "leftwards",show.tip.label = TRUE,cex=0.7,label.offset=0.7)
nodelabels(fake_letters,bg = colors_for_nodes_diva,
           frame="circle",cex=0.7,col=colors_for_nodes_diva)
fake_letters2 <- rep("A",66)
tiplabels(fake_letters2,bg = colors_for_tips,
          frame="circle",cex=0.7,col=colors_for_tips)
title(paste0("DIVA"),cex.main=2)
axisPhylo(side = 1, root.time = NULL, backward = TRUE)


###' map
###' 
###' library(rworldmap)
## produce the world map
map(interior = FALSE)
## list of countries per continent
SA <- c("argentina", "bolivia", "brazil", "chile", "colombia", "ecuador", "guyana", "paraguay", "peru", "suriname", "uruguay", "venezuela")
SA2 <- c("usa","canada","mexico")
SA3 <- c("costarica","guatemala","panama","nicaragua","belice","elsalvador","honduras")
map(regions = SA, fill=TRUE, add=TRUE,col="darkolivegreen")
map(regions = SA2, fill=TRUE, add=TRUE,col="darkorange")
map(regions = SA3, fill=TRUE, add=TRUE,col="blue2")

#### Legend

plot(0,xlim=c(-0.5,2),ylim=c(0.5,2))

segments(x0 = 1, y0=1.5, x1 = 1.2, y1 = 1.5,col="darkolivegreen",lwd=8)
segments(x0 = 1, y0=1.4, x1 = 1.2, y1 = 1.4,col="blue2",lwd=8)
segments(x0 = 1, y0=1.3, x1 = 1.2, y1 = 1.3,col="darkorange",lwd=8)
segments(x0 = 1, y0=1.2, x1 = 1.2, y1 = 1.2,col="deeppink",lwd=8)
segments(x0 = 1, y0=1.1, x1 = 1.2, y1 = 1.1,col="cadetblue4",lwd=8)
segments(x0 = 1, y0=1, x1 = 1.2, y1 = 1,col="aquamarine3",lwd=8)
segments(x0 = 1, y0=0.9, x1 = 1.2, y1 = .9,col="black",lwd=8)





text(1.3,1.5,"A: South America",adj = 0)
text(1.3,1.4,"B: Mesoamerica",adj = 0)
text(1.3,1.3,"C: North America",adj = 0)
text(1.3,1.2,"AB",adj = 0)
text(1.3,1.1,"AC",adj = 0)
text(1.3,1,"BC",adj = 0)
text(1.3,0.9,"ABC",adj = 0)
