### Auswertung Fortüne ###

# Dieses Script liest eine CSV-Datendatei in GNU R ein.
# Beim Einlesen werden für alle Variablen Beschriftungen (comment) angelegt.
# Die Beschriftungen für Werte wird ebenfalls als Attribute (attr) abgelegt.

ds_file = file.choose()
# setwd("/Users/martadrujan/Documents/Projekt Fortüne/Auswertung/neu")
# ds_file = "rdata_fortuene_2021-08-12_11-41.csv"

ds = read.table(
  file=ds_file, encoding="UTF-8",
  header = FALSE, sep = "\t", quote = "\"",
  dec = ".", row.names = "CASE",
  col.names = c(
    "CASE","SERIAL","REF","QUESTNNR","MODE","STARTED","AD02_01","AD02_02","AD02_03",
    "AD02_04","AD02_05","AD02_06","AD02_07","AD02_08","AD02_09","AD02_10","AD02_11",
    "AD02_12","AD02_13","AD02_14","AD02_15","AD02_16","AD02_17","AD02_18","AD02_19",
    "AD02_20","SD01","SD03_01","SD04_01","TA02_01","TA02_02","TA02_03","TA02_04",
    "TA02_05","TA02_06","TA02_07","TA02_08","TA02_09","TA02_10","TA02_11","TA02_12",
    "TA02_13","TA02_14","TA02_15","TA02_16","TA02_17","TA02_18","TA02_19","TA02_20",
    "TA02_21","TA02_22","TA02_23","TA02_24","TA02_25","TA02_26","TA02_27","TA02_28",
    "TA02_29","TA02_30","TA02_31","TA02_32","TA02_33","TA02_34","NM01_01","NM01_02",
    "NM01_03","NM01_04","NM01_05","NM01_06","NM01_07","NM01_08","NM01_09","NM01_10",
    "NM01_11","NM01_12","NM01_13","NM01_14","NM01_15","NM01_16","NM01_17","NM01_18",
    "NM01_19","NM01_20","NM01_21","NM01_22","NM01_23","NM01_24","NM01_25","NM01_26",
    "NM01_27","NM01_28","NM01_29","NM01_30","P001_01","P001_02","P001_03","P001_04",
    "P001_05","P001_06","P001_07","P001_08","P001_09","P001_10","P001_11","P001_12",
    "P001_13","P001_14","P001_15","P001_16","P001_17","P001_18","P001_19","P001_20",
    "P001_21","P001_22","P001_23","P001_24","P001_25","P001_26","P001_27","P102_01",
    "P102_02","P102_03","P102_04","P102_05","P102_06","P102_07","P102_08","P102_09",
    "P102_10","P102_11","P102_12","P102_13","P102_14","P102_15","P102_16","P102_17",
    "P102_18","P102_19","P102_20","P102_21","P102_22","P102_23","P102_24","P102_25",
    "P102_26","P102_27","P201_01","P201_02","P201_03","P201_04","P201_05","P201_06",
    "P201_07","P201_08","P201_09","P201_10","P201_11","P201_12","P201_13","P201_14",
    "P201_15","P201_16","P201_17","P201_18","P201_19","P201_20","P201_21","P201_22",
    "P201_23","P201_24","P201_25","P201_26","P201_27","SM01_01","SM01_02","SM01_03",
    "SM01_04","SM01_05","SM01_06","SM01_07","KF01_01","KF04_01","KF06_01","KF07_01",
    "KF02","KF02x01","KF02x02","KF02x03","KF02x04","KF02x05","KF05","KF05x01",
    "KF05x02","KF05x03","KF05x04","KF05x05","KF03","KF03_01","KF03_02","KF03_03",
    "KF03_04","IF01_01","IF02","IF02x01","IF02x02","IF02x03","IF02x04","IF02x05",
    "IF03","IF03_01","IF03_02","IF03_03","IF03_04","IF04_01","IF05","IF05x01",
    "IF05x02","IF05x03","IF05x04","IF05x05","IF06_01","IF07_01","IF08_01","RU02_01",
    "RU03_01","RA01_CP","RA01","FW01_01","FW02_01","FW03_01","FW04_01","FW05_01",
    "FW06_01","FW07_01","FW08_01","FW09_01","FW10_01","FW11_01","FW12_01","FW13_01",
    "FW14_01","FW15_01","VP01_01","TIME001","TIME002","TIME003","TIME004","TIME005",
    "TIME006","TIME007","TIME008","TIME009","TIME010","TIME011","TIME012","TIME013",
    "TIME014","TIME015","TIME016","TIME_SUM","MAILSENT","LASTDATA","FINISHED",
    "Q_VIEWER","LASTPAGE","MAXPAGE","MISSING","MISSREL","TIME_RSI","DEG_TIME"
  ),
  as.is = TRUE,
  colClasses = c(
    CASE="numeric", SERIAL="character", REF="character", QUESTNNR="character",
    MODE="factor", STARTED="POSIXct", AD02_01="numeric", AD02_02="numeric",
    AD02_03="numeric", AD02_04="numeric", AD02_05="numeric", AD02_06="numeric",
    AD02_07="numeric", AD02_08="numeric", AD02_09="numeric", AD02_10="numeric",
    AD02_11="numeric", AD02_12="numeric", AD02_13="numeric", AD02_14="numeric",
    AD02_15="numeric", AD02_16="numeric", AD02_17="numeric", AD02_18="numeric",
    AD02_19="numeric", AD02_20="numeric", SD01="numeric", SD03_01="numeric",
    SD04_01="character", TA02_01="numeric", TA02_02="numeric",
    TA02_03="numeric", TA02_04="numeric", TA02_05="numeric", TA02_06="numeric",
    TA02_07="numeric", TA02_08="numeric", TA02_09="numeric", TA02_10="numeric",
    TA02_11="numeric", TA02_12="numeric", TA02_13="numeric", TA02_14="numeric",
    TA02_15="numeric", TA02_16="numeric", TA02_17="numeric", TA02_18="numeric",
    TA02_19="numeric", TA02_20="numeric", TA02_21="numeric", TA02_22="numeric",
    TA02_23="numeric", TA02_24="numeric", TA02_25="numeric", TA02_26="numeric",
    TA02_27="numeric", TA02_28="numeric", TA02_29="numeric", TA02_30="numeric",
    TA02_31="numeric", TA02_32="numeric", TA02_33="numeric", TA02_34="numeric",
    NM01_01="numeric", NM01_02="numeric", NM01_03="numeric", NM01_04="numeric",
    NM01_05="numeric", NM01_06="numeric", NM01_07="numeric", NM01_08="numeric",
    NM01_09="numeric", NM01_10="numeric", NM01_11="numeric", NM01_12="numeric",
    NM01_13="numeric", NM01_14="numeric", NM01_15="numeric", NM01_16="numeric",
    NM01_17="numeric", NM01_18="numeric", NM01_19="numeric", NM01_20="numeric",
    NM01_21="numeric", NM01_22="numeric", NM01_23="numeric", NM01_24="numeric",
    NM01_25="numeric", NM01_26="numeric", NM01_27="numeric", NM01_28="numeric",
    NM01_29="numeric", NM01_30="numeric", P001_01="numeric", P001_02="numeric",
    P001_03="numeric", P001_04="numeric", P001_05="numeric", P001_06="numeric",
    P001_07="numeric", P001_08="numeric", P001_09="numeric", P001_10="numeric",
    P001_11="numeric", P001_12="numeric", P001_13="numeric", P001_14="numeric",
    P001_15="numeric", P001_16="numeric", P001_17="numeric", P001_18="numeric",
    P001_19="numeric", P001_20="numeric", P001_21="numeric", P001_22="numeric",
    P001_23="numeric", P001_24="numeric", P001_25="numeric", P001_26="numeric",
    P001_27="numeric", P102_01="numeric", P102_02="numeric", P102_03="numeric",
    P102_04="numeric", P102_05="numeric", P102_06="numeric", P102_07="numeric",
    P102_08="numeric", P102_09="numeric", P102_10="numeric", P102_11="numeric",
    P102_12="numeric", P102_13="numeric", P102_14="numeric", P102_15="numeric",
    P102_16="numeric", P102_17="numeric", P102_18="numeric", P102_19="numeric",
    P102_20="numeric", P102_21="numeric", P102_22="numeric", P102_23="numeric",
    P102_24="numeric", P102_25="numeric", P102_26="numeric", P102_27="numeric",
    P201_01="numeric", P201_02="numeric", P201_03="numeric", P201_04="numeric",
    P201_05="numeric", P201_06="numeric", P201_07="numeric", P201_08="numeric",
    P201_09="numeric", P201_10="numeric", P201_11="numeric", P201_12="numeric",
    P201_13="numeric", P201_14="numeric", P201_15="numeric", P201_16="numeric",
    P201_17="numeric", P201_18="numeric", P201_19="numeric", P201_20="numeric",
    P201_21="numeric", P201_22="numeric", P201_23="numeric", P201_24="numeric",
    P201_25="numeric", P201_26="numeric", P201_27="numeric", SM01_01="numeric",
    SM01_02="numeric", SM01_03="numeric", SM01_04="numeric", SM01_05="numeric",
    SM01_06="numeric", SM01_07="numeric", KF01_01="numeric", KF04_01="numeric",
    KF06_01="numeric", KF07_01="numeric", KF02="numeric", KF02x01="character",
    KF02x02="character", KF02x03="character", KF02x04="character",
    KF02x05="character", KF05="numeric", KF05x01="character",
    KF05x02="character", KF05x03="character", KF05x04="character",
    KF05x05="character", KF03="numeric", KF03_01="logical", KF03_02="logical",
    KF03_03="logical", KF03_04="logical", IF01_01="numeric", IF02="numeric",
    IF02x01="character", IF02x02="character", IF02x03="character",
    IF02x04="character", IF02x05="character", IF03="numeric", IF03_01="logical",
    IF03_02="logical", IF03_03="logical", IF03_04="logical", IF04_01="numeric",
    IF05="numeric", IF05x01="character", IF05x02="character",
    IF05x03="character", IF05x04="character", IF05x05="character",
    IF06_01="numeric", IF07_01="numeric", IF08_01="numeric", RU02_01="numeric",
    RU03_01="numeric", RA01_CP="numeric", RA01="numeric", FW01_01="character",
    FW02_01="character", FW03_01="character", FW04_01="character",
    FW05_01="character", FW06_01="character", FW07_01="character",
    FW08_01="character", FW09_01="character", FW10_01="character",
    FW11_01="character", FW12_01="character", FW13_01="character",
    FW14_01="character", FW15_01="character", VP01_01="numeric",
    TIME001="integer", TIME002="integer", TIME003="integer", TIME004="integer",
    TIME005="integer", TIME006="integer", TIME007="integer", TIME008="integer",
    TIME009="integer", TIME010="integer", TIME011="integer", TIME012="integer",
    TIME013="integer", TIME014="integer", TIME015="integer", TIME016="integer",
    TIME_SUM="integer", MAILSENT="POSIXct", LASTDATA="POSIXct",
    FINISHED="logical", Q_VIEWER="logical", LASTPAGE="numeric",
    MAXPAGE="numeric", MISSING="numeric", MISSREL="numeric", TIME_RSI="numeric",
    DEG_TIME="numeric"
  ),
  skip = 1,
  check.names = TRUE, fill = TRUE,
  strip.white = FALSE, blank.lines.skip = TRUE,
  comment.char = "",
  na.strings = ""
)

rm(ds_file)

attr(ds, "project") = "fortuene"
attr(ds, "description") = "Fortüne_ERH"
attr(ds, "date") = "2021-08-12 11:41:25"
attr(ds, "server") = "https://www.soscisurvey.de"

# Variable und Value Labels
ds$SD01 = factor(ds$SD01, levels=c("1","2","3","-9"), labels=c("männlich","weiblich","divers","[NA] nicht beantwortet"), ordered=FALSE)
attr(ds$AD02_01,"1") = "selten"
attr(ds$AD02_01,"2") = "manchmal"
attr(ds$AD02_01,"3") = "öfters"
attr(ds$AD02_01,"4") = "meistens"
attr(ds$AD02_02,"1") = "selten"
attr(ds$AD02_02,"2") = "manchmal"
attr(ds$AD02_02,"3") = "öfters"
attr(ds$AD02_02,"4") = "meistens"
attr(ds$AD02_03,"1") = "selten"
attr(ds$AD02_03,"2") = "manchmal"
attr(ds$AD02_03,"3") = "öfters"
attr(ds$AD02_03,"4") = "meistens"
attr(ds$AD02_04,"1") = "meistens"
attr(ds$AD02_04,"2") = "öfters"
attr(ds$AD02_04,"3") = "manchmal"
attr(ds$AD02_04,"4") = "selten"
attr(ds$AD02_05,"1") = "selten"
attr(ds$AD02_05,"2") = "manchmal"
attr(ds$AD02_05,"3") = "öfters"
attr(ds$AD02_05,"4") = "meistens"
attr(ds$AD02_06,"1") = "selten"
attr(ds$AD02_06,"2") = "manchmal"
attr(ds$AD02_06,"3") = "öfters"
attr(ds$AD02_06,"4") = "meistens"
attr(ds$AD02_07,"1") = "selten"
attr(ds$AD02_07,"2") = "manchmal"
attr(ds$AD02_07,"3") = "öfters"
attr(ds$AD02_07,"4") = "meistens"
attr(ds$AD02_08,"1") = "meistens"
attr(ds$AD02_08,"2") = "öfters"
attr(ds$AD02_08,"3") = "manchmal"
attr(ds$AD02_08,"4") = "selten"
attr(ds$AD02_09,"1") = "selten"
attr(ds$AD02_09,"2") = "manchmal"
attr(ds$AD02_09,"3") = "öfters"
attr(ds$AD02_09,"4") = "meistens"
attr(ds$AD02_10,"1") = "selten"
attr(ds$AD02_10,"2") = "manchmal"
attr(ds$AD02_10,"3") = "öfters"
attr(ds$AD02_10,"4") = "meistens"
attr(ds$AD02_11,"1") = "selten"
attr(ds$AD02_11,"2") = "manchmal"
attr(ds$AD02_11,"3") = "öfters"
attr(ds$AD02_11,"4") = "meistens"
attr(ds$AD02_12,"1") = "meistens"
attr(ds$AD02_12,"2") = "öfters"
attr(ds$AD02_12,"3") = "manchmal"
attr(ds$AD02_12,"4") = "selten"
attr(ds$AD02_13,"1") = "selten"
attr(ds$AD02_13,"2") = "manchmal"
attr(ds$AD02_13,"3") = "öfters"
attr(ds$AD02_13,"4") = "meistens"
attr(ds$AD02_14,"1") = "selten"
attr(ds$AD02_14,"2") = "manchmal"
attr(ds$AD02_14,"3") = "öfters"
attr(ds$AD02_14,"4") = "meistens"
attr(ds$AD02_15,"1") = "selten"
attr(ds$AD02_15,"2") = "manchmal"
attr(ds$AD02_15,"3") = "öfters"
attr(ds$AD02_15,"4") = "meistens"
attr(ds$AD02_16,"1") = "meistens"
attr(ds$AD02_16,"2") = "öfters"
attr(ds$AD02_16,"3") = "manchmal"
attr(ds$AD02_16,"4") = "selten"
attr(ds$AD02_17,"1") = "selten"
attr(ds$AD02_17,"2") = "manchmal"
attr(ds$AD02_17,"3") = "öfters"
attr(ds$AD02_17,"4") = "meistens"
attr(ds$AD02_18,"1") = "selten"
attr(ds$AD02_18,"2") = "manchmal"
attr(ds$AD02_18,"3") = "öfters"
attr(ds$AD02_18,"4") = "meistens"
attr(ds$AD02_19,"1") = "selten"
attr(ds$AD02_19,"2") = "manchmal"
attr(ds$AD02_19,"3") = "öfters"
attr(ds$AD02_19,"4") = "meistens"
attr(ds$AD02_20,"1") = "selten"
attr(ds$AD02_20,"2") = "manchmal"
attr(ds$AD02_20,"3") = "öfters"
attr(ds$AD02_20,"4") = "meistens"
attr(ds$TA02_01,"1") = "trifft... nicht"
attr(ds$TA02_01,"2") = "etwas"
attr(ds$TA02_01,"3") = "teilweise"
attr(ds$TA02_01,"4") = "überwiegend"
attr(ds$TA02_01,"5") = "...zu völlig"
attr(ds$TA02_02,"1") = "trifft... nicht"
attr(ds$TA02_02,"2") = "etwas"
attr(ds$TA02_02,"3") = "teilweise"
attr(ds$TA02_02,"4") = "überwiegend"
attr(ds$TA02_02,"5") = "...zu völlig"
attr(ds$TA02_03,"1") = "trifft... nicht"
attr(ds$TA02_03,"2") = "etwas"
attr(ds$TA02_03,"3") = "teilweise"
attr(ds$TA02_03,"4") = "überwiegend"
attr(ds$TA02_03,"5") = "...zu völlig"
attr(ds$TA02_04,"1") = "trifft... nicht"
attr(ds$TA02_04,"2") = "etwas"
attr(ds$TA02_04,"3") = "teilweise"
attr(ds$TA02_04,"4") = "überwiegend"
attr(ds$TA02_04,"5") = "...zu völlig"
attr(ds$TA02_05,"1") = "trifft... nicht"
attr(ds$TA02_05,"2") = "etwas"
attr(ds$TA02_05,"3") = "teilweise"
attr(ds$TA02_05,"4") = "überwiegend"
attr(ds$TA02_05,"5") = "...zu völlig"
attr(ds$TA02_06,"1") = "trifft... nicht"
attr(ds$TA02_06,"2") = "etwas"
attr(ds$TA02_06,"3") = "teilweise"
attr(ds$TA02_06,"4") = "überwiegend"
attr(ds$TA02_06,"5") = "...zu völlig"
attr(ds$TA02_07,"1") = "trifft... nicht"
attr(ds$TA02_07,"2") = "etwas"
attr(ds$TA02_07,"3") = "teilweise"
attr(ds$TA02_07,"4") = "überwiegend"
attr(ds$TA02_07,"5") = "...zu völlig"
attr(ds$TA02_08,"1") = "trifft... nicht"
attr(ds$TA02_08,"2") = "etwas"
attr(ds$TA02_08,"3") = "teilweise"
attr(ds$TA02_08,"4") = "überwiegend"
attr(ds$TA02_08,"5") = "...zu völlig"
attr(ds$TA02_09,"1") = "trifft... nicht"
attr(ds$TA02_09,"2") = "etwas"
attr(ds$TA02_09,"3") = "teilweise"
attr(ds$TA02_09,"4") = "überwiegend"
attr(ds$TA02_09,"5") = "...zu völlig"
attr(ds$TA02_10,"1") = "trifft... nicht"
attr(ds$TA02_10,"2") = "etwas"
attr(ds$TA02_10,"3") = "teilweise"
attr(ds$TA02_10,"4") = "überwiegend"
attr(ds$TA02_10,"5") = "...zu völlig"
attr(ds$TA02_11,"1") = "trifft... nicht"
attr(ds$TA02_11,"2") = "etwas"
attr(ds$TA02_11,"3") = "teilweise"
attr(ds$TA02_11,"4") = "überwiegend"
attr(ds$TA02_11,"5") = "...zu völlig"
attr(ds$TA02_12,"1") = "trifft... nicht"
attr(ds$TA02_12,"2") = "etwas"
attr(ds$TA02_12,"3") = "teilweise"
attr(ds$TA02_12,"4") = "überwiegend"
attr(ds$TA02_12,"5") = "...zu völlig"
attr(ds$TA02_13,"1") = "trifft... nicht"
attr(ds$TA02_13,"2") = "etwas"
attr(ds$TA02_13,"3") = "teilweise"
attr(ds$TA02_13,"4") = "überwiegend"
attr(ds$TA02_13,"5") = "...zu völlig"
attr(ds$TA02_14,"1") = "trifft... nicht"
attr(ds$TA02_14,"2") = "etwas"
attr(ds$TA02_14,"3") = "teilweise"
attr(ds$TA02_14,"4") = "überwiegend"
attr(ds$TA02_14,"5") = "...zu völlig"
attr(ds$TA02_15,"1") = "trifft... nicht"
attr(ds$TA02_15,"2") = "etwas"
attr(ds$TA02_15,"3") = "teilweise"
attr(ds$TA02_15,"4") = "überwiegend"
attr(ds$TA02_15,"5") = "...zu völlig"
attr(ds$TA02_16,"1") = "trifft... nicht"
attr(ds$TA02_16,"2") = "etwas"
attr(ds$TA02_16,"3") = "teilweise"
attr(ds$TA02_16,"4") = "überwiegend"
attr(ds$TA02_16,"5") = "...zu völlig"
attr(ds$TA02_17,"1") = "trifft... nicht"
attr(ds$TA02_17,"2") = "etwas"
attr(ds$TA02_17,"3") = "teilweise"
attr(ds$TA02_17,"4") = "überwiegend"
attr(ds$TA02_17,"5") = "...zu völlig"
attr(ds$TA02_18,"1") = "trifft... nicht"
attr(ds$TA02_18,"2") = "etwas"
attr(ds$TA02_18,"3") = "teilweise"
attr(ds$TA02_18,"4") = "überwiegend"
attr(ds$TA02_18,"5") = "...zu völlig"
attr(ds$TA02_19,"1") = "trifft... nicht"
attr(ds$TA02_19,"2") = "etwas"
attr(ds$TA02_19,"3") = "teilweise"
attr(ds$TA02_19,"4") = "überwiegend"
attr(ds$TA02_19,"5") = "...zu völlig"
attr(ds$TA02_20,"1") = "trifft... nicht"
attr(ds$TA02_20,"2") = "etwas"
attr(ds$TA02_20,"3") = "teilweise"
attr(ds$TA02_20,"4") = "überwiegend"
attr(ds$TA02_20,"5") = "...zu völlig"
attr(ds$TA02_21,"1") = "trifft... nicht"
attr(ds$TA02_21,"2") = "etwas"
attr(ds$TA02_21,"3") = "teilweise"
attr(ds$TA02_21,"4") = "überwiegend"
attr(ds$TA02_21,"5") = "...zu völlig"
attr(ds$TA02_22,"1") = "trifft... nicht"
attr(ds$TA02_22,"2") = "etwas"
attr(ds$TA02_22,"3") = "teilweise"
attr(ds$TA02_22,"4") = "überwiegend"
attr(ds$TA02_22,"5") = "...zu völlig"
attr(ds$TA02_23,"1") = "trifft... nicht"
attr(ds$TA02_23,"2") = "etwas"
attr(ds$TA02_23,"3") = "teilweise"
attr(ds$TA02_23,"4") = "überwiegend"
attr(ds$TA02_23,"5") = "...zu völlig"
attr(ds$TA02_24,"1") = "trifft... nicht"
attr(ds$TA02_24,"2") = "etwas"
attr(ds$TA02_24,"3") = "teilweise"
attr(ds$TA02_24,"4") = "überwiegend"
attr(ds$TA02_24,"5") = "...zu völlig"
attr(ds$TA02_25,"1") = "trifft... nicht"
attr(ds$TA02_25,"2") = "etwas"
attr(ds$TA02_25,"3") = "teilweise"
attr(ds$TA02_25,"4") = "überwiegend"
attr(ds$TA02_25,"5") = "...zu völlig"
attr(ds$TA02_26,"1") = "trifft... nicht"
attr(ds$TA02_26,"2") = "etwas"
attr(ds$TA02_26,"3") = "teilweise"
attr(ds$TA02_26,"4") = "überwiegend"
attr(ds$TA02_26,"5") = "...zu völlig"
attr(ds$TA02_27,"1") = "trifft... nicht"
attr(ds$TA02_27,"2") = "etwas"
attr(ds$TA02_27,"3") = "teilweise"
attr(ds$TA02_27,"4") = "überwiegend"
attr(ds$TA02_27,"5") = "...zu völlig"
attr(ds$TA02_28,"1") = "trifft... nicht"
attr(ds$TA02_28,"2") = "etwas"
attr(ds$TA02_28,"3") = "teilweise"
attr(ds$TA02_28,"4") = "überwiegend"
attr(ds$TA02_28,"5") = "...zu völlig"
attr(ds$TA02_29,"1") = "trifft... nicht"
attr(ds$TA02_29,"2") = "etwas"
attr(ds$TA02_29,"3") = "teilweise"
attr(ds$TA02_29,"4") = "überwiegend"
attr(ds$TA02_29,"5") = "...zu völlig"
attr(ds$TA02_30,"1") = "trifft... nicht"
attr(ds$TA02_30,"2") = "etwas"
attr(ds$TA02_30,"3") = "teilweise"
attr(ds$TA02_30,"4") = "überwiegend"
attr(ds$TA02_30,"5") = "...zu völlig"
attr(ds$TA02_31,"1") = "trifft... nicht"
attr(ds$TA02_31,"2") = "etwas"
attr(ds$TA02_31,"3") = "teilweise"
attr(ds$TA02_31,"4") = "überwiegend"
attr(ds$TA02_31,"5") = "...zu völlig"
attr(ds$TA02_32,"1") = "trifft... nicht"
attr(ds$TA02_32,"2") = "etwas"
attr(ds$TA02_32,"3") = "teilweise"
attr(ds$TA02_32,"4") = "überwiegend"
attr(ds$TA02_32,"5") = "...zu völlig"
attr(ds$TA02_33,"1") = "trifft... nicht"
attr(ds$TA02_33,"2") = "etwas"
attr(ds$TA02_33,"3") = "teilweise"
attr(ds$TA02_33,"4") = "überwiegend"
attr(ds$TA02_33,"5") = "...zu völlig"
attr(ds$TA02_34,"1") = "trifft... nicht"
attr(ds$TA02_34,"2") = "etwas"
attr(ds$TA02_34,"3") = "teilweise"
attr(ds$TA02_34,"4") = "überwiegend"
attr(ds$TA02_34,"5") = "...zu völlig"
attr(ds$NM01_01,"1") = "starke Ablehnung"
attr(ds$NM01_01,"5") = "starke Zustimmung"
attr(ds$NM01_02,"1") = "starke Ablehnung"
attr(ds$NM01_02,"5") = "starke Zustimmung"
attr(ds$NM01_03,"1") = "starke Zustimmung"
attr(ds$NM01_03,"5") = "starke Ablehnung"
attr(ds$NM01_04,"1") = "starke Ablehnung"
attr(ds$NM01_04,"5") = "starke Zustimmung"
attr(ds$NM01_05,"1") = "starke Zustimmung"
attr(ds$NM01_05,"5") = "starke Ablehnung"
attr(ds$NM01_06,"1") = "starke Ablehnung"
attr(ds$NM01_06,"5") = "starke Zustimmung"
attr(ds$NM01_07,"1") = "starke Ablehnung"
attr(ds$NM01_07,"5") = "starke Zustimmung"
attr(ds$NM01_08,"1") = "starke Zustimmung"
attr(ds$NM01_08,"5") = "starke Ablehnung"
attr(ds$NM01_09,"1") = "starke Zustimmung"
attr(ds$NM01_09,"5") = "starke Ablehnung"
attr(ds$NM01_10,"1") = "starke Ablehnung"
attr(ds$NM01_10,"5") = "starke Zustimmung"
attr(ds$NM01_11,"1") = "starke Zustimmung"
attr(ds$NM01_11,"5") = "starke Ablehnung"
attr(ds$NM01_12,"1") = "starke Ablehnung"
attr(ds$NM01_12,"5") = "starke Zustimmung"
attr(ds$NM01_13,"1") = "starke Ablehnung"
attr(ds$NM01_13,"5") = "starke Zustimmung"
attr(ds$NM01_14,"1") = "starke Zustimmung"
attr(ds$NM01_14,"5") = "starke Ablehnung"
attr(ds$NM01_15,"1") = "starke Ablehnung"
attr(ds$NM01_15,"5") = "starke Zustimmung"
attr(ds$NM01_16,"1") = "starke Ablehnung"
attr(ds$NM01_16,"5") = "starke Zustimmung"
attr(ds$NM01_17,"1") = "starke Ablehnung"
attr(ds$NM01_17,"5") = "starke Zustimmung"
attr(ds$NM01_18,"1") = "starke Ablehnung"
attr(ds$NM01_18,"5") = "starke Zustimmung"
attr(ds$NM01_19,"1") = "starke Zustimmung"
attr(ds$NM01_19,"5") = "starke Ablehnung"
attr(ds$NM01_20,"1") = "starke Ablehnung"
attr(ds$NM01_20,"5") = "starke Zustimmung"
attr(ds$NM01_21,"1") = "starke Zustimmung"
attr(ds$NM01_21,"5") = "starke Ablehnung"
attr(ds$NM01_22,"1") = "starke Zustimmung"
attr(ds$NM01_22,"5") = "starke Ablehnung"
attr(ds$NM01_23,"1") = "starke Ablehnung"
attr(ds$NM01_23,"5") = "starke Zustimmung"
attr(ds$NM01_24,"1") = "starke Zustimmung"
attr(ds$NM01_24,"5") = "starke Ablehnung"
attr(ds$NM01_25,"1") = "starke Zustimmung"
attr(ds$NM01_25,"5") = "starke Ablehnung"
attr(ds$NM01_26,"1") = "starke Ablehnung"
attr(ds$NM01_26,"5") = "starke Zustimmung"
attr(ds$NM01_27,"1") = "starke Zustimmung"
attr(ds$NM01_27,"5") = "starke Ablehnung"
attr(ds$NM01_28,"1") = "starke Ablehnung"
attr(ds$NM01_28,"5") = "starke Zustimmung"
attr(ds$NM01_29,"1") = "starke Ablehnung"
attr(ds$NM01_29,"5") = "starke Zustimmung"
attr(ds$NM01_30,"1") = "starke Zustimmung"
attr(ds$NM01_30,"5") = "starke Ablehnung"
attr(ds$P001_01,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_01,"2") = "ein bisschen"
attr(ds$P001_01,"3") = "einigermaßen"
attr(ds$P001_01,"4") = "erheblich"
attr(ds$P001_01,"5") = "äußerst"
attr(ds$P001_02,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_02,"2") = "ein bisschen"
attr(ds$P001_02,"3") = "einigermaßen"
attr(ds$P001_02,"4") = "erheblich"
attr(ds$P001_02,"5") = "äußerst"
attr(ds$P001_03,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_03,"2") = "ein bisschen"
attr(ds$P001_03,"3") = "einigermaßen"
attr(ds$P001_03,"4") = "erheblich"
attr(ds$P001_03,"5") = "äußerst"
attr(ds$P001_04,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_04,"2") = "ein bisschen"
attr(ds$P001_04,"3") = "einigermaßen"
attr(ds$P001_04,"4") = "erheblich"
attr(ds$P001_04,"5") = "äußerst"
attr(ds$P001_05,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_05,"2") = "ein bisschen"
attr(ds$P001_05,"3") = "einigermaßen"
attr(ds$P001_05,"4") = "erheblich"
attr(ds$P001_05,"5") = "äußerst"
attr(ds$P001_06,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_06,"2") = "ein bisschen"
attr(ds$P001_06,"3") = "einigermaßen"
attr(ds$P001_06,"4") = "erheblich"
attr(ds$P001_06,"5") = "äußerst"
attr(ds$P001_07,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_07,"2") = "ein bisschen"
attr(ds$P001_07,"3") = "einigermaßen"
attr(ds$P001_07,"4") = "erheblich"
attr(ds$P001_07,"5") = "äußerst"
attr(ds$P001_08,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_08,"2") = "ein bisschen"
attr(ds$P001_08,"3") = "einigermaßen"
attr(ds$P001_08,"4") = "erheblich"
attr(ds$P001_08,"5") = "äußerst"
attr(ds$P001_09,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_09,"2") = "ein bisschen"
attr(ds$P001_09,"3") = "einigermaßen"
attr(ds$P001_09,"4") = "erheblich"
attr(ds$P001_09,"5") = "äußerst"
attr(ds$P001_10,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_10,"2") = "ein bisschen"
attr(ds$P001_10,"3") = "einigermaßen"
attr(ds$P001_10,"4") = "erheblich"
attr(ds$P001_10,"5") = "äußerst"
attr(ds$P001_11,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_11,"2") = "ein bisschen"
attr(ds$P001_11,"3") = "einigermaßen"
attr(ds$P001_11,"4") = "erheblich"
attr(ds$P001_11,"5") = "äußerst"
attr(ds$P001_12,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_12,"2") = "ein bisschen"
attr(ds$P001_12,"3") = "einigermaßen"
attr(ds$P001_12,"4") = "erheblich"
attr(ds$P001_12,"5") = "äußerst"
attr(ds$P001_13,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_13,"2") = "ein bisschen"
attr(ds$P001_13,"3") = "einigermaßen"
attr(ds$P001_13,"4") = "erheblich"
attr(ds$P001_13,"5") = "äußerst"
attr(ds$P001_14,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_14,"2") = "ein bisschen"
attr(ds$P001_14,"3") = "einigermaßen"
attr(ds$P001_14,"4") = "erheblich"
attr(ds$P001_14,"5") = "äußerst"
attr(ds$P001_15,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_15,"2") = "ein bisschen"
attr(ds$P001_15,"3") = "einigermaßen"
attr(ds$P001_15,"4") = "erheblich"
attr(ds$P001_15,"5") = "äußerst"
attr(ds$P001_16,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_16,"2") = "ein bisschen"
attr(ds$P001_16,"3") = "einigermaßen"
attr(ds$P001_16,"4") = "erheblich"
attr(ds$P001_16,"5") = "äußerst"
attr(ds$P001_17,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_17,"2") = "ein bisschen"
attr(ds$P001_17,"3") = "einigermaßen"
attr(ds$P001_17,"4") = "erheblich"
attr(ds$P001_17,"5") = "äußerst"
attr(ds$P001_18,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_18,"2") = "ein bisschen"
attr(ds$P001_18,"3") = "einigermaßen"
attr(ds$P001_18,"4") = "erheblich"
attr(ds$P001_18,"5") = "äußerst"
attr(ds$P001_19,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_19,"2") = "ein bisschen"
attr(ds$P001_19,"3") = "einigermaßen"
attr(ds$P001_19,"4") = "erheblich"
attr(ds$P001_19,"5") = "äußerst"
attr(ds$P001_20,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_20,"2") = "ein bisschen"
attr(ds$P001_20,"3") = "einigermaßen"
attr(ds$P001_20,"4") = "erheblich"
attr(ds$P001_20,"5") = "äußerst"
attr(ds$P001_21,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_21,"2") = "ein bisschen"
attr(ds$P001_21,"3") = "einigermaßen"
attr(ds$P001_21,"4") = "erheblich"
attr(ds$P001_21,"5") = "äußerst"
attr(ds$P001_22,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_22,"2") = "ein bisschen"
attr(ds$P001_22,"3") = "einigermaßen"
attr(ds$P001_22,"4") = "erheblich"
attr(ds$P001_22,"5") = "äußerst"
attr(ds$P001_23,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_23,"2") = "ein bisschen"
attr(ds$P001_23,"3") = "einigermaßen"
attr(ds$P001_23,"4") = "erheblich"
attr(ds$P001_23,"5") = "äußerst"
attr(ds$P001_24,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_24,"2") = "ein bisschen"
attr(ds$P001_24,"3") = "einigermaßen"
attr(ds$P001_24,"4") = "erheblich"
attr(ds$P001_24,"5") = "äußerst"
attr(ds$P001_25,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_25,"2") = "ein bisschen"
attr(ds$P001_25,"3") = "einigermaßen"
attr(ds$P001_25,"4") = "erheblich"
attr(ds$P001_25,"5") = "äußerst"
attr(ds$P001_26,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_26,"2") = "ein bisschen"
attr(ds$P001_26,"3") = "einigermaßen"
attr(ds$P001_26,"4") = "erheblich"
attr(ds$P001_26,"5") = "äußerst"
attr(ds$P001_27,"1") = "ganz wenig oder gar nicht"
attr(ds$P001_27,"2") = "ein bisschen"
attr(ds$P001_27,"3") = "einigermaßen"
attr(ds$P001_27,"4") = "erheblich"
attr(ds$P001_27,"5") = "äußerst"
attr(ds$P102_01,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_01,"2") = "ein bisschen"
attr(ds$P102_01,"3") = "einigermaßen"
attr(ds$P102_01,"4") = "erheblich"
attr(ds$P102_01,"5") = "äußerst"
attr(ds$P102_02,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_02,"2") = "ein bisschen"
attr(ds$P102_02,"3") = "einigermaßen"
attr(ds$P102_02,"4") = "erheblich"
attr(ds$P102_02,"5") = "äußerst"
attr(ds$P102_03,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_03,"2") = "ein bisschen"
attr(ds$P102_03,"3") = "einigermaßen"
attr(ds$P102_03,"4") = "erheblich"
attr(ds$P102_03,"5") = "äußerst"
attr(ds$P102_04,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_04,"2") = "ein bisschen"
attr(ds$P102_04,"3") = "einigermaßen"
attr(ds$P102_04,"4") = "erheblich"
attr(ds$P102_04,"5") = "äußerst"
attr(ds$P102_05,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_05,"2") = "ein bisschen"
attr(ds$P102_05,"3") = "einigermaßen"
attr(ds$P102_05,"4") = "erheblich"
attr(ds$P102_05,"5") = "äußerst"
attr(ds$P102_06,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_06,"2") = "ein bisschen"
attr(ds$P102_06,"3") = "einigermaßen"
attr(ds$P102_06,"4") = "erheblich"
attr(ds$P102_06,"5") = "äußerst"
attr(ds$P102_07,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_07,"2") = "ein bisschen"
attr(ds$P102_07,"3") = "einigermaßen"
attr(ds$P102_07,"4") = "erheblich"
attr(ds$P102_07,"5") = "äußerst"
attr(ds$P102_08,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_08,"2") = "ein bisschen"
attr(ds$P102_08,"3") = "einigermaßen"
attr(ds$P102_08,"4") = "erheblich"
attr(ds$P102_08,"5") = "äußerst"
attr(ds$P102_09,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_09,"2") = "ein bisschen"
attr(ds$P102_09,"3") = "einigermaßen"
attr(ds$P102_09,"4") = "erheblich"
attr(ds$P102_09,"5") = "äußerst"
attr(ds$P102_10,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_10,"2") = "ein bisschen"
attr(ds$P102_10,"3") = "einigermaßen"
attr(ds$P102_10,"4") = "erheblich"
attr(ds$P102_10,"5") = "äußerst"
attr(ds$P102_11,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_11,"2") = "ein bisschen"
attr(ds$P102_11,"3") = "einigermaßen"
attr(ds$P102_11,"4") = "erheblich"
attr(ds$P102_11,"5") = "äußerst"
attr(ds$P102_12,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_12,"2") = "ein bisschen"
attr(ds$P102_12,"3") = "einigermaßen"
attr(ds$P102_12,"4") = "erheblich"
attr(ds$P102_12,"5") = "äußerst"
attr(ds$P102_13,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_13,"2") = "ein bisschen"
attr(ds$P102_13,"3") = "einigermaßen"
attr(ds$P102_13,"4") = "erheblich"
attr(ds$P102_13,"5") = "äußerst"
attr(ds$P102_14,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_14,"2") = "ein bisschen"
attr(ds$P102_14,"3") = "einigermaßen"
attr(ds$P102_14,"4") = "erheblich"
attr(ds$P102_14,"5") = "äußerst"
attr(ds$P102_15,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_15,"2") = "ein bisschen"
attr(ds$P102_15,"3") = "einigermaßen"
attr(ds$P102_15,"4") = "erheblich"
attr(ds$P102_15,"5") = "äußerst"
attr(ds$P102_16,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_16,"2") = "ein bisschen"
attr(ds$P102_16,"3") = "einigermaßen"
attr(ds$P102_16,"4") = "erheblich"
attr(ds$P102_16,"5") = "äußerst"
attr(ds$P102_17,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_17,"2") = "ein bisschen"
attr(ds$P102_17,"3") = "einigermaßen"
attr(ds$P102_17,"4") = "erheblich"
attr(ds$P102_17,"5") = "äußerst"
attr(ds$P102_18,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_18,"2") = "ein bisschen"
attr(ds$P102_18,"3") = "einigermaßen"
attr(ds$P102_18,"4") = "erheblich"
attr(ds$P102_18,"5") = "äußerst"
attr(ds$P102_19,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_19,"2") = "ein bisschen"
attr(ds$P102_19,"3") = "einigermaßen"
attr(ds$P102_19,"4") = "erheblich"
attr(ds$P102_19,"5") = "äußerst"
attr(ds$P102_20,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_20,"2") = "ein bisschen"
attr(ds$P102_20,"3") = "einigermaßen"
attr(ds$P102_20,"4") = "erheblich"
attr(ds$P102_20,"5") = "äußerst"
attr(ds$P102_21,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_21,"2") = "ein bisschen"
attr(ds$P102_21,"3") = "einigermaßen"
attr(ds$P102_21,"4") = "erheblich"
attr(ds$P102_21,"5") = "äußerst"
attr(ds$P102_22,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_22,"2") = "ein bisschen"
attr(ds$P102_22,"3") = "einigermaßen"
attr(ds$P102_22,"4") = "erheblich"
attr(ds$P102_22,"5") = "äußerst"
attr(ds$P102_23,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_23,"2") = "ein bisschen"
attr(ds$P102_23,"3") = "einigermaßen"
attr(ds$P102_23,"4") = "erheblich"
attr(ds$P102_23,"5") = "äußerst"
attr(ds$P102_24,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_24,"2") = "ein bisschen"
attr(ds$P102_24,"3") = "einigermaßen"
attr(ds$P102_24,"4") = "erheblich"
attr(ds$P102_24,"5") = "äußerst"
attr(ds$P102_25,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_25,"2") = "ein bisschen"
attr(ds$P102_25,"3") = "einigermaßen"
attr(ds$P102_25,"4") = "erheblich"
attr(ds$P102_25,"5") = "äußerst"
attr(ds$P102_26,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_26,"2") = "ein bisschen"
attr(ds$P102_26,"3") = "einigermaßen"
attr(ds$P102_26,"4") = "erheblich"
attr(ds$P102_26,"5") = "äußerst"
attr(ds$P102_27,"1") = "ganz wenig oder gar nicht"
attr(ds$P102_27,"2") = "ein bisschen"
attr(ds$P102_27,"3") = "einigermaßen"
attr(ds$P102_27,"4") = "erheblich"
attr(ds$P102_27,"5") = "äußerst"
attr(ds$P201_01,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_01,"2") = "ein bisschen"
attr(ds$P201_01,"3") = "einigermaßen"
attr(ds$P201_01,"4") = "erheblich"
attr(ds$P201_01,"5") = "äußerst"
attr(ds$P201_02,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_02,"2") = "ein bisschen"
attr(ds$P201_02,"3") = "einigermaßen"
attr(ds$P201_02,"4") = "erheblich"
attr(ds$P201_02,"5") = "äußerst"
attr(ds$P201_03,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_03,"2") = "ein bisschen"
attr(ds$P201_03,"3") = "einigermaßen"
attr(ds$P201_03,"4") = "erheblich"
attr(ds$P201_03,"5") = "äußerst"
attr(ds$P201_04,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_04,"2") = "ein bisschen"
attr(ds$P201_04,"3") = "einigermaßen"
attr(ds$P201_04,"4") = "erheblich"
attr(ds$P201_04,"5") = "äußerst"
attr(ds$P201_05,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_05,"2") = "ein bisschen"
attr(ds$P201_05,"3") = "einigermaßen"
attr(ds$P201_05,"4") = "erheblich"
attr(ds$P201_05,"5") = "äußerst"
attr(ds$P201_06,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_06,"2") = "ein bisschen"
attr(ds$P201_06,"3") = "einigermaßen"
attr(ds$P201_06,"4") = "erheblich"
attr(ds$P201_06,"5") = "äußerst"
attr(ds$P201_07,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_07,"2") = "ein bisschen"
attr(ds$P201_07,"3") = "einigermaßen"
attr(ds$P201_07,"4") = "erheblich"
attr(ds$P201_07,"5") = "äußerst"
attr(ds$P201_08,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_08,"2") = "ein bisschen"
attr(ds$P201_08,"3") = "einigermaßen"
attr(ds$P201_08,"4") = "erheblich"
attr(ds$P201_08,"5") = "äußerst"
attr(ds$P201_09,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_09,"2") = "ein bisschen"
attr(ds$P201_09,"3") = "einigermaßen"
attr(ds$P201_09,"4") = "erheblich"
attr(ds$P201_09,"5") = "äußerst"
attr(ds$P201_10,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_10,"2") = "ein bisschen"
attr(ds$P201_10,"3") = "einigermaßen"
attr(ds$P201_10,"4") = "erheblich"
attr(ds$P201_10,"5") = "äußerst"
attr(ds$P201_11,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_11,"2") = "ein bisschen"
attr(ds$P201_11,"3") = "einigermaßen"
attr(ds$P201_11,"4") = "erheblich"
attr(ds$P201_11,"5") = "äußerst"
attr(ds$P201_12,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_12,"2") = "ein bisschen"
attr(ds$P201_12,"3") = "einigermaßen"
attr(ds$P201_12,"4") = "erheblich"
attr(ds$P201_12,"5") = "äußerst"
attr(ds$P201_13,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_13,"2") = "ein bisschen"
attr(ds$P201_13,"3") = "einigermaßen"
attr(ds$P201_13,"4") = "erheblich"
attr(ds$P201_13,"5") = "äußerst"
attr(ds$P201_14,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_14,"2") = "ein bisschen"
attr(ds$P201_14,"3") = "einigermaßen"
attr(ds$P201_14,"4") = "erheblich"
attr(ds$P201_14,"5") = "äußerst"
attr(ds$P201_15,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_15,"2") = "ein bisschen"
attr(ds$P201_15,"3") = "einigermaßen"
attr(ds$P201_15,"4") = "erheblich"
attr(ds$P201_15,"5") = "äußerst"
attr(ds$P201_16,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_16,"2") = "ein bisschen"
attr(ds$P201_16,"3") = "einigermaßen"
attr(ds$P201_16,"4") = "erheblich"
attr(ds$P201_16,"5") = "äußerst"
attr(ds$P201_17,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_17,"2") = "ein bisschen"
attr(ds$P201_17,"3") = "einigermaßen"
attr(ds$P201_17,"4") = "erheblich"
attr(ds$P201_17,"5") = "äußerst"
attr(ds$P201_18,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_18,"2") = "ein bisschen"
attr(ds$P201_18,"3") = "einigermaßen"
attr(ds$P201_18,"4") = "erheblich"
attr(ds$P201_18,"5") = "äußerst"
attr(ds$P201_19,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_19,"2") = "ein bisschen"
attr(ds$P201_19,"3") = "einigermaßen"
attr(ds$P201_19,"4") = "erheblich"
attr(ds$P201_19,"5") = "äußerst"
attr(ds$P201_20,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_20,"2") = "ein bisschen"
attr(ds$P201_20,"3") = "einigermaßen"
attr(ds$P201_20,"4") = "erheblich"
attr(ds$P201_20,"5") = "äußerst"
attr(ds$P201_21,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_21,"2") = "ein bisschen"
attr(ds$P201_21,"3") = "einigermaßen"
attr(ds$P201_21,"4") = "erheblich"
attr(ds$P201_21,"5") = "äußerst"
attr(ds$P201_22,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_22,"2") = "ein bisschen"
attr(ds$P201_22,"3") = "einigermaßen"
attr(ds$P201_22,"4") = "erheblich"
attr(ds$P201_22,"5") = "äußerst"
attr(ds$P201_23,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_23,"2") = "ein bisschen"
attr(ds$P201_23,"3") = "einigermaßen"
attr(ds$P201_23,"4") = "erheblich"
attr(ds$P201_23,"5") = "äußerst"
attr(ds$P201_24,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_24,"2") = "ein bisschen"
attr(ds$P201_24,"3") = "einigermaßen"
attr(ds$P201_24,"4") = "erheblich"
attr(ds$P201_24,"5") = "äußerst"
attr(ds$P201_25,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_25,"2") = "ein bisschen"
attr(ds$P201_25,"3") = "einigermaßen"
attr(ds$P201_25,"4") = "erheblich"
attr(ds$P201_25,"5") = "äußerst"
attr(ds$P201_26,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_26,"2") = "ein bisschen"
attr(ds$P201_26,"3") = "einigermaßen"
attr(ds$P201_26,"4") = "erheblich"
attr(ds$P201_26,"5") = "äußerst"
attr(ds$P201_27,"1") = "ganz wenig oder gar nicht"
attr(ds$P201_27,"2") = "ein bisschen"
attr(ds$P201_27,"3") = "einigermaßen"
attr(ds$P201_27,"4") = "erheblich"
attr(ds$P201_27,"5") = "äußerst"
attr(ds$SM01_01,"1") = "starke Zustimmung"
attr(ds$SM01_01,"7") = "starke Ablehnung"
attr(ds$SM01_02,"1") = "starke Zustimmung"
attr(ds$SM01_02,"7") = "starke Ablehnung"
attr(ds$SM01_03,"1") = "starke Ablehnung"
attr(ds$SM01_03,"7") = "starke Zustimmung"
attr(ds$SM01_04,"1") = "starke Zustimmung"
attr(ds$SM01_04,"7") = "starke Ablehnung"
attr(ds$SM01_05,"1") = "starke Ablehnung"
attr(ds$SM01_05,"7") = "starke Zustimmung"
attr(ds$SM01_06,"1") = "starke Zustimmung"
attr(ds$SM01_06,"7") = "starke Ablehnung"
attr(ds$SM01_07,"1") = "starke Zustimmung"
attr(ds$SM01_07,"7") = "starke Ablehnung"
attr(ds$KF01_01,"1") = "gar nicht"
attr(ds$KF01_01,"101") = "sehr gut"
attr(ds$KF04_01,"1") = "gar nicht"
attr(ds$KF04_01,"101") = "sehr gut"
attr(ds$KF06_01,"1") = "wenig intensiv"
attr(ds$KF06_01,"101") = "sehr intensiv"
attr(ds$KF07_01,"1") = "wenig intensiv"
attr(ds$KF07_01,"101") = "sehr intensiv"
attr(ds$KF03_01,"F") = "nicht gewählt"
attr(ds$KF03_01,"T") = "ausgewählt"
attr(ds$KF03_02,"F") = "nicht gewählt"
attr(ds$KF03_02,"T") = "ausgewählt"
attr(ds$KF03_03,"F") = "nicht gewählt"
attr(ds$KF03_03,"T") = "ausgewählt"
attr(ds$KF03_04,"F") = "nicht gewählt"
attr(ds$KF03_04,"T") = "ausgewählt"
attr(ds$IF01_01,"1") = "wenig intensiv"
attr(ds$IF01_01,"101") = "sehr intensiv"
attr(ds$IF03_01,"F") = "nicht gewählt"
attr(ds$IF03_01,"T") = "ausgewählt"
attr(ds$IF03_02,"F") = "nicht gewählt"
attr(ds$IF03_02,"T") = "ausgewählt"
attr(ds$IF03_03,"F") = "nicht gewählt"
attr(ds$IF03_03,"T") = "ausgewählt"
attr(ds$IF03_04,"F") = "nicht gewählt"
attr(ds$IF03_04,"T") = "ausgewählt"
attr(ds$IF04_01,"1") = "gar nicht"
attr(ds$IF04_01,"101") = "sehr gut"
attr(ds$IF06_01,"1") = "wenig intensiv"
attr(ds$IF06_01,"101") = "sehr intensiv"
attr(ds$IF07_01,"1") = "wenig präsent"
attr(ds$IF07_01,"101") = "sehr präsent"
attr(ds$IF08_01,"1") = "wenig sicher"
attr(ds$IF08_01,"101") = "sehr sicher"
attr(ds$RU02_01,"1") = "0%"
attr(ds$RU02_01,"101") = "100%"
attr(ds$RU03_01,"1") = "0%"
attr(ds$RU03_01,"101") = "100%"
attr(ds$RA01,"1") = "Experimentalgruppe"
attr(ds$RA01,"2") = "Ruminationsgruppe"
attr(ds$FINISHED,"F") = "abgebrochen"
attr(ds$FINISHED,"T") = "ausgefüllt"
attr(ds$Q_VIEWER,"F") = "Teilnehmer"
attr(ds$Q_VIEWER,"T") = "Durchklicker"
comment(ds$SERIAL) = "Seriennummer (sofern verwendet)"
comment(ds$REF) = "Referenz (sofern im Link angegeben)"
comment(ds$QUESTNNR) = "Fragebogen, der im Interview verwendet wurde"
comment(ds$MODE) = "Interview-Modus"
comment(ds$STARTED) = "Zeitpunkt zu dem das Interview begonnen hat (Europe/Berlin)"
comment(ds$AD02_01) = "Skala: haben mich Dinge beunruhigt, die mir sonst nichts ausmachen."
comment(ds$AD02_02) = "Skala: hatte ich kaum Appetit."
comment(ds$AD02_03) = "Skala: konnte ich meine trübsinnige Laune nicht loswerden, obwohl mich meine Freunde/ Familie versuchte(n), aufzumuntern."
comment(ds$AD02_04) = "Skala: kam ich mir genauso gut vor wie andere. (umgepolt)"
comment(ds$AD02_05) = "Skala: hatte ich Mühe, mich zu konzentrieren."
comment(ds$AD02_06) = "Skala: war ich deprimiert/niedergeschlagen."
comment(ds$AD02_07) = "Skala: war alles anstrengend für mich."
comment(ds$AD02_08) = "Skala: dachte ich voller Hoffnung an die Zukunft. (umgepolt)"
comment(ds$AD02_09) = "Skala: dachte ich, mein Leben ist ein einziger Fehlschlag."
comment(ds$AD02_10) = "Skala: hatte ich Angst."
comment(ds$AD02_11) = "Skala: habe ich schlecht geschlafen."
comment(ds$AD02_12) = "Skala: war ich fröhlich gestimmt. (umgepolt)"
comment(ds$AD02_13) = "Skala: habe ich weniger als sonst geredet."
comment(ds$AD02_14) = "Skala: fühlte ich mich einsam."
comment(ds$AD02_15) = "Skala: waren die Leute unfreundlich zu mir."
comment(ds$AD02_16) = "Skala: habe ich das Leben genossen. (umgepolt)"
comment(ds$AD02_17) = "Skala: musste ich weinen."
comment(ds$AD02_18) = "Skala: war ich traurig."
comment(ds$AD02_19) = "Skala: hatte ich das Gefühl, dass mich die Leute nicht leiden können."
comment(ds$AD02_20) = "Skala: konnte ich mich zu nichts aufraffen."
comment(ds$SD01) = "Geschlecht"
comment(ds$SD03_01) = "Alter:  ... Jahre alt"
comment(ds$SD04_01) = "Studienfach: [01]"
comment(ds$TA02_01) = "Skala: Manchmal empfinde und erlebe ich Dinge wie in meiner Kindheit."
comment(ds$TA02_02) = "Skala: Wortgewandte oder poetische Sprache kann mich stark beeindrucken."
comment(ds$TA02_03) = "Skala: Filme, Fernsehspiele oder Theaterstücke können mich so mitreißen, dass ich mich und alles um mich herum vergesse und die Geschichte erlebe als wäre sie Realität und ich an ihr beteiligt."
comment(ds$TA02_04) = "Skala: Wenn ich ein Bild betrachte und danach wegsehe, habe ich manchmal ein Abbild davon, fast so als ob ich das Bild selber noch sehen würde."
comment(ds$TA02_05) = "Skala: Manchmal habe ich das Gefühl, mein Geist könnte die ganze Welt umfangen."
comment(ds$TA02_06) = "Skala: Ich beobachte gerne, wie Wolken ihre Form verändern."
comment(ds$TA02_07) = "Skala: Wenn ich will, kann ich Tagträumen oder mir manche Dinge so lebhaft vorstellen, dass sie meine Aufmerksamkeit fesseln wie ein guter Film oder eine gute Geschichte."
comment(ds$TA02_08) = "Skala: Ich glaube, dass ich weiß, was manche Leute meinen, wenn sie von mystischen Erfahrungen sprechen."
comment(ds$TA02_09) = "Skala: Ich kann manchmal aus mir heraustreten und einen völlig anderen Seinszustand erfahren."
comment(ds$TA02_10) = "Skala: Stoffe – wie etwa Wolle, Sand oder Holz – erinnern mich manchmal an Farben oder Musik."
comment(ds$TA02_11) = "Skala: Manchmal erlebe ich die Dinge als wären sie doppelt wirklich."
comment(ds$TA02_12) = "Skala: Wenn ich Musik höre, kann sie mich so gefangen nehmen, dass ich nichts anderes mehr beachte."
comment(ds$TA02_13) = "Skala: Wenn ich will, kann ich mir vorstellen, dass mein Körper so schwer ist, dass ich ihn nicht mehr bewegen kann, selbst wenn ich wollte"
comment(ds$TA02_14) = "Skala: Oft kann ich die Gegenwart einer anderen Person spüren, noch bevor ich sie (oder ihn) wirklich sehe oder höre."
comment(ds$TA02_15) = "Skala: Das Knistern und die Flammen eines Holzfeuers regen meine Phantasie an."
comment(ds$TA02_16) = "Skala: Manchmal ist es mir möglich, mich völlig in Natur oder Kunst zu versenken, als ob sich mein Bewusstseinszustand vorübergehend verändert hätte."
comment(ds$TA02_17) = "Skala: Verschiedene Farben haben unterschiedliche und besondere Bedeutungen für mich."
comment(ds$TA02_18) = "Skala: Es kann mir passieren, dass ich während einer Routineaufgabe in Gedanken abschweife und dabei vergesse, was ich tue, bis ich nach einigen Minuten bemerke, dass ich die Aufgabe erledigt habe."
comment(ds$TA02_19) = "Skala: Ich kann mich manchmal an bestimmte Erfahrungen aus meiner Vergangenheit so lebhaft und klar erinnern, als ob ich sie noch einmal durchleben würde."
comment(ds$TA02_20) = "Skala: Dinge, die anderen bedeutungslos erscheinen mögen, haben für mich oft einen Sinn."
comment(ds$TA02_21) = "Skala: Ich glaube, wenn ich in einem Stück eine Rolle spielen würde, könnte ich die Gefühle des dargestellten Charakters tatsächlich empfinden und für diese Zeit als die betreffende Person wirklich leben, mich selbst und das Publikum vergessend."
comment(ds$TA02_22) = "Skala: Meine Gedanken erscheinen oft nicht als Worte, sondern als Bilder."
comment(ds$TA02_23) = "Skala: Ich kann mich oft an kleinen Dingen erfreuen (wie die Farbe von Seifenblasen oder ähnliches)."
comment(ds$TA02_24) = "Skala: Wenn ich mir Orgelmusik oder andere kraftvolle Musik anhöre, fühle ich mich manchmal wie in die Luft gehoben."
comment(ds$TA02_25) = "Skala: Manchmal kann ich Geräusche in Musik verwandeln, wenn ich auf eine bestimmte Art hinhöre."
comment(ds$TA02_26) = "Skala: Einige meiner lebhaftesten Erinnerungen werden von Düften und Gerüchen geweckt."
comment(ds$TA02_27) = "Skala: Manche Musik erinnert mich an Bilder oder sich ändernde Farbmuster."
comment(ds$TA02_28) = "Skala: Oft weiß ich, was jemand sagen will, noch bevor er (oder sie) es ausspricht."
comment(ds$TA02_29) = "Skala: Ich habe oft eine Art „körperliche Erinnerungen”, z.B. wenn ich geschwommen bin, kann ich danach immer noch das Gefühl haben, im Wasser zu sein."
comment(ds$TA02_30) = "Skala: Der Klang einer Stimme kann so faszinierend für mich sein, dass ich einfach nur zuhöre."
comment(ds$TA02_31) = "Skala: Manchmal fühle ich die Anwesenheit einer Person, die physisch überhaupt nicht da ist."
comment(ds$TA02_32) = "Skala: Manchmal kommen mir Gedanken und Bilder ohne das geringste Hinzutun."
comment(ds$TA02_33) = "Skala: Ich finde, dass verschiedene Gerüche verschiedene Farben haben."
comment(ds$TA02_34) = "Skala: Ein Sonnenuntergang kann mich tief berühren."
comment(ds$NM01_01) = "Skala: ... finde ich normalerweise einen Weg, um mich aufzuheitern."
comment(ds$NM01_02) = "Skala: ... kann ich etwas dafür tun, damit meine Stimmung besser wird."
comment(ds$NM01_03) = "Skala: ... ist das Einzige, was ich tun kann, mich meinen negativen Gefühlen hinzugeben. (umgepolt)"
comment(ds$NM01_04) = "Skala: ... werde ich mich gut fühlen, wenn ich an angenehmere Zeiten denke."
comment(ds$NM01_05) = "Skala: ... wird es mir auf die Nerven gehen, mit anderen Leuten zusammen zu sein. (umgepolt)"
comment(ds$NM01_06) = "Skala: ... kann ich mich besser fühlen, wenn ich mir etwas Schönes gönne."
comment(ds$NM01_07) = "Skala: ... werde ich mich besser fühlen, wenn ich verstehe, warum es mir schlecht geht."
comment(ds$NM01_08) = "Skala: ... werde ich nicht in der Lage sein, mich dazu aufzuraffen, etwas dagegen zu unternehmen. (umgepolt)"
comment(ds$NM01_09) = "Skala: ... werde ich mich nicht besser fühlen, wenn ich versuche, der Situation etwas Positives abzugewinnen. (umgepolt)"
comment(ds$NM01_10) = "Skala: ... wird es nicht lange dauern, bis ich mich wieder beruhigen kann."
comment(ds$NM01_11) = "Skala: ... wird es schwer sein, jemanden zu finden, der mich wirklich verstehen kann. (umgepolt)"
comment(ds$NM01_12) = "Skala: ... wird es mir helfen, mich zu beruhigen, wenn ich mir selbst sage, dass es vorbeigehen wird."
comment(ds$NM01_13) = "Skala: ... wird es mich aufheitern, wenn ich etwas Nettes für jemand anderen tue."
comment(ds$NM01_14) = "Skala: ... werde ich mich letztendlich richtig niedergeschlagen fühlen. (umgepolt)"
comment(ds$NM01_15) = "Skala: ... wird es mir helfen, wenn ich plane, wie ich mit meinen Angelegenheiten umgehe."
comment(ds$NM01_16) = "Skala: ... kann ich ziemlich leicht vergessen, was mich so verstimmt."
comment(ds$NM01_17) = "Skala: ... hilft es mir, mich zu beruhigen, wenn ich mit meiner Arbeit gut nachkomme."
comment(ds$NM01_18) = "Skala: ... wird es mir nicht dabei helfen, mich besser zu fühlen, wenn Freunde mir Ratschläge geben"
comment(ds$NM01_19) = "Skala: ... werde ich nicht in der Lage sein, die Dinge zu genießen, die mir normalerweise Spaß machen. (umgepolt)"
comment(ds$NM01_20) = "Skala: ... werde ich eine Möglichkeit finden, mich zu entspannen."
comment(ds$NM01_21) = "Skala: ... erscheint mir alles nur noch viel schlimmer, wenn ich versuche, das Problem in meinem Kopf klar zu kriegen. (umgepolt)"
comment(ds$NM01_22) = "Skala: ... wird es mir nicht helfen, mich besser zu fühlen, wenn ich einen Film anschaue. (umgepolt)"
comment(ds$NM01_23) = "Skala: ... wird es mir helfen, mit Freunden zum Essen auszugehen."
comment(ds$NM01_24) = "Skala: ...werde ich mich für eine lange Zeit nicht beruhigen können. (umgepolt)"
comment(ds$NM01_25) = "Skala: ... wird mir das nicht mehr aus dem Kopf gehen. (umgepolt)"
comment(ds$NM01_26) = "Skala: ... kann ich mich dadurch besser fühlen, dass ich etwas Kreatives tue."
comment(ds$NM01_27) = "Skala: ... werde ich mich im Hinblick auf meine eigene Person wirklich schlecht fühlen. (umgepolt)"
comment(ds$NM01_28) = "Skala: ... wird es mir nicht dabei helfen, mich besser zu fühlen, wenn ich daran denke, dass die Dinge irgendwann besser sein werden."
comment(ds$NM01_29) = "Skala: ... kann ich die Situation mit Humor betrachten und fühle mich dann besser."
comment(ds$NM01_30) = "Skala: ... werde ich mich „allein unter anderen“ fühlen, wenn ich in einer Gruppe von Menschen bin. (umgepolt)"
comment(ds$P001_01) = "Skala: angeregt"
comment(ds$P001_02) = "Skala: unzufrieden"
comment(ds$P001_03) = "Skala: entschlossen"
comment(ds$P001_04) = "Skala: desinteressiert"
comment(ds$P001_05) = "Skala: stark"
comment(ds$P001_06) = "Skala: nervös"
comment(ds$P001_07) = "Skala: feindselig"
comment(ds$P001_08) = "Skala: wach"
comment(ds$P001_09) = "Skala: durcheinander"
comment(ds$P001_10) = "Skala: freudig erregt"
comment(ds$P001_11) = "Skala: bekümmert"
comment(ds$P001_12) = "Skala: erschrocken"
comment(ds$P001_13) = "Skala: ängstlich"
comment(ds$P001_14) = "Skala: motiviert"
comment(ds$P001_15) = "Skala: schuldig"
comment(ds$P001_16) = "Skala: verschämt"
comment(ds$P001_17) = "Skala: aufgeschlossen"
comment(ds$P001_18) = "Skala: gereizt"
comment(ds$P001_19) = "Skala: verärgert"
comment(ds$P001_20) = "Skala: begeistert"
comment(ds$P001_21) = "Skala: stolz"
comment(ds$P001_22) = "Skala: interessiert"
comment(ds$P001_23) = "Skala: genussfähig"
comment(ds$P001_24) = "Skala: freudlos"
comment(ds$P001_25) = "Skala: gelangweilt"
comment(ds$P001_26) = "Skala: aktiv"
comment(ds$P001_27) = "Skala: aufmerksam"
comment(ds$P102_01) = "Skala: wach"
comment(ds$P102_02) = "Skala: gereizt"
comment(ds$P102_03) = "Skala: desinteressiert"
comment(ds$P102_04) = "Skala: aufmerksam"
comment(ds$P102_05) = "Skala: freudig erregt"
comment(ds$P102_06) = "Skala: gelangweilt"
comment(ds$P102_07) = "Skala: freudlos"
comment(ds$P102_08) = "Skala: genussfähig"
comment(ds$P102_09) = "Skala: erschrocken"
comment(ds$P102_10) = "Skala: unzufrieden"
comment(ds$P102_11) = "Skala: verschämt"
comment(ds$P102_12) = "Skala: nervös"
comment(ds$P102_13) = "Skala: motiviert"
comment(ds$P102_14) = "Skala: aufgeschlossen"
comment(ds$P102_15) = "Skala: interessiert"
comment(ds$P102_16) = "Skala: schuldig"
comment(ds$P102_17) = "Skala: aktiv"
comment(ds$P102_18) = "Skala: ängstlich"
comment(ds$P102_19) = "Skala: begeistert"
comment(ds$P102_20) = "Skala: angeregt"
comment(ds$P102_21) = "Skala: verärgert"
comment(ds$P102_22) = "Skala: bekümmert"
comment(ds$P102_23) = "Skala: feindselig"
comment(ds$P102_24) = "Skala: entschlossen"
comment(ds$P102_25) = "Skala: stolz"
comment(ds$P102_26) = "Skala: durcheinander"
comment(ds$P102_27) = "Skala: stark"
comment(ds$P201_01) = "Skala: schuldig"
comment(ds$P201_02) = "Skala: wach"
comment(ds$P201_03) = "Skala: bekümmert"
comment(ds$P201_04) = "Skala: aufmerksam"
comment(ds$P201_05) = "Skala: durcheinander"
comment(ds$P201_06) = "Skala: gereizt"
comment(ds$P201_07) = "Skala: unzufrieden"
comment(ds$P201_08) = "Skala: gelangweilt"
comment(ds$P201_09) = "Skala: begeistert"
comment(ds$P201_10) = "Skala: aktiv"
comment(ds$P201_11) = "Skala: aufgeschlossen"
comment(ds$P201_12) = "Skala: genussfähig"
comment(ds$P201_13) = "Skala: erschrocken"
comment(ds$P201_14) = "Skala: stark"
comment(ds$P201_15) = "Skala: freudlos"
comment(ds$P201_16) = "Skala: interessiert"
comment(ds$P201_17) = "Skala: motiviert"
comment(ds$P201_18) = "Skala: stolz"
comment(ds$P201_19) = "Skala: desinteressiert"
comment(ds$P201_20) = "Skala: freudig erregt"
comment(ds$P201_21) = "Skala: ängstlich"
comment(ds$P201_22) = "Skala: verärgert"
comment(ds$P201_23) = "Skala: verschämt"
comment(ds$P201_24) = "Skala: feindselig"
comment(ds$P201_25) = "Skala: nervös"
comment(ds$P201_26) = "Skala: entschlossen"
comment(ds$P201_27) = "Skala: angeregt"
comment(ds$SM01_01) = "Skala: Es gibt wirklich keine Möglichkeit manche meiner Probleme zu lösen. (umgepolt)"
comment(ds$SM01_02) = "Skala: Ich habe wenig Kontrolle über die Dinge, die mir passieren. (umgepolt)"
comment(ds$SM01_03) = "Skala: Ich kann alles tun was ich wirklich will."
comment(ds$SM01_04) = "Skala: Ich fühle mich oft hilflos, wenn ich im Alltag mit Problemen konfrontiert werde. (umgepolt)"
comment(ds$SM01_05) = "Skala: Was in meiner Zukunft liegt, habe ich größtenteils selbst in der Hand."
comment(ds$SM01_06) = "Skala: Es gibt wenig was ich tun kann, um wichtige Dinge in meinem Leben zu verändern. (umgepolt)"
comment(ds$SM01_07) = "Skala: Manchmal fühle ich mich so, als würde ich im Leben herumkommandiert werden. (umgepolt)"
comment(ds$KF01_01) = "Qualität: gar nicht/sehr gut"
comment(ds$KF04_01) = "Details: gar nicht/sehr gut"
comment(ds$KF06_01) = "Intensität der Gefühle: wenig intensiv/sehr intensiv"
comment(ds$KF07_01) = "Hier und Jetzt: wenig intensiv/sehr intensiv"
comment(ds$KF02) = "Personen: Anzahl der Nennungen"
comment(ds$KF02x01) = "Personen: Nennung 1"
comment(ds$KF02x02) = "Personen: Nennung 2"
comment(ds$KF02x03) = "Personen: Nennung 3"
comment(ds$KF02x04) = "Personen: Nennung 4"
comment(ds$KF02x05) = "Personen: Nennung 5"
comment(ds$KF05) = "Gedanken: Anzahl der Nennungen"
comment(ds$KF05x01) = "Gedanken: Nennung 1"
comment(ds$KF05x02) = "Gedanken: Nennung 2"
comment(ds$KF05x03) = "Gedanken: Nennung 3"
comment(ds$KF05x04) = "Gedanken: Nennung 4"
comment(ds$KF05x05) = "Gedanken: Nennung 5"
comment(ds$KF03) = "Kanäle: Ausweichoption (negativ) oder Anzahl ausgewählter Optionen"
comment(ds$KF03_01) = "Kanäle: auditiv (hören)"
comment(ds$KF03_02) = "Kanäle: visuell (sehen)"
comment(ds$KF03_03) = "Kanäle: kinästhetisch (spüren)"
comment(ds$KF03_04) = "Kanäle: olfaktorisch (riechen/schmecken)"
comment(ds$IF01_01) = "Qualität: wenig intensiv/sehr intensiv"
comment(ds$IF02) = "Personen: Anzahl der Nennungen"
comment(ds$IF02x01) = "Personen: Nennung 1"
comment(ds$IF02x02) = "Personen: Nennung 2"
comment(ds$IF02x03) = "Personen: Nennung 3"
comment(ds$IF02x04) = "Personen: Nennung 4"
comment(ds$IF02x05) = "Personen: Nennung 5"
comment(ds$IF03) = "Kanäle: Ausweichoption (negativ) oder Anzahl ausgewählter Optionen"
comment(ds$IF03_01) = "Kanäle: auditiv (hören)"
comment(ds$IF03_02) = "Kanäle: visuell (sehen)"
comment(ds$IF03_03) = "Kanäle: kinästhetisch (spüren)"
comment(ds$IF03_04) = "Kanäle: olfaktorisch (riechen/schmecken)"
comment(ds$IF04_01) = "Details: gar nicht/sehr gut"
comment(ds$IF05) = "Gedanken: Anzahl der Nennungen"
comment(ds$IF05x01) = "Gedanken: Nennung 1"
comment(ds$IF05x02) = "Gedanken: Nennung 2"
comment(ds$IF05x03) = "Gedanken: Nennung 3"
comment(ds$IF05x04) = "Gedanken: Nennung 4"
comment(ds$IF05x05) = "Gedanken: Nennung 5"
comment(ds$IF06_01) = "Intensität der Gefühle: wenig intensiv/sehr intensiv"
comment(ds$IF07_01) = "Präsent: wenig präsent/sehr präsent"
comment(ds$IF08_01) = "Sicher: wenig sicher/sehr sicher"
comment(ds$RU02_01) = "Check1: 0%/100%"
comment(ds$RU03_01) = "Check2: 0%/100%"
comment(ds$RA01_CP) = "Gruppe: Vollständige Leerungen der Urne bisher"
comment(ds$RA01) = "Gruppe: Gezogener Code"
comment(ds$FW01_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW02_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW03_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW04_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW05_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW06_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW07_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW08_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW09_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW10_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW11_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW12_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW13_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW14_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$FW15_01) = "Fensterwechsel: Fensterwechsel"
comment(ds$VP01_01) = "Abfrage: [01]"
comment(ds$TIME001) = "Verweildauer Seite 1"
comment(ds$TIME002) = "Verweildauer Seite 2"
comment(ds$TIME003) = "Verweildauer Seite 3"
comment(ds$TIME004) = "Verweildauer Seite 4"
comment(ds$TIME005) = "Verweildauer Seite 5"
comment(ds$TIME006) = "Verweildauer Seite 6"
comment(ds$TIME007) = "Verweildauer Seite 7"
comment(ds$TIME008) = "Verweildauer Seite 8"
comment(ds$TIME009) = "Verweildauer Seite 9"
comment(ds$TIME010) = "Verweildauer Seite 10"
comment(ds$TIME011) = "Verweildauer Seite 11"
comment(ds$TIME012) = "Verweildauer Seite 12"
comment(ds$TIME013) = "Verweildauer Seite 13"
comment(ds$TIME014) = "Verweildauer Seite 14"
comment(ds$TIME015) = "Verweildauer Seite 15"
comment(ds$TIME016) = "Verweildauer Seite 16"
comment(ds$TIME_SUM) = "Verweildauer gesamt (ohne Ausreißer)"
comment(ds$MAILSENT) = "Versandzeitpunkt der Einladungsmail (nur für nicht-anonyme Adressaten)"
comment(ds$LASTDATA) = "Zeitpunkt als der Datensatz das letzte mal geändert wurde"
comment(ds$FINISHED) = "Wurde die Befragung abgeschlossen (letzte Seite erreicht)?"
comment(ds$Q_VIEWER) = "Hat der Teilnehmer den Fragebogen nur angesehen, ohne die Pflichtfragen zu beantworten?"
comment(ds$LASTPAGE) = "Seite, die der Teilnehmer zuletzt bearbeitet hat"
comment(ds$MAXPAGE) = "Letzte Seite, die im Fragebogen bearbeitet wurde"
comment(ds$MISSING) = "Anteil fehlender Antworten in Prozent"
comment(ds$MISSREL) = "Anteil fehlender Antworten (gewichtet nach Relevanz)"
comment(ds$TIME_RSI) = "Maluspunkte für schnelles Ausfüllen"
comment(ds$DEG_TIME) = "Maluspunkte für schnelles Ausfüllen"



# Assure that the comments are retained in subsets
as.data.frame.avector = as.data.frame.vector
`[.avector` <- function(x,i,...) {
  r <- NextMethod("[")
  mostattributes(r) <- attributes(x)
  r
}
ds_tmp = data.frame(
  lapply(ds, function(x) {
    structure( x, class = c("avector", class(x) ) )
  } )
)
mostattributes(ds_tmp) = attributes(ds)
ds = ds_tmp
rm(ds_tmp)


     
  
### 2. Daten aufbereiten 


# alle Fragebögen am Anfang Spalten = 20+3+34+30+(3*27)+7

# nicht gebrauchte Spalten löschen:

dat <- ds[,6:227]

dat <- dat[, -c(23,180:192,198:204,210:215,221)]


#dat$SD03_01 <- "Alter"
# Alter einer Vpn korrigieren, die wegen Voreinstellung in Soscisurvey nicht ihr richtiges Alter angeben konnte 49 -> 53


dat[6, 22] <- 53


# ADS-Wert und TAS-Wert und NMR-Wert 

## ADS und TAS Werte Minus 1, da Skala von 0-3 bzw. 4 und nicht von 1-4

dat[,c(1:20, 23:56)] <- dat[,c(1:20, 23:56)] -1



### Summenwerte 

dat$ADS <- rowSums(dat[,1:20])

dat$TAS <- rowSums(dat[,23:56])

dat$NMR <- rowSums(dat[,57:86])


dat$SMS <- rowSums(dat[,168:174])



### Gruppe als Faktorvariable ###

dat$RA01 <- as.factor(dat$RA01)

### Geschlecht als Faktorvariable### 

dat$SD01 <- as.factor(dat$SD01)


# dat$SD01 <- "Geschlecht"

tab <- ftable(SD01 ~ RA01, dat)

# chi quadrat test 

chisq.test(tab)



### Auswertung mit PA und NA Werte jeweils 10 Items pro Skala ###



### PA und NA Werte ###

# Baseline

dat$P0 <- rowSums(dat[, c("P001_01", "P001_03", "P001_05", "P001_08", "P001_10", "P001_20", "P001_21", "P001_22", "P001_26", "P001_26")])

dat$N0 <- rowSums(dat[, c("P001_06", "P001_07", "P001_09", "P001_11", "P001_12", "P001_13", "P001_15", "P001_16", "P001_18", "P001_19")])


# t1

dat$P1 <- rowSums(dat[, c("P102_20", "P102_24", "P102_27", "P102_01", "P102_05", "P102_19", "P102_25", "P102_15", "P102_17", "P102_04")])

dat$N1 <- rowSums(dat[, c("P102_12", "P102_23", "P102_26", "P102_22", "P102_09", "P102_18", "P102_16", "P102_11", "P102_02", "P102_21")])



# t2

dat$P2 <- rowSums(dat[, c("P201_27", "P201_26", "P201_14", "P201_02", "P201_20", "P201_09", "P201_18", "P201_16", "P201_10", "P201_04")])

dat$N2 <- rowSums(dat[, c("P201_25", "P201_24", "P201_05", "P201_03", "P201_13", "P201_21", "P201_01", "P201_23", "P201_06", "P201_22")])


### Baseline Unterschiede 
# Alter

t.test(SD03_01 ~ RA01, dat) # p = .589

aggregate(SD03_01 ~ RA01, dat, sd)

# Stimmung

var.test(N0 ~ RA01, dat)
var.test(P0 ~ RA01, dat)

t.test(P0 ~ RA01, var.equal = T, dat) # p = .596
t.test(N0 ~ RA01, var.equal = T, dat) # p = .371


#Depressivität
var.test(ADS ~ RA01, dat)
t.test(ADS ~ RA01, var.equal = T,  dat) # p = .578

# imaginative ability
var.test(TAS ~ RA01, dat)
t.test(TAS ~ RA01, var.equal = T, dat) # p = .797




# Datensatz nur mit Summenwerten 

dat1 <- dat[,194:204]

dat1$VP <- 1:54

dat1$VP <- as.factor(dat1$VP)


### langer Datensatz = Reshape ####


### alle 3 Zeitpunkte als Faktor dat4 ###
dat4 <- reshape(dat1, 
		    idvar = "VP",
		    varying = list(c(6, 8, 10), c(7, 9, 11)), 
		    v.names = c("P", "N"),
		    timevar = "Zeitpunkt",
		    direction = "long")


dat4$Zeitpunkt <- as.factor(dat4$Zeitpunkt)



### Reshape (Baseline bleibt, 2 Zeitpunkte, für ANOVA)###

dat2 <- reshape(dat1, 
		    idvar = "VP",
		    varying = list(c(8,10), c(9,11)), 
		    v.names = c("P", "N"),
		    timevar = "Zeitpunkt",
		    direction = "long")


dat2$Zeitpunkt <- as.factor(dat2$Zeitpunkt)

### Reshape (t2 bleibt, 2 Zeitpunkte, für Mood Checks)###


dat3 <- reshape(dat1, 
		    idvar = "VP",
		    varying = list(c(6,8), c(7,9)), 
		    v.names = c("P", "N"),
		    timevar = "Zeitpunkt",
		    direction = "long")


dat3$Zeitpunkt <- as.factor(dat3$Zeitpunkt)

### ANOVA überprüfung mood manipulation check ###

Mood1 <- aov(P ~ Zeitpunkt + Error(VP/Zeitpunkt),dat3)

Mood2 <- aov(N ~ Zeitpunkt + Error(VP/Zeitpunkt),dat3)


### Unterschiedliche Wirkung der Negativen Stimmungsinduktion in Gruppen?


aovM.1 <- aov(P ~ RA01 * Zeitpunkt + Error(VP/Zeitpunkt), dat3)

aovM.2 <- aov(N ~ RA01 * Zeitpunkt + Error(VP/Zeitpunkt), dat3)

summary(aovM.1)
summary(aovM.2)




########################################################################################

### Omnibus ANOVA über alle 3 Zeitpunkte ###

aov.P  <- aov(P ~ RA01 * Zeitpunkt + Error(VP/(Zeitpunkt)), dat3)


aov.N <- aov(N ~ RA01*Zeitpunkt + Error(VP/(Zeitpunkt)), dat3)

summary(aov.P)
summary(aov.N)

## nur Haupteffekt für Zeitpunkt 


#### Hauptanalyse ANOVA Veränderung zwischen t1 und t2 #####

aov.1  <- aov(P ~ RA01 * Zeitpunkt + Error(VP/(Zeitpunkt)), dat2)


aov.2 <- aov(N ~ RA01*Zeitpunkt + Error(VP/(Zeitpunkt)), dat2)

summary(aov.1) # Haupteffekt Zeitpunkt und Interaktion zwischen Bedingung und Zeitpunkt
summary(aov.2) # Haupteffekt Zeitpunkt

### Effektstärke

#install.packages("DescTools")
library(DescTools)

EtaSq(aov.1, type = 1)
f1.int = sqrt(0.019840152/(1-0.019840152))
f1.zeit = sqrt(0.114556520/(1-0.114556520))

EtaSq(aov.2, type = 1)
f2.zeit = sqrt(0.193446633 /(1-0.193446633 ))

ancova10.2 <- aov(N2 ~  N1 + RA01, dat1)

summary(ancova10.2)


### Reiner Vergleich der Werte zu t2 ###

t.test(N2 ~ RA01, dat1)
t.test(P2 ~ RA01, dat1)

# zu t2 unterscheidet sich der negative Affekt signifikant zwischen den Gruppen, jedoch ist bei diesem Vergleich nicht die Ausprägung des negativen Affekts vor der Intervention berücksichtigt.


######################################################################################
### Sekundäranalyse ###


### haben ADS oder TAS Einfluss auf das Outcome? 

## Korrelation zwischen ADS/TAS und Outcome vorhanden?

datchange <- dat1

datchange$P <- datchange$P2 - datchange$P1

datchange$N <- datchange$N2 - datchange$N1


cor.test(datchange$P, datchange$TAS) # .327

cor.test(datchange$N, datchange$TAS) # -.155

cor.test(datchange$P, datchange$ADS) # .1

cor.test(datchange$N, datchange$ADS) #.205


### es wird nur positiver moodchange mit TAS als Prädiktor untersucht

# hat TAS Wert einen Einfluss auf die positive Stimmungsverbesserung nach Stimmungsinduktion?

T.1 <- lm(P ~ TAS, datchange)
T.2 <- lm(P ~ TAS + RA01, datchange)
T.3 <- lm(P ~ TAS*RA01, datchange)

summary(T.2)
summary(T.1)
summary(T.3)


anova(T.1, T.2, T.3)


########################## Graphik ####################################################

ag10 <- aggregate(P ~ RA01 + Zeitpunkt, dat4 , mean)
ag10$sd <- aggregate(P ~ RA01 + Zeitpunkt, dat4 , sd)[,3]
ag10$length <-  aggregate(P ~ RA01 + Zeitpunkt, dat4 , length)[,3]
ag10$se <- ag10$sd/sqrt(ag10$length)


ag110 <- aggregate(N ~ RA01 + Zeitpunkt, dat4 , mean)
ag110$sd <- aggregate(N ~ RA01 + Zeitpunkt, dat4 , sd)[,3]
ag110$length <-  aggregate(N ~ RA01 + Zeitpunkt, dat4, length)[,3]
ag110$se <- ag110$sd/sqrt(ag110$length)



pdf("Drujan.pdf", height = 8, width = 12, pointsize = 12) 
par(mgp = c(2, .7, 0), mai = c(.7, .7, .1, .1), mfrow = c(1, 2))

plot(P ~ as.numeric(Zeitpunkt), ag10, type = "n", axes = F,
     xlab = "", ylab = "PANAS-PA",
     ylim = c(20, 40))

axis(side = 1, c(1, 2, 3), labels = c("t0", "t1", "t2"))
axis(side = 2)

points(P ~ as.numeric(Zeitpunkt), ag10[ag10$RA01 == "1",],
       col = "black", type = "b", pch = 16) 

points(P ~ as.numeric(Zeitpunkt), ag10[ag10$RA01 == "2",],
       col = "black", type = "b", pch = 4) 

arrows(rep(1:3, each = 2), ag10$P + ag10$se, rep(1:3, each = 2),
       ag10$P - ag10$se, angle = 90, length = 0.05, code = 3) 

legend(2.5, 36, legend = c("Safe Place", "Rumination"),
       pch = c(16, 4, 2),
       col = c("black", "black"), title = "", bty = "n")



plot(N ~ as.numeric(Zeitpunkt), ag110, type = "n", axes = F,
     xlab = "", ylab = "PANAS-NA",
     ylim = c(8, 20))

axis(side = 1, c(1, 2, 3), labels = c("t0", "t1", "t2"))
axis(side = 2)

points(N ~ as.numeric(Zeitpunkt), ag110[ag110$RA01 == "1",],
       col = "black", type = "b", pch = 16) 

points(N ~ as.numeric(Zeitpunkt), ag110[ag110$RA01 == "2",],
       col = "black", type = "b", pch = 4) 

arrows(rep(1:3, each = 2), ag110$N + ag110$se, rep(1:3, each = 2),
       ag110$N - ag110$se, angle = 90, length = 0.05, code = 3) 

legend(2.5, 18, legend = c("Safe Place", "Rumination"),
       pch = c(16, 4, 2),
       col = c("black", "black"), title = "", bty = "n")

dev.off()


