% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgstats-summary.R
\name{pkgstats_summary}
\alias{pkgstats_summary}
\title{Condense the output of \code{pkgstats} to summary statistics only}
\usage{
pkgstats_summary(s = NULL)
}
\arguments{
\item{s}{Output of \link{pkgstats}, containing full statistical data on one
package. Default of \code{NULL} returns a single row with \code{NA} values (used in
\link{pkgstats_from_archive}).}
}
\value{
Summarised version of \code{s}, as a single row of a standardised
\code{data.frame} object
}
\description{
Condense the output of \code{pkgstats} to summary statistics only
}
\note{
Variable names in the summary object use the following abbreviations:
\itemize{
\item "loc" = Lines-of-Code
\item "fn" = Function
\item "n_fns" = Number of functions
\item "npars" = Number of parameters
\item "doclines" = Number of documentation lines
\item "nedges" = Number of edges in function call network, as a count of
\emph{unique} edges, which may be less than the size of the \code{network}
object returned by \link{pkgstats}, because that may include multiple calls
between identical function pairs.
\item "n_clusters" = Number of connected clusters within the function call
network.
\item "centrality" used as a prefix for several statistics, along with
"dir" or "undir" for centrality calculated on networks respectively
constructed with directed or undirected edges; "mn" or "md" for respective
measures of mean or median centrality, and "no0" for measures excluding
edges with zero centrality.
}
}
\examples{
f <- system.file ("extdata", "pkgstats_9.9.tar.gz", package = "pkgstats")
\dontrun{
p <- pkgstats (f)
s <- pkgstats_summary (p)
}
}
\seealso{
Other stats: 
\code{\link{desc_stats}()},
\code{\link{loc_stats}()},
\code{\link{pkgstats}()},
\code{\link{rd_stats}()}
}
\concept{stats}
