# COMPETENCIES FOR CODE REVIEW

## Authors
PAVLÍNA WURZEL GONÇALVES, University of Zurich, Switzerland
GÜL ÇALIKLI, University of Glasgow, United Kingdom
ALEXANDER SEREBRENIK, Eindhoven University of Technology, The Netherlands
ALBERTO BACCHELLI, University of Zurich, Switzerland

## About the study

This study aimed to identify what competencies developers need to perform better code reviews. It adressed the topic from four different perspectives:
- which competencies reviewers use more frequently
- which competencies reviewers consider more important for efficient code reviews
- what proficiency level reviewers report for these competencies
- which competencies would reviewers like to improve
- for all the points above, are there differences between novice and expert reviewers?


## Methodology

The study firstly identified competencies relevant for efficient code reviews through identifying relevant competency frameworks. These frameworks served as a basis to create a pool of competencies that was validated and adjusted through expert validation: Through expert feedback obtained in a series of interviews, we have adjusted and clustered the competencies. The final competency list consisted of 27 competencies relevant for code reviews. Then they were assessed in a survey.

105 software developers who perform code reviews - the reviewers.
We assess the frequency of usage of a competency on a Likert-type scale from `Never' to `Always'. The level of proficiency of reviewers was assessed on a Likert-type scale from `Poor' to `Excellent'.
For the analysis we use the non-parametric variant of the Scott-Knott's ESD test. This variant produces ranked clusters of competencies that are more used than the competencies in the following cluster.
Developers also could choose up to 5 most important competencies and up to 5 competencies that they would like to improve. These were ranked by the frequencies of votes.
We produce rankings of competencies for novice and expert reviewers using the same methods. We calculate Spearman's rho to assess the relationship between the ranked clusters of the competencies in the subset of novice and experienced reviewers.
Furthermore, we perform the Mann-Whitney-U-test on the ordinal variables (frequency of usage and level of proficiency).

## Folder Content

This folder contains supplementary materials for the study with its replication package.

- README.md - information on the content and purpose of this supplementary material
- expert_validation_member-checking.pdf - the list of competencies and a questionnaire used to check with the interviewed experts on the validity of the derived list of competencies, their clustering and definitions
- survey_pilot_anonymized.pdf - the printable version of the survey pilot including all the competencies and survey questions
- analysis_script.Rmd - the R script used for analysis in an R notebook format
- data files/ - folder containing the produced data files

Data files:
- data_clean.csv - data file containing all the full responses
- data_expert.csv - subset of the data containing responses of experts
- data_novice.csv - subset of the data containing responses of novices
- data_ranking.csv - data file containing the rankings of each competency by all reviewers, experts and novices
