# Contributing to PyNM
Your input is much welcome! Please do not hesitate to contribute to this project, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We Develop with Github
We use github to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [Github Flow](https://guides.github.com/introduction/flow/index.html), So All Code Changes Happen Through Pull Requests
Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://guides.github.com/introduction/flow/index.html)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes (Travis).
5. Make sure your code lints (PEP8).
6. Issue the pull request!

## Any contributions you make will be under the 3-clause BSD License
In short, when you submit code changes, your submissions are understood to be under the same [3-clause BSD License](https://opensource.org/licenses/BSD-3-Clause) that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using Github's [issues](https://github.com/ppsp-team/PyNM/issues)
We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/ppsp-team/PyNM/issues/new/choose); it's that easy!

## Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Specific steps to reproduce, with sample code if you can.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

Thanks in advance to take the time for writing **Great** Bug Reports!

## Use a Consistent Coding Style

* 4 spaces for indentation rather than tabs
* [PEP 8 Style Guide for Python Code](https://pep8.org/)
* [Numpydoc](https://numpydoc.readthedocs.io/en/latest/) for the docstring

## License
By contributing, you agree that your contributions will be licensed under its [3-clause BSD License](https://opensource.org/licenses/BSD-3-Clause).

## References
This document was adapted from [this open-source contribution guidelines](https://gist.github.com/briandk/3d2e8b3ec8daf5a27a62).
