This README file was generated on 2022-10-21 by Andrea C WEsterband


GENERAL INFORMATION

Journal Name: Global Change Biology.

Title of Dataset: Australia-wide Photosynthetic Trait Dataset

Author/Principal Investigator Information
Name: Andrea C Westerband
ORCID: 0000-0003-4065-9689
Institution: Macquarie University
Address: Balaclava Rd, Macquarie Park NSW 2109
Email: andreawesterband@gmail.com

Author/Associate or Co-investigator Information
Name: Ian J Wright
ORCID: 0000-0001-8338-9143
Institution: Western Sydney University
Address: UWS Hawkesbury Campus, Science Rd, Richmond NSW 2753
Email: ian.j.wright@westernsydney.edu.au

Full author list: Westerband AC, Wright IJ, Maire V, Paillassa J, Prentice IC, Atkin OK, Bloomfield KJ, Cernusak LA, Dong N, Gleason SM, Guilherme Pereira C, Lambers H, Leishman MR, Malhi Y, Nolan RH

Abstract:  “Least-cost theory” posits that C3 plants should balance rates of photosynthetic water loss and carboxylation in relation to the relative acquisition and maintenance costs of resources required for these activities. Here we investigated the dependency of photosynthetic traits on climate and soil properties using a new Australia-wide trait dataset spanning 528 species from 67 sites. 
We tested the hypotheses that plants on relatively cold or dry sites, or on relatively more fertile sites, would typically operate at greater CO2 drawdown (lower ratio of leaf internal to ambient CO2, Ci:Ca) during light-saturated photosynthesis, and at higher leaf N per area (Narea) and higher carboxylation capacity (Vcmax 25) for a given rate of stomatal conductance to water, gsw. These results would be indicative of plants having relatively higher water costs than nutrient costs. 
In general, our hypotheses were supported. Soil total phosphorus (P) concentration and (more weakly) soil pH exerted positive effects on the Narea-gsw and Vcmax 25-gsw slopes, and negative effects on Ci:Ca. The P effect strengthened when the effect of climate was removed via partial regression. We observed similar trends with increasing soil cation exchange capacity and clay content, which affect soil nutrient availability, and found that soil properties explained similar amounts of variation in the focal traits as climate did. Although climate typically explained more trait variation than soil did, together they explained up to 52% of variation in the slope relationships and soil properties explained up to 30% of the variation in individual traits. 
Soils influenced photosynthetic traits as well as their coordination. In particular, the influence of soil P likely reflects the Australia’s geologically ancient low-relief landscapes with highly leached soils. Least-cost theory provides a valuable framework for understanding trade-offs between resource costs and use in plants, including limiting soil nutrients. 

Keywords: Australia; least-cost theory of photosynthesis; nutrient-use efficiency; optimality theory; plant functional traits; soil nutrients; soil phosphorus; trait coordination; water-use efficiency

Research domain: 1 Natural Sciences, 1.06 Biological Sciences

Information about funding sources that supported the collection of the data: 
Fieldwork carried out by ACW in 2020 and 2021 was funded by the Hermon Slade Foundation, HSF20047. ACW acknowledges support from Macquarie University and from Australian Research Council funding to IJW and ICP (DP170103410). 
VM and JP were supported by grants NSERC-Discovery (2016-05716). Data collection in Northern Queensland was supported by European Research Council advanced investigator grants GEM-TRAITS (321131) and T-FORCES (291585) under the European Union’s Seventh Framework Programme (FP7/2007-2013). 
OKA was supported by the ARC (DP130101252 and CE140100008). 
Data contributed by SMG were funded by the ARC Australian Laureate Fellowship (FL100100080/2011-2015).

Date of data collection: 1998-2021 

Geographic location of data collection: Australia


SHARING/ACCESS INFORMATION

Licenses/restrictions placed on the data: None

Links/relationships to ancillary data sets: Ancillary datasets are referenced in the source publications. 

Was data derived from another source? Yes.

If yes, list source(s): 
Atkin, O.K., Bloomfield, K.J., Reich, P.B., Tjoelker, M.G., Asner, G.P., Bonal, D., Bönisch, G., Bradford, M.G., Cernusak, L.A., Cosio, E.G., & Creek, D. (2015). Global variability in leaf respiration in relation to climate, plant functional types and leaf traits. New Phytologist, 206(2), 614-636. 
Bauman D., Fortunel C., Cernusak L.A., Bentley L.P., McMahon S.M., Rifai S.W., Aguirre-Gutiérrez J., Oliveras I., Bradford M., Laurance S.G.W. et al. (2022). Tropical tree growth sensitivity to climate is driven by species intrinsic growth rate and leaf traits. Global Change Biology, In press: https://doi.org/10.1111/gcb.15982.
Bloomfield, K.J., Cernusak, L.A., Eamus, D., Ellsworth, D.S., Colin Prentice, I., Wright, I.J., Boer, M.M., Bradford, M.G., Cale, P., Cleverly, J., & Egerton, J.J. (2018). A continental‐scale assessment of variability in leaf traits: Within species, across sites and between seasons. Functional Ecology, 32(6), 1492-1506. 
Cernusak, L.A., Hutley, L.B., Beringer, J., & Tapper, N.J., 2006. Stem and leaf gas exchange and their responses to fire in a north Australian tropical savanna. Plant, Cell & Environment, 29(4), pp.632-646. 
Cernusak, L.A., Hutley, L.B., Beringer, J., Holtum, J.A., & Turner, B.L. (2011). Photosynthetic physiology of eucalypts along a sub-continental rainfall gradient in northern Australia. Agricultural and Forest Meteorology, 151(11), 1462-1470. 
Eamus, D., Myers, B., Duff, G., & Williams, R. (2000). A cost-benefit analysis of leaves of eight Australian savanna tree species of differing leaf life-span. Photosynthetica, 36(4), 575-586. 
Eamus, D., & Prichard, H. (1998). A cost-benefit analysis of leaves of four Australian savanna species. Tree Physiology, 18(8-9), 537-545. 
Fürstenau Togashi, H, Bloomfield, K., Prentice, C., Evans, B., Atkin, O., Prober, S., & Macfarlane, C. (2015): Leaf Level Physiology, Chemistry and Structural Traits, Great Western Woodlands SuperSite, 2014. TERN Australian SuperSite Leaf Level Physiology, Chemistry and Structural Traits, Great Western Woodlands SuperSite, 2014 Network. http://supersites.tern.org.au/knb/metacat/supersite.302.3/html. Accessed on 4/24/2019.
Gleason, S.M., Butler, D.W., Ziemińska, K., Waryszak, P., & Westoby, M. (2012). Stem xylem conductivity is key to plant water balance across Australian angiosperm species. Functional Ecology, 26(2), 343-352. 
Gleason, S.M., Butler, D.W., & Waryszak, P. (2013). Shifts in leaf and stem hydraulic traits across aridity gradients in eastern Australia. International Journal of Plant Sciences, 174(9), 1292-1301. 
Gray, E. F., Wright, I.J., Falster, D.S., Eller, A.S., Lehmann, C.E.R., Bradford, M.G., & Cernusak, L.A. (2019). Leaf: wood allometry and functional traits together explain substantial growth rate variation in rainforest trees. AoB Plants, 11(3), plz024. 
Guilherme Pereira, C., Hayes, P. E., O’Sullivan, O. S., Weerasinghe, L. K., Clode, P. L., Atkin, O. K., & Lambers, H. (2019). Trait convergence in photosynthetic nutrient‐use efficiency along a 2‐million year dune chronosequence in a global biodiversity hotspot. Journal of Ecology, 107(4), 2006-2023. 
Leishman, M.R., Thomson, V.P., & Cooke, J. (2010). Native and exotic invasive plants have fundamentally similar carbon capture strategies. Journal of Ecology, 98(1), 28-42.
Maire, V., Wright, I.J., Prentice, I.C., Batjes, N.H., Bhaskar, R., Van Bodegom, P.M., Cornwell, W.K., Ellsworth, D., Niinemets, Ü., Ordonez, A., & Reich, P.B. (2015). Global effects of soil and climate on leaf photosynthetic traits and rates. Global Ecology and Biogeography, 24(6), 706-717. 
McPherson, S., Eamus, D., & Murray, B.R. (2004). Seasonal impacts of leaf atributes of several tree species growing in three diverse ecosystems in south-eastern Australia. Australian Journal of Botany, 52, 293-301.
Niinemets, Ü., Wright, I.J., & Evans, J.R. (2009). Leaf mesophyll diffusion conductance in 35 Australian sclerophylls covering a broad range of foliage structural and physiological variation. Journal of Experimental Botany, 60(8), 2433-2449. 
Nolan, R.H., Fairweather, K.A., Tarin, T., Santini, N.S., Cleverly, J., Faux, R., & Eamus, D. (2017). Divergence in plant water-use strategies in semiarid woody species. Functional Plant Biology, 44(11), 1134-1146
Nolan, R.H., Tarin, T., Fairweather, K.A., Cleverly, J., & Eamus, D. (2017). Variation in photosynthetic traits related to access to water in semiarid Australian woody species. Functional Plant Biology, 44(11), 1087-1097
Prior, L. D., Eamus, D., & Bowman, D. M. (2003). Leaf attributes in the seasonally dry tropics: a comparison of four habitats in northern Australia. Functional Ecology, 504-515.
Richards, A. E., & Schmidt, S. (2010). Complementary resource use by tree species in a rain forest tree plantation. Ecological Applications, 20(5), 1237-1254.
Walker, A.P., I. Aranda, A.P. Beckerman, H. Bown, L.A. Cernusak, Q.L. Dang, T.F. Domingues, L. Gu, S. Guo, Q. Han, J. Kattge, M. Kubiske, D. Manter, E. Merilo, G. Midgley, A. Porte, J.C. Scales, D. Tissue, T. Turnbull, C. Warren, G. Wohlfahrt, F.I. Woodward, & S.D. Wullschleger. (2014). A Global Data Set of Leaf Photosynthetic Rates, Leaf N and P, and Specific Leaf Area. Data set. Available on-line [http://daac.ornl.gov] from Oak Ridge National Laboratory Distributed Active Archive Center, Oak Ridge, Tennessee, USA. http://dx.doi.org/10.3334/ORNLDAAC/1224
Walker, A.P., Beckerman, A.P., Gu, L., Kattge, J., Cernusak, L.A., Domingues, T.F., Scales, J.C.,  Wohlfahrt, G., Wullschleger, S.D., & Woodward, F.I. (2014). The relationship of leaf photosynthetic traits - V cmax and J max - to leaf nitrogen, leaf phosphorus, and specific leaf area: a meta-analysis and modeling study. Ecology and Evolution, 4(16), 3218-3235. 
Warren, C.R., & Adams, M.A. (2001). Distribution of N, Rubisco and photosynthesis in Pinus pinaster and acclimation to light. Plant, Cell & Environment, 24(6), 597-609.
Weerasinghe, L.K., Creek, D., Crous, K.Y., Xiang, S., Liddell, M.J., Turnbull, M.H., & Atkin O.K. (2014). Canopy position affects the relationships between leaf respiration and associated traits in a tropical rainforest in Far North Queensland. Tree Physiology, 34(6), 564-584.
Wright, I. J., Reich, P. B., & Westoby, M. (2001). Strategy shifts in leaf physiology, structure and nutrient content between species of high‐and low‐rainfall and high‐and low‐nutrient habitats. Functional Ecology, 15(4), 423-434. 
Wright, I. J., Cooke, J., Cernusak, L.A., Hutley, L.B., Scalon, M.C., Tozer, W.C., & Lehmann, C.E. (2019). Stem diameter growth rates in a fire‐prone savanna correlate with photosynthetic rate and branch‐scale biomass allocation, but not specific leaf area. Austral Ecology, 44(2), 339-350.


Recommended citation for this dataset: 
Westerband AC, Wright IJ, Maire V, Paillassa J, Prentice IC, Atkin OK, Bloomfield KJ, Cernusak LA, Dong N, Gleason SM, Guilherme Pereira C, Lambers H, Leishman MR, Malhi Y, Nolan RH. (2022) Data from: Coordination of photosynthetic traits across soil and climate gradients. Dryad Digital Repository.


DATA & FILE OVERVIEW

File List: "Westerband_2022_GCB_DRYAD.xlsx", contains leaf photosynthesis and associated gas exchange traits, leaf nitrogen concentrations, leaf phosphorus concentrations, and leaf mass per area for over 500 species at 67 sites in Australia. Dataset also contains 22 climate and soil variables.

Are there multiple versions of the dataset? No


METHODOLOGICAL INFORMATION

Description of methods used for collection/generation of data: Light-saturated rates of photosynthesis were measured at ambient CO2 levels using a portable gas exchange system. 
Stomatal conductance to water vapor and Ci:Ca correspond to light-saturated rates of photosynthesis.
Carboxylation capacity, Vcmax, was estimated via the one-point method when it was not provided from A-ci curves.
Concentrations of leaf nitrogen and phosphorus were measured using an elemental analyzer. 
LMA was measured by dividing the leaf dry mass by the surface area of a fresh leaf. 

Methods for processing the data: Raw data were used to calculate species means for all sites, which were then compiled to produce one data file.
This was done using RStudio Version 1.3.959.

Environmental/experimental conditions: All data were collected on plants growing under natural conditions in the field.

Describe any quality-assurance procedures performed on the data: Ci:Ca values less than 0 or greater than 1 were excluded, as were stomatal conductance values greater than 3000 millimol per square meter per second. Vcmax 25 values greater than 500 micromol CO2 per square meter per second were also excluded for the final analysis.



DATA-SPECIFIC INFORMATION FOR: "Westerband_2022_GCB_DRYAD.xlsx"

Number of variables: 

Number of cases/rows: 761

Variable List: 
Species: species names 
Site: site name
Latitude: Latitudinal coordinates
Longitude: Longitudinal coordinates
Asat_area_micromol_m2.s: Light-saturated rate of photosynthesis at ambient CO2. Units are micromol of CO2 per meters squared per second.
gsw_mmol.m2.s: stomatal conductance to water vapor associated with Asat
CiCa: internal (to leaf) concentration of CO2 divided by ambient concentration of CO2. Unitless.
Vcmax_micromol.m2.s: Maximum carboxylation capacity at 25 degrees Celsius. Units are micromol CO2 per meters squared per second. 
LMA_g.m2: Leaf mass per unit surface area. Units are grams per meters squared.
LeafN_area_g.m2: Leaf nitrogen concentration per unit leaf area. Units are grams per meters squared.
LeafP_area_g.m2: Leaf phosphorus concentration per unit leaf area. Units are grams per meters squared.
MAP: Mean annual precipitation in mm
MAT: Mean annual temperature in degrees Celsius
MI: moisture index, unitless
AET: actual evapotranspiration in mm per month
PET: potential evapotranspiration in mm per month
Radiation: solar radiation in MJ per m2 per year
GDD0: growing degree days, units are number of days
Isothermality: (Annual mean diurnal range - Temperature annual range) × 100, unitless
Max Temp: annual mean of daily maximum temperature, degrees Celsius
Min Temp: annual mean of daily maximum temperature, degrees Celsius
VPD: vapore pressure deficit at 9am, kPa
Temp Seasonality: standard deviation of temperature × 100, unitless
Soil Phosphorus: total soil phosphorus concentration, g per kg
pH: soil pH, unitless
Soil Nitrogen: total soil nitrogen, g per kg
ECE: effective cation exchange capacity, meq per 100 g
BDW: bulk density of whole earth, g per cubic centimeter
SOC: soil organic carbon concentration, %
%Clay: % soil composed of clay
%Silt: % soil composed of silt
%Sand: % soil composed of sand