# Phenotypic plasticity in desiccation physiology of closely related, range restricted and broadly distributed fruit fly species


---



## Description of the Data and file structure

Raw data file for respirometry derived values for 4 species (Ceratitis capitata, Ceratits cosyra, Ceratitis podocarpi and Ceratitis rosa), each in a seperate tab. A seperate tab in the data set (metadata sheet) explains eah colomn heading, including how data was derived and outlining any calculations of the data. 

 Below is a description of the data collection and analysis:
 
Methods
Rearing of wild caught species
Pupae of Ceratitis capitata (Wiedemann, 1824), Ceratitis rosa (Karsch, 1887), Ceratitis cosyra (Walker, 1849) and Ceratitis podocarpi (Bezzi, 1924) were seasonally collected from stung host fruit (Table 1) and reared using standard culture methods to the F2 generation for experiments (see online supporting material for details). 
Acclimation treatments
The potential phenotypic plasticity of the desiccation physiology of adult flies was tested by rearing the flies at standard conditions and then exposing adults to one of two short-term acclimation treatments of 24 hours to test if the four fly species had different rapid responses to variation in temperature and humidity relative to each other and a control. Acclimation treatments were chosen to test the effects of different combinations of temperature and relative humidity on both respiration rate and cuticle composition. Temperature could affect both cuticular and respiratory water loss, while relative humidity might only affect cuticular water loss (CWL) since the humidity gradient between the internal environment and surrounds of an insect drives passive cuticular water loss, but active respiratory water loss (RWL) should be unaffected. The selected treatments were: (1) Control treatment, representing basal conditions (exposure to 25 °C and 76% RH for 8 hours), (2) ‘heat+desiccation’ or Temperature treatment (exposure to 35 °C and 0% RH for 2 hours), and (3) Desiccation treatment (exposure to 25 °C and 0% for 8 hours). The desired RH was achieved following the methods of Winston and Bates (1960) with a saturated solution of NaCl creating a RH of 76%, while airtight desiccators filled with silica gel were used to achieve <5% RH (hereafter referred to as 0% RH). Age was controlled to measure only flies between 5-7 days old (Weldon and Taylor 2010; Weldon et al. 2013). The acclimation treatments were achieved by placing females and males of known age in individual microcentrifuge tubes containing a small (~1 mm) air hole in the lid. The tubes containing the flies were then transferred to airtight containers in which relative humidity was controlled, and these were put into incubators set to the desired temperature. Temperature and RH during acclimation were verified with data loggers (DS1923, hygrochron-iButton, Maxim) placed within each airtight container. Flies allocated to the control and desiccation treatments were acclimated for 8 hours while flies allocated to the temperature treatment were acclimated for 2 hours as pilot trails determined that longer acclimation treatments led to mortality. For the duration of the acclimation treatments, food and water were withheld but provided again during a 12 hour resting period (at 25°C and 75%RH) before measurements of either mortality or partitioning of routes of water loss were undertaken in separate groups of flies. The effects of the combined temperature and humidity treatments on longevity (desiccation resistance), water loss at death, metabolic rate, activity, and water loss rates (partitioned into RWL and CWL) were recorded.
Desiccation resistance assay
Equal numbers of female and male flies (ntotal = 180) were weighed to the nearest 0.1 mg (Mettler Toledo, MS104S/01), acclimated to each of the three treatments (ntreatment = 60) and then given a 12 h rest period, under the control conditions described above. Following this rest period, flies were placed in individual, marked micro-centrifuge tubes, weighed, then transferred to a container set up as for the desiccation treatment and checked every 2 hours. Flies that were found dead at each of the observations were removed and immediately re-weighed, after which they were placed in a drying oven at 60°C for 72 hours. The flies were removed from the drying oven and weighed a final time to determine dry mass. Body water was estimated as the difference between initial wet mass at the start of the assay and final dry mass. While this estimate of body water does not account for weight lost due to catabolism of stored nutrients, the difference is likely to be within the range of measurement error for the balance that we used (e.g., see Weldon et al., 2016).
Metabolic rate and water loss
Gravimetric total water loss does not identify the avenue of water loss (e.g., water loss through the cuticle, from respiration, or by excretion). To partition routes of water loss and determine if respiratory, excretory or cuticular water loss rates differed between the four Ceratitis species, CO2 (as an indirect measure of metabolic rate) and H2O outputs were measured with flow-through respirometry using methods like those in Terblanche et al. (2010). All measurements were taken under desiccating conditions (0% RH and 25°C). Flies aged between 5 to 7 days were selected (n = 20 per treatment) and weighed to the nearest 0.1 mg after being placed in individual respirometry chambers constructed from 5 ml sterile syringes. These respirometry chambers were then connected to a LiCor 7000 CO2/H2O gas analyser that was calibrated using a CO2 standard and a LiCor 610 dew point generator following methods in Terblanche et al. (2010). The gas analyser was connected to a desktop computer running Sable Systems LiCor software (LI-7000-500 Windows® Software, v2.0.0, Lincoln, Nebraska, USA), which recorded CO2 and H2O output. The test temperature of 25°C was achieved by placing the respirometry chamber containing the individual fly inside a programmable water bath (CC410wl, Huber, Berching, Germany). A type T thermocouple connected to a temperature data logger (TC-08, Pico Technologies, Cambridgeshire, England) was also inserted into the syringe via a small opening to measure the temperature inside the respirometry chamber for the duration of the measurement and the opening sealed to prevent air loss. Each individual was measured for approximately 120 minutes at an airflow of 100 ml.min-1 with air that was first passed through soda lime, silica gel and Drierite columns, to ensure that the air that entered the system was free of water vapour and CO2. A Sable Systems AD-2 electronic activity detector was connected to the respirometry chamber, recording a pronounced Voltage change every time the fly interrupted a light beam, and used to qualitatively identify resting periods, although activity and rest periods were also readily visible in the V̇CO2 traces. 
Statistical analysis
Desiccation resistance
A set of model selection analyses were run in R (R software v. 3.5.1; R Development Core Team, 2018) (Cranley package; Leoncio 2022) using the ‘dredge’ function in the MuMin library (Burnham and Anderson 2002) to find the simplest model that best explained the variation in survival time between acclimation treatments in each species. Body water and body mass were positively correlated (Spearman, r = 0.944) and therefore only one of these variables was included in the test models to avoid autocorrelation. For each species, two models were tested with the dredge function, namely model1 = Treatment*Sex*Body mass and model 2 = Treatment*Sex*Body water. From these two models, the combination of variables that produced the lowest AIC score was selected as the best model. Where AIC values were similar between models, the model with the fewest predictor variables was selected. Cox proportional hazards models were run with the determined variables and the differences between groups summarised.
Metabolic rate and water loss
All metabolic data were extracted using Expedata (v 1.9.1 Sable Systems, Las Vegas, USA). The CO2 and H2O output traces for each individual were corrected for baseline drift, which was typically non-existent. All measurements were standard temperature and pressure corrected by the internal calibration of the infrared gas analyser. After each CO2 and H2O trace was drift corrected, they were converted from mMol/m and ppm to ml CO2.h−1 and mg H2O.h-1, respectively (standard gas equations; supporting information). Thereafter, a range of metabolic rate and water loss variables were extracted. Resting metabolic rate and average water loss rates were determined as the most level 120 seconds where there was no corresponding activity recorded by the activity detector, and the mean value and standard deviation were extracted for each individual. As the flies in this study were not observed to exhibit any obvious cyclic or discontinuous gas exchange pattern (where the spiracles are periodically closed), we could estimate cuticular water loss for each individual. To do so, we used ordinary least squares regression to relate H2O (mg.h-1) against CO2 (ml.h-1) output, and determined cuticular water loss as the H2O output when CO2 output was zero (i.e., the y-intercept of the regression equation) (Gibbs and Johnson 2004). Excretion events during the course of the full 2 hour measurement were clearly visible as spikes in the H2O trace that did not correspond with a spike in the CO2 trace and for each individual the number of excretion events was tallied. The area under the trace of each excretion event was measured and taken as the volume of H2O excreted and corrected by subtracting the estimated cuticular water loss from the peaks. The cumulative volume of these excretion events was also recorded for each individual. Activity was determined as the percentage time each individual spent active during the 2 hour measurement period. The duration of activity spikes was determined in each activity trace and totalled before being divided by the total duration of the respirometry recording. 
Before testing our hypotheses, we checked our data for the assumptions of ANOVA for each dependent variable using Levene’s tests (homogeneity of variance), Shapiro-Wilk tests (normal distribution) and likelihood ratio tests (over dispersion). None of the data were normally distributed, even following log transformation. Therefore, generalised linear models (GLZ’s) with Gaussian error distribution and log link function were used to test our hypotheses. A Gaussian distribution offered the best fit for our data based on comparison of Akaike’s information criterion (AIC) relative to other investigated distributions. These were followed by post-hoc Tukey multiple comparisons tests to identify groups that differed from each other. For metabolic rate, activity, water loss rate, and cuticular and respiratory water loss, the best model predictors were species, sex and body mass, as determined through model selection. For convenience, all mass-adjusted metabolic rate data are presented as µl.h−1.mg-1 and water loss rates presented as µg.h-1.mg-1. Statistical analyses were performed using R (R software v. 3.5.1; R Development Core Team, 2018), packages used included ‘car’ (Fox and Weisberg 2019), and ‘lsmeans’ (Russel 2016). 




## Sharing/access Information

NA

Was data derived from another source? NO
If yes, list source(s):