
// NOTE: THIS FILE IS AUTOMATICALLY GENERATED
// DO NOT EDIT BY HAND

// Re-run esum_cxx.py to update this file

// Fortran 2003 implementation of the msum routine
// provided by Raymond Hettinger:
// https://code.activestate.com/recipes/393090/
// This routine calculates the sum of N numbers
// exactly to within double precision arithmetic.
// Ported to C++.

// For perfomance reasons we implement a specialized
// version of esum for each possible value of N >= 3.

// Also for performance reasons, we explicitly unroll
// the outer loop of the msum method into groups of 3
// (and a group of 4 at the end, for even N). This seems
// to be significantly faster, but should still be exact
// to within the arithmetic because each one of the
// individual msums is (although this does not necessarily
// mean that the result is the same).

// This routine is called "esum" for generality
// because in principle we could add implementations
// other than msum that do exact arithmetic, without
// changing the interface as seen in the networks.

#ifndef _esum_H_
#define _esum_H_

#include <AMReX_REAL.H>
#include <AMReX_Array.H>
#include <ArrayUtilities.H>

using namespace amrex;


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum3(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum4(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum5(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum6(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum7(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum8(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum9(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum10(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum11(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum12(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum13(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum14(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum15(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum16(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum17(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum18(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum19(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum20(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum21(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum22(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum23(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+20);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum24(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+20);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum25(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+20);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+22);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum26(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+20);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+22);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum27(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+20);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+22);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+24);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum28(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+20);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+22);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+24);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum29(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+20);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+22);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+24);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+26);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum30(T const& array)
{
    // return value
    Real esum;

    // Indices for tracking the partials array.
    // j keeps track of how many entries in partials are actually used.
    // The algorithm we model this off of, written in Python, simply
    // deletes array entries at the end of every outer loop iteration.
    // The Fortran equivalent to this might be to just zero them out,
    // but this results in a huge performance hit given how often
    // this routine is called during in a burn. So we opt instead to
    // just track how many of the values are meaningful, which j does
    // automatically, and ignore any data in the remaining slots.
    int i, j, k, km;

    // Note that for performance reasons we are not
    // initializing any unused values in this array.
    Array1D<Real, 0, 4> partials;

    // Some temporary variables for holding intermediate data.
    Real x, y, z;

    // These temporary variables need to be explicitly
    // constructed for the algorithm to make sense.
    // If the compiler optimizes away the statement
    // lo = y - (hi - x), the approach fails. This could
    // be avoided with the volatile keyword, but at the
    // expense of forcing additional memory usage
    // which would slow down the calculation. Instead
    // we will rely on the compiler not to optimize
    // the statement away. This should be true for gcc
    // by default but is not necessarily true for all
    // compilers. In particular, Intel does not do this
    // by default, so you must use the -assume-protect-parens
    // flag for ifort.
    Real hi, lo;

    // The first partial is just the first term.
    esum = array(1);


    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+0);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+2);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+4);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+6);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+8);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+10);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+12);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+14);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+16);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+18);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+20);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+22);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 3; ++i) {

       km = j;
       j = 0;

       x = array(i+24);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);



    j = 0;
    partials(0) = esum;

    for (i = 2; i <= 4; ++i) {

       km = j;
       j = 0;

       x = array(i+26);

       for (k = 0; k <= km; ++k) {
          y = partials(k);

          if (std::abs(x) < std::abs(y)) {
             // Swap x, y
             z = y;
             y = x;
             x = z;
          }

          hi = x + y;
          lo = y - (hi - x);

          if (lo != 0.0_rt) {
             partials(j) = lo;
             j++;
          }

          x = hi;

       }

       partials(j) = x;

    }

    esum = ArrayUtil::Math::sum(partials, 0, j);


    return esum;
}


template<int n, class T>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real esum(T const& array)
{
    // return value
    Real sum = 0.0_rt;

    switch (n) {
    case 1:
        sum = array(1);
        break;
    case 2:
        sum = array(1) + array(2);
        break;
    case 3:
        sum = esum3(array);
        break;
    case 4:
        sum = esum4(array);
        break;
    case 5:
        sum = esum5(array);
        break;
    case 6:
        sum = esum6(array);
        break;
    case 7:
        sum = esum7(array);
        break;
    case 8:
        sum = esum8(array);
        break;
    case 9:
        sum = esum9(array);
        break;
    case 10:
        sum = esum10(array);
        break;
    case 11:
        sum = esum11(array);
        break;
    case 12:
        sum = esum12(array);
        break;
    case 13:
        sum = esum13(array);
        break;
    case 14:
        sum = esum14(array);
        break;
    case 15:
        sum = esum15(array);
        break;
    case 16:
        sum = esum16(array);
        break;
    case 17:
        sum = esum17(array);
        break;
    case 18:
        sum = esum18(array);
        break;
    case 19:
        sum = esum19(array);
        break;
    case 20:
        sum = esum20(array);
        break;
    case 21:
        sum = esum21(array);
        break;
    case 22:
        sum = esum22(array);
        break;
    case 23:
        sum = esum23(array);
        break;
    case 24:
        sum = esum24(array);
        break;
    case 25:
        sum = esum25(array);
        break;
    case 26:
        sum = esum26(array);
        break;
    case 27:
        sum = esum27(array);
        break;
    case 28:
        sum = esum28(array);
        break;
    case 29:
        sum = esum29(array);
        break;
    case 30:
        sum = esum30(array);
        break;

    default:
        sum = 0.0_rt;
        break;
    }
    return sum;
}


#endif
