#ifndef actual_rhs_H
#define actual_rhs_H

#include <AMReX_REAL.H>
#include <AMReX_Array.H>

#include <extern_parameters.H>
#include <actual_network.H>
#include <burn_type.H>
#include <jacobian_utilities.H>
#include <extern_parameters.H>

using namespace amrex;
using namespace ArrayUtil;




AMREX_GPU_HOST_DEVICE AMREX_INLINE
void rhs_specie(const burn_t& state,
             Array1D<Real, 1, neqs>& ydot,
             const Array1D<Real, 0, NumSpec-1>& X,
             Real const z) {

    using namespace Rates;

    Real T = state.T;

    ydot(1) = -35.5*std::pow(T, -2.2799999999999998)*X(0)*X(8)*std::exp(-46707.0/T) - 2.5950363272655348e-10*std::pow(T, -0.75)*X(0)*X(4) + 1.0e-8*std::pow(T, -0.40000000000000002)*X(1)*X(3) + 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(2)*X(7) + 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(3)*X(5) - 1.4000000000000001e-18*std::pow(T, 0.92800000000000005)*X(0)*X(2)*std::exp(-6.1728395061728397e-5*T) - 1.3300135414628029e-18*std::pow(T, 0.94999999999999996)*X(0)*X(5)*std::exp(-0.00010729613733905579*T) + 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(0)*X(3)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(0)*X(2)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(0)*X(13)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(0)*X(12)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(0)*X(1)*((8.6173430000000006e-5*T <= 5500.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - X(0)*X(12)*((8.6173430000000006e-5*T <= 9280.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   1250086.112245841*std::pow(T, -1.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)) - X(0)*X(6)*((T <= 10000.0) ? (
   -5.5279999999999998e-28*std::pow(T, 5) + 3.3467999999999999e-23*std::pow(T, 4) - 7.5474000000000004e-19*std::pow(T, 3) + 7.3427999999999993e-15*std::pow(T, 2) - 2.3088e-11*T + 4.2277999999999996e-8
)
: (
   0
)) + X(2)*X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + X(2)*X(3)*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(T, 1.78186)
)
: (
   3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - 5.7884371785482823e-10*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::sqrt(T) - 7.1999999999999996e-8*X(0)*X(9)/std::sqrt(T);


    ydot(2) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(1)*X(5) - 7.9674337148168363e-7*std::pow(T, -0.5)*X(1)*X(7) - 1.0e-8*std::pow(T, -0.40000000000000002)*X(1)*X(3) + 2.8833736969617052e-16*std::pow(T, 0.25)*X(12)*X(2) + 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(0)*X(2)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(0)*X(1)*((8.6173430000000006e-5*T <= 5500.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - 1.0000000000000001e-9*X(1)*X(10)*std::exp(-457.0/T) - X(1)*X(13)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
)) - X(1)*X(2)*((T < 30) ? (
   3.4977396723747635e-20*std::pow(T, -0.14999999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)
)) - X(1)*X(3)*((T >= 10.0 && T <= 100000.0) ? (
   2.5000000000000002e-10*std::sqrt(T) - 7.7700000000000002e-13*T - 1.73e-9 + 2.96e-6/std::sqrt(T)
)
: (
   0
)) - X(1)*X(5)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
)) - X(1)*X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
)) + X(2)*X(4)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
)) + 6.0e-10*X(2)*X(6) + 6.3999999999999996e-10*X(2)*X(9) + X(4)*X(8)*(-1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 8.4600000000000008e-10*std::log(T)/M_LN10 + 4.1700000000000001e-10);


    ydot(3) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(2)*X(4) + 35.5*std::pow(T, -2.2799999999999998)*X(0)*X(8)*std::exp(-46707.0/T) + 7.9674337148168363e-7*std::pow(T, -0.5)*X(1)*X(7) - 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(2)*X(7) - 2.8833736969617052e-16*std::pow(T, 0.25)*X(12)*X(2) + 8.7599999999999997e-10*std::pow(T, 0.34999999999999998)*X(0)*X(8)*std::exp(-102000.0/T) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(2)*X(7) + 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(3)*X(5) - 1.4000000000000001e-18*std::pow(T, 0.92800000000000005)*X(0)*X(2)*std::exp(-6.1728395061728397e-5*T) + 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(0)*X(3)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(0)*X(2)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + X(0)*X(1)*((8.6173430000000006e-5*T <= 5500.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) + 2*X(0)*X(6)*((T <= 10000.0) ? (
   -5.5279999999999998e-28*std::pow(T, 5) + 3.3467999999999999e-23*std::pow(T, 4) - 7.5474000000000004e-19*std::pow(T, 3) + 7.3427999999999993e-15*std::pow(T, 2) - 2.3088e-11*T + 4.2277999999999996e-8
)
: (
   0
)) + X(1)*X(13)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
)) - X(1)*X(2)*((T < 30) ? (
   3.4977396723747635e-20*std::pow(T, -0.14999999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)
)) + 2*X(1)*X(3)*((T >= 10.0 && T <= 100000.0) ? (
   2.5000000000000002e-10*std::sqrt(T) - 7.7700000000000002e-13*T - 1.73e-9 + 2.96e-6/std::sqrt(T)
)
: (
   0
)) + X(1)*X(5)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
)) + X(1)*X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
)) - X(10)*X(2)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + std::pow(X(2), 3)*(-6.0000000000000005e-31*std::pow(T, -0.5) - 1.8e-31*std::pow(T, -0.25)) + std::pow(X(2), 3)*(2.0000000000000002e-31*std::pow(T, -0.5) + 6.0000000000000001e-32*std::pow(T, -0.25)) + std::pow(X(2), 2)*X(8)*(-5.0000000000000004e-32*std::pow(T, -0.5) - 1.5e-32*std::pow(T, -0.25)) - X(2)*X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + X(2)*X(3)*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(T, 1.78186)
)
: (
   3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - X(2)*X(4)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
)) - 1.0e-25*X(2)*X(5) - 6.0e-10*X(2)*X(6) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) + X(2)*X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) - 6.3999999999999996e-10*X(2)*X(9) + X(5)*X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
)) + 2*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0)) + 7.1999999999999996e-8*X(0)*X(9)/std::sqrt(T) + 4.9999999999999996e-6*X(3)*X(6)/std::sqrt(T);


    ydot(4) = 35.5*std::pow(T, -2.2799999999999998)*X(0)*X(8)*std::exp(-46707.0/T) - 1.0e-8*std::pow(T, -0.40000000000000002)*X(1)*X(3) - 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(3)*X(5) + 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(2)*X(7) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(3)*X(5) + 1.4000000000000001e-18*std::pow(T, 0.92800000000000005)*X(0)*X(2)*std::exp(-6.1728395061728397e-5*T) - 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(0)*X(3)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(1)*X(3)*((T >= 10.0 && T <= 100000.0) ? (
   2.5000000000000002e-10*std::sqrt(T) - 7.7700000000000002e-13*T - 1.73e-9 + 2.96e-6/std::sqrt(T)
)
: (
   0
)) - X(2)*X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) - X(2)*X(3)*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(T, 1.78186)
)
: (
   3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - 4.9999999999999996e-6*X(3)*X(6)/std::sqrt(T);


    ydot(5) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(2)*X(4) - 2.5950363272655348e-10*std::pow(T, -0.75)*X(0)*X(4) - 9.8726896031426014e-7*std::pow(T, -0.5)*X(4)*X(7) + 1.0000000000000001e-9*X(1)*X(10)*std::exp(-457.0/T) + X(1)*X(5)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
)) - X(2)*X(4)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
)) + X(4)*X(8)*(1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 8.4600000000000008e-10*std::log(T)/M_LN10 - 4.1700000000000001e-10);


    ydot(6) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(1)*X(5) + 2.5950363272655348e-10*std::pow(T, -0.75)*X(0)*X(4) + 7.9674337148168363e-7*std::pow(T, -0.5)*X(1)*X(7) + 1.9745379206285203e-6*std::pow(T, -0.5)*X(4)*X(7) - 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(3)*X(5) + 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(2)*X(7) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(3)*X(5) - 1.3300135414628029e-18*std::pow(T, 0.94999999999999996)*X(0)*X(5)*std::exp(-0.00010729613733905579*T) - X(1)*X(5)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
)) + X(10)*X(2)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + X(2)*X(4)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
)) - 1.0e-25*X(2)*X(5) - X(5)*X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
)) + 7.1999999999999996e-8*X(0)*X(9)/std::sqrt(T);


    ydot(7) = 1.0e-8*std::pow(T, -0.40000000000000002)*X(1)*X(3) - X(0)*X(6)*((T <= 10000.0) ? (
   -5.5279999999999998e-28*std::pow(T, 5) + 3.3467999999999999e-23*std::pow(T, 4) - 7.5474000000000004e-19*std::pow(T, 3) + 7.3427999999999993e-15*std::pow(T, 2) - 2.3088e-11*T + 4.2277999999999996e-8
)
: (
   0
)) + X(1)*X(2)*((T < 30) ? (
   3.4977396723747635e-20*std::pow(T, -0.14999999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)
)) + X(1)*X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
)) - 6.0e-10*X(2)*X(6) - 4.9999999999999996e-6*X(3)*X(6)/std::sqrt(T);


    ydot(8) = -7.9674337148168363e-7*std::pow(T, -0.5)*X(1)*X(7) - 9.8726896031426014e-7*std::pow(T, -0.5)*X(4)*X(7) - 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(2)*X(7) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(2)*X(7) + 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(3)*X(5) + 1.3300135414628029e-18*std::pow(T, 0.94999999999999996)*X(0)*X(5)*std::exp(-0.00010729613733905579*T);


    ydot(9) = -35.5*std::pow(T, -2.2799999999999998)*X(0)*X(8)*std::exp(-46707.0/T) - 4.3799999999999999e-10*std::pow(T, 0.34999999999999998)*X(0)*X(8)*std::exp(-102000.0/T) + 1.0000000000000001e-9*X(1)*X(10)*std::exp(-457.0/T) - X(1)*X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
)) + X(10)*X(2)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + std::pow(X(2), 3)*(2.0000000000000002e-31*std::pow(T, -0.5) + 6.0000000000000001e-32*std::pow(T, -0.25)) + std::pow(X(2), 2)*X(8)*(-2.5000000000000002e-32*std::pow(T, -0.5) - 7.5000000000000001e-33*std::pow(T, -0.25)) + std::pow(X(2), 2)*X(8)*(5.0000000000000004e-32*std::pow(T, -0.5) + 1.5e-32*std::pow(T, -0.25)) + X(2)*X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + 6.0e-10*X(2)*X(6) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) + X(4)*X(8)*(1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 8.4600000000000008e-10*std::log(T)/M_LN10 - 4.1700000000000001e-10) - X(5)*X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
)) - std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0)) + 4.9999999999999996e-6*X(3)*X(6)/std::sqrt(T);


    ydot(10) = std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(1)*X(5) + std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(2)*X(4) - 6.3999999999999996e-10*X(2)*X(9) - 7.1999999999999996e-8*X(0)*X(9)/std::sqrt(T);


    ydot(11) = 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(2)*X(7) + 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(3)*X(5) - 1.0000000000000001e-9*X(1)*X(10)*std::exp(-457.0/T) - X(10)*X(2)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + 1.0e-25*X(2)*X(5) + 6.3999999999999996e-10*X(2)*X(9) + X(4)*X(8)*(-1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 8.4600000000000008e-10*std::log(T)/M_LN10 + 4.1700000000000001e-10) + X(5)*X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
));


    ydot(12) = 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(0)*X(12)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 5.7884371785482823e-10*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::sqrt(T);


    ydot(13) = -2.8833736969617052e-16*std::pow(T, 0.25)*X(12)*X(2) + 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(0)*X(13)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(0)*X(12)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(0)*X(12)*((8.6173430000000006e-5*T <= 9280.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   1250086.112245841*std::pow(T, -1.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)) + X(1)*X(13)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
)) + 5.7884371785482823e-10*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::sqrt(T);


    ydot(14) = 2.8833736969617052e-16*std::pow(T, 0.25)*X(12)*X(2) - 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(0)*X(13)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + X(0)*X(12)*((8.6173430000000006e-5*T <= 9280.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   1250086.112245841*std::pow(T, -1.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)) - X(1)*X(13)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
));




}

AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real rhs_eint(const burn_t& state,
             const Array1D<Real, 0, NumSpec-1>& X,
             Real const z) {

    using namespace Rates;

    Real T = state.T;

    return (-3.1438547368704001e-21*std::pow(T, 0.34999999999999998)*X(0)*X(8)*std::exp(-102000.0/T) - 0.00022681492*std::pow(T, 4)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))*((((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
   4.8339620236294848e-32/std::pow(std::pow(10.0, 2.1498900000000001 - 0.69317629274152892/M_LN10)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.1986273043946046e-56, 2) >= 1.0
)
: (
   ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
      4.8339620236294848e-32/std::pow(std::pow(10.0, 1.0000420000000001*std::log(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/M_LN10 + 2.1498900000000001)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.1986273043946046e-56, 2) >= 1.0
   )
   : (
      ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
         true
      )
      : (
         ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
            216.48287161311649/std::pow(std::pow(10.0, 2.1498900000000001 - 0.69317629274152892/M_LN10)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/std::fabs(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9)) + 1.471335691176954e-39, 2) >= 1.0
         )
         : (
            ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
               216.48287161311649/std::pow(std::pow(10.0, 1.0000420000000001*std::log(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/M_LN10 + 2.1498900000000001)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/std::fabs(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9)) + 1.471335691176954e-39, 2) >= 1.0
            )
            : (
               ((X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
                  true
               )
               : (
                  ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41) ? (
                     4.833962023629485e-72/std::pow(std::pow(10.0, 2.1498900000000001 - 0.69317629274152892/M_LN10)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))*std::sqrt(X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9)) + 2.1986273043946045e-76, 2) >= 1.0
                  )
                  : (
                     ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41) ? (
                        4.833962023629485e-72/std::pow(std::pow(10.0, 1.0000420000000001*std::log(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/M_LN10 + 2.1498900000000001)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))*std::sqrt(X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9)) + 2.1986273043946045e-76, 2) >= 1.0
                     )
                     : (
                        ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41) ? (
                           true
                        )
                        : (
                           ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5) ? (
                              2.1648287161311648e-38/std::pow(std::pow(10.0, 2.1498900000000001 - 0.69317629274152892/M_LN10)*std::sqrt(M_PI)*std::sqrt(T)*std::sqrt((X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9))/std::pow(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9), 2))*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 1.471335691176954e-59, 2) >= 1.0
                           )
                           : (
                              ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13) ? (
                                 2.1648287161311648e-38/std::pow(std::pow(10.0, 1.0000420000000001*std::log(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/M_LN10 + 2.1498900000000001)*std::sqrt(M_PI)*std::sqrt(T)*std::sqrt((X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9))/std::pow(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9), 2))*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 1.471335691176954e-59, 2) >= 1.0
                              )
                              : (
                                 true
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))
))) ? (
   1.0
)
: (
   483396202.36294854/std::pow(std::sqrt(M_PI)*std::sqrt(T)*std::sqrt(((X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
      9.9999999999999993e-41
   )
   : (
      X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9)
   ))*((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41) ? (
      1.0e+80
   )
   : (
      2.232953576238777e+46/std::pow(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9), 2)
   )))*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))*((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13) ? (
      std::pow(10.0, 1.0000420000000001*std::log(((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5) ? (
         0.5
      )
      : (
         9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)
      )))/M_LN10 + 2.1498900000000001)
   )
   : (
      0.0
   )) + 2.1986273043946046e-36, 2)
))*((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13) ? (
   std::pow(10.0, 1.0000420000000001*std::log(((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5) ? (
      0.5
   )
   : (
      9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)
   )))/M_LN10 + 2.1498900000000001)
)
: (
   0.0
)) + 0.00084373771595996178*T*(1.3806479999999999e-16*X(0) + 1.3806479999999999e-16*X(1) + 1.3806479999999999e-16*X(10) + 1.3806479999999999e-16*X(11) + 1.3806479999999999e-16*X(12) + 1.3806479999999999e-16*X(13) + 1.3806479999999999e-16*X(2) + 1.3806479999999999e-16*X(3) + 1.3806479999999999e-16*X(4) + 1.3806479999999999e-16*X(5) + 1.3806479999999999e-16*X(6) + 1.3806479999999999e-16*X(7) + 1.3806479999999999e-16*X(8) + 1.3806479999999999e-16*X(9))/(std::sqrt(M_PI)*std::sqrt(1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)))) - 5.0099999999999997e-27*std::pow(X(0), 2)*X(12)*((T <= 10) ? (
   0.67810976749343443
)
: (
   std::pow(T, -0.16869999999999999)
))*std::exp(-55338.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 9.1000000000000001e-27*std::pow(X(0), 2)*X(12)*((T <= 10) ? (
   0.67810976749343443
)
: (
   std::pow(T, -0.16869999999999999)
))*std::exp(-13179.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 3.4635323838154264e-26*X(0)*X(1)*((T <= 10) ? (
   0.63095734448019325
)
: (
   std::pow(T, -0.20000000000000001)
))*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))/(6.3095734448019361e-5*((T <= 10) ? (
   5.011872336272722
)
: (
   std::pow(T, 0.69999999999999996)
)) + 1.0) - 1.3854129535261706e-25*X(0)*X(11)*((T <= 10) ? (
   0.63095734448019325
)
: (
   std::pow(T, -0.20000000000000001)
))*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))/(6.3095734448019361e-5*((T <= 10) ? (
   5.011872336272722
)
: (
   std::pow(T, 0.69999999999999996)
)) + 1.0) - 1.24e-13*X(0)*X(12)*(1.0 + 0.29999999999999999*std::exp(-94000.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
))))*((T <= 10) ? (
   0.031622776601683791
)
: (
   std::pow(T, -1.5)
))*std::exp(-470000.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
))) - 1.5499999999999999e-26*X(0)*X(12)*((T <= 10) ? (
   2.3157944032250755
)
: (
   std::pow(T, 0.36470000000000002)
)) - 5.5399999999999998e-17*X(0)*X(12)*((T <= 10) ? (
   0.4008667176273028
)
: (
   std::pow(T, -0.39700000000000002)
))*std::exp(-473638.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 4.9500000000000001e-22*X(0)*X(12)*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))*std::exp(-631515.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 9.3799999999999993e-22*X(0)*X(13)*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))*std::exp(-285335.40000000002*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 1.2700000000000001e-21*X(0)*X(2)*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))*std::exp(-157809.10000000001*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 7.4999999999999996e-19*X(0)*X(2)*std::exp(-118348.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 5.6500000000000001e-36*X(0)*std::pow(z + 1.0, 4)*(T - 2.73*z - 2.73) + 7.1777505408000004e-12*std::pow(X(2), 3)*(2.0000000000000002e-31*std::pow(T, -0.5) + 6.0000000000000001e-32*std::pow(T, -0.25))/(1000000.0*std::pow(T, -0.5)/((1.6000000000000001*X(2)*std::exp(-160000.0/std::pow(T, 2)) + 1.3999999999999999*X(8)*std::exp(-12000.0/(T + 1200.0)))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 1.0) + 7.1777505408000004e-12*std::pow(X(2), 2)*X(8)*(2.5000000000000002e-32*std::pow(T, -0.5) + 7.5000000000000001e-33*std::pow(T, -0.25))/(1000000.0*std::pow(T, -0.5)/((1.6000000000000001*X(2)*std::exp(-160000.0/std::pow(T, 2)) + 1.3999999999999999*X(8)*std::exp(-12000.0/(T + 1200.0)))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 1.0) + 5.6556829037999995e-12*X(2)*X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/((1000000.0*std::pow(T, -0.5)/((1.6000000000000001*X(2)*std::exp(-160000.0/std::pow(T, 2)) + 1.3999999999999999*X(8)*std::exp(-12000.0/(T + 1200.0)))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 1.0)*(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0)) + 1.75918975308e-21*X(2)*X(6)/(1000000.0*std::pow(T, -0.5)/((1.6000000000000001*X(2)*std::exp(-160000.0/std::pow(T, 2)) + 1.3999999999999999*X(8)*std::exp(-12000.0/(T + 1200.0)))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 1.0) - 7.1777505408000004e-12*X(2)*X(8)*(std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) + std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) - 7.1777505408000004e-12*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0)) - ((T < 2.0) ? (
   0
)
: (
   X(8)*((((1.2500000000000001e-10*X(0) + 1.2500000000000001e-10*X(1) + 1.2500000000000001e-10*X(10) + 1.2500000000000001e-10*X(11) + 1.2500000000000001e-10*X(12) + 1.2500000000000001e-10*X(13) + 1.2500000000000001e-10*X(2) + 1.2500000000000001e-10*X(3) + 1.2500000000000001e-10*X(4) + 1.2500000000000001e-10*X(5) + 1.2500000000000001e-10*X(6) + 1.2500000000000001e-10*X(7) + 1.2500000000000001e-10*X(8) + 1.2500000000000001e-10*X(9) <= 9.9999999999999993e-41) ? (
      true
   )
   : (
      28601.610899577994*std::pow(X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9), -0.45000000000000001) >= 1.0
   ))) ? (
      1.0
   )
   : (
      ((1.2500000000000001e-10*X(0) + 1.2500000000000001e-10*X(1) + 1.2500000000000001e-10*X(10) + 1.2500000000000001e-10*X(11) + 1.2500000000000001e-10*X(12) + 1.2500000000000001e-10*X(13) + 1.2500000000000001e-10*X(2) + 1.2500000000000001e-10*X(3) + 1.2500000000000001e-10*X(4) + 1.2500000000000001e-10*X(5) + 1.2500000000000001e-10*X(6) + 1.2500000000000001e-10*X(7) + 1.2500000000000001e-10*X(8) + 1.2500000000000001e-10*X(9) <= 9.9999999999999993e-41) ? (
         1.000000000000001e+18
      )
      : (
         28601.610899577994*std::pow(X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9), -0.45000000000000001)
      ))
   ))*((((T <= 100.0 && T <= 500.0 && T <= 10000.0 && T > 10.0 && T > 100 && T < 2000.0) ? (
      4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
   )
   : (
      ((T <= 500.0 && T <= 1000.0 && T <= 10000.0 && T > 10.0 && T > 100 && T < 2000.0) ? (
         4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
      )
      : (
         ((T <= 500.0 && T <= 6000.0 && T <= 10000.0 && T > 10.0 && T > 100 && T < 2000.0) ? (
            4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
         )
         : (
            ((T <= 500.0 && T <= 10000.0 && T > 10.0 && T > 100 && T < 2000.0) ? (
               4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
            )
            : (
               ((T <= 100.0 && T <= 500.0 && T > 100 && T < 2000.0) ? (
                  4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
               )
               : (
                  ((T <= 500.0 && T <= 1000.0 && T > 100 && T < 2000.0) ? (
                     4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                  )
                  : (
                     ((T <= 500.0 && T <= 6000.0 && T > 100 && T < 2000.0) ? (
                        4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                     )
                     : (
                        ((T <= 500.0 && T > 100 && T < 2000.0) ? (
                           4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                        )
                        : (
                           ((T <= 100.0 && T <= 10000.0 && T > 10.0 && T > 500.0 && T < 2000.0) ? (
                              4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                           )
                           : (
                              ((T <= 1000.0 && T <= 10000.0 && T > 10.0 && T > 500.0 && T < 2000.0) ? (
                                 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                              )
                              : (
                                 ((T <= 6000.0 && T <= 10000.0 && T > 10.0 && T > 500.0 && T < 2000.0) ? (
                                    4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                 )
                                 : (
                                    ((T <= 10000.0 && T > 10.0 && T > 500.0 && T < 2000.0) ? (
                                       4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                    )
                                    : (
                                       ((T <= 100.0 && T > 500.0 && T < 2000.0) ? (
                                          4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                       )
                                       : (
                                          ((T <= 1000.0 && T > 500.0 && T < 2000.0) ? (
                                             4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                          )
                                          : (
                                             ((T <= 6000.0 && T > 500.0 && T < 2000.0) ? (
                                                4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                             )
                                             : (
                                                ((T > 500.0 && T < 2000.0) ? (
                                                   4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                )
                                                : (
                                                   ((T <= 100.0 && T <= 10000.0 && T > 10.0 && T < 2000.0) ? (
                                                      std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                   )
                                                   : (
                                                      ((T <= 1000.0 && T <= 10000.0 && T > 10.0 && T < 2000.0) ? (
                                                         std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                      )
                                                      : (
                                                         ((T <= 6000.0 && T <= 10000.0 && T > 10.0 && T < 2000.0) ? (
                                                            std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                         )
                                                         : (
                                                            ((T <= 10000.0 && T > 10.0 && T < 2000.0) ? (
                                                               std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                            )
                                                            : (
                                                               ((T <= 100.0 && T < 2000.0) ? (
                                                                  std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                               )
                                                               : (
                                                                  ((T <= 1000.0 && T < 2000.0) ? (
                                                                     std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                                  )
                                                                  : (
                                                                     ((T <= 6000.0 && T < 2000.0) ? (
                                                                        std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                                     )
                                                                     : (
                                                                        ((T < 2000.0) ? (
                                                                           std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                                        )
                                                                        : (
                                                                           ((T <= 100.0 && T <= 500.0 && T <= 10000.0 && T > 10.0 && T > 100) ? (
                                                                              std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                           )
                                                                           : (
                                                                              ((T <= 500.0 && T <= 1000.0 && T <= 10000.0 && T > 10.0 && T > 100) ? (
                                                                                 std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                              )
                                                                              : (
                                                                                 ((T <= 500.0 && T <= 6000.0 && T <= 10000.0 && T > 10.0 && T > 100) ? (
                                                                                    std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                 )
                                                                                 : (
                                                                                    ((T <= 500.0 && T <= 10000.0 && T > 10.0 && T > 100) ? (
                                                                                       std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                    )
                                                                                    : (
                                                                                       ((T <= 100.0 && T <= 500.0 && T <= 10000.0 && T > 100) ? (
                                                                                          std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                       )
                                                                                       : (
                                                                                          ((T <= 500.0 && T <= 1000.0 && T <= 10000.0 && T > 100) ? (
                                                                                             std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                          )
                                                                                          : (
                                                                                             ((T <= 500.0 && T <= 6000.0 && T <= 10000.0 && T > 100) ? (
                                                                                                std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                             )
                                                                                             : (
                                                                                                ((T <= 500.0 && T <= 10000.0 && T > 100) ? (
                                                                                                   std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                )
                                                                                                : (
                                                                                                   ((T <= 100.0 && T <= 10000.0 && T > 10.0 && T > 500.0) ? (
                                                                                                      std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                   )
                                                                                                   : (
                                                                                                      ((T <= 1000.0 && T <= 10000.0 && T > 10.0 && T > 500.0) ? (
                                                                                                         std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                                      )
                                                                                                      : (
                                                                                                         ((T <= 6000.0 && T <= 10000.0 && T > 10.0 && T > 500.0) ? (
                                                                                                            std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                         )
                                                                                                         : (
                                                                                                            ((T <= 10000.0 && T > 10.0 && T > 500.0) ? (
                                                                                                               std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                                            )
                                                                                                            : (
                                                                                                               ((T <= 100.0 && T <= 10000.0 && T > 500.0) ? (
                                                                                                                  std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                               )
                                                                                                               : (
                                                                                                                  ((T <= 1000.0 && T <= 10000.0 && T > 500.0) ? (
                                                                                                                     std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                  )
                                                                                                                  : (
                                                                                                                     ((T <= 6000.0 && T <= 10000.0 && T > 500.0) ? (
                                                                                                                        std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                     )
                                                                                                                     : (
                                                                                                                        ((T <= 10000.0 && T > 500.0) ? (
                                                                                                                           std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                                        )
                                                                                                                        : (
                                                                                                                           ((T <= 100.0 && T <= 10000.0 && T > 10.0) ? (
                                                                                                                              std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                                           )
                                                                                                                           : (
                                                                                                                              ((T <= 1000.0 && T <= 10000.0 && T > 10.0) ? (
                                                                                                                                 std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                                                              )
                                                                                                                              : (
                                                                                                                                 ((T <= 6000.0 && T <= 10000.0 && T > 10.0) ? (
                                                                                                                                    std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                 )
                                                                                                                                 : (
                                                                                                                                    ((T <= 10000.0 && T > 10.0) ? (
                                                                                                                                       std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                                                                    )
                                                                                                                                    : (
                                                                                                                                       ((T <= 100.0 && T <= 10000.0) ? (
                                                                                                                                          std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                                                       )
                                                                                                                                       : (
                                                                                                                                          ((T <= 1000.0 && T <= 10000.0) ? (
                                                                                                                                             std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                          )
                                                                                                                                          : (
                                                                                                                                             ((T <= 6000.0 && T <= 10000.0) ? (
                                                                                                                                                std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                             )
                                                                                                                                             : (
                                                                                                                                                ((T <= 10000.0) ? (
                                                                                                                                                   std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                                                                )
                                                                                                                                                : (
                                                                                                                                                   ((0.00020000000000000001*T - 6.0 >= 300.0 && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 1000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 6000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 1000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 6000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 1000.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 1000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T <= 6000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 6000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 1000.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 1000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T <= 6000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 6000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 1000.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T <= 6000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 1000.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T <= 6000.0 || T > 100 || T > 500.0)) ? (
                                                                                                                                                      false
                                                                                                                                                   )
                                                                                                                                                   : (
                                                                                                                                                      ((T <= 100.0 && T <= 500.0 && T > 100) ? (
                                                                                                                                                         5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                                                                      )
                                                                                                                                                      : (
                                                                                                                                                         ((T <= 500.0 && T <= 1000.0 && T > 100) ? (
                                                                                                                                                            5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                                         )
                                                                                                                                                         : (
                                                                                                                                                            ((T <= 500.0 && T <= 6000.0 && T > 100) ? (
                                                                                                                                                               5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                                            )
                                                                                                                                                            : (
                                                                                                                                                               ((T <= 500.0 && T > 100) ? (
                                                                                                                                                                  5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                                                                               )
                                                                                                                                                               : (
                                                                                                                                                                  ((T <= 100.0 && T > 500.0) ? (
                                                                                                                                                                     5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                                                                                  )
                                                                                                                                                                  : (
                                                                                                                                                                     ((T <= 1000.0 && T > 500.0) ? (
                                                                                                                                                                        5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                                                     )
                                                                                                                                                                     : (
                                                                                                                                                                        ((T <= 6000.0 && T > 500.0) ? (
                                                                                                                                                                           5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                                                        )
                                                                                                                                                                        : (
                                                                                                                                                                           5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                                                                                        ))
                                                                                                                                                                     ))
                                                                                                                                                                  ))
                                                                                                                                                               ))
                                                                                                                                                            ))
                                                                                                                                                         ))
                                                                                                                                                      ))
                                                                                                                                                   ))
                                                                                                                                                ))
                                                                                                                                             ))
                                                                                                                                          ))
                                                                                                                                       ))
                                                                                                                                    ))
                                                                                                                                 ))
                                                                                                                              ))
                                                                                                                           ))
                                                                                                                        ))
                                                                                                                     ))
                                                                                                                  ))
                                                                                                               ))
                                                                                                            ))
                                                                                                         ))
                                                                                                      ))
                                                                                                   ))
                                                                                                ))
                                                                                             ))
                                                                                          ))
                                                                                       ))
                                                                                    ))
                                                                                 ))
                                                                              ))
                                                                           ))
                                                                        ))
                                                                     ))
                                                                  ))
                                                               ))
                                                            ))
                                                         ))
                                                      ))
                                                   ))
                                                ))
                                             ))
                                          ))
                                       ))
                                    ))
                                 ))
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))) ? (
      (std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*((T <= 500.0 && T > 100) ? (
         std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0)
      )
      : ((T > 500.0) ? (
         std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0)
      )
      : (
         0
      ))) + ((T <= 10000.0 && T > 10.0) ? (
         std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13)
      )
      : (
         1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13)
      )) + ((T <= 10000.0 && T > 10.0) ? (
         std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1)
      )
      : (
         1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1)
      )) + ((T <= 100.0) ? (
         std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2)
      )
      : ((T <= 1000.0) ? (
         std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2)
      )
      : ((T <= 6000.0) ? (
         std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2)
      )
      : (
         1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2)
      )))))*((T < 2000.0) ? (
         4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T)
      )
      : ((T <= 10000.0) ? (
         std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225)
      )
      : (
         5.5313336794064847e-19/(std::exp(((0.00020000000000000001*T - 6.0 >= 300.0) ? (
            300.0
         )
         : (
            0.00020000000000000001*T - 6.0
         ))) + 1.0)
      )))/(std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*((T <= 500.0 && T > 100) ? (
         std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0)
      )
      : ((T > 500.0) ? (
         std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0)
      )
      : (
         0
      ))) + ((T <= 10000.0 && T > 10.0) ? (
         std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13)
      )
      : (
         1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13)
      )) + ((T <= 10000.0 && T > 10.0) ? (
         std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1)
      )
      : (
         1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1)
      )) + ((T < 2000.0) ? (
         4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T)
      )
      : ((T <= 10000.0) ? (
         std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225)
      )
      : (
         5.5313336794064847e-19/(std::exp(((0.00020000000000000001*T - 6.0 >= 300.0) ? (
            300.0
         )
         : (
            0.00020000000000000001*T - 6.0
         ))) + 1.0)
      ))) + ((T <= 100.0) ? (
         std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2)
      )
      : ((T <= 1000.0) ? (
         std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2)
      )
      : ((T <= 6000.0) ? (
         std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2)
      )
      : (
         1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2)
      )))))
   )
   : (
      0
   ))
)) - ((T >= 2.73*z + 2.73) ? (
   std::pow(10.0, 6.1920000000000003e-5*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 8) - 0.001482*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 7) + 0.0106*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 6) - 0.0083499999999999998*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/std::pow(M_LN10, 5) - 0.17333999999999999*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)/std::pow(M_LN10, 4) - 0.00066631000000000004*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 7) + 0.017590000000000001*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 6) - 0.13768*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 5) + 0.11711000000000001*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/std::pow(M_LN10, 4) + 2.1990599999999998*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)/std::pow(M_LN10, 3) + 0.0025140000000000002*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 6) - 0.073660000000000003*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 5) + 0.62343000000000004*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 4) - 0.54262999999999995*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/std::pow(M_LN10, 3) - 10.19097*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)/std::pow(M_LN10, 2) - 0.0036600000000000001*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 5) + 0.11864*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 4) - 1.06447*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 3) + 0.77951999999999999*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/std::pow(M_LN10, 2) + 21.93385*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))/M_LN10 + 0.0027499999999999998*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 4) - 0.076759999999999995*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 3) + 0.54962*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 2) + 0.92432999999999998*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/M_LN10 - 42.567880000000002)*X(10)
)
: (
   0
)))/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));
}


AMREX_GPU_HOST_DEVICE AMREX_INLINE
void actual_rhs (burn_t& state, Array1D<Real, 1, neqs>& ydot)
{
    Real z = 30.;

    Array1D<Real, 0, NumSpec-1> X;
    for (int i = 0; i < NumSpec; ++i) {
           X(i) = state.xn[i];
    }
    // YDOTS

    rhs_specie(state, ydot, X, z);

    // Edot

    Real edot = rhs_eint(state, X, z);

    // Append the energy equation (this is erg/g/s)

    ydot(net_ienuc) = edot;

}


template<class MatrixType>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
void jac_nuc(const burn_t& state,
             MatrixType& jac,
             const Array1D<Real, 0, NumSpec-1>& X,
             Real const z)
{

    Real T = state.T;

    jac(1,1) = -35.5*std::pow(T, -2.2799999999999998)*X(8)*std::exp(-46707.0/T) - 2.5950363272655348e-10*std::pow(T, -0.75)*X(4) - 1.4000000000000001e-18*std::pow(T, 0.92800000000000005)*X(2)*std::exp(-6.1728395061728397e-5*T) - 1.3300135414628029e-18*std::pow(T, 0.94999999999999996)*X(5)*std::exp(-0.00010729613733905579*T) + 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(3)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(2)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(13)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(12)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(1)*((8.6173430000000006e-5*T <= 5500.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - X(12)*((8.6173430000000006e-5*T <= 9280.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   1250086.112245841*std::pow(T, -1.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)) - X(6)*((T <= 10000.0) ? (
   -5.5279999999999998e-28*std::pow(T, 5) + 3.3467999999999999e-23*std::pow(T, 4) - 7.5474000000000004e-19*std::pow(T, 3) + 7.3427999999999993e-15*std::pow(T, 2) - 2.3088e-11*T + 4.2277999999999996e-8
)
: (
   0
)) - 5.7884371785482823e-10*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::sqrt(T) - 7.1999999999999996e-8*X(9)/std::sqrt(T);


    jac(1,2) = 1.0e-8*std::pow(T, -0.40000000000000002)*X(3) - X(0)*((8.6173430000000006e-5*T <= 5500.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
));


    jac(1,3) = 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(7) - 1.4000000000000001e-18*std::pow(T, 0.92800000000000005)*X(0)*std::exp(-6.1728395061728397e-5*T) + 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(0)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + X(3)*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(T, 1.78186)
)
: (
   3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
));


    jac(1,4) = 1.0e-8*std::pow(T, -0.40000000000000002)*X(1) + 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(5) + 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(0)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + X(2)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + X(2)*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(T, 1.78186)
)
: (
   3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
));


    jac(1,5) = -2.5950363272655348e-10*std::pow(T, -0.75)*X(0);


    jac(1,6) = 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(3) - 1.3300135414628029e-18*std::pow(T, 0.94999999999999996)*X(0)*std::exp(-0.00010729613733905579*T);


    jac(1,7) = -X(0)*((T <= 10000.0) ? (
   -5.5279999999999998e-28*std::pow(T, 5) + 3.3467999999999999e-23*std::pow(T, 4) - 7.5474000000000004e-19*std::pow(T, 3) + 7.3427999999999993e-15*std::pow(T, 2) - 2.3088e-11*T + 4.2277999999999996e-8
)
: (
   0
));


    jac(1,8) = 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(2);


    jac(1,9) = -35.5*std::pow(T, -2.2799999999999998)*X(0)*std::exp(-46707.0/T);


    jac(1,10) = -7.1999999999999996e-8*X(0)/std::sqrt(T);


    jac(1,11) = 0;


    jac(1,12) = -5.7884371785482823e-10*X(0)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::sqrt(T);


    jac(1,13) = 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(0)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(0)*((8.6173430000000006e-5*T <= 9280.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   1250086.112245841*std::pow(T, -1.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
));


    jac(1,14) = 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(0)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2));


    jac(1,15) = (-1658098.5*std::pow(T, -4.2799999999999994)*X(0)*X(8)*std::exp(-46707.0/T) + 80.939999999999998*std::pow(T, -3.2799999999999998)*X(0)*X(8)*std::exp(-46707.0/T) + 1.9462772454491511e-10*std::pow(T, -1.75)*X(0)*X(4) - 4.0000000000000002e-9*std::pow(T, -1.3999999999999999)*X(1)*X(3) - 2.6534040307116389e-10*std::pow(T, -1.1000000000000001)*X(2)*X(7) - 2.6534040307116389e-10*std::pow(T, -1.1000000000000001)*X(3)*X(5) - 1.2992000000000002e-18*std::pow(T, -0.071999999999999953)*X(0)*X(2)*std::exp(-6.1728395061728397e-5*T) - 1.2635128643896626e-18*std::pow(T, -0.050000000000000044)*X(0)*X(5)*std::exp(-0.00010729613733905579*T) + 8.6419753086419757e-23*std::pow(T, 0.92800000000000005)*X(0)*X(2)*std::exp(-6.1728395061728397e-5*T) + 1.4270531560759686e-22*std::pow(T, 0.94999999999999996)*X(0)*X(5)*std::exp(-0.00010729613733905579*T) + 8.9485740404797324e-18*std::pow(T, 1.360852208681)*X(0)*X(3)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(0)*X(3)*(-132.40745296375542*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 502.57312666436974*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 713.58279438845966*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 452.04559591922725*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 110.34576000052905*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 4.2657675552955459*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 0.56548861234079995*(std::log(T) - 9.3591486644682416)/T)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 7.997727392299023e-69*std::pow(T, 12.536555999999999)*X(0)*X(2)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(0)*X(2)*(-102.61091246917582*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 526.69265558088011*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 1134.0049033576197*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 1336.0230978224265*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 943.44664424718405*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 410.76741499805485*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 11.478657500000001*(std::log(T) - 9.3591486644682416)/T)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 1.0409203801861816e-115*std::pow(T, 22.915965629999999)*X(0)*X(13)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(0)*X(13)*(-183.62739846088516*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 972.53716821320074*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 2158.1860213397736*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 2606.9329003992802*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 1864.2690126126299*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 803.59445376387646*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 21.506460400000002*(std::log(T) - 9.3591486644682416)/T)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 1.694596485110541e-207*std::pow(T, 42.933476326349997)*X(0)*X(12)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(0)*X(12)*(-159.29342399384313*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 929.47621890049993*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 2293.8906388558121*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 3112.4265917774933*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 2522.5200862482043*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 1235.498068305666*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 36.961339871360003*(std::log(T) - 9.3591486644682416)/T)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(0)*X(1)*((8.6173430000000006e-5*T <= 5500.0) ? (
   -9.5174852894472843e-11*std::pow(T, -1.6353)
)
: (
   -2.3799651743169991e-10*std::pow(T, -1.724112565782685)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*(-1.6271673375367475*std::pow(0.10684732509875319*std::log(T) - 1, 8)/T - 0.93433329676104959*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 2.7077451444569309*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T + 2.1495916427711754*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T - 0.54533471131155187*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 1.0534802268965147*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T - 0.62564524397088728*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 0.04052089463969382*(std::log(T) - 9.3591486644682416)/T)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - X(0)*X(12)*((8.6173430000000006e-5*T <= 9280.0) ? (
   -9.5174852894472843e-11*std::pow(T, -1.6353)
)
: (
   587469852277.90271*std::pow(T, -3.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 54.282214350476039*std::pow(T, -3.5)*std::exp(-563932.20901156683/T) - 1875129.1683687614*std::pow(T, -2.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) - 9.5174852894472843e-11*std::pow(T, -1.6353)
)) - X(0)*X(6)*((T <= 10000.0) ? (
   -2.7639999999999999e-27*std::pow(T, 4) + 1.3387199999999999e-22*std::pow(T, 3) - 2.2642200000000001e-18*std::pow(T, 2) + 1.4685599999999999e-14*T - 2.3088e-11
)
: (
   0
)) + X(2)*X(3)*(1.3296555000000001e-10*std::pow(T, -0.90150700000000006) + 2.466314622e-10*std::pow(T, -0.44389999999999996) + 8.1647792100000001e-16*std::pow(T, 1.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + X(2)*X(3)*(-0.0064764051000000007*std::pow(T, 0.04610000000000003) - 2.7293978880000002e-10*std::pow(T, 2.0424000000000002) - 1.229450816e-13*std::pow(T, 2.7740999999999998))*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/std::pow(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0, 2) + X(2)*X(3)*((T <= 1160.0) ? (
   2.6092635916521491e-16*std::pow(T, 0.78186)
)
: (
   3.7804827525136553e-14*std::pow(T, 0.13944933584163111)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*(-42.748389009145441*std::pow(0.10684732509875319*std::log(T) - 1, 8)/T + 123.5618943832626*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T - 121.61252027671875*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T + 37.329277187848724*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 7.7196459978647596*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 4.6983322613028582*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 2.2242979762200967*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 0.28420270431082961*(std::log(T) - 9.3591486644682416)/T)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) + 3.0451686126851684e-13*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -2.7523999999999997)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/T + 2.3410580000000002e-11*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -1.2476)/T + 2.8942185892741411e-10*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::pow(T, 3.0/2.0) + 3.5999999999999998e-8*X(0)*X(9)/std::pow(T, 3.0/2.0))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(2,1) = 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(2)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(1)*((8.6173430000000006e-5*T <= 5500.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
));


    jac(2,2) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(5) - 7.9674337148168363e-7*std::pow(T, -0.5)*X(7) - 1.0e-8*std::pow(T, -0.40000000000000002)*X(3) - X(0)*((8.6173430000000006e-5*T <= 5500.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - 1.0000000000000001e-9*X(10)*std::exp(-457.0/T) - X(13)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
)) - X(2)*((T < 30) ? (
   3.4977396723747635e-20*std::pow(T, -0.14999999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)
)) - X(3)*((T >= 10.0 && T <= 100000.0) ? (
   2.5000000000000002e-10*std::sqrt(T) - 7.7700000000000002e-13*T - 1.73e-9 + 2.96e-6/std::sqrt(T)
)
: (
   0
)) - X(5)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
)) - X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
));


    jac(2,3) = 2.8833736969617052e-16*std::pow(T, 0.25)*X(12) + 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(0)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(1)*((T < 30) ? (
   3.4977396723747635e-20*std::pow(T, -0.14999999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)
)) + X(4)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
)) + 6.0e-10*X(6) + 6.3999999999999996e-10*X(9);


    jac(2,4) = -1.0e-8*std::pow(T, -0.40000000000000002)*X(1) - X(1)*((T >= 10.0 && T <= 100000.0) ? (
   2.5000000000000002e-10*std::sqrt(T) - 7.7700000000000002e-13*T - 1.73e-9 + 2.96e-6/std::sqrt(T)
)
: (
   0
));


    jac(2,5) = X(2)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
)) + X(8)*(-1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 8.4600000000000008e-10*std::log(T)/M_LN10 + 4.1700000000000001e-10);


    jac(2,6) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(1) - X(1)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
));


    jac(2,7) = 6.0e-10*X(2);


    jac(2,8) = -7.9674337148168363e-7*std::pow(T, -0.5)*X(1);


    jac(2,9) = -X(1)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
)) + X(4)*(-1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 8.4600000000000008e-10*std::log(T)/M_LN10 + 4.1700000000000001e-10);


    jac(2,10) = 6.3999999999999996e-10*X(2);


    jac(2,11) = -1.0000000000000001e-9*X(1)*std::exp(-457.0/T);


    jac(2,12) = 0;


    jac(2,13) = 2.8833736969617052e-16*std::pow(T, 0.25)*X(2);


    jac(2,14) = -X(1)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
));


    jac(2,15) = (-std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(1)*X(5)*(5.1485802679346868*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 1.0)/T - 0.87659414490283338*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 2.0)/T - 3.5068370966299316/(T*M_LN10)) + 3.9837168574084181e-7*std::pow(T, -1.5)*X(1)*X(7) + 4.0000000000000002e-9*std::pow(T, -1.3999999999999999)*X(1)*X(3) + 7.2084342424042629e-17*std::pow(T, -0.75)*X(12)*X(2) + 7.997727392299023e-69*std::pow(T, 12.536555999999999)*X(0)*X(2)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(0)*X(2)*(-102.61091246917582*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 526.69265558088011*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 1134.0049033576197*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 1336.0230978224265*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 943.44664424718405*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 410.76741499805485*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 11.478657500000001*(std::log(T) - 9.3591486644682416)/T)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(0)*X(1)*((8.6173430000000006e-5*T <= 5500.0) ? (
   -9.5174852894472843e-11*std::pow(T, -1.6353)
)
: (
   -2.3799651743169991e-10*std::pow(T, -1.724112565782685)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*(-1.6271673375367475*std::pow(0.10684732509875319*std::log(T) - 1, 8)/T - 0.93433329676104959*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 2.7077451444569309*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T + 2.1495916427711754*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T - 0.54533471131155187*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 1.0534802268965147*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T - 0.62564524397088728*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 0.04052089463969382*(std::log(T) - 9.3591486644682416)/T)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - X(1)*X(13)*((T <= 10000.0) ? (
   0.00016065*std::pow(T, -2.75)*std::exp(-127500.0/T) - 9.4499999999999994e-10*std::pow(T, -1.75)*std::exp(-127500.0/T)
)
: (
   1.8960000000000001e-36*std::pow(T, 3.7400000000000002)
)) - X(1)*X(2)*((T < 30) ? (
   -5.2466095085621454e-21*std::pow(T, -1.1499999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)*(-0.62159999999999993*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 3.5720000000000001*std::log(T)/(T*std::pow(M_LN10, 2)) - 3.194/(T*M_LN10))*M_LN10
)) - X(1)*X(3)*((T >= 10.0 && T <= 100000.0) ? (
   -7.7700000000000002e-13 + 1.2500000000000001e-10/std::sqrt(T) - 1.48e-6/std::pow(T, 3.0/2.0)
)
: (
   0
)) - X(1)*X(5)*((T >= 50.0) ? (
   7.4200000000000004e-9*std::pow(T, -1.5979999999999999)*std::exp(-37.100000000000001/T) + 8.0400000000000002e-11*std::pow(T, -0.59799999999999998)*std::exp(-37.100000000000001/T) - 4.8987999999999998e-17*std::pow(T, 0.47999999999999998)
)
: (
   0
)) - X(1)*X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (2.4718352399999997e-12*std::pow(std::log(T), 6)/T - 1.09028466e-10*std::pow(std::log(T), 5)/T + 1.9865770999999999e-9*std::pow(std::log(T), 4)/T - 1.9125491199999999e-8*std::pow(std::log(T), 3)/T + 1.0251841499999999e-7*std::pow(std::log(T), 2)/T - 2.8982736e-7*std::log(T)/T + 3.3735381999999997e-7/T)*std::exp(-21237.150000000001/T) + 21237.150000000001*(3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)/std::pow(T, 2)
)
: (
   0
)) + X(2)*X(4)*((T >= 50.0) ? (
   6.7980000000000007e-9*std::pow(T, -1.6040000000000001)*std::exp(-33.0/T) - 6.7396000000000002e-10*std::pow(T, -1.3320000000000001) + 8.1576000000000009e-11*std::pow(T, -0.60399999999999998)*std::exp(-33.0/T)
)
: (
   0
)) + X(4)*X(8)*(-2.7400000000000004e-10*std::log(T)/(T*std::pow(M_LN10, 2)) + 8.4600000000000008e-10/(T*M_LN10)) - 4.5700000000000003e-7*X(1)*X(10)*std::exp(-457.0/T)/std::pow(T, 2))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(3,1) = 35.5*std::pow(T, -2.2799999999999998)*X(8)*std::exp(-46707.0/T) + 8.7599999999999997e-10*std::pow(T, 0.34999999999999998)*X(8)*std::exp(-102000.0/T) - 1.4000000000000001e-18*std::pow(T, 0.92800000000000005)*X(2)*std::exp(-6.1728395061728397e-5*T) + 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(3)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(2)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + X(1)*((8.6173430000000006e-5*T <= 5500.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) + 2*X(6)*((T <= 10000.0) ? (
   -5.5279999999999998e-28*std::pow(T, 5) + 3.3467999999999999e-23*std::pow(T, 4) - 7.5474000000000004e-19*std::pow(T, 3) + 7.3427999999999993e-15*std::pow(T, 2) - 2.3088e-11*T + 4.2277999999999996e-8
)
: (
   0
)) + 7.1999999999999996e-8*X(9)/std::sqrt(T);


    jac(3,2) = -2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 7.9674337148168363e-7*std::pow(T, -0.5)*X(7) + X(0)*((8.6173430000000006e-5*T <= 5500.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) + X(13)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
)) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) - X(2)*((T < 30) ? (
   3.4977396723747635e-20*std::pow(T, -0.14999999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)
)) + 2*X(3)*((T >= 10.0 && T <= 100000.0) ? (
   2.5000000000000002e-10*std::sqrt(T) - 7.7700000000000002e-13*T - 1.73e-9 + 2.96e-6/std::sqrt(T)
)
: (
   0
)) + X(5)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
)) + X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
));


    jac(3,3) = -2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) - std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(4) - 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(7) - 2.8833736969617052e-16*std::pow(T, 0.25)*X(12) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(7) - 1.4000000000000001e-18*std::pow(T, 0.92800000000000005)*X(0)*std::exp(-6.1728395061728397e-5*T) - 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(0)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(1)*((T < 30) ? (
   3.4977396723747635e-20*std::pow(T, -0.14999999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)
)) - X(10)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + 3*std::pow(X(2), 2)*(-6.0000000000000005e-31*std::pow(T, -0.5) - 1.8e-31*std::pow(T, -0.25)) + 3*std::pow(X(2), 2)*(2.0000000000000002e-31*std::pow(T, -0.5) + 6.0000000000000001e-32*std::pow(T, -0.25)) + 2*X(2)*X(8)*(-5.0000000000000004e-32*std::pow(T, -0.5) - 1.5e-32*std::pow(T, -0.25)) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) - X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + X(3)*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(T, 1.78186)
)
: (
   3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - X(4)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
)) - 1.0e-25*X(5) - 6.0e-10*X(6) + X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) + X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) - 6.3999999999999996e-10*X(9);


    jac(3,4) = -2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(5) + 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(0)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 2*X(1)*((T >= 10.0 && T <= 100000.0) ? (
   2.5000000000000002e-10*std::sqrt(T) - 7.7700000000000002e-13*T - 1.73e-9 + 2.96e-6/std::sqrt(T)
)
: (
   0
)) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) - X(2)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + X(2)*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(T, 1.78186)
)
: (
   3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) + 4.9999999999999996e-6*X(6)/std::sqrt(T);


    jac(3,5) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(2) - X(2)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
));


    jac(3,6) = 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(3) + X(1)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
)) - 1.0e-25*X(2) + X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
));


    jac(3,7) = -4.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 4.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 2*X(0)*((T <= 10000.0) ? (
   -5.5279999999999998e-28*std::pow(T, 5) + 3.3467999999999999e-23*std::pow(T, 4) - 7.5474000000000004e-19*std::pow(T, 3) + 7.3427999999999993e-15*std::pow(T, 2) - 2.3088e-11*T + 4.2277999999999996e-8
)
: (
   0
)) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 9580.6421066314851*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 7632.6551179585222*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 9580.6421066314851*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 7632.6551179585222*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) - 6.0e-10*X(2) + 4.9999999999999996e-6*X(3)/std::sqrt(T);


    jac(3,8) = 7.9674337148168363e-7*std::pow(T, -0.5)*X(1) - 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(2) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(2);


    jac(3,9) = -4.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 4.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 35.5*std::pow(T, -2.2799999999999998)*X(0)*std::exp(-46707.0/T) + 8.7599999999999997e-10*std::pow(T, 0.34999999999999998)*X(0)*std::exp(-102000.0/T) + X(1)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
)) + std::pow(X(2), 2)*(-5.0000000000000004e-32*std::pow(T, -0.5) - 1.5e-32*std::pow(T, -0.25)) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 9580.6421066314851*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 7632.6551179585222*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 9580.6421066314851*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 7632.6551179585222*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) + X(2)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) + X(5)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
)) + 4*X(8)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0));


    jac(3,10) = -2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) - 6.3999999999999996e-10*X(2) + 7.1999999999999996e-8*X(0)/std::sqrt(T);


    jac(3,11) = -2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) - X(2)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
));


    jac(3,12) = 0;


    jac(3,13) = -2.8833736969617052e-16*std::pow(T, 0.25)*X(2);


    jac(3,14) = X(1)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
));


    jac(3,15) = (-std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(2)*X(4)*(5.1485802679346868*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 1.0)/T - 0.87659414490283338*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 2.0)/T - 3.5068370966299316/(T*M_LN10)) + 1658098.5*std::pow(T, -4.2799999999999994)*X(0)*X(8)*std::exp(-46707.0/T) - 80.939999999999998*std::pow(T, -3.2799999999999998)*X(0)*X(8)*std::exp(-46707.0/T) + 8.9351999999999994e-5*std::pow(T, -1.6499999999999999)*X(0)*X(8)*std::exp(-102000.0/T) - 3.9837168574084181e-7*std::pow(T, -1.5)*X(1)*X(7) + 2.6534040307116389e-10*std::pow(T, -1.1000000000000001)*X(2)*X(7) - 7.2084342424042629e-17*std::pow(T, -0.75)*X(12)*X(2) + 3.0659999999999995e-10*std::pow(T, -0.65000000000000002)*X(0)*X(8)*std::exp(-102000.0/T) - 2.5313028975878652e-10*std::pow(T, -0.59000000000000008)*X(2)*X(7) + 2.5313028975878652e-10*std::pow(T, -0.59000000000000008)*X(3)*X(5) - 1.2992000000000002e-18*std::pow(T, -0.071999999999999953)*X(0)*X(2)*std::exp(-6.1728395061728397e-5*T) + 8.6419753086419757e-23*std::pow(T, 0.92800000000000005)*X(0)*X(2)*std::exp(-6.1728395061728397e-5*T) + 8.9485740404797324e-18*std::pow(T, 1.360852208681)*X(0)*X(3)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(0)*X(3)*(-132.40745296375542*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 502.57312666436974*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 713.58279438845966*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 452.04559591922725*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 110.34576000052905*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 4.2657675552955459*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 0.56548861234079995*(std::log(T) - 9.3591486644682416)/T)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 7.997727392299023e-69*std::pow(T, 12.536555999999999)*X(0)*X(2)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 5.9082438637265071e-70*std::pow(T, 13.536555999999999)*X(0)*X(2)*(-102.61091246917582*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 526.69265558088011*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 1134.0049033576197*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 1336.0230978224265*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 943.44664424718405*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 410.76741499805485*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 11.478657500000001*(std::log(T) - 9.3591486644682416)/T)*std::exp(-120.0438480494693*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 704.19926629500367*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1768.8867461266502*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 2500.8077583366976*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2207.4643501257692*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 1281.477767828706*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 502.72883252679094*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + X(0)*X(1)*((8.6173430000000006e-5*T <= 5500.0) ? (
   -9.5174852894472843e-11*std::pow(T, -1.6353)
)
: (
   -2.3799651743169991e-10*std::pow(T, -1.724112565782685)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.2867337024382687e-10*std::pow(T, -0.72411256578268512)*(-1.6271673375367475*std::pow(0.10684732509875319*std::log(T) - 1, 8)/T - 0.93433329676104959*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 2.7077451444569309*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T + 2.1495916427711754*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T - 0.54533471131155187*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 1.0534802268965147*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T - 0.62564524397088728*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 0.04052089463969382*(std::log(T) - 9.3591486644682416)/T)*std::exp(-1.6921001126637107*std::pow(0.10684732509875319*std::log(T) - 1, 9) - 1.0930705283186732*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 3.6203127646377791*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 3.3530579587656564*std::pow(0.10684732509875319*std::log(T) - 1, 6) - 1.020773727011937*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 2.4649195146505534*std::pow(0.10684732509875319*std::log(T) - 1, 4) - 1.951835616513679*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1.774686809424741*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) + 2*X(0)*X(6)*((T <= 10000.0) ? (
   -2.7639999999999999e-27*std::pow(T, 4) + 1.3387199999999999e-22*std::pow(T, 3) - 2.2642200000000001e-18*std::pow(T, 2) + 1.4685599999999999e-14*T - 2.3088e-11
)
: (
   0
)) + X(1)*X(13)*((T <= 10000.0) ? (
   0.00016065*std::pow(T, -2.75)*std::exp(-127500.0/T) - 9.4499999999999994e-10*std::pow(T, -1.75)*std::exp(-127500.0/T)
)
: (
   1.8960000000000001e-36*std::pow(T, 3.7400000000000002)
)) - X(1)*X(2)*((T < 30) ? (
   -5.2466095085621454e-21*std::pow(T, -1.1499999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)*(-0.62159999999999993*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 3.5720000000000001*std::log(T)/(T*std::pow(M_LN10, 2)) - 3.194/(T*M_LN10))*M_LN10
)) + 2*X(1)*X(3)*((T >= 10.0 && T <= 100000.0) ? (
   -7.7700000000000002e-13 + 1.2500000000000001e-10/std::sqrt(T) - 1.48e-6/std::pow(T, 3.0/2.0)
)
: (
   0
)) + X(1)*X(5)*((T >= 50.0) ? (
   7.4200000000000004e-9*std::pow(T, -1.5979999999999999)*std::exp(-37.100000000000001/T) + 8.0400000000000002e-11*std::pow(T, -0.59799999999999998)*std::exp(-37.100000000000001/T) - 4.8987999999999998e-17*std::pow(T, 0.47999999999999998)
)
: (
   0
)) + X(1)*X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (2.4718352399999997e-12*std::pow(std::log(T), 6)/T - 1.09028466e-10*std::pow(std::log(T), 5)/T + 1.9865770999999999e-9*std::pow(std::log(T), 4)/T - 1.9125491199999999e-8*std::pow(std::log(T), 3)/T + 1.0251841499999999e-7*std::pow(std::log(T), 2)/T - 2.8982736e-7*std::log(T)/T + 3.3735381999999997e-7/T)*std::exp(-21237.150000000001/T) + 21237.150000000001*(3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)/std::pow(T, 2)
)
: (
   0
)) - X(10)*X(2)*((T > 200.0) ? (
   5.25e-11*(4430.0/std::pow(T, 2) - 347800.0/std::pow(T, 3))*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + std::pow(X(2), 3)*(-1.0000000000000001e-31*std::pow(T, -1.5) - 1.5e-32*std::pow(T, -1.25)) + std::pow(X(2), 3)*(3.0000000000000003e-31*std::pow(T, -1.5) + 4.5e-32*std::pow(T, -1.25)) + std::pow(X(2), 2)*X(8)*(2.5000000000000002e-32*std::pow(T, -1.5) + 3.75e-33*std::pow(T, -1.25)) - X(2)*X(3)*(1.3296555000000001e-10*std::pow(T, -0.90150700000000006) + 2.466314622e-10*std::pow(T, -0.44389999999999996) + 8.1647792100000001e-16*std::pow(T, 1.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) - X(2)*X(3)*(-0.0064764051000000007*std::pow(T, 0.04610000000000003) - 2.7293978880000002e-10*std::pow(T, 2.0424000000000002) - 1.229450816e-13*std::pow(T, 2.7740999999999998))*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/std::pow(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0, 2) + X(2)*X(3)*((T <= 1160.0) ? (
   2.6092635916521491e-16*std::pow(T, 0.78186)
)
: (
   3.7804827525136553e-14*std::pow(T, 0.13944933584163111)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*(-42.748389009145441*std::pow(0.10684732509875319*std::log(T) - 1, 8)/T + 123.5618943832626*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T - 121.61252027671875*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T + 37.329277187848724*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 7.7196459978647596*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 4.6983322613028582*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 2.2242979762200967*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 0.28420270431082961*(std::log(T) - 9.3591486644682416)/T)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - X(2)*X(4)*((T >= 50.0) ? (
   6.7980000000000007e-9*std::pow(T, -1.6040000000000001)*std::exp(-33.0/T) - 6.7396000000000002e-10*std::pow(T, -1.3320000000000001) + 8.1576000000000009e-11*std::pow(T, -0.60399999999999998)*std::exp(-33.0/T)
)
: (
   0
)) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-2.1870091368363029*std::log(T)/(T*std::pow(M_LN10, 2)) + 11.261747970100974/(T*M_LN10) - 308.15104860073512/std::pow(T, 2)) + (0.0046734386363636356*std::exp(-0.0022727272727272726*T) - 0.00031697691891891889*std::exp(-0.00054054054054054055*T))*(-1.0935045684181515*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 11.261747970100974*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 34.127143257836146 + 308.15104860073512/T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2) - 2.3025850929940459*(-13.899501000000001*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 75.773826*std::log(T)/(T*std::pow(M_LN10, 2)) - 14.509090000000008/(T*M_LN10) - 2848700.6345267999/(std::pow(T, 2)*(1.0 + 40870.379999999997/T)*M_LN10) - 331159.79815649998/(std::pow(T, 2)*(1.0 + 16780.950000000001/T)*M_LN10))/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) + 4790.3210533157426*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-2.1870091368363029*std::log(T)/(T*std::pow(M_LN10, 2)) + 11.261747970100974/(T*M_LN10) - 308.15104860073512/std::pow(T, 2)) + (0.0046734386363636356*std::exp(-0.0022727272727272726*T) - 0.00031697691891891889*std::exp(-0.00054054054054054055*T))*(-1.0935045684181515*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 11.261747970100974*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 31.445994754873134 + 308.15104860073512/T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)) - 32.004783802655837*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 198.95454259823751*std::log(T)/(T*std::pow(M_LN10, 2)) - 157.54846734442862/(T*M_LN10) + 54584.391438988954/std::pow(T, 2) + 4790.3210533157426/(std::pow(T, 2)*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)) - 6559375.6154640894/(std::pow(T, 2)*(1.0 + 40870.379999999997/T)*M_LN10)) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.91456607567139814*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.6735903924031659/(T*M_LN10) + 1710.9588792001557/std::pow(T, 2)) + (-0.0066761522727272725*std::exp(-0.0022727272727272726*T) - 0.0001275052972972973*std::exp(-0.00054054054054054055*T))*(-0.45728303783569907*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.6735903924031659*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 21.426852948302045 - 1710.9588792001557/T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2) - 2.3025850929940459*(-0.77462909999999996*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) - 9.4070299999999989*std::log(T)/(T*std::pow(M_LN10, 2)) + 70.138370000000009/(T*M_LN10) - 588180.10479140002/(std::pow(T, 2)*(1.0 + 27535.310000000001/T)*M_LN10) - 160821.97128249999/(std::pow(T, 2)*(1.0 + 14254.549999999999/T)*M_LN10))/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) + 3816.3275589792611*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.91456607567139814*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.6735903924031659/(T*M_LN10) + 1710.9588792001557/std::pow(T, 2)) + (-0.0066761522727272725*std::exp(-0.0022727272727272726*T) - 0.0001275052972972973*std::exp(-0.00054054054054054055*T))*(-0.45728303783569907*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.6735903924031659*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 18.723060823534531 - 1710.9588792001557/T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)) - 1.783649418259394*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) - 9.3363608541157479*std::log(T)/(T*std::pow(M_LN10, 2)) + 98.337445626384849/(T*M_LN10) + 49431.413233526648/std::pow(T, 2) + 3816.3275589792611/(std::pow(T, 2)*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)) - 1354334.7412883535/(std::pow(T, 2)*(1.0 + 27535.310000000001/T)*M_LN10))) + X(2)*X(8)*(3*std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-2.1870091368363029*std::log(T)/(T*std::pow(M_LN10, 2)) + 11.261747970100974/(T*M_LN10) - 308.15104860073512/std::pow(T, 2)) + (0.0046734386363636356*std::exp(-0.0022727272727272726*T) - 0.00031697691891891889*std::exp(-0.00054054054054054055*T))*(-1.0935045684181515*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 11.261747970100974*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 34.127143257836146 + 308.15104860073512/T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2) - 2.3025850929940459*(-13.899501000000001*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 75.773826*std::log(T)/(T*std::pow(M_LN10, 2)) - 14.509090000000008/(T*M_LN10) - 2848700.6345267999/(std::pow(T, 2)*(1.0 + 40870.379999999997/T)*M_LN10) - 331159.79815649998/(std::pow(T, 2)*(1.0 + 16780.950000000001/T)*M_LN10))/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) + 4790.3210533157426*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-2.1870091368363029*std::log(T)/(T*std::pow(M_LN10, 2)) + 11.261747970100974/(T*M_LN10) - 308.15104860073512/std::pow(T, 2)) + (0.0046734386363636356*std::exp(-0.0022727272727272726*T) - 0.00031697691891891889*std::exp(-0.00054054054054054055*T))*(-1.0935045684181515*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 11.261747970100974*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 31.445994754873134 + 308.15104860073512/T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)) - 32.004783802655837*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 198.95454259823751*std::log(T)/(T*std::pow(M_LN10, 2)) - 157.54846734442862/(T*M_LN10) + 54584.391438988954/std::pow(T, 2) + 4790.3210533157426/(std::pow(T, 2)*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)) - 6559375.6154640894/(std::pow(T, 2)*(1.0 + 40870.379999999997/T)*M_LN10)) + 3*std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.91456607567139814*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.6735903924031659/(T*M_LN10) + 1710.9588792001557/std::pow(T, 2)) + (-0.0066761522727272725*std::exp(-0.0022727272727272726*T) - 0.0001275052972972973*std::exp(-0.00054054054054054055*T))*(-0.45728303783569907*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.6735903924031659*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 21.426852948302045 - 1710.9588792001557/T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2) - 2.3025850929940459*(-0.77462909999999996*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) - 9.4070299999999989*std::log(T)/(T*std::pow(M_LN10, 2)) + 70.138370000000009/(T*M_LN10) - 588180.10479140002/(std::pow(T, 2)*(1.0 + 27535.310000000001/T)*M_LN10) - 160821.97128249999/(std::pow(T, 2)*(1.0 + 14254.549999999999/T)*M_LN10))/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) + 3816.3275589792611*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.91456607567139814*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.6735903924031659/(T*M_LN10) + 1710.9588792001557/std::pow(T, 2)) + (-0.0066761522727272725*std::exp(-0.0022727272727272726*T) - 0.0001275052972972973*std::exp(-0.00054054054054054055*T))*(-0.45728303783569907*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.6735903924031659*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 18.723060823534531 - 1710.9588792001557/T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)) - 1.783649418259394*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) - 9.3363608541157479*std::log(T)/(T*std::pow(M_LN10, 2)) + 98.337445626384849/(T*M_LN10) + 49431.413233526648/std::pow(T, 2) + 3816.3275589792611/(std::pow(T, 2)*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)) - 1354334.7412883535/(std::pow(T, 2)*(1.0 + 27535.310000000001/T)*M_LN10))) + X(5)*X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)*(1.5894349999999999*std::pow(std::log(T), 4)/(T*std::pow(M_LN10, 5)) - 8.6761199999999992*std::pow(std::log(T), 3)/(T*std::pow(M_LN10, 4)) + 6.7520699999999998*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 14.393840000000001*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.8888600000000002/(T*M_LN10))*M_LN10
)
: (
   1.650619e-6*std::exp(-5207.0/T)/std::pow(T, 2)
)) + 2*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(-22.860336491462885 - 69500.0/T)*(-7.460375701300709*(std::log(T) - 9.2103403719761836)/(T*std::pow(M_LN10, 2)) + 2.9933606208922598/(T*M_LN10))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 69500.0/(std::pow(T, 2)*(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))) + 2*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(-7.460375701300709*(std::log(T) - 9.2103403719761836)/(T*std::pow(M_LN10, 2)) + 2.9933606208922598/(T*M_LN10))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 12307692.307692308*std::sqrt(T)*(1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(0.0042250000000000005*std::pow(T, -2.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T) - 0.00048750000000000003*std::pow(T, -2.5)*std::exp(-58000.0/T) - 4.0625000000000001e-8*std::pow(T, -1.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T))*std::exp(52000.0/T)/(1.0 - std::exp(-6000.0/T))) - 3.5999999999999998e-8*X(0)*X(9)/std::pow(T, 3.0/2.0) - 2.4999999999999998e-6*X(3)*X(6)/std::pow(T, 3.0/2.0))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(4,1) = 35.5*std::pow(T, -2.2799999999999998)*X(8)*std::exp(-46707.0/T) + 1.4000000000000001e-18*std::pow(T, 0.92800000000000005)*X(2)*std::exp(-6.1728395061728397e-5*T) - 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(3)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2));


    jac(4,2) = -1.0e-8*std::pow(T, -0.40000000000000002)*X(3) - X(3)*((T >= 10.0 && T <= 100000.0) ? (
   2.5000000000000002e-10*std::sqrt(T) - 7.7700000000000002e-13*T - 1.73e-9 + 2.96e-6/std::sqrt(T)
)
: (
   0
));


    jac(4,3) = 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(7) + 1.4000000000000001e-18*std::pow(T, 0.92800000000000005)*X(0)*std::exp(-6.1728395061728397e-5*T) - X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) - X(3)*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(T, 1.78186)
)
: (
   3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
));


    jac(4,4) = -1.0e-8*std::pow(T, -0.40000000000000002)*X(1) - 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(5) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(5) - 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(0)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(1)*((T >= 10.0 && T <= 100000.0) ? (
   2.5000000000000002e-10*std::sqrt(T) - 7.7700000000000002e-13*T - 1.73e-9 + 2.96e-6/std::sqrt(T)
)
: (
   0
)) - X(2)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) - X(2)*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(T, 1.78186)
)
: (
   3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) - 4.9999999999999996e-6*X(6)/std::sqrt(T);


    jac(4,5) = 0;


    jac(4,6) = -2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(3) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(3);


    jac(4,7) = -4.9999999999999996e-6*X(3)/std::sqrt(T);


    jac(4,8) = 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(2);


    jac(4,9) = 35.5*std::pow(T, -2.2799999999999998)*X(0)*std::exp(-46707.0/T);


    jac(4,10) = 0;


    jac(4,11) = 0;


    jac(4,12) = 0;


    jac(4,13) = 0;


    jac(4,14) = 0;


    jac(4,15) = (1658098.5*std::pow(T, -4.2799999999999994)*X(0)*X(8)*std::exp(-46707.0/T) - 80.939999999999998*std::pow(T, -3.2799999999999998)*X(0)*X(8)*std::exp(-46707.0/T) + 4.0000000000000002e-9*std::pow(T, -1.3999999999999999)*X(1)*X(3) + 2.6534040307116389e-10*std::pow(T, -1.1000000000000001)*X(3)*X(5) + 2.5313028975878652e-10*std::pow(T, -0.59000000000000008)*X(2)*X(7) - 2.5313028975878652e-10*std::pow(T, -0.59000000000000008)*X(3)*X(5) + 1.2992000000000002e-18*std::pow(T, -0.071999999999999953)*X(0)*X(2)*std::exp(-6.1728395061728397e-5*T) - 8.6419753086419757e-23*std::pow(T, 0.92800000000000005)*X(0)*X(2)*std::exp(-6.1728395061728397e-5*T) - 8.9485740404797324e-18*std::pow(T, 1.360852208681)*X(0)*X(3)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 3.7903999274394518e-18*std::pow(T, 2.360852208681)*X(0)*X(3)*(-132.40745296375542*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 502.57312666436974*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 713.58279438845966*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 452.04559591922725*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 110.34576000052905*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 4.2657675552955459*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 0.56548861234079995*(std::log(T) - 9.3591486644682416)/T)*std::exp(-154.90262957142161*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 671.95094388835207*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 1113.0879095147111*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 846.15238706523724*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 258.18559308467115*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 13.307984239358756*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 24.766609674457612*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(1)*X(3)*((T >= 10.0 && T <= 100000.0) ? (
   -7.7700000000000002e-13 + 1.2500000000000001e-10/std::sqrt(T) - 1.48e-6/std::pow(T, 3.0/2.0)
)
: (
   0
)) - X(2)*X(3)*(1.3296555000000001e-10*std::pow(T, -0.90150700000000006) + 2.466314622e-10*std::pow(T, -0.44389999999999996) + 8.1647792100000001e-16*std::pow(T, 1.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) - X(2)*X(3)*(-0.0064764051000000007*std::pow(T, 0.04610000000000003) - 2.7293978880000002e-10*std::pow(T, 2.0424000000000002) - 1.229450816e-13*std::pow(T, 2.7740999999999998))*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/std::pow(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0, 2) - X(2)*X(3)*((T <= 1160.0) ? (
   2.6092635916521491e-16*std::pow(T, 0.78186)
)
: (
   3.7804827525136553e-14*std::pow(T, 0.13944933584163111)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.3178155742407614e-14*std::pow(T, 1.1394493358416311)*(-42.748389009145441*std::pow(0.10684732509875319*std::log(T) - 1, 8)/T + 123.5618943832626*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T - 121.61252027671875*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T + 37.329277187848724*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 7.7196459978647596*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 4.6983322613028582*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 2.2242979762200967*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 0.28420270431082961*(std::log(T) - 9.3591486644682416)/T)*std::exp(-44.454280878123605*std::pow(0.10684732509875319*std::log(T) - 1, 9) + 144.55426734953477*std::pow(0.10684732509875319*std::log(T) - 1, 8) - 162.59852239006702*std::pow(0.10684732509875319*std::log(T) - 1, 7) + 58.228375789703179*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 14.449862906216714*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 10.993097527150175*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 6.9391784778399117*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 12.447178055372778*std::pow(0.10684732509875319*std::log(T) - 1, 2))
)) + 2.4999999999999998e-6*X(3)*X(6)/std::pow(T, 3.0/2.0))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(5,1) = -2.5950363272655348e-10*std::pow(T, -0.75)*X(4);


    jac(5,2) = 1.0000000000000001e-9*X(10)*std::exp(-457.0/T) + X(5)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
));


    jac(5,3) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(4) - X(4)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
));


    jac(5,4) = 0;


    jac(5,5) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(2) - 2.5950363272655348e-10*std::pow(T, -0.75)*X(0) - 9.8726896031426014e-7*std::pow(T, -0.5)*X(7) - X(2)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
)) + X(8)*(1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 8.4600000000000008e-10*std::log(T)/M_LN10 - 4.1700000000000001e-10);


    jac(5,6) = X(1)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
));


    jac(5,7) = 0;


    jac(5,8) = -9.8726896031426014e-7*std::pow(T, -0.5)*X(4);


    jac(5,9) = X(4)*(1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 8.4600000000000008e-10*std::log(T)/M_LN10 - 4.1700000000000001e-10);


    jac(5,10) = 0;


    jac(5,11) = 1.0000000000000001e-9*X(1)*std::exp(-457.0/T);


    jac(5,12) = 0;


    jac(5,13) = 0;


    jac(5,14) = 0;


    jac(5,15) = (-std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(2)*X(4)*(5.1485802679346868*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 1.0)/T - 0.87659414490283338*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 2.0)/T - 3.5068370966299316/(T*M_LN10)) + 1.9462772454491511e-10*std::pow(T, -1.75)*X(0)*X(4) + 4.9363448015713007e-7*std::pow(T, -1.5)*X(4)*X(7) + X(1)*X(5)*((T >= 50.0) ? (
   7.4200000000000004e-9*std::pow(T, -1.5979999999999999)*std::exp(-37.100000000000001/T) + 8.0400000000000002e-11*std::pow(T, -0.59799999999999998)*std::exp(-37.100000000000001/T) - 4.8987999999999998e-17*std::pow(T, 0.47999999999999998)
)
: (
   0
)) - X(2)*X(4)*((T >= 50.0) ? (
   6.7980000000000007e-9*std::pow(T, -1.6040000000000001)*std::exp(-33.0/T) - 6.7396000000000002e-10*std::pow(T, -1.3320000000000001) + 8.1576000000000009e-11*std::pow(T, -0.60399999999999998)*std::exp(-33.0/T)
)
: (
   0
)) + X(4)*X(8)*(2.7400000000000004e-10*std::log(T)/(T*std::pow(M_LN10, 2)) - 8.4600000000000008e-10/(T*M_LN10)) + 4.5700000000000003e-7*X(1)*X(10)*std::exp(-457.0/T)/std::pow(T, 2))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(6,1) = 2.5950363272655348e-10*std::pow(T, -0.75)*X(4) - 1.3300135414628029e-18*std::pow(T, 0.94999999999999996)*X(5)*std::exp(-0.00010729613733905579*T) + 7.1999999999999996e-8*X(9)/std::sqrt(T);


    jac(6,2) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(5) + 7.9674337148168363e-7*std::pow(T, -0.5)*X(7) - X(5)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
));


    jac(6,3) = 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(7) + X(10)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + X(4)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
)) - 1.0e-25*X(5);


    jac(6,4) = -2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(5) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(5);


    jac(6,5) = 2.5950363272655348e-10*std::pow(T, -0.75)*X(0) + 1.9745379206285203e-6*std::pow(T, -0.5)*X(7) + X(2)*((T >= 50.0) ? (
   2.0299999999999998e-9*std::pow(T, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(T, 0.39600000000000002)*std::exp(-33.0/T)
)
: (
   0
));


    jac(6,6) = -std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(1) - 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(3) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(3) - 1.3300135414628029e-18*std::pow(T, 0.94999999999999996)*X(0)*std::exp(-0.00010729613733905579*T) - X(1)*((T >= 50.0) ? (
   2.0000000000000001e-10*std::pow(T, 0.40200000000000002)*std::exp(-37.100000000000001/T) - 3.3099999999999998e-17*std::pow(T, 1.48)
)
: (
   0
)) - 1.0e-25*X(2) - X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
));


    jac(6,7) = 0;


    jac(6,8) = 7.9674337148168363e-7*std::pow(T, -0.5)*X(1) + 1.9745379206285203e-6*std::pow(T, -0.5)*X(4) + 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(2);


    jac(6,9) = -X(5)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
));


    jac(6,10) = 7.1999999999999996e-8*X(0)/std::sqrt(T);


    jac(6,11) = X(2)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
));


    jac(6,12) = 0;


    jac(6,13) = 0;


    jac(6,14) = 0;


    jac(6,15) = (-std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(1)*X(5)*(5.1485802679346868*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 1.0)/T - 0.87659414490283338*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 2.0)/T - 3.5068370966299316/(T*M_LN10)) - 1.9462772454491511e-10*std::pow(T, -1.75)*X(0)*X(4) - 3.9837168574084181e-7*std::pow(T, -1.5)*X(1)*X(7) - 9.8726896031426014e-7*std::pow(T, -1.5)*X(4)*X(7) + 2.6534040307116389e-10*std::pow(T, -1.1000000000000001)*X(3)*X(5) + 2.5313028975878652e-10*std::pow(T, -0.59000000000000008)*X(2)*X(7) - 2.5313028975878652e-10*std::pow(T, -0.59000000000000008)*X(3)*X(5) - 1.2635128643896626e-18*std::pow(T, -0.050000000000000044)*X(0)*X(5)*std::exp(-0.00010729613733905579*T) + 1.4270531560759686e-22*std::pow(T, 0.94999999999999996)*X(0)*X(5)*std::exp(-0.00010729613733905579*T) - X(1)*X(5)*((T >= 50.0) ? (
   7.4200000000000004e-9*std::pow(T, -1.5979999999999999)*std::exp(-37.100000000000001/T) + 8.0400000000000002e-11*std::pow(T, -0.59799999999999998)*std::exp(-37.100000000000001/T) - 4.8987999999999998e-17*std::pow(T, 0.47999999999999998)
)
: (
   0
)) + X(10)*X(2)*((T > 200.0) ? (
   5.25e-11*(4430.0/std::pow(T, 2) - 347800.0/std::pow(T, 3))*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + X(2)*X(4)*((T >= 50.0) ? (
   6.7980000000000007e-9*std::pow(T, -1.6040000000000001)*std::exp(-33.0/T) - 6.7396000000000002e-10*std::pow(T, -1.3320000000000001) + 8.1576000000000009e-11*std::pow(T, -0.60399999999999998)*std::exp(-33.0/T)
)
: (
   0
)) - X(5)*X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)*(1.5894349999999999*std::pow(std::log(T), 4)/(T*std::pow(M_LN10, 5)) - 8.6761199999999992*std::pow(std::log(T), 3)/(T*std::pow(M_LN10, 4)) + 6.7520699999999998*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 14.393840000000001*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.8888600000000002/(T*M_LN10))*M_LN10
)
: (
   1.650619e-6*std::exp(-5207.0/T)/std::pow(T, 2)
)) - 3.5999999999999998e-8*X(0)*X(9)/std::pow(T, 3.0/2.0))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(7,1) = -X(6)*((T <= 10000.0) ? (
   -5.5279999999999998e-28*std::pow(T, 5) + 3.3467999999999999e-23*std::pow(T, 4) - 7.5474000000000004e-19*std::pow(T, 3) + 7.3427999999999993e-15*std::pow(T, 2) - 2.3088e-11*T + 4.2277999999999996e-8
)
: (
   0
));


    jac(7,2) = 1.0e-8*std::pow(T, -0.40000000000000002)*X(3) + X(2)*((T < 30) ? (
   3.4977396723747635e-20*std::pow(T, -0.14999999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)
)) + X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
));


    jac(7,3) = X(1)*((T < 30) ? (
   3.4977396723747635e-20*std::pow(T, -0.14999999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)
)) - 6.0e-10*X(6);


    jac(7,4) = 1.0e-8*std::pow(T, -0.40000000000000002)*X(1) - 4.9999999999999996e-6*X(6)/std::sqrt(T);


    jac(7,5) = 0;


    jac(7,6) = 0;


    jac(7,7) = -X(0)*((T <= 10000.0) ? (
   -5.5279999999999998e-28*std::pow(T, 5) + 3.3467999999999999e-23*std::pow(T, 4) - 7.5474000000000004e-19*std::pow(T, 3) + 7.3427999999999993e-15*std::pow(T, 2) - 2.3088e-11*T + 4.2277999999999996e-8
)
: (
   0
)) - 6.0e-10*X(2) - 4.9999999999999996e-6*X(3)/std::sqrt(T);


    jac(7,8) = 0;


    jac(7,9) = X(1)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
));


    jac(7,10) = 0;


    jac(7,11) = 0;


    jac(7,12) = 0;


    jac(7,13) = 0;


    jac(7,14) = 0;


    jac(7,15) = (-4.0000000000000002e-9*std::pow(T, -1.3999999999999999)*X(1)*X(3) - X(0)*X(6)*((T <= 10000.0) ? (
   -2.7639999999999999e-27*std::pow(T, 4) + 1.3387199999999999e-22*std::pow(T, 3) - 2.2642200000000001e-18*std::pow(T, 2) + 1.4685599999999999e-14*T - 2.3088e-11
)
: (
   0
)) + X(1)*X(2)*((T < 30) ? (
   -5.2466095085621454e-21*std::pow(T, -1.1499999999999999)
)
: (
   std::pow(10, -0.2072*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 1.786*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 3.194*std::log(T)/M_LN10 - 18.199999999999999)*(-0.62159999999999993*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 3.5720000000000001*std::log(T)/(T*std::pow(M_LN10, 2)) - 3.194/(T*M_LN10))*M_LN10
)) + X(1)*X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (2.4718352399999997e-12*std::pow(std::log(T), 6)/T - 1.09028466e-10*std::pow(std::log(T), 5)/T + 1.9865770999999999e-9*std::pow(std::log(T), 4)/T - 1.9125491199999999e-8*std::pow(std::log(T), 3)/T + 1.0251841499999999e-7*std::pow(std::log(T), 2)/T - 2.8982736e-7*std::log(T)/T + 3.3735381999999997e-7/T)*std::exp(-21237.150000000001/T) + 21237.150000000001*(3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)/std::pow(T, 2)
)
: (
   0
)) + 2.4999999999999998e-6*X(3)*X(6)/std::pow(T, 3.0/2.0))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(8,1) = 1.3300135414628029e-18*std::pow(T, 0.94999999999999996)*X(5)*std::exp(-0.00010729613733905579*T);


    jac(8,2) = -7.9674337148168363e-7*std::pow(T, -0.5)*X(7);


    jac(8,3) = -2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(7) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(7);


    jac(8,4) = 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(5);


    jac(8,5) = -9.8726896031426014e-7*std::pow(T, -0.5)*X(7);


    jac(8,6) = 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(3) + 1.3300135414628029e-18*std::pow(T, 0.94999999999999996)*X(0)*std::exp(-0.00010729613733905579*T);


    jac(8,7) = 0;


    jac(8,8) = -7.9674337148168363e-7*std::pow(T, -0.5)*X(1) - 9.8726896031426014e-7*std::pow(T, -0.5)*X(4) - 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(2) - 6.1739095063118665e-10*std::pow(T, 0.40999999999999998)*X(2);


    jac(8,9) = 0;


    jac(8,10) = 0;


    jac(8,11) = 0;


    jac(8,12) = 0;


    jac(8,13) = 0;


    jac(8,14) = 0;


    jac(8,15) = (3.9837168574084181e-7*std::pow(T, -1.5)*X(1)*X(7) + 4.9363448015713007e-7*std::pow(T, -1.5)*X(4)*X(7) + 2.6534040307116389e-10*std::pow(T, -1.1000000000000001)*X(2)*X(7) - 2.5313028975878652e-10*std::pow(T, -0.59000000000000008)*X(2)*X(7) + 2.5313028975878652e-10*std::pow(T, -0.59000000000000008)*X(3)*X(5) + 1.2635128643896626e-18*std::pow(T, -0.050000000000000044)*X(0)*X(5)*std::exp(-0.00010729613733905579*T) - 1.4270531560759686e-22*std::pow(T, 0.94999999999999996)*X(0)*X(5)*std::exp(-0.00010729613733905579*T))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(9,1) = -35.5*std::pow(T, -2.2799999999999998)*X(8)*std::exp(-46707.0/T) - 4.3799999999999999e-10*std::pow(T, 0.34999999999999998)*X(8)*std::exp(-102000.0/T);


    jac(9,2) = 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) - 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 1.0000000000000001e-9*X(10)*std::exp(-457.0/T) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) - X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
));


    jac(9,3) = 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) - 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + X(10)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + 3*std::pow(X(2), 2)*(2.0000000000000002e-31*std::pow(T, -0.5) + 6.0000000000000001e-32*std::pow(T, -0.25)) + 2*X(2)*X(8)*(-2.5000000000000002e-32*std::pow(T, -0.5) - 7.5000000000000001e-33*std::pow(T, -0.25)) + 2*X(2)*X(8)*(5.0000000000000004e-32*std::pow(T, -0.5) + 1.5e-32*std::pow(T, -0.25)) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + 6.0e-10*X(6) + X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0))));


    jac(9,4) = 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) - 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + 4.9999999999999996e-6*X(6)/std::sqrt(T);


    jac(9,5) = X(8)*(1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 8.4600000000000008e-10*std::log(T)/M_LN10 - 4.1700000000000001e-10);


    jac(9,6) = -X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
));


    jac(9,7) = 2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) - 2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 9580.6421066314851*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 7632.6551179585222*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + 6.0e-10*X(2) + 4.9999999999999996e-6*X(3)/std::sqrt(T);


    jac(9,8) = 0;


    jac(9,9) = 2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) - 2.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) - 35.5*std::pow(T, -2.2799999999999998)*X(0)*std::exp(-46707.0/T) - 4.3799999999999999e-10*std::pow(T, 0.34999999999999998)*X(0)*std::exp(-102000.0/T) - X(1)*((T >= 100.0 && T <= 30000.0) ? (
   (3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)
)
: (
   0
)) + std::pow(X(2), 2)*(-2.5000000000000002e-32*std::pow(T, -0.5) - 7.5000000000000001e-33*std::pow(T, -0.25)) + std::pow(X(2), 2)*(5.0000000000000004e-32*std::pow(T, -0.5) + 1.5e-32*std::pow(T, -0.25)) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 9580.6421066314851*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(4.6051701859880918*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 7632.6551179585222*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) + X(4)*(1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 8.4600000000000008e-10*std::log(T)/M_LN10 - 4.1700000000000001e-10) - X(5)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
)) - 2*X(8)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0));


    jac(9,10) = 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) - 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))));


    jac(9,11) = 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-22.860336491462885 - 69500.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) - 1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 1.0000000000000001e-9*X(1)*std::exp(-457.0/T) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 4790.3210533157426*std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)))) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 3816.3275589792611*std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))))) + X(2)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
));


    jac(9,12) = 0;


    jac(9,13) = 0;


    jac(9,14) = 0;


    jac(9,15) = (-1658098.5*std::pow(T, -4.2799999999999994)*X(0)*X(8)*std::exp(-46707.0/T) + 80.939999999999998*std::pow(T, -3.2799999999999998)*X(0)*X(8)*std::exp(-46707.0/T) - 4.4675999999999997e-5*std::pow(T, -1.6499999999999999)*X(0)*X(8)*std::exp(-102000.0/T) - 1.5329999999999998e-10*std::pow(T, -0.65000000000000002)*X(0)*X(8)*std::exp(-102000.0/T) - X(1)*X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (2.4718352399999997e-12*std::pow(std::log(T), 6)/T - 1.09028466e-10*std::pow(std::log(T), 5)/T + 1.9865770999999999e-9*std::pow(std::log(T), 4)/T - 1.9125491199999999e-8*std::pow(std::log(T), 3)/T + 1.0251841499999999e-7*std::pow(std::log(T), 2)/T - 2.8982736e-7*std::log(T)/T + 3.3735381999999997e-7/T)*std::exp(-21237.150000000001/T) + 21237.150000000001*(3.5311931999999998e-13*std::pow(std::log(T), 7) - 1.8171411000000001e-11*std::pow(std::log(T), 6) + 3.9731542e-10*std::pow(std::log(T), 5) - 4.7813727999999997e-9*std::pow(std::log(T), 4) + 3.4172804999999998e-8*std::pow(std::log(T), 3) - 1.4491368e-7*std::pow(std::log(T), 2) + 3.3735381999999997e-7*std::log(T) - 3.3232183000000002e-7)*std::exp(-21237.150000000001/T)/std::pow(T, 2)
)
: (
   0
)) + X(10)*X(2)*((T > 200.0) ? (
   5.25e-11*(4430.0/std::pow(T, 2) - 347800.0/std::pow(T, 3))*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + std::pow(X(2), 3)*(-1.0000000000000001e-31*std::pow(T, -1.5) - 1.5e-32*std::pow(T, -1.25)) + std::pow(X(2), 2)*X(8)*(-2.5000000000000002e-32*std::pow(T, -1.5) - 3.75e-33*std::pow(T, -1.25)) + std::pow(X(2), 2)*X(8)*(1.2500000000000001e-32*std::pow(T, -1.5) + 1.875e-33*std::pow(T, -1.25)) + X(2)*X(3)*(1.3296555000000001e-10*std::pow(T, -0.90150700000000006) + 2.466314622e-10*std::pow(T, -0.44389999999999996) + 8.1647792100000001e-16*std::pow(T, 1.1825999999999999))/(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0) + X(2)*X(3)*(-0.0064764051000000007*std::pow(T, 0.04610000000000003) - 2.7293978880000002e-10*std::pow(T, 2.0424000000000002) - 1.229450816e-13*std::pow(T, 2.7740999999999998))*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/std::pow(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0, 2) + X(2)*X(8)*(-std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 14.82123 - 133.82830000000001/T)*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-2.1870091368363029*std::log(T)/(T*std::pow(M_LN10, 2)) + 11.261747970100974/(T*M_LN10) - 308.15104860073512/std::pow(T, 2)) + (0.0046734386363636356*std::exp(-0.0022727272727272726*T) - 0.00031697691891891889*std::exp(-0.00054054054054054055*T))*(-1.0935045684181515*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 11.261747970100974*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 34.127143257836146 + 308.15104860073512/T))*(-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2) - 2.3025850929940459*(-13.899501000000001*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 75.773826*std::log(T)/(T*std::pow(M_LN10, 2)) - 14.509090000000008/(T*M_LN10) - 2848700.6345267999/(std::pow(T, 2)*(1.0 + 40870.379999999997/T)*M_LN10) - 331159.79815649998/(std::pow(T, 2)*(1.0 + 16780.950000000001/T)*M_LN10))/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) + 4790.3210533157426*std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*std::pow(10.0, 0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 4.8909149999999997*std::log(T)/M_LN10 + 13.656822 - 133.82830000000001/T)*(0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T))*(-2.1870091368363029*std::log(T)/(T*std::pow(M_LN10, 2)) + 11.261747970100974/(T*M_LN10) - 308.15104860073512/std::pow(T, 2)) + (0.0046734386363636356*std::exp(-0.0022727272727272726*T) - 0.00031697691891891889*std::exp(-0.00054054054054054055*T))*(-1.0935045684181515*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 11.261747970100974*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 31.445994754873134 + 308.15104860073512/T))/(T*std::pow(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0, 2)) - 32.004783802655837*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 198.95454259823751*std::log(T)/(T*std::pow(M_LN10, 2)) - 157.54846734442862/(T*M_LN10) + 54584.391438988954/std::pow(T, 2) + 4790.3210533157426/(std::pow(T, 2)*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0)) - 6559375.6154640894/(std::pow(T, 2)*(1.0 + 40870.379999999997/T)*M_LN10)) - std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))*(2.3025850929940459*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 9.3055640000000004 + 743.05999999999995/T)*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.91456607567139814*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.6735903924031659/(T*M_LN10) + 1710.9588792001557/std::pow(T, 2)) + (-0.0066761522727272725*std::exp(-0.0022727272727272726*T) - 0.0001275052972972973*std::exp(-0.00054054054054054055*T))*(-0.45728303783569907*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.6735903924031659*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 21.426852948302045 - 1710.9588792001557/T))*(-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2) - 2.3025850929940459*(-0.77462909999999996*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) - 9.4070299999999989*std::log(T)/(T*std::pow(M_LN10, 2)) + 70.138370000000009/(T*M_LN10) - 588180.10479140002/(std::pow(T, 2)*(1.0 + 27535.310000000001/T)*M_LN10) - 160821.97128249999/(std::pow(T, 2)*(1.0 + 14254.549999999999/T)*M_LN10))/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) + 3816.3275589792611*std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*std::pow(10.0, 0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 2.4640089999999999*std::log(T)/M_LN10 + 8.1313220000000008 + 743.05999999999995/T)*(0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T))*(-0.91456607567139814*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.6735903924031659/(T*M_LN10) + 1710.9588792001557/std::pow(T, 2)) + (-0.0066761522727272725*std::exp(-0.0022727272727272726*T) - 0.0001275052972972973*std::exp(-0.00054054054054054055*T))*(-0.45728303783569907*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.6735903924031659*std::log(T)/M_LN10 + std::log(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) - 18.723060823534531 - 1710.9588792001557/T))/(T*std::pow(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0, 2)) - 1.783649418259394*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) - 9.3363608541157479*std::log(T)/(T*std::pow(M_LN10, 2)) + 98.337445626384849/(T*M_LN10) + 49431.413233526648/std::pow(T, 2) + 3816.3275589792611/(std::pow(T, 2)*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)) - 1354334.7412883535/(std::pow(T, 2)*(1.0 + 27535.310000000001/T)*M_LN10))) + X(4)*X(8)*(2.7400000000000004e-10*std::log(T)/(T*std::pow(M_LN10, 2)) - 8.4600000000000008e-10/(T*M_LN10)) - X(5)*X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)*(1.5894349999999999*std::pow(std::log(T), 4)/(T*std::pow(M_LN10, 5)) - 8.6761199999999992*std::pow(std::log(T), 3)/(T*std::pow(M_LN10, 4)) + 6.7520699999999998*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 14.393840000000001*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.8888600000000002/(T*M_LN10))*M_LN10
)
: (
   1.650619e-6*std::exp(-5207.0/T)/std::pow(T, 2)
)) - std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(-1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(-22.860336491462885 - 69500.0/T)*(-7.460375701300709*(std::log(T) - 9.2103403719761836)/(T*std::pow(M_LN10, 2)) + 2.9933606208922598/(T*M_LN10))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 69500.0/(std::pow(T, 2)*(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))) - std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(1.0*std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(-7.460375701300709*(std::log(T) - 9.2103403719761836)/(T*std::pow(M_LN10, 2)) + 2.9933606208922598/(T*M_LN10))*(-0.5*std::log(T) + std::log(1.0 - std::exp(-6000.0/T)) - 16.325735015736566 - 52000.0/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))/std::pow(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0, 2) + 12307692.307692308*std::sqrt(T)*(1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*(0.0042250000000000005*std::pow(T, -2.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T) - 0.00048750000000000003*std::pow(T, -2.5)*std::exp(-58000.0/T) - 4.0625000000000001e-8*std::pow(T, -1.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T))*std::exp(52000.0/T)/(1.0 - std::exp(-6000.0/T))) + 4.5700000000000003e-7*X(1)*X(10)*std::exp(-457.0/T)/std::pow(T, 2) - 2.4999999999999998e-6*X(3)*X(6)/std::pow(T, 3.0/2.0))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(10,1) = -7.1999999999999996e-8*X(9)/std::sqrt(T);


    jac(10,2) = std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(5);


    jac(10,3) = std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(4) - 6.3999999999999996e-10*X(9);


    jac(10,4) = 0;


    jac(10,5) = std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(2);


    jac(10,6) = std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(1);


    jac(10,7) = 0;


    jac(10,8) = 0;


    jac(10,9) = 0;


    jac(10,10) = -6.3999999999999996e-10*X(2) - 7.1999999999999996e-8*X(0)/std::sqrt(T);


    jac(10,11) = 0;


    jac(10,12) = 0;


    jac(10,13) = 0;


    jac(10,14) = 0;


    jac(10,15) = (std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(1)*X(5)*(5.1485802679346868*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 1.0)/T - 0.87659414490283338*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 2.0)/T - 3.5068370966299316/(T*M_LN10)) + std::pow(10.0, -1.5229999999999999*std::log(T)/M_LN10 + 1.1180000000000001*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 2.0) - 0.12690000000000001*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 3.0) - 19.379999999999999)*X(2)*X(4)*(5.1485802679346868*std::pow(M_LN10, -2.0)*std::pow(std::log(T), 1.0)/T - 0.87659414490283338*std::pow(M_LN10, -3.0)*std::pow(std::log(T), 2.0)/T - 3.5068370966299316/(T*M_LN10)) + 3.5999999999999998e-8*X(0)*X(9)/std::pow(T, 3.0/2.0))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(11,1) = 0;


    jac(11,2) = -1.0000000000000001e-9*X(10)*std::exp(-457.0/T);


    jac(11,3) = 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(7) - X(10)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + 1.0e-25*X(5) + 6.3999999999999996e-10*X(9);


    jac(11,4) = 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(5);


    jac(11,5) = X(8)*(-1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 8.4600000000000008e-10*std::log(T)/M_LN10 + 4.1700000000000001e-10);


    jac(11,6) = 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(3) + 1.0e-25*X(2) + X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
));


    jac(11,7) = 0;


    jac(11,8) = 2.6534040307116387e-9*std::pow(T, -0.10000000000000001)*X(2);


    jac(11,9) = X(4)*(-1.3700000000000002e-10*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 8.4600000000000008e-10*std::log(T)/M_LN10 + 4.1700000000000001e-10) + X(5)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)
)
: (
   3.1699999999999999e-10*std::exp(-5207.0/T)
));


    jac(11,10) = 6.3999999999999996e-10*X(2);


    jac(11,11) = -1.0000000000000001e-9*X(1)*std::exp(-457.0/T) - X(2)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
));


    jac(11,12) = 0;


    jac(11,13) = 0;


    jac(11,14) = 0;


    jac(11,15) = (-2.6534040307116389e-10*std::pow(T, -1.1000000000000001)*X(2)*X(7) - 2.6534040307116389e-10*std::pow(T, -1.1000000000000001)*X(3)*X(5) - X(10)*X(2)*((T > 200.0) ? (
   5.25e-11*(4430.0/std::pow(T, 2) - 347800.0/std::pow(T, 3))*std::exp(-4430.0/T + 173900.0/std::pow(T, 2))
)
: (
   0
)) + X(4)*X(8)*(-2.7400000000000004e-10*std::log(T)/(T*std::pow(M_LN10, 2)) + 8.4600000000000008e-10/(T*M_LN10)) + X(5)*X(8)*((T <= 1167.4796423742259) ? (
   std::pow(10, 0.31788699999999998*std::pow(std::log(T), 5)/std::pow(M_LN10, 5) - 2.1690299999999998*std::pow(std::log(T), 4)/std::pow(M_LN10, 4) + 2.2506900000000001*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 7.1969200000000004*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 5.8888600000000002*std::log(T)/M_LN10 - 56.473700000000001)*(1.5894349999999999*std::pow(std::log(T), 4)/(T*std::pow(M_LN10, 5)) - 8.6761199999999992*std::pow(std::log(T), 3)/(T*std::pow(M_LN10, 4)) + 6.7520699999999998*std::pow(std::log(T), 2)/(T*std::pow(M_LN10, 3)) + 14.393840000000001*std::log(T)/(T*std::pow(M_LN10, 2)) + 5.8888600000000002/(T*M_LN10))*M_LN10
)
: (
   1.650619e-6*std::exp(-5207.0/T)/std::pow(T, 2)
)) - 4.5700000000000003e-7*X(1)*X(10)*std::exp(-457.0/T)/std::pow(T, 2))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(12,1) = 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(12)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 5.7884371785482823e-10*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::sqrt(T);


    jac(12,2) = 0;


    jac(12,3) = 0;


    jac(12,4) = 0;


    jac(12,5) = 0;


    jac(12,6) = 0;


    jac(12,7) = 0;


    jac(12,8) = 0;


    jac(12,9) = 0;


    jac(12,10) = 0;


    jac(12,11) = 0;


    jac(12,12) = -5.7884371785482823e-10*X(0)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::sqrt(T);


    jac(12,13) = 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(0)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2));


    jac(12,14) = 0;


    jac(12,15) = (1.694596485110541e-207*std::pow(T, 42.933476326349997)*X(0)*X(12)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(0)*X(12)*(-159.29342399384313*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 929.47621890049993*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 2293.8906388558121*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 3112.4265917774933*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 2522.5200862482043*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 1235.498068305666*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 36.961339871360003*(std::log(T) - 9.3591486644682416)/T)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 3.0451686126851684e-13*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -2.7523999999999997)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/T + 2.3410580000000002e-11*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -1.2476)/T + 2.8942185892741411e-10*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::pow(T, 3.0/2.0))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(13,1) = 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(13)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(12)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(12)*((8.6173430000000006e-5*T <= 9280.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   1250086.112245841*std::pow(T, -1.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)) + 5.7884371785482823e-10*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::sqrt(T);


    jac(13,2) = X(13)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
));


    jac(13,3) = -2.8833736969617052e-16*std::pow(T, 0.25)*X(12);


    jac(13,4) = 0;


    jac(13,5) = 0;


    jac(13,6) = 0;


    jac(13,7) = 0;


    jac(13,8) = 0;


    jac(13,9) = 0;


    jac(13,10) = 0;


    jac(13,11) = 0;


    jac(13,12) = 5.7884371785482823e-10*X(0)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::sqrt(T);


    jac(13,13) = -2.8833736969617052e-16*std::pow(T, 0.25)*X(2) - 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(0)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(0)*((8.6173430000000006e-5*T <= 9280.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   1250086.112245841*std::pow(T, -1.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
));


    jac(13,14) = 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(0)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + X(1)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
));


    jac(13,15) = (-7.2084342424042629e-17*std::pow(T, -0.75)*X(12)*X(2) + 1.0409203801861816e-115*std::pow(T, 22.915965629999999)*X(0)*X(13)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(0)*X(13)*(-183.62739846088516*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 972.53716821320074*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 2158.1860213397736*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 2606.9329003992802*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 1864.2690126126299*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 803.59445376387646*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 21.506460400000002*(std::log(T) - 9.3591486644682416)/T)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 1.694596485110541e-207*std::pow(T, 42.933476326349997)*X(0)*X(12)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 3.8571873359681582e-209*std::pow(T, 43.933476326349997)*X(0)*X(12)*(-159.29342399384313*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 929.47621890049993*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 2293.8906388558121*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 3112.4265917774933*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 2522.5200862482043*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 1235.498068305666*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 36.961339871360003*(std::log(T) - 9.3591486644682416)/T)*std::exp(-186.35635455381879*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1242.7294446825149*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3578.1439181805954*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 5825.9326359379538*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 5902.1601240760483*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 3854.4033653120223*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 1618.789587733125*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(0)*X(12)*((8.6173430000000006e-5*T <= 9280.0) ? (
   -9.5174852894472843e-11*std::pow(T, -1.6353)
)
: (
   587469852277.90271*std::pow(T, -3.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 54.282214350476039*std::pow(T, -3.5)*std::exp(-563932.20901156683/T) - 1875129.1683687614*std::pow(T, -2.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) - 9.5174852894472843e-11*std::pow(T, -1.6353)
)) + X(1)*X(13)*((T <= 10000.0) ? (
   0.00016065*std::pow(T, -2.75)*std::exp(-127500.0/T) - 9.4499999999999994e-10*std::pow(T, -1.75)*std::exp(-127500.0/T)
)
: (
   1.8960000000000001e-36*std::pow(T, 3.7400000000000002)
)) - 3.0451686126851684e-13*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -2.7523999999999997)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/T - 2.3410580000000002e-11*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -1.2476)/T - 2.8942185892741411e-10*X(0)*X(11)*std::pow(0.00060040841663220993*std::sqrt(T) + 1.0, -1.7524)*std::pow(0.32668576019240059*std::sqrt(T) + 1.0, -0.24759999999999999)/std::pow(T, 3.0/2.0))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(14,1) = -4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(13)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + X(12)*((8.6173430000000006e-5*T <= 9280.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   1250086.112245841*std::pow(T, -1.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
));


    jac(14,2) = -X(13)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
));


    jac(14,3) = 2.8833736969617052e-16*std::pow(T, 0.25)*X(12);


    jac(14,4) = 0;


    jac(14,5) = 0;


    jac(14,6) = 0;


    jac(14,7) = 0;


    jac(14,8) = 0;


    jac(14,9) = 0;


    jac(14,10) = 0;


    jac(14,11) = 0;


    jac(14,12) = 0;


    jac(14,13) = 2.8833736969617052e-16*std::pow(T, 0.25)*X(2) + X(0)*((8.6173430000000006e-5*T <= 9280.0) ? (
   1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
)
: (
   1250086.112245841*std::pow(T, -1.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 1.4981088130721367e-10*std::pow(T, -0.63529999999999998)
));


    jac(14,14) = -4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(0)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - X(1)*((T <= 10000.0) ? (
   1.26e-9*std::pow(T, -0.75)*std::exp(-127500.0/T)
)
: (
   4.0000000000000003e-37*std::pow(T, 4.7400000000000002)
));


    jac(14,15) = (7.2084342424042629e-17*std::pow(T, -0.75)*X(12)*X(2) - 1.0409203801861816e-115*std::pow(T, 22.915965629999999)*X(0)*X(13)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) - 4.3524079114767552e-117*std::pow(T, 23.915965629999999)*X(0)*X(13)*(-183.62739846088516*std::pow(0.10684732509875319*std::log(T) - 1, 7)/T + 972.53716821320074*std::pow(0.10684732509875319*std::log(T) - 1, 6)/T - 2158.1860213397736*std::pow(0.10684732509875319*std::log(T) - 1, 5)/T + 2606.9329003992802*std::pow(0.10684732509875319*std::log(T) - 1, 4)/T - 1864.2690126126299*std::pow(0.10684732509875319*std::log(T) - 1, 3)/T + 803.59445376387646*std::pow(0.10684732509875319*std::log(T) - 1, 2)/T - 21.506460400000002*(std::log(T) - 9.3591486644682416)/T)*std::exp(-214.82451513312137*std::pow(0.10684732509875319*std::log(T) - 1, 8) + 1300.3028484326148*std::pow(0.10684732509875319*std::log(T) - 1, 7) - 3366.4639698826941*std::pow(0.10684732509875319*std::log(T) - 1, 6) + 4879.7345146260486*std::pow(0.10684732509875319*std::log(T) - 1, 5) - 4361.9927099007555*std::pow(0.10684732509875319*std::log(T) - 1, 4) + 2506.9866529060901*std::pow(0.10684732509875319*std::log(T) - 1, 3) - 941.91483008144996*std::pow(0.10684732509875319*std::log(T) - 1, 2)) + X(0)*X(12)*((8.6173430000000006e-5*T <= 9280.0) ? (
   -9.5174852894472843e-11*std::pow(T, -1.6353)
)
: (
   587469852277.90271*std::pow(T, -3.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) + 54.282214350476039*std::pow(T, -3.5)*std::exp(-563932.20901156683/T) - 1875129.1683687614*std::pow(T, -2.5)*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661/T))*std::exp(-469943.50750964211/T) - 9.5174852894472843e-11*std::pow(T, -1.6353)
)) - X(1)*X(13)*((T <= 10000.0) ? (
   0.00016065*std::pow(T, -2.75)*std::exp(-127500.0/T) - 9.4499999999999994e-10*std::pow(T, -1.75)*std::exp(-127500.0/T)
)
: (
   1.8960000000000001e-36*std::pow(T, 3.7400000000000002)
)))/(2.0860422997526066e-16*X(0)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(1)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(10)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(11)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(12)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(13)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(2)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(3)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(4)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(5)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(6)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.0860422997526066e-16*X(7)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(8)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 3.4767371836380304e-16*X(9)/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)));


    jac(15,1) = -2.0340826846270714e+19*(-3.1438547368704001e-21*std::pow(T, 0.34999999999999998)*X(0)*X(8)*std::exp(-102000.0/T) - 0.00022681492*std::pow(T, 4)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))*((((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
   4.8339620236294848e-32/std::pow(std::pow(10.0, 2.1498900000000001 - 0.69317629274152892/M_LN10)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.1986273043946046e-56, 2) >= 1.0
)
: (
   ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
      4.8339620236294848e-32/std::pow(std::pow(10.0, 1.0000420000000001*std::log(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/M_LN10 + 2.1498900000000001)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.1986273043946046e-56, 2) >= 1.0
   )
   : (
      ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
         true
      )
      : (
         ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
            216.48287161311649/std::pow(std::pow(10.0, 2.1498900000000001 - 0.69317629274152892/M_LN10)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/std::fabs(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9)) + 1.471335691176954e-39, 2) >= 1.0
         )
         : (
            ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
               216.48287161311649/std::pow(std::pow(10.0, 1.0000420000000001*std::log(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/M_LN10 + 2.1498900000000001)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/std::fabs(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9)) + 1.471335691176954e-39, 2) >= 1.0
            )
            : (
               ((X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
                  true
               )
               : (
                  ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41) ? (
                     4.833962023629485e-72/std::pow(std::pow(10.0, 2.1498900000000001 - 0.69317629274152892/M_LN10)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))*std::sqrt(X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9)) + 2.1986273043946045e-76, 2) >= 1.0
                  )
                  : (
                     ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41) ? (
                        4.833962023629485e-72/std::pow(std::pow(10.0, 1.0000420000000001*std::log(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/M_LN10 + 2.1498900000000001)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))*std::sqrt(X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9)) + 2.1986273043946045e-76, 2) >= 1.0
                     )
                     : (
                        ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41) ? (
                           true
                        )
                        : (
                           ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5) ? (
                              2.1648287161311648e-38/std::pow(std::pow(10.0, 2.1498900000000001 - 0.69317629274152892/M_LN10)*std::sqrt(M_PI)*std::sqrt(T)*std::sqrt((X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9))/std::pow(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9), 2))*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 1.471335691176954e-59, 2) >= 1.0
                           )
                           : (
                              ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13) ? (
                                 2.1648287161311648e-38/std::pow(std::pow(10.0, 1.0000420000000001*std::log(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/M_LN10 + 2.1498900000000001)*std::sqrt(M_PI)*std::sqrt(T)*std::sqrt((X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9))/std::pow(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9), 2))*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 1.471335691176954e-59, 2) >= 1.0
                              )
                              : (
                                 true
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))
))) ? (
   1.0
)
: (
   483396202.36294854/std::pow(std::sqrt(M_PI)*std::sqrt(T)*std::sqrt(((X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
      9.9999999999999993e-41
   )
   : (
      X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9)
   ))*((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41) ? (
      1.0e+80
   )
   : (
      2.232953576238777e+46/std::pow(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9), 2)
   )))*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))*((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13) ? (
      std::pow(10.0, 1.0000420000000001*std::log(((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5) ? (
         0.5
      )
      : (
         9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)
      )))/M_LN10 + 2.1498900000000001)
   )
   : (
      0.0
   )) + 2.1986273043946046e-36, 2)
))*((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13) ? (
   std::pow(10.0, 1.0000420000000001*std::log(((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5) ? (
      0.5
   )
   : (
      9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)
   )))/M_LN10 + 2.1498900000000001)
)
: (
   0.0
)) + 0.00084373771595996178*T*(1.3806479999999999e-16*X(0) + 1.3806479999999999e-16*X(1) + 1.3806479999999999e-16*X(10) + 1.3806479999999999e-16*X(11) + 1.3806479999999999e-16*X(12) + 1.3806479999999999e-16*X(13) + 1.3806479999999999e-16*X(2) + 1.3806479999999999e-16*X(3) + 1.3806479999999999e-16*X(4) + 1.3806479999999999e-16*X(5) + 1.3806479999999999e-16*X(6) + 1.3806479999999999e-16*X(7) + 1.3806479999999999e-16*X(8) + 1.3806479999999999e-16*X(9))/(std::sqrt(M_PI)*std::sqrt(1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)))) - 5.0099999999999997e-27*std::pow(X(0), 2)*X(12)*((T <= 10) ? (
   0.67810976749343443
)
: (
   std::pow(T, -0.16869999999999999)
))*std::exp(-55338.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 9.1000000000000001e-27*std::pow(X(0), 2)*X(12)*((T <= 10) ? (
   0.67810976749343443
)
: (
   std::pow(T, -0.16869999999999999)
))*std::exp(-13179.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 3.4635323838154264e-26*X(0)*X(1)*((T <= 10) ? (
   0.63095734448019325
)
: (
   std::pow(T, -0.20000000000000001)
))*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))/(6.3095734448019361e-5*((T <= 10) ? (
   5.011872336272722
)
: (
   std::pow(T, 0.69999999999999996)
)) + 1.0) - 1.3854129535261706e-25*X(0)*X(11)*((T <= 10) ? (
   0.63095734448019325
)
: (
   std::pow(T, -0.20000000000000001)
))*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))/(6.3095734448019361e-5*((T <= 10) ? (
   5.011872336272722
)
: (
   std::pow(T, 0.69999999999999996)
)) + 1.0) - 1.24e-13*X(0)*X(12)*(1.0 + 0.29999999999999999*std::exp(-94000.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
))))*((T <= 10) ? (
   0.031622776601683791
)
: (
   std::pow(T, -1.5)
))*std::exp(-470000.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
))) - 1.5499999999999999e-26*X(0)*X(12)*((T <= 10) ? (
   2.3157944032250755
)
: (
   std::pow(T, 0.36470000000000002)
)) - 5.5399999999999998e-17*X(0)*X(12)*((T <= 10) ? (
   0.4008667176273028
)
: (
   std::pow(T, -0.39700000000000002)
))*std::exp(-473638.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 4.9500000000000001e-22*X(0)*X(12)*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))*std::exp(-631515.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 9.3799999999999993e-22*X(0)*X(13)*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))*std::exp(-285335.40000000002*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 1.2700000000000001e-21*X(0)*X(2)*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
))*std::exp(-157809.10000000001*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 7.4999999999999996e-19*X(0)*X(2)*std::exp(-118348.0*((T <= 10) ? (
   1.0/10.0
)
: (
   1.0/T
)))/(0.0031622776601683794*((T <= 10) ? (
   std::sqrt(10)
)
: (
   std::sqrt(T)
)) + 1.0) - 5.6500000000000001e-36*X(0)*std::pow(z + 1.0, 4)*(T - 2.73*z - 2.73) + 7.1777505408000004e-12*std::pow(X(2), 3)*(2.0000000000000002e-31*std::pow(T, -0.5) + 6.0000000000000001e-32*std::pow(T, -0.25))/(1000000.0*std::pow(T, -0.5)/((1.6000000000000001*X(2)*std::exp(-160000.0/std::pow(T, 2)) + 1.3999999999999999*X(8)*std::exp(-12000.0/(T + 1200.0)))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 1.0) + 7.1777505408000004e-12*std::pow(X(2), 2)*X(8)*(2.5000000000000002e-32*std::pow(T, -0.5) + 7.5000000000000001e-33*std::pow(T, -0.25))/(1000000.0*std::pow(T, -0.5)/((1.6000000000000001*X(2)*std::exp(-160000.0/std::pow(T, 2)) + 1.3999999999999999*X(8)*std::exp(-12000.0/(T + 1200.0)))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 1.0) + 5.6556829037999995e-12*X(2)*X(3)*(1.3500000000000001e-9*std::pow(T, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(T, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(T, 2.1825999999999999))/((1000000.0*std::pow(T, -0.5)/((1.6000000000000001*X(2)*std::exp(-160000.0/std::pow(T, 2)) + 1.3999999999999999*X(8)*std::exp(-12000.0/(T + 1200.0)))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 1.0)*(0.0061910000000000003*std::pow(T, 1.0461) + 8.9711999999999997e-11*std::pow(T, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(T, 3.7740999999999998) + 1.0)) + 1.75918975308e-21*X(2)*X(6)/(1000000.0*std::pow(T, -0.5)/((1.6000000000000001*X(2)*std::exp(-160000.0/std::pow(T, 2)) + 1.3999999999999999*X(8)*std::exp(-12000.0/(T + 1200.0)))*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9))) + 1.0) - 7.1777505408000004e-12*X(2)*X(8)*(std::pow(10.0, -4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 43.20243*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 68.422430000000006*std::log(T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 178.4239 - (-4.6331670000000003*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) + 37.886913*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) - 14.509090000000008*std::log(T)/M_LN10 + 19.734269999999999*std::log(1.0 + 16780.950000000001/T)/M_LN10 + 69.700860000000006*std::log(1.0 + 40870.379999999997/T)/M_LN10 - 307.31920000000002)/(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 14.82123 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0) - 23705.700000000001/T - 2080.4099999999999/(T*(std::pow(std::pow(10.0, -0.47490300000000002*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 4.8909149999999997*std::log(T)/M_LN10 - 13.656822 + 133.82830000000001/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.82274429999999998 - 2.0563129999999998*std::exp(-0.0022727272727272726*T) + 0.58640729999999996*std::exp(-0.00054054054054054055*T)) + 1.0))) + std::pow(10.0, -0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 2.0273650000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 42.707410000000003*std::log(T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 142.7664 - (-0.25820969999999999*std::pow(std::log(T), 3)/std::pow(M_LN10, 3) - 4.7035149999999994*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 70.138370000000009*std::log(T)/M_LN10 + 11.28215*std::log(1.0 + 14254.549999999999/T)/M_LN10 + 21.360939999999999*std::log(1.0 + 27535.310000000001/T)/M_LN10 - 203.11568)/(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 9.3055640000000004 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0) - 21467.790000000001/T - 1657.4099999999999/(T*(std::pow(std::pow(10.0, -0.19859550000000001*std::pow(std::log(T), 2)/std::pow(M_LN10, 2) + 2.4640089999999999*std::log(T)/M_LN10 - 8.1313220000000008 - 743.05999999999995/T)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)), 0.75022860000000002 + 2.9375070000000001*std::exp(-0.0022727272727272726*T) + 0.23588480000000001*std::exp(-0.00054054054054054055*T)) + 1.0)))) - 7.1777505408000004e-12*std::pow(X(8), 2)*std::pow(1.1800000000000001e-10*std::exp(-69500.0/T), 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0))*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0/T))*std::exp(-52000.0/T), 1.0 - 1.0/(std::pow(10.0, -137.42519902360013*std::pow(0.10857362047581294*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.3*(std::log(T) - 9.2103403719761836)/M_LN10 - 4.8449999999999998)*(X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9)) + 1.0)) - ((T < 2.0) ? (
   0
)
: (
   X(8)*((((1.2500000000000001e-10*X(0) + 1.2500000000000001e-10*X(1) + 1.2500000000000001e-10*X(10) + 1.2500000000000001e-10*X(11) + 1.2500000000000001e-10*X(12) + 1.2500000000000001e-10*X(13) + 1.2500000000000001e-10*X(2) + 1.2500000000000001e-10*X(3) + 1.2500000000000001e-10*X(4) + 1.2500000000000001e-10*X(5) + 1.2500000000000001e-10*X(6) + 1.2500000000000001e-10*X(7) + 1.2500000000000001e-10*X(8) + 1.2500000000000001e-10*X(9) <= 9.9999999999999993e-41) ? (
      true
   )
   : (
      28601.610899577994*std::pow(X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9), -0.45000000000000001) >= 1.0
   ))) ? (
      1.0
   )
   : (
      ((1.2500000000000001e-10*X(0) + 1.2500000000000001e-10*X(1) + 1.2500000000000001e-10*X(10) + 1.2500000000000001e-10*X(11) + 1.2500000000000001e-10*X(12) + 1.2500000000000001e-10*X(13) + 1.2500000000000001e-10*X(2) + 1.2500000000000001e-10*X(3) + 1.2500000000000001e-10*X(4) + 1.2500000000000001e-10*X(5) + 1.2500000000000001e-10*X(6) + 1.2500000000000001e-10*X(7) + 1.2500000000000001e-10*X(8) + 1.2500000000000001e-10*X(9) <= 9.9999999999999993e-41) ? (
         1.000000000000001e+18
      )
      : (
         28601.610899577994*std::pow(X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9), -0.45000000000000001)
      ))
   ))*((((T <= 100.0 && T <= 500.0 && T <= 10000.0 && T > 10.0 && T > 100 && T < 2000.0) ? (
      4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
   )
   : (
      ((T <= 500.0 && T <= 1000.0 && T <= 10000.0 && T > 10.0 && T > 100 && T < 2000.0) ? (
         4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
      )
      : (
         ((T <= 500.0 && T <= 6000.0 && T <= 10000.0 && T > 10.0 && T > 100 && T < 2000.0) ? (
            4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
         )
         : (
            ((T <= 500.0 && T <= 10000.0 && T > 10.0 && T > 100 && T < 2000.0) ? (
               4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
            )
            : (
               ((T <= 100.0 && T <= 500.0 && T > 100 && T < 2000.0) ? (
                  4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
               )
               : (
                  ((T <= 500.0 && T <= 1000.0 && T > 100 && T < 2000.0) ? (
                     4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                  )
                  : (
                     ((T <= 500.0 && T <= 6000.0 && T > 100 && T < 2000.0) ? (
                        4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                     )
                     : (
                        ((T <= 500.0 && T > 100 && T < 2000.0) ? (
                           4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                        )
                        : (
                           ((T <= 100.0 && T <= 10000.0 && T > 10.0 && T > 500.0 && T < 2000.0) ? (
                              4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                           )
                           : (
                              ((T <= 1000.0 && T <= 10000.0 && T > 10.0 && T > 500.0 && T < 2000.0) ? (
                                 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                              )
                              : (
                                 ((T <= 6000.0 && T <= 10000.0 && T > 10.0 && T > 500.0 && T < 2000.0) ? (
                                    4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                 )
                                 : (
                                    ((T <= 10000.0 && T > 10.0 && T > 500.0 && T < 2000.0) ? (
                                       4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                    )
                                    : (
                                       ((T <= 100.0 && T > 500.0 && T < 2000.0) ? (
                                          4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                       )
                                       : (
                                          ((T <= 1000.0 && T > 500.0 && T < 2000.0) ? (
                                             4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                          )
                                          : (
                                             ((T <= 6000.0 && T > 500.0 && T < 2000.0) ? (
                                                4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                             )
                                             : (
                                                ((T > 500.0 && T < 2000.0) ? (
                                                   4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                )
                                                : (
                                                   ((T <= 100.0 && T <= 10000.0 && T > 10.0 && T < 2000.0) ? (
                                                      std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                   )
                                                   : (
                                                      ((T <= 1000.0 && T <= 10000.0 && T > 10.0 && T < 2000.0) ? (
                                                         std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                      )
                                                      : (
                                                         ((T <= 6000.0 && T <= 10000.0 && T > 10.0 && T < 2000.0) ? (
                                                            std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                         )
                                                         : (
                                                            ((T <= 10000.0 && T > 10.0 && T < 2000.0) ? (
                                                               std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                            )
                                                            : (
                                                               ((T <= 100.0 && T < 2000.0) ? (
                                                                  std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                               )
                                                               : (
                                                                  ((T <= 1000.0 && T < 2000.0) ? (
                                                                     std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                                  )
                                                                  : (
                                                                     ((T <= 6000.0 && T < 2000.0) ? (
                                                                        std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                                     )
                                                                     : (
                                                                        ((T < 2000.0) ? (
                                                                           std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99 && 4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T) >= 1.0e-99
                                                                        )
                                                                        : (
                                                                           ((T <= 100.0 && T <= 500.0 && T <= 10000.0 && T > 10.0 && T > 100) ? (
                                                                              std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                           )
                                                                           : (
                                                                              ((T <= 500.0 && T <= 1000.0 && T <= 10000.0 && T > 10.0 && T > 100) ? (
                                                                                 std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                              )
                                                                              : (
                                                                                 ((T <= 500.0 && T <= 6000.0 && T <= 10000.0 && T > 10.0 && T > 100) ? (
                                                                                    std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                 )
                                                                                 : (
                                                                                    ((T <= 500.0 && T <= 10000.0 && T > 10.0 && T > 100) ? (
                                                                                       std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                    )
                                                                                    : (
                                                                                       ((T <= 100.0 && T <= 500.0 && T <= 10000.0 && T > 100) ? (
                                                                                          std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                       )
                                                                                       : (
                                                                                          ((T <= 500.0 && T <= 1000.0 && T <= 10000.0 && T > 100) ? (
                                                                                             std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                          )
                                                                                          : (
                                                                                             ((T <= 500.0 && T <= 6000.0 && T <= 10000.0 && T > 100) ? (
                                                                                                std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                             )
                                                                                             : (
                                                                                                ((T <= 500.0 && T <= 10000.0 && T > 100) ? (
                                                                                                   std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                )
                                                                                                : (
                                                                                                   ((T <= 100.0 && T <= 10000.0 && T > 10.0 && T > 500.0) ? (
                                                                                                      std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                   )
                                                                                                   : (
                                                                                                      ((T <= 1000.0 && T <= 10000.0 && T > 10.0 && T > 500.0) ? (
                                                                                                         std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                                      )
                                                                                                      : (
                                                                                                         ((T <= 6000.0 && T <= 10000.0 && T > 10.0 && T > 500.0) ? (
                                                                                                            std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                         )
                                                                                                         : (
                                                                                                            ((T <= 10000.0 && T > 10.0 && T > 500.0) ? (
                                                                                                               std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                                            )
                                                                                                            : (
                                                                                                               ((T <= 100.0 && T <= 10000.0 && T > 500.0) ? (
                                                                                                                  std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                               )
                                                                                                               : (
                                                                                                                  ((T <= 1000.0 && T <= 10000.0 && T > 500.0) ? (
                                                                                                                     std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                  )
                                                                                                                  : (
                                                                                                                     ((T <= 6000.0 && T <= 10000.0 && T > 500.0) ? (
                                                                                                                        std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                     )
                                                                                                                     : (
                                                                                                                        ((T <= 10000.0 && T > 500.0) ? (
                                                                                                                           std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                                        )
                                                                                                                        : (
                                                                                                                           ((T <= 100.0 && T <= 10000.0 && T > 10.0) ? (
                                                                                                                              std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                                           )
                                                                                                                           : (
                                                                                                                              ((T <= 1000.0 && T <= 10000.0 && T > 10.0) ? (
                                                                                                                                 std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                                                              )
                                                                                                                              : (
                                                                                                                                 ((T <= 6000.0 && T <= 10000.0 && T > 10.0) ? (
                                                                                                                                    std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                 )
                                                                                                                                 : (
                                                                                                                                    ((T <= 10000.0 && T > 10.0) ? (
                                                                                                                                       std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13) + std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1) >= 1.0e-99
                                                                                                                                    )
                                                                                                                                    : (
                                                                                                                                       ((T <= 100.0 && T <= 10000.0) ? (
                                                                                                                                          std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                                                       )
                                                                                                                                       : (
                                                                                                                                          ((T <= 1000.0 && T <= 10000.0) ? (
                                                                                                                                             std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                          )
                                                                                                                                          : (
                                                                                                                                             ((T <= 6000.0 && T <= 10000.0) ? (
                                                                                                                                                std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                             )
                                                                                                                                             : (
                                                                                                                                                ((T <= 10000.0) ? (
                                                                                                                                                   std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                                                                )
                                                                                                                                                : (
                                                                                                                                                   ((0.00020000000000000001*T - 6.0 >= 300.0 && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 1000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 6000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 1000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 6000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 1000.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 1000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T <= 6000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 6000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 1000.0 || T <= 6000.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 1000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T <= 6000.0 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 6000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 500.0 || T <= 1000.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 1000.0 || T <= 6000.0 || T > 100 || T > 500.0) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 500.0 || T <= 1000.0 || T <= 6000.0 || T > 100) && (0.00020000000000000001*T - 6.0 >= 300.0 || T <= 100.0 || T <= 1000.0 || T <= 6000.0 || T > 100 || T > 500.0)) ? (
                                                                                                                                                      false
                                                                                                                                                   )
                                                                                                                                                   : (
                                                                                                                                                      ((T <= 100.0 && T <= 500.0 && T > 100) ? (
                                                                                                                                                         5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                                                                      )
                                                                                                                                                      : (
                                                                                                                                                         ((T <= 500.0 && T <= 1000.0 && T > 100) ? (
                                                                                                                                                            5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                                         )
                                                                                                                                                         : (
                                                                                                                                                            ((T <= 500.0 && T <= 6000.0 && T > 100) ? (
                                                                                                                                                               5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                                            )
                                                                                                                                                            : (
                                                                                                                                                               ((T <= 500.0 && T > 100) ? (
                                                                                                                                                                  5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                                                                               )
                                                                                                                                                               : (
                                                                                                                                                                  ((T <= 100.0 && T > 500.0) ? (
                                                                                                                                                                     5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2) >= 1.0e-99
                                                                                                                                                                  )
                                                                                                                                                                  : (
                                                                                                                                                                     ((T <= 1000.0 && T > 500.0) ? (
                                                                                                                                                                        5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                                                     )
                                                                                                                                                                     : (
                                                                                                                                                                        ((T <= 6000.0 && T > 500.0) ? (
                                                                                                                                                                           5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) + std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2) >= 1.0e-99
                                                                                                                                                                        )
                                                                                                                                                                        : (
                                                                                                                                                                           5.5313336794064847e-19/(0.0024787521766663585*std::exp(0.00020000000000000001*T) + 1.0) >= 1.0e-99 && std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0) + 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2) + 1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1) + 1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13) >= 1.0e-99
                                                                                                                                                                        ))
                                                                                                                                                                     ))
                                                                                                                                                                  ))
                                                                                                                                                               ))
                                                                                                                                                            ))
                                                                                                                                                         ))
                                                                                                                                                      ))
                                                                                                                                                   ))
                                                                                                                                                ))
                                                                                                                                             ))
                                                                                                                                          ))
                                                                                                                                       ))
                                                                                                                                    ))
                                                                                                                                 ))
                                                                                                                              ))
                                                                                                                           ))
                                                                                                                        ))
                                                                                                                     ))
                                                                                                                  ))
                                                                                                               ))
                                                                                                            ))
                                                                                                         ))
                                                                                                      ))
                                                                                                   ))
                                                                                                ))
                                                                                             ))
                                                                                          ))
                                                                                       ))
                                                                                    ))
                                                                                 ))
                                                                              ))
                                                                           ))
                                                                        ))
                                                                     ))
                                                                  ))
                                                               ))
                                                            ))
                                                         ))
                                                      ))
                                                   ))
                                                ))
                                             ))
                                          ))
                                       ))
                                    ))
                                 ))
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))) ? (
      (std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*((T <= 500.0 && T > 100) ? (
         std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0)
      )
      : ((T > 500.0) ? (
         std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0)
      )
      : (
         0
      ))) + ((T <= 10000.0 && T > 10.0) ? (
         std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13)
      )
      : (
         1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13)
      )) + ((T <= 10000.0 && T > 10.0) ? (
         std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1)
      )
      : (
         1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1)
      )) + ((T <= 100.0) ? (
         std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2)
      )
      : ((T <= 1000.0) ? (
         std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2)
      )
      : ((T <= 6000.0) ? (
         std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2)
      )
      : (
         1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2)
      )))))*((T < 2000.0) ? (
         4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T)
      )
      : ((T <= 10000.0) ? (
         std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225)
      )
      : (
         5.5313336794064847e-19/(std::exp(((0.00020000000000000001*T - 6.0 >= 300.0) ? (
            300.0
         )
         : (
            0.00020000000000000001*T - 6.0
         ))) + 1.0)
      )))/(std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*std::pow(10.0, -529.07725573213918*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 339.5619991617852*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 144.02112655888752*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 36.814414747418546*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.0943374000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.962112000000001)*X(8) + std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17*std::pow(T, -25.0/M_LN10))*(1.6889118802245084e-48*std::pow(T, 25.0/M_LN10) + 10.0)))*((T <= 500.0 && T > 100) ? (
         std::pow(10.0, 366063607.58415633*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 273295393.17143697*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 87115306.05744876*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 15471651.937466398*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 1672890.7229183144*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 113122.17137872758*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 4616.3011562659685*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 16.815729999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 21.928795999999998)*X(0)
      )
      : ((T > 500.0) ? (
         std::pow(10.0, -33025002.640084207*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) + 4831859.3594864924*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) + 968783.44101153011*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) - 138531.11016116844*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 10763.919849753534*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1331.8748828877385*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 44.525106942242758*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.6802758*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.921188999999998)*X(0)
      )
      : (
         0
      ))) + ((T <= 10000.0 && T > 10.0) ? (
         std::pow(10.0, 3018.4974183098116*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 377.88183430702219*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 95.70878894783884*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 38.89917505778142*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 2.1892372*(std::log(T) - 6.9077552789821368)/M_LN10 - 23.689236999999999)*X(13)
      )
      : (
         1.002560385050777e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(13)
      )) + ((T <= 10000.0 && T > 10.0) ? (
         std::pow(10.0, 5059.6285287169567*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 1161.2797752309887*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 77.855706084264682*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 0.73442154540113413*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 1.5714710999999999*(std::log(T) - 6.9077552789821368)/M_LN10 - 22.089523)*X(1)
      )
      : (
         1.1825091393820599e-21*std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614*std::pow(T, -16.666666666666664/M_LN10))*(5.0592917094448065e-34*std::pow(T, 16.666666666666664/M_LN10) + 10.0)))*X(1)
      )) + ((T < 2000.0) ? (
         4.985670872372847e-33*std::pow(T, 3.7599999999999998)*std::exp(-2197000.0/std::pow(T, 3))/(6.0142468035272636e-8*std::pow(T, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0/T) + 6.7e-19*std::exp(-5860.0/T) + 3.0e-24*std::exp(-510.0/T)
      )
      : ((T <= 10000.0) ? (
         std::pow(10.0, 9415777.8988952208*std::pow(0.14476482730108395*std::log(T) - 1, 8)/std::pow(M_LN10, 8) - 1662263.0320406025*std::pow(0.14476482730108395*std::log(T) - 1, 7)/std::pow(M_LN10, 7) - 428804.85473346239*std::pow(0.14476482730108395*std::log(T) - 1, 6)/std::pow(M_LN10, 6) + 86051.290034608537*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 5627.2167698544854*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 1554.3387057364687*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 75.100986441619156*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 5.0194035000000001*(std::log(T) - 6.9077552789821368)/M_LN10 - 20.584225)
      )
      : (
         5.5313336794064847e-19/(std::exp(((0.00020000000000000001*T - 6.0 >= 300.0) ? (
            300.0
         )
         : (
            0.00020000000000000001*T - 6.0
         ))) + 1.0)
      ))) + ((T <= 100.0) ? (
         std::pow(10.0, 60522.293708798054*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) + 45902.322591745004*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 16037.924047681272*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) + 2774.5177117396752*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 37.383713*(std::log(T) - 6.9077552789821368)/M_LN10 - 16.818342000000001)*X(2)
      )
      : ((T <= 1000.0) ? (
         std::pow(10.0, -66875.646562351845*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 48562.751069188118*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) - 9179.8864335208946*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 540.77102118284597*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 3.5692468000000002*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2)
      )
      : ((T <= 6000.0) ? (
         std::pow(10.0, 24439.250555499191*std::pow(0.14476482730108395*std::log(T) - 1, 5)/std::pow(M_LN10, 5) - 12547.661945180447*std::pow(0.14476482730108395*std::log(T) - 1, 4)/std::pow(M_LN10, 4) + 1956.911370108365*std::pow(0.14476482730108395*std::log(T) - 1, 3)/std::pow(M_LN10, 3) - 177.55453097873294*std::pow(0.14476482730108395*std::log(T) - 1, 2)/std::pow(M_LN10, 2) + 4.6450521*(std::log(T) - 6.9077552789821368)/M_LN10 - 24.311209000000002)*X(2)
      )
      : (
         1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281297*std::pow(T, -17.997580222853358/M_LN10))*(1.3368457736780898e-34*std::pow(T, 17.997580222853358/M_LN10) + 10.0)))*X(2)
      )))))
   )
   : (
      0
   ))
)) - ((T >= 2.73*z + 2.73) ? (
   std::pow(10.0, 6.1920000000000003e-5*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 8) - 0.001482*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 7) + 0.0106*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 6) - 0.0083499999999999998*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/std::pow(M_LN10, 5) - 0.17333999999999999*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 4)/std::pow(M_LN10, 4) - 0.00066631000000000004*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 7) + 0.017590000000000001*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 6) - 0.13768*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 5) + 0.11711000000000001*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/std::pow(M_LN10, 4) + 2.1990599999999998*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 3)/std::pow(M_LN10, 3) + 0.0025140000000000002*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 6) - 0.073660000000000003*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 5) + 0.62343000000000004*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 4) - 0.54262999999999995*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/std::pow(M_LN10, 3) - 10.19097*std::pow(std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   ))), 2)/std::pow(M_LN10, 2) - 0.0036600000000000001*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 5) + 0.11864*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 4) - 1.06447*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 3) + 0.77951999999999999*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/std::pow(M_LN10, 2) + 21.93385*std::log(((T >= 10000.0) ? (
      10000.0
   )
   : (
      T
   )))/M_LN10 + 0.0027499999999999998*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 4)/std::pow(M_LN10, 4) - 0.076759999999999995*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 3)/std::pow(M_LN10, 3) + 0.54962*std::pow(std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   ))), 2)/std::pow(M_LN10, 2) + 0.92432999999999998*std::log(((((X(2) <= 0.01) ? (
      false
   )
   : (
      X(2) >= 10000000000.0
   ))) ? (
      10000000000.0
   )
   : (
      ((X(2) <= 0.01) ? (
         0.01
      )
      : (
         X(2)
      ))
   )))/M_LN10 - 42.567880000000002)*X(10)
)
: (
   0
)))/std::pow(0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9), 2) + (-3.1438547368704001e-21*std::pow(T, 0.34999999999999998)*X(8)*std::exp(-102000.0/T) - 0.00022681492*std::pow(T, 4)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))*((((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 0.5 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
   4.8339620236294848e-32/std::pow(std::pow(10.0, 2.1498900000000001 - 0.69317629274152892/M_LN10)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9)) + 2.1986273043946046e-56, 2) >= 1.0
)
: (
   ((9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) >= 9.9999999999999998e-13 && 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9) <= 9.9999999999999993e-41 && X(0) + X(1) + X(10) + X(11) + X(12) + X(13) + X(2) + X(3) + X(4) + X(5) + X(6) + X(7) + X(8) + X(9) <= 9.9999999999999993e-41) ? (
      4.8339620236294848e-32/std::pow(std::pow(10.0, 1.0000420000000001*std::log(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9))/M_LN10 + 2.1498900000000001)*std::sqrt(M_PI)*std::sqrt(T)*(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.691154098