% vykresleni grafu

clear

velik=20;

betas=[-92.083,-22.283,8.3513,24.509,43.691,62.801,89.822,117.45];
gamas=[178.16,158.21,155.85,164.44,175.39,191.54,209.67,237.49];

nbars=[113.05,118.14,127.12,140.22,156.76,177.74,204.17,238.78];
deltans=[91.920,91.496,95.556,103.72,113.90,127.28,143.38,165.43];


nbar0=100;
deltan0=sqrt(nbar0^2+nbar0);

figure(1)
plot([0,0],[nbar0-deltan0,nbar0+deltan0])
hold on
plot(0,nbar0,'.')
plot([0,0],[nbar0-deltan0,nbar0+deltan0],'+')
for n=1:8
plot([n,n],[nbars(n)-deltans(n),nbars(n)+deltans(n)])
plot([n,n],[nbars(n)-deltans(n),nbars(n)+deltans(n)],'+')
plot(n,nbars(n),'.')
end
hold off
axis([-0.5,8.5,-10,410])
set(gca,'FontSize',1.5*velik)

ns=0:1200;
probs=zeros(9,max(ns)+1);
probs(1,:)=(nbar0/(nbar0+1)).^ns/(nbar0+1);
for n=1:8
 probP=exp(-(ns-betas(n)).^2/2/gamas(n)^2);
 probs(n+1,:)=probP/sum(probP);
end

figure(2)
plot(ns,probs)
set(gca,'FontSize',velik)
axis([0,800,0,0.01])

