function cmap = cm_turbid(varargin)

% CM_TURBID: 256 color palette from CMOCEAN
%
% cmap = cm_turbid(M)
%
% TURBID colormap by Kristen Thyng.
%
% On Input:
%
%    M        Number of colors (integer, OPTIONAL)
%
% On Ouput:
%
%    cmap     Mx3 colormap matrix
%
% Usage:
%
%    colormap(cm_turbid)
%    colormap(flipud(cm_turbid))
%
% https://github.com/matplotlib/cmocean/tree/master/cmocean/rgb
%
% Thyng, K.M., C.A. Greene, R.D. Hetland, H.M. Zimmerle, and S.F DiMarco, 2016:
%   True colord of oceanography: Guidelines for effective and accurate colormap
%   selection, Oceanography, 29(3), 9-13, http://dx.doi.org/10.5670/oceanog.2016.66 
% 

% svn $Id: cm_turbid.m 895 2018-02-11 23:15:37Z arango $
  
% Initialize.

switch numel(varargin)
  case 0
    M = 256;
  case 1
    M = varargin{1};
end

% Set 256 colormap.

cmap = [[9.128247827303703765e-01, 9.639053479101408195e-01, 6.723488894068933019e-01],
        [9.105541439463002984e-01, 9.592872094872512134e-01, 6.663907644186453094e-01],
        [9.082861583229014935e-01, 9.546805250318116665e-01, 6.604691147501789983e-01],
        [9.060452334346256187e-01, 9.500783067250512248e-01, 6.545538618591559832e-01],
        [9.038150489008132116e-01, 9.454849862587190179e-01, 6.486649327173524826e-01],
        [9.016037749037892901e-01, 9.408980925645457072e-01, 6.427923205892623892e-01],
        [8.994100526612220925e-01, 9.363178430715828338e-01, 6.369376634451241470e-01],
        [8.972283335855062436e-01, 9.317456838096750404e-01, 6.311075587918794083e-01],
        [8.950696728809198754e-01, 9.271782394664687121e-01, 6.252888115672152747e-01],
        [8.929173737868275618e-01, 9.226202315494650419e-01, 6.195011901939884158e-01],
        [8.907923116926522722e-01, 9.180653547565199579e-01, 6.137200788543796248e-01],
        [8.886692522817520867e-01, 9.135209242332905655e-01, 6.079750370293484085e-01],
        [8.865762636352767512e-01, 9.089784066893161762e-01, 6.022333770048255985e-01],
        [8.844822115233714754e-01, 9.044469910654970857e-01, 5.965311430834745465e-01],
        [8.824197090505849772e-01, 8.999166548769963470e-01, 5.908308404756164034e-01],
        [8.803543805345617201e-01, 8.953977033216384829e-01, 5.851717778972109762e-01],
        [8.783207074075700671e-01, 8.908794045328807254e-01, 5.795148392301145979e-01],
        [8.762837291194094380e-01, 8.863723903264537629e-01, 5.738994936029852001e-01],
        [8.742771906432560414e-01, 8.818660105043367725e-01, 5.682879912596860983e-01],
        [8.722681388310039585e-01, 8.773704198332279436e-01, 5.627170493987142530e-01],
        [8.702869566172963811e-01, 8.728758815872331711e-01, 5.571531747195710427e-01],
        [8.683053185700908561e-01, 8.683912265313378231e-01, 5.516275115467151879e-01],
        [8.663476627856837586e-01, 8.639084851022803546e-01, 5.461135394992869818e-01],
        [8.643928371591906856e-01, 8.594343049131268897e-01, 5.406342206369587622e-01],
        [8.624568202066339451e-01, 8.549633517080399425e-01, 5.351725180271732496e-01],
        [8.605281096749168857e-01, 8.504992167172934492e-01, 5.297408107341389227e-01],
        [8.586117879987910095e-01, 8.460400804193519697e-01, 5.243338350869022335e-01],
        [8.567083921128474389e-01, 8.415855961633933457e-01, 5.189512185545770429e-01],
        [8.548097683783190126e-01, 8.371383437933764826e-01, 5.136015164012288636e-01],
        [8.529307767408889074e-01, 8.326931553267608033e-01, 5.082696912104300857e-01],
        [8.510506087990278301e-01, 8.282569318779919865e-01, 5.029770800265680464e-01],
        [8.491921882796159560e-01, 8.238216896030918779e-01, 4.977007922336022516e-01],
        [8.473354714528938958e-01, 8.193941476796476886e-01, 4.924611248003303854e-01],
        [8.454893810507302376e-01, 8.149710832043290942e-01, 4.872494055687389136e-01],
        [8.436548921629284381e-01, 8.105519834307682858e-01, 4.820650051378080891e-01],
        [8.418197380538857688e-01, 8.061410299518165790e-01, 4.769199747107543685e-01],
        [8.400053197367541857e-01, 8.017304745289870471e-01, 4.717941759727964368e-01],
        [8.381909179373602248e-01, 7.973275360052080041e-01, 4.667076177307682427e-01],
        [8.363830265089613469e-01, 7.929297607375542789e-01, 4.616544156277210820e-01],
        [8.345877920103869085e-01, 7.885347495856604993e-01, 4.566293264683093933e-01],
        [8.327919089080556558e-01, 7.841472126590459668e-01, 4.516448413369297810e-01],
        [8.310063135234079246e-01, 7.797629900031863848e-01, 4.466914503101058753e-01],
        [8.292275089883606176e-01, 7.753832051359705879e-01, 4.417727747802380756e-01],
        [8.274479714210091208e-01, 7.710105395274703399e-01, 4.368957512003675547e-01],
        [8.256785592470122781e-01, 7.666407630966191045e-01, 4.320514550589309999e-01],
        [8.239135967944541949e-01, 7.622758578672201857e-01, 4.272453035219374029e-01],
        [8.221475640634913207e-01, 7.579178098056661428e-01, 4.224823211006376589e-01],
        [8.203879070453153899e-01, 7.535636173491093714e-01, 4.177568735562176006e-01],
        [8.186335117171099629e-01, 7.492135470811618347e-01, 4.130705335781763021e-01],
        [8.168774297351566460e-01, 7.448701849739395309e-01, 4.084293549358841147e-01],
        [8.151208269598283485e-01, 7.405329639445877854e-01, 4.038328842986566580e-01],
        [8.133730042127403914e-01, 7.361980289394938204e-01, 3.992747817294182155e-01],
        [8.116225817355652294e-01, 7.318697849631130570e-01, 3.947642928691043052e-01],
        [8.098694933912269356e-01, 7.275481580762414024e-01, 3.903019868836329342e-01],
        [8.081161421647475862e-01, 7.232320558774254504e-01, 3.858867812020280175e-01],
        [8.063663538470418057e-01, 7.189197605534187741e-01, 3.815168716651668457e-01],
        [8.046125622407066524e-01, 7.146142683294098852e-01, 3.771981838442269308e-01],
        [8.028545343811845925e-01, 7.103155798131343124e-01, 3.729315169481128289e-01],
        [8.010919901003339394e-01, 7.060237163039633224e-01, 3.687177325408004802e-01],
        [7.993300055097595225e-01, 7.017364019961147559e-01, 3.645545873969476269e-01],
        [7.975634994838864955e-01, 6.974556802865253813e-01, 3.604460667960328046e-01],
        [7.957906047709230046e-01, 6.931822615073386373e-01, 3.563940392198953200e-01],
        [7.940108757837693876e-01, 6.889162546167795220e-01, 3.523995277667577586e-01],
        [7.922238209776574225e-01, 6.846577925964051348e-01, 3.484635956840971271e-01],
        [7.904293753935112132e-01, 6.804068218754933950e-01, 3.445871200261476641e-01],
        [7.886299371669703850e-01, 6.761621751401072355e-01, 3.407699499113064912e-01],
        [7.868208547545553211e-01, 6.719258532155115704e-01, 3.370151794848580962e-01],
        [7.850015016585555339e-01, 6.676980777850795024e-01, 3.333239143922641090e-01],
        [7.831712152651345571e-01, 6.634790940463787257e-01, 3.296972647086952590e-01],
        [7.813292995863233559e-01, 6.592691702526117803e-01, 3.261363364073748827e-01],
        [7.794750283869652518e-01, 6.550685970372218669e-01, 3.226422224503434077e-01],
        [7.776076486673221266e-01, 6.508776865233487641e-01, 3.192159935965748763e-01],
        [7.757263844650232887e-01, 6.466967712234903409e-01, 3.158586890319579621e-01],
        [7.738304409335882150e-01, 6.425262027384857078e-01, 3.125713069333992955e-01],
        [7.719190086491207747e-01, 6.383663502685200664e-01, 3.093547950848793415e-01],
        [7.699919228068800026e-01, 6.342172763144198200e-01, 3.062099646060428282e-01],
        [7.680475840592058123e-01, 6.300797563557358760e-01, 3.031377731717001534e-01],
        [7.660850744742599971e-01, 6.259542495514858196e-01, 3.001389551573931946e-01],
        [7.641036016288820232e-01, 6.218411653176698639e-01, 2.972141439455896483e-01],
        [7.621023798026289597e-01, 6.177409214840726692e-01, 2.943638837738908332e-01],
        [7.600806343242360041e-01, 6.136539422033919777e-01, 2.915886230831420400e-01],
        [7.580376057793873912e-01, 6.095806558220696614e-01, 2.888887086342720734e-01],
        [7.559725540291885038e-01, 6.055214927394206859e-01, 2.862643804685457427e-01],
        [7.538847619930633126e-01, 6.014768832813116584e-01, 2.837157677714013393e-01],
        [7.517735391550399715e-01, 5.974472556137478962e-01, 2.812428856843471325e-01],
        [7.496385821697367779e-01, 5.934328401156596655e-01, 2.788457594157026098e-01],
        [7.474790247249349928e-01, 5.894341791373612915e-01, 2.765241346674250367e-01],
        [7.452941571551999766e-01, 5.854517449359323278e-01, 2.742776443121395791e-01],
        [7.430834135426160891e-01, 5.814859431780246002e-01, 2.721058338160937673e-01],
        [7.408462686359136296e-01, 5.775371675495697410e-01, 2.700081319859798934e-01],
        [7.385822390693008721e-01, 5.736057983656746018e-01, 2.679838537450121017e-01],
        [7.362908841899132861e-01, 5.696922013455091305e-01, 2.660322037116858995e-01],
        [7.339718065076965559e-01, 5.657967265562297010e-01, 2.641522805055408485e-01],
        [7.316246517864810617e-01, 5.619197075270785380e-01, 2.623430816971141777e-01],
        [7.292491087989990683e-01, 5.580614605321673194e-01, 2.606035093141773062e-01],
        [7.268449087719649482e-01, 5.542222840379915638e-01, 2.589323758133949549e-01],
        [7.244119971505563749e-01, 5.504023530996886571e-01, 2.573286095051418587e-01],
        [7.219503397818252122e-01, 5.466018316756788842e-01, 2.557911025974954899e-01],
        [7.194594088198653647e-01, 5.428211930643935812e-01, 2.543180251101427314e-01],
        [7.169390970998404944e-01, 5.390606612983260826e-01, 2.529078914226555730e-01],
        [7.143893337983732161e-01, 5.353204418367376594e-01, 2.515591605975798783e-01],
        [7.118100825627617922e-01, 5.316007218689121627e-01, 2.502702433238302993e-01],
        [7.092013395547599464e-01, 5.279016707079033921e-01, 2.490395087311264022e-01],
        [7.065632761648270588e-01, 5.242233436125348645e-01, 2.478655721838471937e-01],
        [7.038960056028840118e-01, 5.205658319141027723e-01, 2.467469222620103930e-01],
        [7.011993601253575514e-01, 5.169294192806536126e-01, 2.456813814978507926e-01],
        [6.984734491802424561e-01, 5.133142072042380377e-01, 2.446672141412145063e-01],
        [6.957184043559518916e-01, 5.097202822466132544e-01, 2.437026738057547215e-01],
        [6.929343773945654261e-01, 5.061477167394171639e-01, 2.427860085204449625e-01],
        [6.901216982990902027e-01, 5.025964514073363310e-01, 2.419159412674971588e-01],
        [6.872804633072713276e-01, 4.990665929836670123e-01, 2.410905423858894503e-01],
        [6.844107686966893755e-01, 4.955582518851005536e-01, 2.403077709414531138e-01],
        [6.815128311469199618e-01, 4.920714492259936068e-01, 2.395658950635757289e-01],
        [6.785868785067301623e-01, 4.886061954699182919e-01, 2.388631970725307307e-01],
        [6.756332326667190413e-01, 4.851624213327032087e-01, 2.381983436213906957e-01],
        [6.726521288960277678e-01, 4.817401209176369048e-01, 2.375696985886235346e-01],
        [6.696437188359446457e-01, 4.783393588339723279e-01, 2.369751854422654791e-01],
        [6.666082635296274317e-01, 4.749601080715157297e-01, 2.364131671114735878e-01],
        [6.635460289039749604e-01, 4.716023339061982678e-01, 2.358820311548202042e-01],
        [6.604573673748913576e-01, 4.682659130292578520e-01, 2.353807610155446706e-01],
        [6.573424797961275878e-01, 4.649508592384817285e-01, 2.349074379402631418e-01],
        [6.542016086091390070e-01, 4.616571492422122946e-01, 2.344603126221481149e-01],
        [6.510350327978842166e-01, 4.583847209004847101e-01, 2.340378795902509079e-01],
        [6.478430515953373936e-01, 4.551334824230311438e-01, 2.336388774485689268e-01],
        [6.446259633611755024e-01, 4.519033296020167900e-01, 2.332622032236857934e-01],
        [6.413839940492124247e-01, 4.486942500114745047e-01, 2.329058642884746511e-01],
        [6.381174276440877424e-01, 4.455061586981217681e-01, 2.325684660088059297e-01],
        [6.348265500932614991e-01, 4.423389620941622913e-01, 2.322486831842977550e-01],
        [6.315116605695774155e-01, 4.391925158791953887e-01, 2.319458531661305334e-01],
        [6.281730104223729461e-01, 4.360667833034455043e-01, 2.316579279478628295e-01],
        [6.248108867019236401e-01, 4.329616581049553492e-01, 2.313836187886625928e-01],
        [6.214255770673621226e-01, 4.298770280576157399e-01, 2.311216752923600515e-01],
        [6.180173538237878628e-01, 4.268127440894281532e-01, 2.308715541128374960e-01],
        [6.145865084649400067e-01, 4.237687269357882092e-01, 2.306313089541623396e-01],
        [6.111333338376842006e-01, 4.207448478787260138e-01, 2.303997483300764260e-01],
        [6.076581198732585731e-01, 4.177409699743503957e-01, 2.301757903742778777e-01],
        [6.041611292458852756e-01, 4.147569442408376994e-01, 2.299587629276800271e-01],
        [6.006426901866908086e-01, 4.117926430199113641e-01, 2.297469460659757323e-01],
        [5.971031071270087587e-01, 4.088479120598013661e-01, 2.295392371763493311e-01],
        [5.935426680352169360e-01, 4.059225898260850895e-01, 2.293347588094398759e-01],
        [5.899616653081597439e-01, 4.030165124281641087e-01, 2.291325734316880802e-01],
        [5.863604503326285133e-01, 4.001295067793814719e-01, 2.289312648345211421e-01],
        [5.827393462725786177e-01, 3.972613890222796984e-01, 2.287298138873416486e-01],
        [5.790986411902667719e-01, 3.944119738157387811e-01, 2.285275119372468522e-01],
        [5.754386920094946012e-01, 3.915810608797961612e-01, 2.283231701874827158e-01],
        [5.717598595710956522e-01, 3.887684389212705538e-01, 2.281156877135243621e-01],
        [5.680624888217489232e-01, 3.859738913687448258e-01, 2.279041499218198430e-01],
        [5.643468987836690598e-01, 3.831972016166527162e-01, 2.276878398717704366e-01],
        [5.606135014398240246e-01, 3.804381236067138072e-01, 2.274655664744977823e-01],
        [5.568626686009898741e-01, 3.776964124183660454e-01, 2.272364567122592827e-01],
        [5.530947703612836275e-01, 3.749718169415875435e-01, 2.269997025952595338e-01],
        [5.493102061694418170e-01, 3.722640707136085636e-01, 2.267544107214977123e-01],
        [5.455093844474366849e-01, 3.695728971647626593e-01, 2.264997151134776621e-01],
        [5.416927086216569709e-01, 3.668980144097471752e-01, 2.262348350480499204e-01],
        [5.378606217947595747e-01, 3.642391205981750923e-01, 2.259588836659274236e-01],
        [5.340135354481294616e-01, 3.615959178208362768e-01, 2.256711679956127647e-01],
        [5.301518754638107067e-01, 3.589680973433583278e-01, 2.253709864348782954e-01],
        [5.262761094769513592e-01, 3.563553292394111560e-01, 2.250575362145477709e-01],
        [5.223867172868102982e-01, 3.537572724565644089e-01, 2.247300369556790578e-01],
        [5.184841017313481792e-01, 3.511736091955309780e-01, 2.243880288453043437e-01],
        [5.145687147834636654e-01, 3.486039985632924942e-01, 2.240309158662728284e-01],
        [5.106411440519553757e-01, 3.460480410893026493e-01, 2.236577184811773256e-01],
        [5.067017881423235837e-01, 3.435054056903972253e-01, 2.232681227570667559e-01],
        [5.027510796252681047e-01, 3.409757445575836710e-01, 2.228617265136721426e-01],
        [4.987895070653633467e-01, 3.384586834157125024e-01, 2.224379910665530979e-01],
        [4.948177548651969127e-01, 3.359537625951555251e-01, 2.219958720410014630e-01],
        [4.908360971463728295e-01, 3.334606870942352086e-01, 2.215355358785864315e-01],
        [4.868450056329213793e-01, 3.309790783774143597e-01, 2.210565950309411609e-01],
        [4.828450375686827445e-01, 3.285085184570587513e-01, 2.205584694191147777e-01],
        [4.788368359138705510e-01, 3.260485487451708631e-01, 2.200404115431305319e-01],
        [4.748206472212548879e-01, 3.235988770790072522e-01, 2.195027100981302715e-01],
        [4.707969362808618885e-01, 3.211591169778729160e-01, 2.189450971836008897e-01],
        [4.667662693795122109e-01, 3.187288356425135860e-01, 2.183670869460304087e-01],
        [4.627293116701075015e-01, 3.163075541790801304e-01, 2.177680072916463594e-01],
        [4.586862340695841422e-01, 3.138950081558932736e-01, 2.171483462825098965e-01],
        [4.546374811311343911e-01, 3.114908131915107847e-01, 2.165079490118044792e-01],
        [4.505834924512453488e-01, 3.090945859801553230e-01, 2.158466824363790559e-01],
        [4.465251651502277208e-01, 3.067057384379430762e-01, 2.151634647284257906e-01],
        [4.424624800332205288e-01, 3.043240886593481798e-01, 2.144591818414338102e-01],
        [4.383958498551490668e-01, 3.019492632236420726e-01, 2.137337799541155214e-01],
        [4.343256784780819557e-01, 2.995808923379119637e-01, 2.129872269867968959e-01],
        [4.302525491830334059e-01, 2.972185251864662980e-01, 2.122191462426318287e-01],
        [4.261769801706936645e-01, 2.948617395754311588e-01, 2.114293130588631442e-01],
        [4.220990387565126678e-01, 2.925103169029278360e-01, 2.106183606559913768e-01],
        [4.180190866768337399e-01, 2.901639064725308748e-01, 2.097863381928281035e-01],
        [4.139374748855114139e-01, 2.878221627482029921e-01, 2.089333114395358071e-01],
        [4.098546564000305481e-01, 2.854846942476605975e-01, 2.080591616116443943e-01],
        [4.057712419033978057e-01, 2.831510381788182595e-01, 2.071635039021454405e-01],
        [4.016871580256169971e-01, 2.808210427866469350e-01, 2.062471500335373853e-01],
        [3.976027082875563945e-01, 2.784943860456884357e-01, 2.053102247884384113e-01],
        [3.935181846712299536e-01, 2.761707517515646915e-01, 2.043528642900468983e-01],
        [3.894338675796663596e-01, 2.738498295626687340e-01, 2.033752150347126197e-01],
        [3.853501485284500094e-01, 2.715312592611229259e-01, 2.023772355615125473e-01],
        [3.812675049241057712e-01, 2.692146423201499661e-01, 2.013587500039031863e-01],
        [3.771858334106182320e-01, 2.668998447434733912e-01, 2.003204988638387918e-01],
        [3.731053664536302938e-01, 2.645865804728991244e-01, 1.992626621753412208e-01],
        [3.690263252725575205e-01, 2.622745690957888343e-01, 1.981854256387428070e-01],
        [3.649489199677356521e-01, 2.599635357439662453e-01, 1.970889798104242807e-01],
        [3.608733496668369289e-01, 2.576532109746325627e-01, 1.959735193223784977e-01],
        [3.567998026886545215e-01, 2.553433306346174492e-01, 1.948392421320772061e-01],
        [3.527288062385475209e-01, 2.530334781151396539e-01, 1.936858449182176090e-01],
        [3.486601920186409020e-01, 2.507235512004114542e-01, 1.925140265725779620e-01],
        [3.445940882588859333e-01, 2.484133136793199026e-01, 1.913240314183973223e-01],
        [3.405306410460574029e-01, 2.461025213487854080e-01, 1.901160637330516767e-01],
        [3.364699867832531277e-01, 2.437909343510991644e-01, 1.888903276956251931e-01],
        [3.324122524192171801e-01, 2.414783169649092898e-01, 1.876470268273142949e-01],
        [3.283575556825768516e-01, 2.391644373879673879e-01, 1.863863634598928731e-01],
        [3.243060053196711312e-01, 2.368490675124892975e-01, 1.851085382313104599e-01],
        [3.202577013347079893e-01, 2.345319826939236685e-01, 1.838137496073975197e-01],
        [3.162127352310978301e-01, 2.322129615138344705e-01, 1.825021934285724068e-01],
        [3.121713481873937823e-01, 2.298917159046080516e-01, 1.811738589048320913e-01],
        [3.081335147958294551e-01, 2.275680750195018809e-01, 1.798290697596431065e-01],
        [3.040992288572926250e-01, 2.252418581754896398e-01, 1.784681064582642751e-01],
        [3.000685503066236048e-01, 2.229128543385760497e-01, 1.770911493801810288e-01],
        [2.960415318405872354e-01, 2.205808544095470558e-01, 1.756983743063298686e-01],
        [2.920182191423447704e-01, 2.182456509647304199e-01, 1.742899520962044868e-01],
        [2.879986511013646333e-01, 2.159070379936562922e-01, 1.728660483803914072e-01],
        [2.839828600283449411e-01, 2.135648106336759944e-01, 1.714268232671206371e-01],
        [2.799708718647850314e-01, 2.112187649015158653e-01, 1.699724310614039724e-01],
        [2.759627063869375951e-01, 2.088686974216710790e-01, 1.685030199953476415e-01],
        [2.719583774039363577e-01, 2.065144051514603007e-01, 1.670187319682087390e-01],
        [2.679578929499804030e-01, 2.041556851024882158e-01, 1.655197022947889340e-01],
        [2.639612554705231817e-01, 2.017923340581795344e-01, 1.640060594607524180e-01],
        [2.599684620025124460e-01, 1.994241482869618665e-01, 1.624779248834790635e-01],
        [2.559795043487851918e-01, 1.970509232505948671e-01, 1.609354126770728421e-01],
        [2.519943692468365470e-01, 1.946724533070429697e-01, 1.593786294201690046e-01],
        [2.480130385322499298e-01, 1.922885314071993146e-01, 1.578076739252100846e-01],
        [2.440354892972040890e-01, 1.898989487846577950e-01, 1.562226370078938775e-01],
        [2.400616940445691738e-01, 1.875034946376172018e-01, 1.546236012555405048e-01],
        [2.360916208382524140e-01, 1.851019558018774935e-01, 1.530106407931814128e-01],
        [2.321252334505864434e-01, 1.826941164137449169e-01, 1.513838210462468969e-01],
        [2.281624915077672400e-01, 1.802797575614995262e-01, 1.497431984988283338e-01],
        [2.242033506345226801e-01, 1.778586569239049842e-01, 1.480888204466117852e-01],
        [2.202477625994911925e-01, 1.754305883940150690e-01, 1.464207247437575854e-01],
        [2.162956754630863121e-01, 1.729953216862958332e-01, 1.447389395432186476e-01],
        [2.123470337300349953e-01, 1.705526219247719688e-01, 1.430434830302904636e-01],
        [2.084017785092666109e-01, 1.681022492095620435e-01, 1.413343631495822261e-01],
        [2.044598476844710633e-01, 1.656439581587243193e-01, 1.396115773261282222e-01],
        [2.005211760994463077e-01, 1.631774974218037078e-01, 1.378751121820577796e-01],
        [1.965856988864305155e-01, 1.607026079587815515e-01, 1.361249399201315824e-01],
        [1.926533421135208923e-01, 1.582190261881047944e-01, 1.343610282823611279e-01],
        [1.887240316449029232e-01, 1.557264800392861304e-01, 1.325833310557416600e-01],
        [1.847976928565723820e-01, 1.532246885529702785e-01, 1.307917884786300444e-01],
        [1.808742494403644818e-01, 1.507133617751950094e-01, 1.289863286797117148e-01],
        [1.769536238533599426e-01, 1.481921999716426241e-01, 1.271668674796427312e-01],
        [1.730357378708484994e-01, 1.456608927537091369e-01, 1.253333082519507424e-01],
        [1.691205132766324948e-01, 1.431191180966186194e-01, 1.234855418704042807e-01],
        [1.652078727370975830e-01, 1.405665412234658185e-01, 1.216234467798024410e-01],
        [1.612977409237918991e-01, 1.380028133201234297e-01, 1.197468892401933882e-01],
        [1.573900459762036241e-01, 1.354275700331004917e-01, 1.178557238119506412e-01],
        [1.534847214366352741e-01, 1.328404296837557008e-01, 1.159497941721605863e-01],
        [1.495817088501062986e-01, 1.302409911046356894e-01, 1.140289343827514401e-01],
        [1.456809613162400874e-01, 1.276288309622561901e-01, 1.120929707687035870e-01],
        [1.417824484273444985e-01, 1.250035003675231404e-01, 1.101417246101454861e-01],
        [1.378861632611661503e-01, 1.223645204774909678e-01, 1.081750159008208478e-01],
        [1.339921324751868759e-01, 1.197113766395997425e-01, 1.061926684632616136e-01]];

% Interpolate to requested number of colors.

P = size(cmap,1);

if (P ~= M)
  cmap = interp1(1:size(cmap,1), cmap, linspace(1,P,M), 'linear');
end

return
