function cmap = cm_thermal(varargin)

% CM_THERMAL: 256 color palette from CMOCEAN
%
% cmap = cm_thermal(M)
%
% THERMAL colormap by Kristen Thyng.
%
% On Input:
%
%    M        Number of colors (integer, OPTIONAL)
%
% On Ouput:
%
%    cmap     Mx3 colormap matrix
%
% Usage:
%
%    colormap(cm_thermal)
%    colormap(flipud(cm_thermal))
%
% https://github.com/matplotlib/cmocean/tree/master/cmocean/rgb
%
% Thyng, K.M., C.A. Greene, R.D. Hetland, H.M. Zimmerle, and S.F DiMarco, 2016:
%   True colord of oceanography: Guidelines for effective and accurate colormap
%   selection, Oceanography, 29(3), 9-13, http://dx.doi.org/10.5670/oceanog.2016.66 
% 

% svn $Id: cm_thermal.m 895 2018-02-11 23:15:37Z arango $

% Initialize.

switch numel(varargin)
  case 0
    M = 256;
  case 1
    M = varargin{1};
end

% Set 256 colormap.

cmap = [[1.555601333154079877e-02, 1.382442454646408414e-01, 2.018108864558305071e-01],
        [1.620183633850513089e-02, 1.410507428866217272e-01, 2.089765125440807836e-01],
        [1.685648942708358952e-02, 1.438270143621834252e-01, 2.162386804476043589e-01],
        [1.752640064782528401e-02, 1.465717250667996630e-01, 2.235996996833259920e-01],
        [1.821871873545745021e-02, 1.492834638238061673e-01, 2.310618693528040390e-01],
        [1.894137836902154426e-02, 1.519607349643580241e-01, 2.386274839825403005e-01],
        [1.969967580211434005e-02, 1.546014513385217670e-01, 2.463049741539924953e-01],
        [2.050331512714091350e-02, 1.572037794856419868e-01, 2.540971092002056730e-01],
        [2.136720981691051999e-02, 1.597664500864496573e-01, 2.619991459036808412e-01],
        [2.230340677460975612e-02, 1.622875536944013708e-01, 2.700132114112391291e-01],
        [2.332520459934065912e-02, 1.647650548255009395e-01, 2.781413941166567261e-01],
        [2.444727823684482437e-02, 1.671967824349823439e-01, 2.863857270216258466e-01],
        [2.568581629165060318e-02, 1.695804203313354408e-01, 2.947481661145329168e-01],
        [2.705867185137392564e-02, 1.719134976584987262e-01, 3.032305630924797546e-01],
        [2.858552764394725262e-02, 1.741933796245943022e-01, 3.118346316168387755e-01],
        [3.028807626872338093e-02, 1.764172587161002559e-01, 3.205619061457981589e-01],
        [3.219021609777513587e-02, 1.785821467123839268e-01, 3.294136922283489310e-01],
        [3.431826321592867240e-02, 1.806848679100377109e-01, 3.383910069732901649e-01],
        [3.670117943457189280e-02, 1.827220540829147533e-01, 3.474945082255425644e-01],
        [3.937081594703384368e-02, 1.846901418460877020e-01, 3.567244107935257369e-01],
        [4.230474116360182640e-02, 1.865853732643254770e-01, 3.660803878810173217e-01],
        [4.544128431656369732e-02, 1.884038007524381497e-01, 3.755614556934170345e-01],
        [4.879889459256544354e-02, 1.901412975600472455e-01, 3.851658390246698871e-01],
        [5.238564999909287728e-02, 1.917935754201579024e-01, 3.948908155057742619e-01],
        [5.620896927989652708e-02, 1.933562112707872260e-01, 4.047325361348014794e-01],
        [6.027560971317643540e-02, 1.948246853300575621e-01, 4.146858197468099028e-01],
        [6.459519137924149557e-02, 1.961877478810097886e-01, 4.247714594384868758e-01],
        [6.917293885235362150e-02, 1.974458334676339466e-01, 4.349572770994127868e-01],
        [7.401397924875777190e-02, 1.985943734629224688e-01, 4.452322549865626589e-01],
        [7.912632580773251711e-02, 1.996251445642635014e-01, 4.555965555444902448e-01],
        [8.452074659970570947e-02, 2.005284212595413451e-01, 4.660508732253974551e-01],
        [9.019392390291772199e-02, 2.013079448693051998e-01, 4.765478779135125520e-01],
        [9.616430834359415702e-02, 2.019472529514862447e-01, 4.871044455010897223e-01],
        [1.024253987466881288e-01, 2.024520213616345932e-01, 4.976646226688278829e-01],
        [1.089944270249512126e-01, 2.028088855832538839e-01, 5.082270885561682716e-01],
        [1.158597351626668159e-01, 2.030273547727350913e-01, 5.187245256305992314e-01],
        [1.230424263443430921e-01, 2.030937970306834206e-01, 5.291483757425788914e-01],
        [1.305276694613609623e-01, 2.030217816424806365e-01, 5.394201195013325068e-01],
        [1.383099125215292158e-01, 2.028195613734770086e-01, 5.494767764101642360e-01],
        [1.463797060150685281e-01, 2.025001769277504637e-01, 5.592461312000727158e-01],
        [1.547186326280874380e-01, 2.020850680852618320e-01, 5.686422620965899677e-01],
        [1.632970499077517346e-01, 2.016054641193363861e-01, 5.775676861911989146e-01],
        [1.720728231749732162e-01, 2.011027291278179585e-01, 5.859183845130113699e-01],
        [1.809917622181062835e-01, 2.006270524284321510e-01, 5.935918186078640302e-01],
        [1.899902199574210471e-01, 2.002341583564870575e-01, 6.004970669758479263e-01],
        [1.989997441940680178e-01, 1.999802927301375655e-01, 6.065651516258429021e-01],
        [2.079529779081165097e-01, 1.999164256738651391e-01, 6.117570630961892686e-01],
        [2.167895160216459782e-01, 2.000830340237900185e-01, 6.160673924886361785e-01],
        [2.254604257150365498e-01, 2.005067081654643424e-01, 6.195227918364496489e-01],
        [2.339306302023402284e-01, 2.011991984057693306e-01, 6.221760825969698816e-01],
        [2.421790683949211487e-01, 2.021587162723321729e-01, 6.240979346009031259e-01],
        [2.501971277034634733e-01, 2.033727314506766359e-01, 6.253682433520739714e-01],
        [2.579861074778473928e-01, 2.048213417591974728e-01, 6.260687943604991146e-01],
        [2.655544225081862275e-01, 2.064804694302365684e-01, 6.262779744769025880e-01],
        [2.729150389729214088e-01, 2.083244557603688429e-01, 6.260675767301320249e-01],
        [2.800833915559314269e-01, 2.103279194298604549e-01, 6.255013265069014894e-01],
        [2.870675074033041674e-01, 2.124691386407265292e-01, 6.246420009551492125e-01],
        [2.938851360627945386e-01, 2.147254304183257023e-01, 6.235380183242871244e-01],
        [3.005577213461362307e-01, 2.170756514619715527e-01, 6.222251903623999825e-01],
        [3.070843773107185259e-01, 2.195059802015210115e-01, 6.207554984633752992e-01],
        [3.134916285549604886e-01, 2.219983100391352271e-01, 6.191452159520036691e-01],
        [3.197798380866583856e-01, 2.245420356602937373e-01, 6.174343435010863912e-01],
        [3.259695527216341926e-01, 2.271241237863139140e-01, 6.156329324235468858e-01],
        [3.320579089479565038e-01, 2.297373625924510887e-01, 6.137771467682858750e-01],
        [3.380660052498126178e-01, 2.323715331127139128e-01, 6.118660583919267593e-01],
        [3.439917420525137604e-01, 2.350215076527270575e-01, 6.099280657295180763e-01],
        [3.498460685618723365e-01, 2.376808945869600675e-01, 6.079694872801727490e-01],
        [3.556384580181179977e-01, 2.403444043084654869e-01, 6.059953497614897211e-01],
        [3.613686295558476425e-01, 2.430089153836439420e-01, 6.040241385974032262e-01],
        [3.670434468015162932e-01, 2.456707832167414618e-01, 6.020607616318822686e-01],
        [3.726708785615932551e-01, 2.483266964722255499e-01, 6.001059364008434205e-01],
        [3.782547954216434749e-01, 2.509743622345630976e-01, 5.981656274234778969e-01],
        [3.837960822688916696e-01, 2.536122834643630419e-01, 5.962498766549472196e-01],
        [3.892988345534371120e-01, 2.562387736058999166e-01, 5.943618049976240325e-01],
        [3.947690991030736729e-01, 2.588520700720948198e-01, 5.924996351953921714e-01],
        [4.002098946086877773e-01, 2.614510659770345469e-01, 5.906660913059953444e-01],
        [4.056240909379103532e-01, 2.640348396856425084e-01, 5.888633104220148962e-01],
        [4.110144223076953041e-01, 2.666026246434279878e-01, 5.870929096766683841e-01],
        [4.163832172801885667e-01, 2.691538344975527575e-01, 5.853565951388559618e-01],
        [4.217313231007376317e-01, 2.716882525666767800e-01, 5.836583632684495537e-01],
        [4.270634345309600177e-01, 2.742050306264073312e-01, 5.819941042354170868e-01],
        [4.323818104897113601e-01, 2.767038027770706843e-01, 5.803639256565888971e-01],
        [4.376886243188534142e-01, 2.791842625143060586e-01, 5.787676418773346487e-01],
        [4.429859696643737577e-01, 2.816461519867726748e-01, 5.772048027503156042e-01],
        [4.482758654902720408e-01, 2.840892531259122666e-01, 5.756747186760452495e-01],
        [4.535602602863915700e-01, 2.865133804028727749e-01, 5.741764823913096949e-01],
        [4.588410355259065487e-01, 2.889183750000149931e-01, 5.727089879419176022e-01],
        [4.641200084236148382e-01, 2.913041002126984247e-01, 5.712709472315609105e-01],
        [4.693989340425177015e-01, 2.936704379215548943e-01, 5.698609044983501404e-01],
        [4.746795067933508583e-01, 2.960172859965477521e-01, 5.684772490345112450e-01],
        [4.799633613697112389e-01, 2.983445565121622955e-01, 5.671182264323321176e-01],
        [4.852520731601697723e-01, 3.006521746683436525e-01, 5.657819486102849682e-01],
        [4.905471581781303825e-01, 3.029400783247205298e-01, 5.644664028469250638e-01],
        [4.958500725502145712e-01, 3.052082180664184574e-01, 5.631694600262432404e-01],
        [5.011622116043696895e-01, 3.074565577287760587e-01, 5.618888822762294621e-01],
        [5.064849085998188727e-01, 3.096850753156841218e-01, 5.606223301621769961e-01],
        [5.118194331420761189e-01, 3.118937642524056697e-01, 5.593673695773668797e-01],
        [5.171669893275794294e-01, 3.140826349187781363e-01, 5.581214784559522801e-01],
        [5.225287136638799845e-01, 3.162517164128481606e-01, 5.568820534159194535e-01],
        [5.279056728126164666e-01, 3.184010584984696690e-01, 5.556464164236831760e-01],
        [5.332988612036093645e-01, 3.205307336933521101e-01, 5.544118215561065766e-01],
        [5.387091985692399332e-01, 3.226408394566178117e-01, 5.531754619204082291e-01],
        [5.441375274486375258e-01, 3.247315004373090841e-01, 5.519344767774559957e-01],
        [5.495846107110635703e-01, 3.268028707475315597e-01, 5.506859588994191812e-01],
        [5.550511291471261766e-01, 3.288551362262008837e-01, 5.494269621786239677e-01],
        [5.605376791749926424e-01, 3.308885166617086537e-01, 5.481545094908906179e-01],
        [5.660447559653561944e-01, 3.329032737201366166e-01, 5.468656290966650291e-01],
        [5.715723572408055730e-01, 3.348998704862335973e-01, 5.455581199822507887e-01],
        [5.771213104289429907e-01, 3.368784486432290226e-01, 5.442280104688511644e-01],
        [5.826918609018115758e-01, 3.388393806259411556e-01, 5.428722728323092106e-01],
        [5.882841610050709713e-01, 3.407830824811499126e-01, 5.414878910241607279e-01],
        [5.938982692324897839e-01, 3.427100153754324974e-01, 5.400718694374621043e-01],
        [5.995341497366565298e-01, 3.446206869260000083e-01, 5.386212416598933350e-01],
        [6.051916721861749782e-01, 3.465156523493675422e-01, 5.371330791454219655e-01],
        [6.108706119725975103e-01, 3.483955154267821541e-01, 5.356044997333838653e-01],
        [6.165706507631435462e-01, 3.502609292895154658e-01, 5.340326759432469927e-01],
        [6.222913773881607602e-01, 3.521125970311436149e-01, 5.324148429745680922e-01],
        [6.280322890453092777e-01, 3.539512721578863541e-01, 5.307483063447554494e-01],
        [6.337927927958686425e-01, 3.557777588917046541e-01, 5.290304491020394462e-01],
        [6.395721854014132512e-01, 3.575929224264804973e-01, 5.272587829694529438e-01],
        [6.453697498455218673e-01, 3.593976455700171879e-01, 5.254307632896803026e-01],
        [6.511846984697030605e-01, 3.611928549527803622e-01, 5.235439096149940852e-01],
        [6.570160963803246545e-01, 3.629795579684892415e-01, 5.215959730192853971e-01],
        [6.628629283562820218e-01, 3.647588132682739737e-01, 5.195848109675399451e-01],
        [6.687241012633005077e-01, 3.665317306708469891e-01, 5.175083912494201632e-01],
        [6.745984464659754432e-01, 3.682994710922303794e-01, 5.153647953022981731e-01],
        [6.804847221871188623e-01, 3.700632465224873990e-01, 5.131522209386339961e-01],
        [6.863816157645579175e-01, 3.718243200760849021e-01, 5.108689845040222943e-01],
        [6.922877457570544291e-01, 3.735840061411623281e-01, 5.085135225034096429e-01],
        [6.982016638532075881e-01, 3.753436706510840937e-01, 5.060843927435032530e-01],
        [7.041218565401857754e-01, 3.771047314992945210e-01, 5.035802750493091340e-01],
        [7.100468845018954589e-01, 3.788685911907690995e-01, 5.009996451582281463e-01],
        [7.159752518731292703e-01, 3.806367017978663503e-01, 4.983410633235164089e-01],
        [7.219050254760910335e-01, 3.824107548202065887e-01, 4.956041045679995816e-01],
        [7.278344332015346252e-01, 3.841923879692217270e-01, 4.927879483140180095e-01],
        [7.337616407032357957e-01, 3.859832960516177969e-01, 4.898918977085310877e-01],
        [7.396847510296571393e-01, 3.877852324461281697e-01, 4.869153794944616753e-01],
        [7.456018038508585022e-01, 3.896000107579556393e-01, 4.838579440403712462e-01],
        [7.515107742785041012e-01, 3.914295066368485010e-01, 4.807192656291401911e-01],
        [7.574095712835625660e-01, 3.932756597383701980e-01, 4.774991431076147097e-01],
        [7.632960357235062387e-01, 3.951404758009958162e-01, 4.741975009994948143e-01],
        [7.691679379984673881e-01, 3.970260288041012053e-01, 4.708143911830061090e-01],
        [7.750229753641669772e-01, 3.989344631636088656e-01, 4.673499952331199858e-01],
        [7.808587689384376418e-01, 4.008679959130103665e-01, 4.638046275250513051e-01],
        [7.866728604480874854e-01, 4.028289188075652172e-01, 4.601787391913814695e-01],
        [7.924627087737056153e-01, 4.048196002786729752e-01, 4.564729230191116316e-01],
        [7.982256863620216247e-01, 4.068424871537119070e-01, 4.526879193650572009e-01],
        [8.039590755885861473e-01, 4.089001060440320967e-01, 4.488246231577860956e-01],
        [8.096600651680347926e-01, 4.109950642903736351e-01, 4.448840920414381395e-01],
        [8.153258420561760866e-01, 4.131300072582320126e-01, 4.408672005707100494e-01],
        [8.209533846301936277e-01, 4.153077124896901728e-01, 4.367753702901882029e-01],
        [8.265394587133882975e-01, 4.175310847974926798e-01, 4.326106584748535266e-01],
        [8.320808476618816174e-01, 4.198030498289601065e-01, 4.283748912056176694e-01],
        [8.375742298072511582e-01, 4.221266063894242304e-01, 4.240701127101388912e-01],
        [8.430161781421201539e-01, 4.245048216497959159e-01, 4.196985997897492715e-01],
        [8.484031611801808870e-01, 4.269408247931844591e-01, 4.152628771038663902e-01],
        [8.537315452228415591e-01, 4.294377989032187592e-01, 4.107657331305429871e-01],
        [8.589975982777037222e-01, 4.319989708985695898e-01, 4.062102365684474026e-01],
        [8.641974958823694930e-01, 4.346275993272235572e-01, 4.015997528869852951e-01],
        [8.693273290890853877e-01, 4.373269598520185819e-01, 3.969379606684441675e-01],
        [8.743831148591909574e-01, 4.401003282876529976e-01, 3.922288673203608855e-01],
        [8.793608090992056647e-01, 4.429509610905758565e-01, 3.874768236699652202e-01],
        [8.842563225402819693e-01, 4.458820732584555802e-01, 3.826865368883226592e-01],
        [8.890655396175203284e-01, 4.488968136663485375e-01, 3.778630811333164030e-01],
        [8.937843693689974112e-01, 4.519982404973394430e-01, 3.730116014425700621e-01],
        [8.984086715918495614e-01, 4.551892900487020666e-01, 3.681382748140558103e-01],
        [9.029343899688814234e-01, 4.584727367754222738e-01, 3.632494215164466245e-01],
        [9.073575586033109097e-01, 4.618511663085561048e-01, 3.583516614288673741e-01],
        [9.116743277656134126e-01, 4.653269421603676848e-01, 3.534519722899168159e-01],
        [9.158809992051784032e-01, 4.689021723136149178e-01, 3.485576699619067353e-01],
        [9.199740625655835613e-01, 4.725786767270368505e-01, 3.436763818638891022e-01],
        [9.239502320744639174e-01, 4.763579567194722864e-01, 3.388160133952918263e-01],
        [9.278064825504417357e-01, 4.802411672570275347e-01, 3.339847073943023048e-01],
        [9.315400836682339314e-01, 4.842290931875970483e-01, 3.291907969273191181e-01],
        [9.351486313601243827e-01, 4.883221304365225612e-01, 3.244427519772630775e-01],
        [9.386300752174523421e-01, 4.925202730905588466e-01, 3.197491208755643965e-01],
        [9.419827407976890665e-01, 4.968231071526066356e-01, 3.151184675888816233e-01],
        [9.452053458453827384e-01, 5.012298115494860928e-01, 3.105593062092800172e-01],
        [9.482970095990234105e-01, 5.057391667267315816e-01, 3.060800341879720277e-01],
        [9.512572545755481057e-01, 5.103495708806106146e-01, 3.016888659817511531e-01],
        [9.540860004899643920e-01, 5.150590635745326828e-01, 2.973937688352701891e-01],
        [9.567835502644689294e-01, 5.198653561843505910e-01, 2.932024023936338208e-01],
        [9.593505683914355098e-01, 5.247658683349885056e-01, 2.891220637265379811e-01],
        [9.617880522174245828e-01, 5.297577692490467172e-01, 2.851596391521897811e-01],
        [9.640972969908582213e-01, 5.348380227429672118e-01, 2.813215639873033469e-01],
        [9.662798557460373639e-01, 5.400034344900018768e-01, 2.776137910349112392e-01],
        [9.683374952663609259e-01, 5.452507001277228094e-01, 2.740417682745930894e-01],
        [9.702721494708056449e-01, 5.505764528210163045e-01, 2.706104258619907443e-01],
        [9.720889605050128113e-01, 5.559744240639272750e-01, 2.673323057285149629e-01],
        [9.737882391976736551e-01, 5.614431075234689317e-01, 2.642051375197135843e-01],
        [9.753722517954447335e-01, 5.669791681305653697e-01, 2.612321043607351290e-01],
        [9.768433321430202154e-01, 5.725792962307277856e-01, 2.584161030939570725e-01],
        [9.782037550763590383e-01, 5.782403184217296266e-01, 2.557595328984585970e-01],
        [9.794556966363962003e-01, 5.839592236834146854e-01, 2.532643241222839459e-01],
        [9.806011989875685897e-01, 5.897331838357899869e-01, 2.509319710696591987e-01],
        [9.816445119805891073e-01, 5.955576445021050214e-01, 2.487674614053176358e-01],
        [9.825957966513861885e-01, 6.014235301335163486e-01, 2.467838886220111161e-01],
        [9.834484089207010671e-01, 6.073354334336248384e-01, 2.449669167474177733e-01],
        [9.842037798764916579e-01, 6.132913094304376367e-01, 2.433164315861336413e-01],
        [9.848630901763529844e-01, 6.192893396808167861e-01, 2.418320393357376030e-01],
        [9.854335855591603854e-01, 6.253232095344845032e-01, 2.405207443125048083e-01],
        [9.859266054527725531e-01, 6.313839151833324781e-01, 2.393924955683320310e-01],
        [9.863290788081210403e-01, 6.374805817839866995e-01, 2.384285005271009616e-01],
        [9.866412575432023102e-01, 6.436122274808632193e-01, 2.376272705850792089e-01],
        [9.868743031654042541e-01, 6.497702193582076680e-01, 2.369977788720153966e-01],
        [9.870387195949218428e-01, 6.559468364085242476e-01, 2.365460008515470891e-01],
        [9.871160198111447182e-01, 6.621544902577213287e-01, 2.362516434857291903e-01],
        [9.871054832314208882e-01, 6.683929123881801049e-01, 2.361125093170109435e-01],
        [9.870452158568817635e-01, 6.746361467497961062e-01, 2.361551640855951706e-01],
        [9.869008071972434903e-01, 6.809069196703931848e-01, 2.363489608363473771e-01],
        [9.866692878063002548e-01, 6.872064512263130753e-01, 2.366900769944741967e-01],
        [9.863929517876753872e-01, 6.935072010148546351e-01, 2.372025181179537867e-01],
        [9.860358081545986808e-01, 6.998320059248218650e-01, 2.378591308273384497e-01],
        [9.855936903889445100e-01, 7.061828277187244263e-01, 2.386553467137359497e-01],
        [9.851166760681809853e-01, 7.125285611733751523e-01, 2.396137846497558566e-01],
        [9.845515404596055786e-01, 7.189016348706930293e-01, 2.407027465239837682e-01],
        [9.839219208542443473e-01, 7.252873073536283410e-01, 2.419304971970357987e-01],
        [9.832411577231264799e-01, 7.316776102841332508e-01, 2.432981102176038357e-01],
        [9.824686360853925882e-01, 7.380960010628512258e-01, 2.447853973017022899e-01],
        [9.816675490572134288e-01, 7.445058075421049359e-01, 2.464118597749720974e-01],
        [9.807811261674898029e-01, 7.509394073137781733e-01, 2.481527624504580309e-01],
        [9.798377198237012697e-01, 7.573804700508821597e-01, 2.500137146942527089e-01],
        [9.788392654586509645e-01, 7.638279008720277874e-01, 2.519905378906656113e-01],
        [9.777574675384567149e-01, 7.702969047505190403e-01, 2.540716600569991046e-01],
        [9.766479350869351483e-01, 7.767573771217611833e-01, 2.562664070834250185e-01],
        [9.754356977304895482e-01, 7.832491288133777152e-01, 2.585534361426328198e-01],
        [9.742107025732685832e-01, 7.897246981741067318e-01, 2.609472103669700505e-01],
        [9.728835679779427315e-01, 7.962305102434532600e-01, 2.634261983272434549e-01],
        [9.715297353896644728e-01, 8.027276438790406088e-01, 2.659994820979044161e-01],
        [9.700861348373609472e-01, 8.092479763321948072e-01, 2.686528986078252079e-01],
        [9.686057099481873989e-01, 8.157648637457888263e-01, 2.713899293880046582e-01],
        [9.670430691608270513e-01, 8.223006128282058791e-01, 2.742007328066633498e-01],
        [9.654377156641301694e-01, 8.288358297838601674e-01, 2.770858440538391254e-01],
        [9.637524161478506768e-01, 8.353882936883590959e-01, 2.800376262549509332e-01],
        [9.620231537308009395e-01, 8.419407901977008502e-01, 2.830554448577937698e-01],
        [9.602104885023859948e-01, 8.485116373841136150e-01, 2.861325388392048086e-01],
        [9.583576301078738924e-01, 8.550807238511934916e-01, 2.892681513706822360e-01],
        [9.564117528707279936e-01, 8.616719638797333269e-01, 2.924557053792812833e-01],
        [9.544348419615947821e-01, 8.682572954460299197e-01, 2.956947937778980906e-01],
        [9.523487086523741985e-01, 8.748712522095133393e-01, 2.989788164145827376e-01],
        [9.502464564071694264e-01, 8.814728114137494464e-01, 3.023077648025994102e-01],
        [9.480141307284709606e-01, 8.881110895508603775e-01, 3.056751963404329420e-01],
        [9.457819798963852387e-01, 8.947301765899248194e-01, 3.090811208408512645e-01],
        [9.434198646152930356e-01, 9.013849121338212145e-01, 3.125200216900483885e-01],
        [9.410286159691669816e-01, 9.080328518084608280e-01, 3.159906396320988908e-01],
        [9.385331275251967975e-01, 9.147047487143539213e-01, 3.194893313796646206e-01],
        [9.359711083432949996e-01, 9.213848126149789541e-01, 3.230138415459749002e-01],
        [9.333375985220991877e-01, 9.280748341844049509e-01, 3.265615469169362850e-01],
        [9.305915654403119630e-01, 9.347905093445134650e-01, 3.301299810381577715e-01],
        [9.278142496620381818e-01, 9.414998557883345054e-01, 3.337168327083647745e-01],
        [9.248899165263079203e-01, 9.482470197415310276e-01, 3.373199677733378365e-01],
        [9.219411401959984875e-01, 9.549849147932994997e-01, 3.409370492608514991e-01],
        [9.188613878011584468e-01, 9.617532494963948464e-01, 3.445662997232426528e-01],
        [9.156931782520092433e-01, 9.685354904254356301e-01, 3.482056900726151483e-01],
        [9.124490701578419349e-01, 9.753266872784461805e-01, 3.518533597970244786e-01],
        [9.090418416674036495e-01, 9.821574063216705897e-01, 3.555078064299531104e-01]];

% Interpolate to requested number of colors.

P = size(cmap,1);

if (P ~= M)
  cmap = interp1(1:size(cmap,1), cmap, linspace(1,P,M), 'linear');
end

return
