function cmap = cm_solar(varargin)

% CM_SOLAR: 256 color palette from CMOCEAN
%
% cmap = cm_solar(M)
%
% SOLAR colormap by Kristen Thyng.
%
% On Input:
%
%    M        Number of colors (integer, OPTIONAL)
%
% On Ouput:
%
%    cmap     Mx3 colormap matrix
%
% Usage:
%
%    colormap(cm_solar)
%    colormap(flipud(cm_solar))
%
% https://github.com/matplotlib/cmocean/tree/master/cmocean/rgb
%
% Thyng, K.M., C.A. Greene, R.D. Hetland, H.M. Zimmerle, and S.F DiMarco, 2016:
%   True colord of oceanography: Guidelines for effective and accurate colormap
%   selection, Oceanography, 29(3), 9-13, http://dx.doi.org/10.5670/oceanog.2016.66 
% 

% svn $Id: cm_solar.m 895 2018-02-11 23:15:37Z arango $

% Initialize.

switch numel(varargin)
  case 0
    M = 256;
  case 1
    M = varargin{1};
end

% Set 256 colormap.

cmap = [[2.014250997833959556e-01, 7.730778455372402935e-02, 9.342024025258441333e-02],
        [2.062319592710875060e-01, 7.906207768979725548e-02, 9.541606071998920413e-02],
        [2.110428892884436691e-01, 8.079536357043612393e-02, 9.737846202556904585e-02],
        [2.158580822956807643e-01, 8.250806203226229707e-02, 9.930725029816905858e-02],
        [2.206777103783343352e-01, 8.420058748958639261e-02, 1.012022063667477878e-01],
        [2.255019582885565144e-01, 8.587332122435217818e-02, 1.030630633154644982e-01],
        [2.303310909623697555e-01, 8.752655129320324745e-02, 1.048894558390352783e-01],
        [2.351651244914957362e-01, 8.916077192669072393e-02, 1.066811567589351084e-01],
        [2.400041538413338893e-01, 9.077639059472936145e-02, 1.084378476867565166e-01],
        [2.448482542469172518e-01, 9.237381813988079782e-02, 1.101591880324293282e-01],
        [2.496974811012195872e-01, 9.395347052392380438e-02, 1.118448155598189275e-01],
        [2.545518697677066067e-01, 9.551577058896976169e-02, 1.134943469265998206e-01],
        [2.594114353201673606e-01, 9.706114983944272301e-02, 1.151073782157037984e-01],
        [2.642761722125430146e-01, 9.859005025060077476e-02, 1.166834854654446307e-01],
        [2.691460538812255332e-01, 1.001029261086328892e-01, 1.182222252052740896e-01],
        [2.740210322821139965e-01, 1.016002458867145131e-01, 1.197231350040377507e-01],
        [2.789010373645949281e-01, 1.030824941607314804e-01, 1.211857340375411263e-01],
        [2.837859764845531707e-01, 1.045501735676682975e-01, 1.226095236822268009e-01],
        [2.886757337585150185e-01, 1.060038068088898222e-01, 1.239939881417738143e-01],
        [2.935705596266552364e-01, 1.074435592047325860e-01, 1.253382180210721730e-01],
        [2.984708123016127645e-01, 1.088694832683588798e-01, 1.266411225341654012e-01],
        [3.033754705455499190e-01, 1.102829776040219478e-01, 1.279029157767591629e-01],
        [3.082843160981594277e-01, 1.116846670615513903e-01, 1.291230138435368602e-01],
        [3.131971029671865581e-01, 1.130752078289798124e-01, 1.303008196341493008e-01],
        [3.181135564546491157e-01, 1.144552897453308959e-01, 1.314357238709698839e-01],
        [3.230337594016901570e-01, 1.158252511924781902e-01, 1.325266762725714476e-01],
        [3.279584359813157990e-01, 1.171847867104950369e-01, 1.335718110238658662e-01],
        [3.328858414856893377e-01, 1.185360731157172887e-01, 1.345719725768937669e-01],
        [3.378155708245871303e-01, 1.198799635036237599e-01, 1.355265097514237183e-01],
        [3.427471842250678358e-01, 1.212173573516503733e-01, 1.364347662233350855e-01],
        [3.476817676568914606e-01, 1.225476080130979417e-01, 1.372941239039429107e-01],
        [3.526179187878998866e-01, 1.238726093833323050e-01, 1.381049156392651633e-01],
        [3.575544570498519481e-01, 1.251940557912539775e-01, 1.388672386602565201e-01],
        [3.624908511464776661e-01, 1.265129959708437557e-01, 1.395803418854749678e-01],
        [3.674287950126607916e-01, 1.278281902872998865e-01, 1.402403192837867185e-01],
        [3.723652245912653647e-01, 1.291433283978542790e-01, 1.408496559025098349e-01],
        [3.772994043575393919e-01, 1.304597230378949646e-01, 1.414077190879147183e-01],
        [3.822328244976108125e-01, 1.317763828069311027e-01, 1.419104659088263887e-01],
        [3.871627501840784191e-01, 1.330967329073056149e-01, 1.423599677282273157e-01],
        [3.920880611619059208e-01, 1.344225444091708133e-01, 1.427559829693639537e-01],
        [3.970102845366911826e-01, 1.357528321160993978e-01, 1.430939047058796265e-01],
        [4.019257908029647552e-01, 1.370920335458912787e-01, 1.433773252895977068e-01],
        [4.068349561616130816e-01, 1.384404082220755672e-01, 1.436033049025308150e-01],
        [4.117365731263126216e-01, 1.397998954736640875e-01, 1.437714012378476514e-01],
        [4.166285955020519460e-01, 1.411733354490503911e-01, 1.438826947863026673e-01],
        [4.215115464927484679e-01, 1.425608842716513391e-01, 1.439334793454142836e-01],
        [4.263818625509953053e-01, 1.439670074541691269e-01, 1.439276912848104217e-01],
        [4.312408181144407604e-01, 1.453911021832318962e-01, 1.438598606513883382e-01],
        [4.360843175580979003e-01, 1.468382080621888075e-01, 1.437352070106750757e-01],
        [4.409133399041038626e-01, 1.483080544589621963e-01, 1.435484892033262738e-01],
        [4.457240620502335715e-01, 1.498053889889406909e-01, 1.433047202671754727e-01],
        [4.505169861034231116e-01, 1.513304477119505886e-01, 1.429993558897900696e-01],
        [4.552886678338638471e-01, 1.528875528172430887e-01, 1.426369447211624508e-01],
        [4.600387072749128614e-01, 1.544778583065680166e-01, 1.422148901612839134e-01],
        [4.647645669051368444e-01, 1.561046932382532393e-01, 1.417359354431781127e-01],
        [4.694647696847664142e-01, 1.577702615986552870e-01, 1.412003046328143552e-01],
        [4.741377460736882488e-01, 1.594768244179092798e-01, 1.406085235372486197e-01],
        [4.787811635810699795e-01, 1.612273475797827982e-01, 1.399635953741071304e-01],
        [4.833940392196432456e-01, 1.630233960258756498e-01, 1.392646788568434324e-01],
        [4.879740080405346458e-01, 1.648678210719416448e-01, 1.385155272254653958e-01],
        [4.925195693223419213e-01, 1.667625387560449646e-01, 1.377175480485133274e-01],
        [4.970292850743541213e-01, 1.687093212494573113e-01, 1.368722045288005285e-01],
        [5.015013418271374590e-01, 1.707101850535491239e-01, 1.359828524777431658e-01],
        [5.059344608615837791e-01, 1.727665378729273671e-01, 1.350513348829507354e-01],
        [5.103272555076001638e-01, 1.748797680652766917e-01, 1.340804814887887886e-01],
        [5.146784999821305551e-01, 1.770509926066398676e-01, 1.330731030668735604e-01],
        [5.189871207659747521e-01, 1.792810660321904059e-01, 1.320320170625302603e-01],
        [5.232521628013230286e-01, 1.815706081303557207e-01, 1.309602397868673829e-01],
        [5.274729145399480457e-01, 1.839199144444812750e-01, 1.298602350351042156e-01],
        [5.316485781433754054e-01, 1.863291944433481395e-01, 1.287360215107217765e-01],
        [5.357788119794710813e-01, 1.887982003317690283e-01, 1.275896151617726404e-01],
        [5.398632980453529351e-01, 1.913265486380361924e-01, 1.264236887032485768e-01],
        [5.439016755531911329e-01, 1.939137144580994065e-01, 1.252427388260835273e-01],
        [5.478941342086204314e-01, 1.965587857098634594e-01, 1.240472431523338970e-01],
        [5.518406011876045847e-01, 1.992608233247842864e-01, 1.228416287224595171e-01],
        [5.557413604777560190e-01, 2.020186434106095441e-01, 1.216276788300265921e-01],
        [5.595967825163993270e-01, 2.048309740311727856e-01, 1.204067641590413351e-01],
        [5.634071785471536087e-01, 2.076963248023981912e-01, 1.191839172318373274e-01],
        [5.671732069794859221e-01, 2.106133447776186718e-01, 1.179569341314256059e-01],
        [5.708953502475510033e-01, 2.135801749668952421e-01, 1.167331750031382620e-01],
        [5.745743340603017835e-01, 2.165955297740416174e-01, 1.155086834950974917e-01],
        [5.782108774062354462e-01, 2.196573476346848075e-01, 1.142903383669127693e-01],
        [5.818056681759461446e-01, 2.227643917275112795e-01, 1.130745297734544186e-01],
        [5.853596324247829497e-01, 2.259144368785390156e-01, 1.118679346243981187e-01],
        [5.888733531729506421e-01, 2.291064977832514282e-01, 1.106657061174652901e-01],
        [5.923480147332496060e-01, 2.323380142637169188e-01, 1.094762267036840098e-01],
        [5.957840241257977842e-01, 2.356083643285451501e-01, 1.082930207415330470e-01],
        [5.991826510896112179e-01, 2.389150535758420846e-01, 1.071233989765111305e-01],
        [6.025444033584952397e-01, 2.422572079085022478e-01, 1.059638000704014038e-01],
        [6.058701491001592387e-01, 2.456332409492081315e-01, 1.048158025498839019e-01],
        [6.091610396494541169e-01, 2.490411636600449730e-01, 1.036832083023569995e-01],
        [6.124172967183565408e-01, 2.524805655496659695e-01, 1.025613962727195683e-01],
        [6.156402174450263942e-01, 2.559493015306805175e-01, 1.014554136320146294e-01],
        [6.188304674185852727e-01, 2.594462946423264360e-01, 1.003647858381197522e-01],
        [6.219883549579363624e-01, 2.629709881912258296e-01, 9.928701461787994842e-02],
        [6.251150949354874475e-01, 2.665215196417168309e-01, 9.822607331815666476e-02],
        [6.282114705640686747e-01, 2.700967151118268128e-01, 9.718275325572381385e-02],
        [6.312775931157122988e-01, 2.736963322450938207e-01, 9.615407260814298751e-02],
        [6.343140968307461325e-01, 2.773194022482146082e-01, 9.514062524056160486e-02],
        [6.373225940474543938e-01, 2.809637253536654833e-01, 9.414820920814792604e-02],
        [6.403029049301643960e-01, 2.846294803262617856e-01, 9.317287627515624671e-02],
        [6.432554503146770131e-01, 2.883160464262430889e-01, 9.221435672465166933e-02],
        [6.461807870545831500e-01, 2.920226445998113096e-01, 9.127322088316058846e-02],
        [6.490798649799141007e-01, 2.957480457349839220e-01, 9.035190862912848009e-02],
        [6.519534890851086395e-01, 2.994912417888541123e-01, 8.945207804511770555e-02],
        [6.548014840508611378e-01, 3.032523985397311828e-01, 8.857115779395227650e-02],
        [6.576243271404891289e-01, 3.070309030666096284e-01, 8.770973119670061324e-02],
        [6.604224780876138956e-01, 3.108261780844247535e-01, 8.686839073952234980e-02],
        [6.631963792788750922e-01, 3.146376804982159436e-01, 8.604773901491818977e-02],
        [6.659464950830153995e-01, 3.184648571182398524e-01, 8.524854019761693436e-02],
        [6.686740068110078594e-01, 3.223063950997894223e-01, 8.447431908919650345e-02],
        [6.713784685540787889e-01, 3.261627733896342862e-01, 8.372242463404078183e-02],
        [6.740602498156743616e-01, 3.300335755312562847e-01, 8.299350184989945367e-02],
        [6.767197045307955516e-01, 3.339184117562906673e-01, 8.228820834254704786e-02],
        [6.793571714405546302e-01, 3.378169176731946055e-01, 8.160721412236313088e-02],
        [6.819729744807380145e-01, 3.417287529939577184e-01, 8.095120122856311329e-02],
        [6.845674231809769639e-01, 3.456536003014257785e-01, 8.032086315939043764e-02],
        [6.871408130714994345e-01, 3.495911638591582271e-01, 7.971690410726239850e-02],
        [6.896934260947393813e-01, 3.535411684651399988e-01, 7.914003799874758105e-02],
        [6.922255310194272981e-01, 3.575033583501715517e-01, 7.859098734029026923e-02],
        [6.947373838550107150e-01, 3.614774961213378379e-01, 7.807048187183049381e-02],
        [6.972292282645524697e-01, 3.654633617505798626e-01, 7.757925703187978916e-02],
        [6.997012959744630667e-01, 3.694607516080961052e-01, 7.711805223920600860e-02],
        [7.021538071796381564e-01, 3.734694775400307920e-01, 7.668760899803153674e-02],
        [7.045869709427744487e-01, 3.774893659897066711e-01, 7.628866883556534306e-02],
        [7.070009855867870341e-01, 3.815202571614760840e-01, 7.592197108269088668e-02],
        [7.093960390794303850e-01, 3.855620042261392877e-01, 7.558825051079040569e-02],
        [7.117723094093527658e-01, 3.896144725667428643e-01, 7.528823483980665032e-02],
        [7.141299649529336824e-01, 3.936775390635336991e-01, 7.502264213486334321e-02],
        [7.164691648313716854e-01, 3.977510914167320943e-01, 7.479217811087204848e-02],
        [7.187900592575979797e-01, 4.018350275057843701e-01, 7.459753336661339995e-02],
        [7.210927898726463559e-01, 4.059292547837213827e-01, 7.443938057163165811e-02],
        [7.233774900712311995e-01, 4.100336897052239138e-01, 7.431837163097509968e-02],
        [7.256442853163093121e-01, 4.141482571870220286e-01, 7.423513485418420377e-02],
        [7.278932934424962031e-01, 4.182728900992377374e-01, 7.419027215599127700e-02],
        [7.301246249482277184e-01, 4.224075287863344741e-01, 7.418435631686179366e-02],
        [7.323383832766364732e-01, 4.265521206163164214e-01, 7.421792833176479864e-02],
        [7.345353882716817440e-01, 4.307060349567022883e-01, 7.429319537753659164e-02],
        [7.367156646423576039e-01, 4.348693003618859243e-01, 7.441039153688730479e-02],
        [7.388787494489402752e-01, 4.390423308641819844e-01, 7.456862859096566321e-02],
        [7.410247212778052761e-01, 4.432250991934941209e-01, 7.476828631581519669e-02],
        [7.431536528151155840e-01, 4.474175832571065103e-01, 7.500970147240951236e-02],
        [7.452656110665121236e-01, 4.516197658271001170e-01, 7.529316628527241151e-02],
        [7.473606575657232298e-01, 4.558316342481479322e-01, 7.561892717684162712e-02],
        [7.494388485722311977e-01, 4.600531801646510766e-01, 7.598718377039928584e-02],
        [7.515014494005359813e-01, 4.642834853101814319e-01, 7.640057068894035019e-02],
        [7.535482386381918696e-01, 4.685227724793568638e-01, 7.685851802683341116e-02],
        [7.555784292647326206e-01, 4.727716755322179387e-01, 7.735934440269953694e-02],
        [7.575920584303713623e-01, 4.770302023787819645e-01, 7.790304647924226056e-02],
        [7.595891587998102601e-01, 4.812983641144596425e-01, 7.848957351759905388e-02],
        [7.615697586917992146e-01, 4.855761748409669898e-01, 7.911882810663906085e-02],
        [7.635351559772435293e-01, 4.898627402128037933e-01, 7.979298836587264687e-02],
        [7.654855818523200739e-01, 4.941579525945941076e-01, 8.051210547168902165e-02],
        [7.674196884953543574e-01, 4.984628195279873775e-01, 8.127340285315723389e-02],
        [7.693374880099380642e-01, 5.027773670563000508e-01, 8.207659805554132215e-02],
        [7.712389886872909051e-01, 5.071016234993879213e-01, 8.292136945254757752e-02],
        [7.731249880551478437e-01, 5.114350748098054344e-01, 8.380866202872513937e-02],
        [7.749971634096607387e-01, 5.157766247025432627e-01, 8.474069791771285387e-02],
        [7.768531656759695148e-01, 5.201279334240793695e-01, 8.571310136491594456e-02],
        [7.786929885023088360e-01, 5.244890387928055064e-01, 8.672540635712724932e-02],
        [7.805166220614638828e-01, 5.288599804136482341e-01, 8.777711918476124864e-02],
        [7.823261306937436821e-01, 5.332394286426104246e-01, 8.887078595429290240e-02],
        [7.841211261331867410e-01, 5.376277019226174403e-01, 9.000512625428583324e-02],
        [7.859000063657322066e-01, 5.420258982280999893e-01, 9.117718483670700369e-02],
        [7.876627478111991598e-01, 5.464340650106903619e-01, 9.238637445837943885e-02],
        [7.894103755328435446e-01, 5.508515783238705499e-01, 9.363351104642655964e-02],
        [7.911449489936349666e-01, 5.552771776345648558e-01, 9.492063714767667859e-02],
        [7.928634178435132185e-01, 5.597128604871853819e-01, 9.624295938665472505e-02],
        [7.945657449982463927e-01, 5.641586812836011378e-01, 9.759983714409603550e-02],
        [7.962529317489702718e-01, 5.686140495102688375e-01, 9.899190462101559174e-02],
        [7.979274645055595139e-01, 5.730774789890704657e-01, 1.004214627980108965e-01],
        [7.995858497679293464e-01, 5.775511834408552092e-01, 1.018835148330231588e-01],
        [8.012280368308171141e-01, 5.820352236202099849e-01, 1.033774013447087969e-01],
        [8.028560740659145267e-01, 5.865283957952628358e-01, 1.049048199319871921e-01],
        [8.044707409966546097e-01, 5.910302911313597418e-01, 1.064658666440542745e-01],
        [8.060691629501393063e-01, 5.955426815778210869e-01, 1.080566579062864629e-01],
        [8.076512751425731773e-01, 6.000656338781130694e-01, 1.096765425113208070e-01],
        [8.092212933019986565e-01, 6.045967120149606799e-01, 1.113292481825315650e-01],
        [8.107760556043207556e-01, 6.091378327200270837e-01, 1.130107512069984665e-01],
        [8.123144185459451050e-01, 6.136896959567099685e-01, 1.147193037693588491e-01],
        [8.138381395305365196e-01, 6.182513237945769236e-01, 1.164560306092000397e-01],
        [8.153492559398581863e-01, 6.228216087115111543e-01, 1.182221687055251269e-01],
        [8.168438497700267753e-01, 6.274028329685673588e-01, 1.200133807424188237e-01],
        [8.183218295752512361e-01, 6.319950736315883555e-01, 1.218290715633482957e-01],
        [8.197890431479778472e-01, 6.365951069307501653e-01, 1.236738150663118929e-01],
        [8.212397496268510899e-01, 6.412061948148843893e-01, 1.255419007966243339e-01],
        [8.226736710596913582e-01, 6.458285162251576894e-01, 1.274326125224898576e-01],
        [8.240954168836683857e-01, 6.504595882304867738e-01, 1.293492244766023536e-01],
        [8.255020135816337756e-01, 6.551010940717902908e-01, 1.312886736975442947e-01],
        [8.268916161790003105e-01, 6.597540661653059635e-01, 1.332490015865780419e-01],
        [8.282680782241739204e-01, 6.644164751020815718e-01, 1.352327076170389830e-01],
        [8.296302321797530688e-01, 6.690890043064162684e-01, 1.372383190289331867e-01],
        [8.309751426979781197e-01, 6.737732479628292248e-01, 1.392631732853782667e-01],
        [8.323064093623322446e-01, 6.784673500649637257e-01, 1.413094448639914957e-01],
        [8.336236702662669362e-01, 6.831715585604193341e-01, 1.433763438952303237e-01],
        [8.349233956754664732e-01, 6.878877450853391196e-01, 1.454609632889922177e-01],
        [8.362094522088989734e-01, 6.926139541357441143e-01, 1.475655370255327115e-01],
        [8.374812451634525701e-01, 6.973505478666088830e-01, 1.496891818583828970e-01],
        [8.387351652304512184e-01, 7.020993985062000675e-01, 1.518291366884736149e-01],
        [8.399758860500933233e-01, 7.068581852631129481e-01, 1.539880238042938276e-01],
        [8.412015039419409312e-01, 7.116279196951651453e-01, 1.561642027825314583e-01],
        [8.424088634362330019e-01, 7.164102051502189150e-01, 1.583553901645263495e-01],
        [8.436040043728154636e-01, 7.212020966440341185e-01, 1.605648786739153067e-01],
        [8.447825998855326146e-01, 7.260057762544317450e-01, 1.627897017014220959e-01],
        [8.459425004297633777e-01, 7.308223161702667170e-01, 1.650283355910636407e-01],
        [8.470916909310660659e-01, 7.356478948636396842e-01, 1.672849872513207936e-01],
        [8.482222682093125687e-01, 7.404863725972353761e-01, 1.695548732398838021e-01],
        [8.493354922705429466e-01, 7.453371669715372905e-01, 1.718384513727829743e-01],
        [8.504363950839656239e-01, 7.501979378252857655e-01, 1.741381147288197651e-01],
        [8.515178010463546610e-01, 7.550721145067320617e-01, 1.764497766633903175e-01],
        [8.525841071331127230e-01, 7.599576641399760080e-01, 1.787754909642916834e-01],
        [8.536351063891680635e-01, 7.648547324583224727e-01, 1.811148665949305070e-01],
        [8.546660216706046809e-01, 7.697655561558608417e-01, 1.834652953721074564e-01],
        [8.556846647048813592e-01, 7.746865865799383855e-01, 1.858303883039418847e-01],
        [8.566843283862169978e-01, 7.796209322090990046e-01, 1.882066457578640828e-01],
        [8.576654697805085048e-01, 7.845684046728831351e-01, 1.905941213680029112e-01],
        [8.586333372669123776e-01, 7.895266856020336510e-01, 1.929950487363375766e-01],
        [8.595800514528921799e-01, 7.944993343355386539e-01, 1.954056082908571246e-01],
        [8.605118919067250571e-01, 7.994835879345245644e-01, 1.978284835821235155e-01],
        [8.614257659190140970e-01, 8.044808542070145396e-01, 2.002621028413892890e-01],
        [8.623187318174559968e-01, 8.094924397675259398e-01, 2.027050514589471275e-01],
        [8.631990866135879070e-01, 8.145147714844941378e-01, 2.051607456378260474e-01],
        [8.640570316077024193e-01, 8.195521241156307202e-01, 2.076248627732380503e-01],
        [8.648985892446832136e-01, 8.246019286985761809e-01, 2.100998205615737802e-01],
        [8.657217542057287218e-01, 8.296650789343075205e-01, 2.125846498551076103e-01],
        [8.665227359996962031e-01, 8.347431960854363453e-01, 2.150777232526754901e-01],
        [8.673102956545263309e-01, 8.398326248425269647e-01, 2.175824369796515168e-01],
        [8.680739840584389411e-01, 8.449377672354075886e-01, 2.200945521598048904e-01],
        [8.688209397597312922e-01, 8.500556721057834775e-01, 2.226167862486261861e-01],
        [8.695475257414353454e-01, 8.551878730451877297e-01, 2.251476450914057237e-01],
        [8.702518466222823879e-01, 8.603351573784762119e-01, 2.276863618988967386e-01],
        [8.709403456886846140e-01, 8.654949292658645765e-01, 2.302352780671254040e-01],
        [8.716032871795772463e-01, 8.706711460791707324e-01, 2.327907403748207260e-01],
        [8.722504095804027857e-01, 8.758599106230183784e-01, 2.353562666294088945e-01],
        [8.728735089177709350e-01, 8.810645242778994968e-01, 2.379288443348342996e-01],
        [8.734755480931443161e-01, 8.862838169179700909e-01, 2.405095194908647427e-01],
        [8.740576468844427627e-01, 8.915173698391286594e-01, 2.430986533749082690e-01],
        [8.746134519571161503e-01, 8.967676725126847437e-01, 2.456940353088591378e-01],
        [8.751533192048812637e-01, 9.020307187484648548e-01, 2.482992135687792645e-01],
        [8.756648875509137619e-01, 9.073112946820588443e-01, 2.509099777331614822e-01],
        [8.761579961220332669e-01, 9.126056308170312770e-01, 2.535296558873600947e-01],
        [8.766251762717257590e-01, 9.179165870428791507e-01, 2.561557673694155324e-01],
        [8.770689942806796369e-01, 9.232431892037369359e-01, 2.587891932203917889e-01],
        [8.774903570045399226e-01, 9.285851079338152125e-01, 2.614302497362179234e-01],
        [8.778834706355089779e-01, 9.339444999568264905e-01, 2.640771174844134261e-01],
        [8.782575035190057777e-01, 9.393179743031147000e-01, 2.667327577149610218e-01],
        [8.785999460636340075e-01, 9.447101339348284998e-01, 2.693932729818908633e-01],
        [8.789235199162210854e-01, 9.501163253664915986e-01, 2.720626987422674059e-01],
        [8.792160143882136181e-01, 9.555409855460589297e-01, 2.747373107314689533e-01],
        [8.794851333774609259e-01, 9.609813222108515296e-01, 2.774195521504189688e-01],
        [8.797259382267708094e-01, 9.664391027363387066e-01, 2.801079938733134767e-01],
        [8.799388863582034981e-01, 9.719141474258771174e-01, 2.828028665891310078e-01],
        [8.801261631980005218e-01, 9.774056784469543624e-01, 2.855049064351531940e-01],
        [8.802811281654138176e-01, 9.829160047653974219e-01, 2.882122575277183407e-01],
        [8.804129372223431504e-01, 9.884419266545670935e-01, 2.909276978215925569e-01],
        [8.805080058500511786e-01, 9.939881188401472611e-01, 2.936474048368232226e-01]];

% Interpolate to requested number of colors.

P = size(cmap,1);

if (P ~= M)
  cmap = interp1(1:size(cmap,1), cmap, linspace(1,P,M), 'linear');
end

return
