function cmap = cm_deep(varargin)

% CM_DEEP: 256 color palette from CMOCEAN
%
% cmap = cm_deep(M)
%
% DEEP colormap by Kristen Thyng.
%
% On Input:
%
%    M        Number of colors (integer, OPTIONAL)
%
% On Ouput:
%
%    cmap     Mx3 colormap matrix
%
% Usage:
%
%    colormap(cm_deep)
%    colormap(flipud(cm_deep))
%
% https://github.com/matplotlib/cmocean/tree/master/cmocean/rgb
%
% Thyng, K.M., C.A. Greene, R.D. Hetland, H.M. Zimmerle, and S.F DiMarco, 2016:
%   True colord of oceanography: Guidelines for effective and accurate colormap
%   selection, Oceanography, 29(3), 9-13, http://dx.doi.org/10.5670/oceanog.2016.66 
% 

% svn $Id: cm_deep.m 895 2018-02-11 23:15:37Z arango $

% Initialize.

switch numel(varargin)
  case 0
    M = 256;
  case 1
    M = varargin{1};
end

% Set 256 colormap.
  
cmap = [[9.928371765383620096e-01, 9.943734553013935384e-01, 8.001361955494933342e-01],
        [9.849374457410008388e-01, 9.913545172197536504e-01, 7.953271573982337861e-01],
        [9.770418482420034634e-01, 9.883418276673759939e-01, 7.905717472557142189e-01],
        [9.691488355955474310e-01, 9.853357520972024775e-01, 7.858697059005903540e-01],
        [9.612382061888059548e-01, 9.823439661710483550e-01, 7.812181455049906909e-01],
        [9.533233708513803029e-01, 9.793607550577946297e-01, 7.766197776697654209e-01],
        [9.454069776374501854e-01, 9.763847481120443428e-01, 7.720753845210462929e-01],
        [9.374799177499437697e-01, 9.734191074102575003e-01, 7.675843461643131471e-01],
        [9.295353395208965086e-01, 9.704660061861888343e-01, 7.631467470398153319e-01],
        [9.215850348376466439e-01, 9.675205198521025229e-01, 7.587646801057830181e-01],
        [9.136274030668488644e-01, 9.645828701859077148e-01, 7.544386825530340346e-01],
        [9.056514559384564178e-01, 9.616567079910524063e-01, 7.501688017241657791e-01],
        [8.976569922484586295e-01, 9.587415918264282633e-01, 7.459562027416458685e-01],
        [8.896512126622908578e-01, 9.558344072358454513e-01, 7.418023698547455691e-01],
        [8.816325974742758032e-01, 9.529352564923027069e-01, 7.377082218108865774e-01],
        [8.735986658557798323e-01, 9.500445573198598170e-01, 7.336747582572585857e-01],
        [8.655355018678880796e-01, 9.471666805105979359e-01, 7.297031220835451526e-01],
        [8.574559441871676402e-01, 9.442965454208677167e-01, 7.257948454644865821e-01],
        [8.493586413080321806e-01, 9.414341108550433601e-01, 7.219511807036801398e-01],
        [8.412422934868647451e-01, 9.385792958890862847e-01, 7.181734629573161000e-01],
        [8.331056602292961077e-01, 9.357319779845385543e-01, 7.144631077114116380e-01],
        [8.249438571064254822e-01, 9.328932140048489252e-01, 7.108218561594963347e-01],
        [8.167536485550084269e-01, 9.300634438432798801e-01, 7.072516022427790539e-01],
        [8.085407925860420564e-01, 9.272401607530683654e-01, 7.037535913222745521e-01],
        [8.003043988510905038e-01, 9.244230580301131539e-01, 7.003294929842703853e-01],
        [7.920436855303579771e-01, 9.216117772405966191e-01, 6.969810377273069069e-01],
        [7.837579923068553889e-01, 9.188059058340631857e-01, 6.937100117646464170e-01],
        [7.754467945117471395e-01, 9.160049747102424478e-01, 6.905182510191696377e-01],
        [7.671097184662585278e-01, 9.132084557727712104e-01, 6.874076341947011892e-01],
        [7.587465580267132026e-01, 9.104157595099175992e-01, 6.843800748081978469e-01],
        [7.503572923166539343e-01, 9.076262326497597233e-01, 6.814375120698907828e-01],
        [7.419421046029871514e-01, 9.048391559449654453e-01, 6.785819005039074314e-01],
        [7.335014022414247936e-01, 9.020537421501462205e-01, 6.758151982106467281e-01],
        [7.250358375800118882e-01, 8.992691342626382145e-01, 6.731393536848668813e-01],
        [7.165463296678448168e-01, 8.964844041051395207e-01, 6.705562911206142118e-01],
        [7.080340865696405084e-01, 8.936985513356989763e-01, 6.680678941563225059e-01],
        [6.995006280355556827e-01, 8.909105029766873907e-01, 6.656759880411459163e-01],
        [6.909478082204841831e-01, 8.881191135591984809e-01, 6.633823202371271766e-01],
        [6.823778380886152961e-01, 8.853231659823359578e-01, 6.611885395113676900e-01],
        [6.737933070789577927e-01, 8.825213731875580780e-01, 6.590961736178440056e-01],
        [6.651972035471812594e-01, 8.797123807461469935e-01, 6.571066057195337207e-01],
        [6.565929334411800822e-01, 8.768947704523611941e-01, 6.552210497573525139e-01],
        [6.479843366143701600e-01, 8.740670650055498703e-01, 6.534405250319036407e-01],
        [6.393757001353049807e-01, 8.712277338509245572e-01, 6.517658303256151919e-01],
        [6.307693113306602761e-01, 8.683757593089920235e-01, 6.501986071208971651e-01],
        [6.221681809999368706e-01, 8.655099786991408140e-01, 6.487403091120448329e-01],
        [6.135828162115329887e-01, 8.626276255310663110e-01, 6.473888753222819537e-01],
        [6.050194699551968425e-01, 8.597270135144634562e-01, 6.461439080647282118e-01],
        [5.964848373853082197e-01, 8.568064537576968176e-01, 6.450046593443751197e-01],
        [5.879840953182007279e-01, 8.538646600753627691e-01, 6.439710905713145195e-01],
        [5.795218127572832056e-01, 8.509005270271372545e-01, 6.430435569229606685e-01],
        [5.711115213696185133e-01, 8.479112775740021979e-01, 6.422171169895777298e-01],
        [5.627614837100215484e-01, 8.448953489705807174e-01, 6.414893854468299850e-01],
        [5.544783665092802849e-01, 8.418515860497588488e-01, 6.408587965640016870e-01],
        [5.462695843545278818e-01, 8.387787842708503971e-01, 6.403232223573597226e-01],
        [5.381481232862911357e-01, 8.356748924828519831e-01, 6.398763669277579558e-01],
        [5.301228248165350543e-01, 8.325387580839158641e-01, 6.395142187190840932e-01],
        [5.221997330825246530e-01, 8.293697946738645133e-01, 6.392346216632595057e-01],
        [5.143908532894702068e-01, 8.261665755050031645e-01, 6.390304309659169402e-01],
        [5.067050118087177424e-01, 8.229283397233977393e-01, 6.388963162980869637e-01],
        [4.991495064662723746e-01, 8.196546689563362076e-01, 6.388277739100475250e-01],
        [4.917330703220189059e-01, 8.163450533427777378e-01, 6.388184799685107107e-01],
        [4.844633050708381794e-01, 8.129992646664957467e-01, 6.388624455765857801e-01],
        [4.773469739538908629e-01, 8.096172922533247940e-01, 6.389538165444101914e-01],
        [4.703904182695624603e-01, 8.061992786917829834e-01, 6.390864379965265352e-01],
        [4.635986539031755060e-01, 8.027456073395251579e-01, 6.392548734619343254e-01],
        [4.569766618393767410e-01, 7.992567478306369377e-01, 6.394529319719780558e-01],
        [4.505287643111087204e-01, 7.957333261733031682e-01, 6.396742566585853496e-01],
        [4.442569334258392177e-01, 7.921762343010834151e-01, 6.399148201157260907e-01],
        [4.381634653667463852e-01, 7.885863788123392837e-01, 6.401694292235835526e-01],
        [4.322513883314121341e-01, 7.849647158245569578e-01, 6.404304190942151642e-01],
        [4.265195639210723755e-01, 7.813124732411278472e-01, 6.406960731925235297e-01],
        [4.209679602144861810e-01, 7.776308288475485275e-01, 6.409622276506293792e-01],
        [4.155968407812616339e-01, 7.739210344346504344e-01, 6.412227317683711902e-01],
        [4.104045242070183952e-01, 7.701844253858858291e-01, 6.414742347181462412e-01],
        [4.053883482522956383e-01, 7.664223146281371468e-01, 6.417151578859574546e-01],
        [4.005459328058830759e-01, 7.626360316845265386e-01, 6.419424749255564500e-01],
        [3.958750262046074608e-01, 7.588270315806920907e-01, 6.421508285001665817e-01],
        [3.913718273240804346e-01, 7.549966666219802836e-01, 6.423387337484185444e-01],
        [3.870322615152646528e-01, 7.511462095764531721e-01, 6.425055472082883412e-01],
        [3.828523536620307977e-01, 7.472769743775978801e-01, 6.426493131526664904e-01],
        [3.788278449989629926e-01, 7.433902546660990929e-01, 6.427683061328856029e-01],
        [3.749542811367644335e-01, 7.394876286687900313e-01, 6.428573615340694714e-01],
        [3.712266123106295335e-01, 7.355700686179795778e-01, 6.429189618774799886e-01],
        [3.676399929257251897e-01, 7.316387718079003788e-01, 6.429520487195032885e-01],
        [3.641894512092864744e-01, 7.276949011320993366e-01, 6.429557270674552960e-01],
        [3.608699207518579755e-01, 7.237395816489646805e-01, 6.429292709767442382e-01],
        [3.576762479926827720e-01, 7.197739138067411613e-01, 6.428719883285997083e-01],
        [3.546027248366774298e-01, 7.157992458648064771e-01, 6.427810759039616073e-01],
        [3.516446005650431528e-01, 7.118162697085735902e-01, 6.426589560156208414e-01],
        [3.487967412412643076e-01, 7.078259414050183107e-01, 6.425054728664090220e-01],
        [3.460540467004642462e-01, 7.038291754672099110e-01, 6.423205839967465192e-01],
        [3.434114694865876838e-01, 6.998268449671132263e-01, 6.421043512357870187e-01],
        [3.408640318201912600e-01, 6.958197818437616977e-01, 6.418569321473704958e-01],
        [3.384068406811324148e-01, 6.918087773726725453e-01, 6.415785719753461791e-01],
        [3.360351011011302735e-01, 6.877945827659479594e-01, 6.412695960850323118e-01],
        [3.337441277691141628e-01, 6.837779098758932639e-01, 6.409304028912300444e-01],
        [3.315291322901112725e-01, 6.797595093162658308e-01, 6.405610222271946874e-01],
        [3.293855731203558790e-01, 6.757400463409192204e-01, 6.401618521317685717e-01],
        [3.273095072934468774e-01, 6.717199943156246800e-01, 6.397341828681051279e-01],
        [3.252967835603527980e-01, 6.676999151191671533e-01, 6.392786349130804568e-01],
        [3.233433949344308722e-01, 6.636803359579184214e-01, 6.387958727683986648e-01],
        [3.214454825944703664e-01, 6.596617502568347113e-01, 6.382866005148117861e-01],
        [3.195993388733257556e-01, 6.556446185422359907e-01, 6.377515576836865208e-01],
        [3.178014094235615539e-01, 6.516293693095515094e-01, 6.371915154212616228e-01],
        [3.160482946464280851e-01, 6.476163998706647718e-01, 6.366072729215248582e-01],
        [3.143367504654775990e-01, 6.436060771766987099e-01, 6.359996541044424800e-01],
        [3.126636885203824545e-01, 6.395987386132337971e-01, 6.353695045172913503e-01],
        [3.110261758511674857e-01, 6.355946927658273626e-01, 6.347176884379418516e-01],
        [3.094214341373541788e-01, 6.315942201545601264e-01, 6.340450861601970578e-01],
        [3.078468385510386152e-01, 6.275975739369872297e-01, 6.333525914425652825e-01],
        [3.062999162775806861e-01, 6.236049805794583456e-01, 6.326411091031564071e-01],
        [3.047783447524610168e-01, 6.196166404972232034e-01, 6.319115527447410896e-01],
        [3.032799496578738041e-01, 6.156327286641396501e-01, 6.311648425953061414e-01],
        [3.018027027180503197e-01, 6.116533951930802626e-01, 6.304019034507418739e-01],
        [3.003447193279823457e-01, 6.076787658883653354e-01, 6.296236627075371128e-01],
        [2.989042560461285802e-01, 6.037089427717098333e-01, 6.288310484745529561e-01],
        [2.974797079780254205e-01, 5.997440045832753697e-01, 6.280249877540684533e-01],
        [2.960696060742640245e-01, 5.957840072594756675e-01, 6.272064046833601969e-01],
        [2.946726143633343065e-01, 5.918289843891730850e-01, 6.263762188290394883e-01],
        [2.932875271368584058e-01, 5.878789476499071132e-01, 6.255353435272825724e-01],
        [2.919132661023912667e-01, 5.839338872257091584e-01, 6.246846842638799080e-01],
        [2.905488775167375803e-01, 5.799937722079637759e-01, 6.238251370887518688e-01],
        [2.891935293105973304e-01, 5.760585509806988025e-01, 6.229575870601862242e-01],
        [2.878465082138687570e-01, 5.721281515915097593e-01, 6.220829067145717817e-01],
        [2.865071747347951447e-01, 5.682024945496734203e-01, 6.212019079466474247e-01],
        [2.851749861947763254e-01, 5.642814857106783766e-01, 6.203153697409601319e-01],
        [2.838497050469647731e-01, 5.603649539888247988e-01, 6.194242689076802089e-01],
        [2.825310677598035780e-01, 5.564527485481920444e-01, 6.185294158631611250e-01],
        [2.812189151446758406e-01, 5.525446999518639490e-01, 6.176316008625786225e-01],
        [2.799131896111074491e-01, 5.486406204645675189e-01, 6.167315925457064196e-01],
        [2.786139324558262742e-01, 5.447403043452749838e-01, 6.158301364812402978e-01],
        [2.773212811865227168e-01, 5.408435281299215358e-01, 6.149279537054621603e-01],
        [2.760354668808263079e-01, 5.369500509042623992e-01, 6.140257392505246159e-01],
        [2.747568115804877587e-01, 5.330596145668072827e-01, 6.131241606570347891e-01],
        [2.734857257205313141e-01, 5.291719440816851083e-01, 6.122238564648385672e-01],
        [2.722227055926091377e-01, 5.252867477212617153e-01, 6.113254346750160995e-01],
        [2.709683308416185876e-01, 5.214037172983150281e-01, 6.104294711750373192e-01],
        [2.697232619941725140e-01, 5.175225283875982685e-01, 6.095365081178055755e-01],
        [2.684882380171457750e-01, 5.136428405367017280e-01, 6.086470522439324515e-01],
        [2.672640739041831637e-01, 5.097642974662250914e-01, 6.077615731349965689e-01],
        [2.660516582874621339e-01, 5.058865272594796902e-01, 6.068805013837572648e-01],
        [2.648519510715739433e-01, 5.020091425421505660e-01, 6.060042266652778675e-01],
        [2.636659810857353015e-01, 4.981317406526836744e-01, 6.051330956906521008e-01],
        [2.624948437498288434e-01, 4.942539038045714039e-01, 6.042674100224807443e-01],
        [2.613396987489819967e-01, 4.903751992421883643e-01, 6.034074237284018372e-01],
        [2.602017811880152354e-01, 4.864951750164123179e-01, 6.025533553474511361e-01],
        [2.590825816132030779e-01, 4.826133005480903182e-01, 6.017055804809932074e-01],
        [2.579832374637801018e-01, 4.787291639776031782e-01, 6.008639770499764055e-01],
        [2.569051367797046126e-01, 4.748422758923547815e-01, 6.000285749995881712e-01],
        [2.558497193309375306e-01, 4.709521329962904068e-01, 5.991993407256713811e-01],
        [2.548184740794410263e-01, 4.670582183399953347e-01, 5.983761730113198452e-01],
        [2.538129365659009817e-01, 4.631600015854966945e-01, 5.975588985257048735e-01],
        [2.528346862021874641e-01, 4.592569393176054171e-01, 5.967472668238706923e-01],
        [2.518853434473967146e-01, 4.553484754161292725e-01, 5.959409447786497838e-01],
        [2.509665668417216944e-01, 4.514340415062205181e-01, 5.951395103673859932e-01],
        [2.500800498681828299e-01, 4.475130575075850214e-01, 5.943424457267542094e-01],
        [2.492275176071283571e-01, 4.435849323073600692e-01, 5.935491293785424283e-01],
        [2.484107231427581941e-01, 4.396490645862106139e-01, 5.927588275177814170e-01],
        [2.476314436738927260e-01, 4.357048438328084417e-01, 5.919706842419948378e-01],
        [2.468914762732849488e-01, 4.317516515883728090e-01, 5.911837105866416531e-01],
        [2.461926332303804310e-01, 4.277888629705645096e-01, 5.903967722170088139e-01],
        [2.455367369014649914e-01, 4.238158485348740845e-01, 5.896085756110598375e-01],
        [2.449256139784778408e-01, 4.198319765418777605e-01, 5.888176525512366366e-01],
        [2.443611399380560822e-01, 4.158365980702596332e-01, 5.880223891276964432e-01],
        [2.438461792188084676e-01, 4.118287207942545325e-01, 5.872218507211212080e-01],
        [2.433817108226277726e-01, 4.078080077755985022e-01, 5.864131553289283483e-01],
        [2.429695407602900925e-01, 4.037738393736669540e-01, 5.855939512690606641e-01],
        [2.426114394907277760e-01, 3.997256137994158465e-01, 5.847615988448080504e-01],
        [2.423091294682429564e-01, 3.956627542073260506e-01, 5.839131390484204598e-01],
        [2.420642707838099872e-01, 3.915847171721096864e-01, 5.830452587571144374e-01],
        [2.418784445905285962e-01, 3.874910027793410650e-01, 5.821542521747482546e-01],
        [2.417531339648231747e-01, 3.833811665857123074e-01, 5.812359783131098023e-01],
        [2.416897018162703636e-01, 3.792548337300427064e-01, 5.802858143751018494e-01],
        [2.416907565718227624e-01, 3.751112253980636857e-01, 5.792995847596160708e-01],
        [2.417595622535183009e-01, 3.709493751547713325e-01, 5.782729391945388153e-01],
        [2.418940089237943680e-01, 3.667702659833258494e-01, 5.771972660307567171e-01],
        [2.420946965383475313e-01, 3.625739944720036134e-01, 5.760653956197256953e-01],
        [2.423619198524908369e-01, 3.583608468185064400e-01, 5.748693688323588402e-01],
        [2.426978313653707087e-01, 3.541305556383861908e-01, 5.736016010478480753e-01],
        [2.431056167697961956e-01, 3.498826161637011989e-01, 5.722540340252517677e-01],
        [2.435790408918375727e-01, 3.456199709880173332e-01, 5.708127541670769967e-01],
        [2.441164681518231960e-01, 3.413441041408621368e-01, 5.692658625959313712e-01],
        [2.447220255685461088e-01, 3.370546900675063240e-01, 5.676029832475817383e-01],
        [2.453897790312707938e-01, 3.327551263503047418e-01, 5.658082210414479007e-01],
        [2.461121481740833894e-01, 3.284495884603169102e-01, 5.638648470620498676e-01],
        [2.468912126448456479e-01, 3.241391993124722593e-01, 5.617586120246663706e-01],
        [2.477157002362878613e-01, 3.198299095156284522e-01, 5.594704462476630669e-01],
        [2.485761162021524751e-01, 3.155272777788998839e-01, 5.569822129976372826e-01],
        [2.494682375867288693e-01, 3.112353605277175528e-01, 5.542766318947622839e-01],
        [2.503729202057394798e-01, 3.069632816204772574e-01, 5.513352372309007210e-01],
        [2.512817651002536290e-01, 3.027167370222472731e-01, 5.481422664464320471e-01],
        [2.521753740527091225e-01, 2.985048904754492582e-01, 5.446839245346258851e-01],
        [2.530378388279626023e-01, 2.943355684042912035e-01, 5.409499814033098541e-01],
        [2.538514672799476179e-01, 2.902167617845944347e-01, 5.369345375383627328e-01],
        [2.545978636988186494e-01, 2.861560770732184955e-01, 5.326370186681820273e-01],
        [2.552597334794323158e-01, 2.821600341185547811e-01, 5.280624026249696179e-01],
        [2.558254018044066047e-01, 2.782328077909240194e-01, 5.232189983935346955e-01],
        [2.562737222001675308e-01, 2.743799915974786674e-01, 5.181261586082565040e-01],
        [2.566051651711689918e-01, 2.706008890121900934e-01, 5.127963599343589030e-01],
        [2.568071232679735028e-01, 2.668971447705413280e-01, 5.072541841677337127e-01],
        [2.568729082739400482e-01, 2.632680806498599591e-01, 5.015251413221865073e-01],
        [2.568088786232387566e-01, 2.597098435540172168e-01, 4.956253550777797723e-01],
        [2.566151212870083631e-01, 2.562195453869526296e-01, 4.895770754997314511e-01],
        [2.562879598478859378e-01, 2.527944349049762174e-01, 4.834087259028412853e-01],
        [2.558322794870629413e-01, 2.494300496133808887e-01, 4.771399728195321877e-01],
        [2.552572079534596305e-01, 2.461214417402471932e-01, 4.707834286138410929e-01],
        [2.545675711557803811e-01, 2.428643843006248471e-01, 4.643557571030281772e-01],
        [2.537686502971923108e-01, 2.396546885092911139e-01, 4.578718126285494239e-01],
        [2.528659964243425984e-01, 2.364882912834416206e-01, 4.513446141213755536e-01],
        [2.518652755598765891e-01, 2.333613180085921113e-01, 4.447853910070804773e-01],
        [2.507721436866522935e-01, 2.302701237479483076e-01, 4.382036814126420432e-01],
        [2.495921493408267966e-01, 2.272113165747541852e-01, 4.316074651476269897e-01],
        [2.483306606950595463e-01, 2.241817667402334346e-01, 4.250033167249620547e-01],
        [2.469928136315570621e-01, 2.211786051187170643e-01, 4.183965667275956202e-01],
        [2.455817950644241798e-01, 2.181991605590304917e-01, 4.117955160707330586e-01],
        [2.440963016438912891e-01, 2.152407079180826410e-01, 4.052187485307188752e-01],
        [2.425474613143962510e-01, 2.123011804696942062e-01, 3.986531809377649171e-01],
        [2.409394174709658110e-01, 2.093786088479052676e-01, 3.921004515047561423e-01],
        [2.392760085101002243e-01, 2.064712127546999287e-01, 3.855616338648150121e-01],
        [2.375559510487991743e-01, 2.035768990151702318e-01, 3.790513023869773179e-01],
        [2.357791582066215419e-01, 2.006936504843463420e-01, 3.725810406048237766e-01],
        [2.339566833930070699e-01, 1.978208439176197264e-01, 3.661282774694271658e-01],
        [2.320913707908846546e-01, 1.949572807641995476e-01, 3.596924727656225507e-01],
        [2.301734316844865069e-01, 1.921000566693645550e-01, 3.533131710447778295e-01],
        [2.282155151615900546e-01, 1.892493734782149939e-01, 3.469585312854190362e-01],
        [2.262221013532286218e-01, 1.864046213456004575e-01, 3.406203233993785884e-01],
        [2.241821302892643142e-01, 1.835626593748518609e-01, 3.343431537784405938e-01],
        [2.221083620693462546e-01, 1.807243380946543521e-01, 3.280900612914751102e-01],
        [2.200027865362182422e-01, 1.778889096627078448e-01, 3.218593457818205161e-01],
        [2.178554139765243036e-01, 1.750533261852178779e-01, 3.156932341101472139e-01],
        [2.156819223383368844e-01, 1.722195412332822306e-01, 3.095395593647118360e-01],
        [2.134730781003147948e-01, 1.693846918206770857e-01, 3.034377234324792671e-01],
        [2.112350828916275125e-01, 1.665490510713014960e-01, 2.973690772834624574e-01],
        [2.089702734855372057e-01, 1.637121940546225618e-01, 2.913286801723345421e-01],
        [2.066728560428846562e-01, 1.608719311731062473e-01, 2.853437530392856081e-01],
        [2.043551063834350701e-01, 1.580301135357929931e-01, 2.793689192405632293e-01],
        [2.020028382233076125e-01, 1.551826890051333785e-01, 2.734655011163185101e-01],
        [1.996333580091984583e-01, 1.523327614839000976e-01, 2.675659276139747411e-01],
        [1.972319620276792862e-01, 1.494761585027865047e-01, 2.617344119314569673e-01],
        [1.948137533226730334e-01, 1.466155558553730864e-01, 2.559107021731873988e-01],
        [1.923665760685599468e-01, 1.437473901381048913e-01, 2.501489823140411461e-01],
        [1.899031789417767457e-01, 1.408738040042367690e-01, 2.443975812138057813e-01],
        [1.874125186315797886e-01, 1.379915476831030108e-01, 2.387062880680187460e-01],
        [1.849071752981109873e-01, 1.351026683367795023e-01, 2.330231779340583564e-01],
        [1.823751828761793481e-01, 1.322038111876145949e-01, 2.274020989868827392e-01],
        [1.798308834661569988e-01, 1.292972741720705698e-01, 2.217828373102059270e-01],
        [1.772595702951434704e-01, 1.263792859047284667e-01, 2.162309361702130506e-01],
        [1.746769766714075522e-01, 1.234522307754042925e-01, 2.106797904214151584e-01],
        [1.720703275074147443e-01, 1.205129174047056828e-01, 2.051860710532931176e-01],
        [1.694509066570421274e-01, 1.175626362090423926e-01, 1.997023294326863430e-01],
        [1.668117590877864764e-01, 1.145994139402238821e-01, 1.942594655847655616e-01],
        [1.641571774416621943e-01, 1.116231764992316466e-01, 1.888399155026514453e-01],
        [1.614878059346168959e-01, 1.086331782717616379e-01, 1.834416540200605461e-01],
        [1.587995102818766935e-01, 1.056281331759973130e-01, 1.780821476813713722e-01],
        [1.561019746507273376e-01, 1.026082525875711138e-01, 1.727215696232307918e-01]];

% Interpolate to requested number of colors.

P = size(cmap,1);

if (P ~= M)
  cmap = interp1(1:size(cmap,1), cmap, linspace(1,P,M), 'linear');
end

return
