function cmap = cm_balance(varargin)

% CM_BALANCE: 256 color palette from CMOCEAN
%
% cmap = cm_balance(M)
%
% BALANCE colormap by Kristen Thyng.
%
% On Input:
%
%    M        Number of colors (integer, OPTIONAL)
%
% On Ouput:
%
%    cmap     Mx3 colormap matrix
%
% Usage:
%
%    colormap(cm_balance)
%    colormap(flipud(cm_balance))
%
% https://github.com/matplotlib/cmocean/tree/master/cmocean/rgb
%
% Thyng, K.M., C.A. Greene, R.D. Hetland, H.M. Zimmerle, and S.F DiMarco, 2016:
%   True colord of oceanography: Guidelines for effective and accurate colormap
%   selection, Oceanography, 29(3), 9-13, http://dx.doi.org/10.5670/oceanog.2016.66 
% 

% svn $Id: cm_balance.m 895 2018-02-11 23:15:37Z arango $

% Initialize.

switch numel(varargin)
  case 0
    M = 256;
  case 1
    M = varargin{1};
end

% Set 256 colormap.

cmap = [[9.317630180115785143e-02, 1.111733294776027225e-01, 2.615123885530547532e-01],
        [9.697151501690241815e-02, 1.168702109792841837e-01, 2.730963071061036085e-01],
        [1.009688451686782534e-01, 1.223931506799195018e-01, 2.849103610759459171e-01],
        [1.049927013864766501e-01, 1.278243708004132007e-01, 2.968738052891420898e-01],
        [1.089874020283561201e-01, 1.331935038256579495e-01, 3.089538370897204067e-01],
        [1.129223008178065757e-01, 1.385131449459734432e-01, 3.211528356563003173e-01],
        [1.167787372671460905e-01, 1.437907235567953967e-01, 3.334763137669404798e-01],
        [1.205463368759411846e-01, 1.490330498991488395e-01, 3.459192712822865556e-01],
        [1.242159653236002137e-01, 1.542448960991174289e-01, 3.584824902114073786e-01],
        [1.277778433781233958e-01, 1.594292997650425259e-01, 3.711737182907450250e-01],
        [1.312243830518974863e-01, 1.645899274655008293e-01, 3.839938980982077199e-01],
        [1.345490385720651272e-01, 1.697307784244891371e-01, 3.969402498465131601e-01],
        [1.377440294143187915e-01, 1.748552489081271477e-01, 4.100132193954066917e-01],
        [1.407996250839473606e-01, 1.799660943911219058e-01, 4.232173781877683894e-01],
        [1.437072840727513789e-01, 1.850671827584920992e-01, 4.365502201613832844e-01],
        [1.464560785040432134e-01, 1.901619264187031366e-01, 4.500130967746718835e-01],
        [1.490348239402249919e-01, 1.952544786288682443e-01, 4.636036238706138235e-01],
        [1.514309258266629821e-01, 2.003493745808981319e-01, 4.773185296806868871e-01],
        [1.536266468153191511e-01, 2.054503782969492598e-01, 4.911623505831314018e-01],
        [1.556073044691906326e-01, 2.105638989188344801e-01, 5.051241984185815825e-01],
        [1.573534941852142433e-01, 2.156962129560367203e-01, 5.191977165014443063e-01],
        [1.588411077773489166e-01, 2.208540630983729658e-01, 5.333780986311171812e-01],
        [1.600396310676128475e-01, 2.260448054488821412e-01, 5.476626851250718797e-01],
        [1.609205321230856855e-01, 2.312792188936386995e-01, 5.620307968352061812e-01],
        [1.614455266589641669e-01, 2.365687572657042548e-01, 5.764661948566720540e-01],
        [1.615687582201552897e-01, 2.419271731798259828e-01, 5.909472809712390529e-01],
        [1.612352769386722617e-01, 2.473711867632350236e-01, 6.054446786315181850e-01],
        [1.603793369556453796e-01, 2.529213001868846900e-01, 6.199179403497330210e-01],
        [1.589165703217830516e-01, 2.586022090180682964e-01, 6.343183928801525706e-01],
        [1.567387388150081051e-01, 2.644444177118183137e-01, 6.485832602021305293e-01],
        [1.537422741701028883e-01, 2.704875236386605764e-01, 6.625942914402649375e-01],
        [1.497539850217274870e-01, 2.767772906869140348e-01, 6.762428866538948702e-01],
        [1.446190280141932405e-01, 2.833703371099008383e-01, 6.893303155405390292e-01],
        [1.381506719438430897e-01, 2.903290266080994497e-01, 7.016166706228140759e-01],
        [1.301937481102784511e-01, 2.977137475582261605e-01, 7.127928058673724809e-01],
        [1.207056294812082625e-01, 3.055623316038361126e-01, 7.225101391519437311e-01],
        [1.098226938414934850e-01, 3.138651882979107688e-01, 7.304694442052537262e-01],
        [9.795843445627248902e-02, 3.225431024585883599e-01, 7.365271649499161022e-01],
        [8.570023827886968926e-02, 3.314661612751826358e-01, 7.407718073497575606e-01],
        [7.367688675533522191e-02, 3.404967458048910878e-01, 7.434693436710165804e-01],
        [6.252232597310111717e-02, 3.495197377754474255e-01, 7.449562973790243570e-01],
        [5.283258403911513662e-02, 3.584600781237165523e-01, 7.455451847703780111e-01],
        [4.520938539971628561e-02, 3.672749347230809258e-01, 7.454889092261348660e-01],
        [4.023631323597558207e-02, 3.759418522020857023e-01, 7.449841371058433248e-01],
        [3.831576485736640919e-02, 3.844536826035842014e-01, 7.441746283479093726e-01],
        [3.948349528027724625e-02, 3.928137536670130436e-01, 7.431581338661337188e-01],
        [4.345843888396401511e-02, 4.010237097170425424e-01, 7.420243047032398787e-01],
        [4.962431895510652918e-02, 4.090953160508887798e-01, 7.408166831290733390e-01],
        [5.739800117053886486e-02, 4.170346954168047682e-01, 7.395877539875740370e-01],
        [6.626017539288729663e-02, 4.248521500099918247e-01, 7.383650122111450331e-01],
        [7.582789138192139178e-02, 4.325572249230948407e-01, 7.371697936237424642e-01],
        [8.583710398799437868e-02, 4.401583433039914506e-01, 7.360206802189788178e-01],
        [9.611023898027164225e-02, 4.476635745571445613e-01, 7.349312516211791158e-01],
        [1.065303883460570755e-01, 4.550804241299538089e-01, 7.339117735870001047e-01],
        [1.170216465020320479e-01, 4.624159111924117660e-01, 7.329693696980987827e-01],
        [1.275357983203295742e-01, 4.696767197731893662e-01, 7.321074968220891988e-01],
        [1.380432121650685962e-01, 4.768686794858796318e-01, 7.313295149248254523e-01],
        [1.485266661140711986e-01, 4.839970747487774561e-01, 7.306374469250058734e-01],
        [1.589774367328510296e-01, 4.910666599003393196e-01, 7.300322634722052895e-01],
        [1.693927097070233589e-01, 4.980816767007848478e-01, 7.295140990156090410e-01],
        [1.797738575018875684e-01, 5.050458714090990675e-01, 7.290824177866462863e-01],
        [1.901252883653588299e-01, 5.119625097219066001e-01, 7.287361439246872186e-01],
        [2.004536741991692628e-01, 5.188343886055641896e-01, 7.284737667569484154e-01],
        [2.107674308545827713e-01, 5.256638445778923918e-01, 7.282934299212738827e-01],
        [2.210763664417479957e-01, 5.324527583974503209e-01, 7.281930113726282627e-01],
        [2.313914398990180310e-01, 5.392025564688637251e-01, 7.281702001646749300e-01],
        [2.417245888287989919e-01, 5.459142096302009861e-01, 7.282225751002735503e-01],
        [2.520885959217774586e-01, 5.525882304010224511e-01, 7.283476897674903139e-01],
        [2.624969693582706598e-01, 5.592246702775622857e-01, 7.285431679898072277e-01],
        [2.729638158446638374e-01, 5.658231192947545951e-01, 7.288068131774058100e-01],
        [2.835036864649327915e-01, 5.723827108458280355e-01, 7.291367343046032401e-01],
        [2.941313761905648416e-01, 5.789021356407471064e-01, 7.295314900628433463e-01],
        [3.048616586033888742e-01, 5.853796696249742304e-01, 7.299902509334000866e-01],
        [3.157089391891977348e-01, 5.918132215225327952e-01, 7.305129762764809298e-01],
        [3.266868146870496870e-01, 5.982004061606387424e-01, 7.311005998876300982e-01],
        [3.378075337747806772e-01, 6.045386495071959354e-01, 7.317552128195412564e-01],
        [3.490818000871770965e-01, 6.108253115449155946e-01, 7.324796800093837934e-01],
        [3.605169723334935572e-01, 6.170578982409773428e-01, 7.332792190500567742e-01],
        [3.721163789840524760e-01, 6.232343167456089184e-01, 7.341612307067191256e-01],
        [3.838798790902256397e-01, 6.293530561660979350e-01, 7.351337469132933622e-01],
        [3.958028137607393915e-01, 6.354134382185918639e-01, 7.362060213183361235e-01],
        [4.078755353103907799e-01, 6.414158575290970221e-01, 7.373884640869047269e-01],
        [4.200825599604326444e-01, 6.473620651543986471e-01, 7.386930839012650907e-01],
        [4.324066537782813580e-01, 6.532548504780409937e-01, 7.401294470548486215e-01],
        [4.448270147115060968e-01, 6.590982595876608841e-01, 7.417069328868316491e-01],
        [4.573210929073768805e-01, 6.648973878622411737e-01, 7.434335263117878290e-01],
        [4.698658823662555939e-01, 6.706581495075844002e-01, 7.453153847182404368e-01],
        [4.824391638200489774e-01, 6.763869948243975694e-01, 7.473565606883062484e-01],
        [4.950205546820442004e-01, 6.820906132919950515e-01, 7.495589040396917202e-01],
        [5.075922656244505893e-01, 6.877756591216436233e-01, 7.519221394187723950e-01],
        [5.201395209800695474e-01, 6.934485275105084501e-01, 7.544440922042097153e-01],
        [5.326506556783058288e-01, 6.991151975856019218e-01, 7.571210204550441469e-01],
        [5.451151059190834092e-01, 7.047815278674717243e-01, 7.599492971931861574e-01],
        [5.575181558550945660e-01, 7.104543187762520917e-01, 7.629291415211207905e-01],
        [5.698635397781144363e-01, 7.161365136199150383e-01, 7.660488334775965580e-01],
        [5.821485860154738123e-01, 7.218322109491160932e-01, 7.693023567855580280e-01],
        [5.943602368020499682e-01, 7.275477994362923306e-01, 7.726916325476315128e-01],
        [6.065080899095934841e-01, 7.332844479726540188e-01, 7.762041114816310428e-01],
        [6.185864665812587093e-01, 7.390466790641196937e-01, 7.798383670352863062e-01],
        [6.305963554035781682e-01, 7.448373397672364282e-01, 7.835892177406345027e-01],
        [6.425403291413834816e-01, 7.506587685331359561e-01, 7.874510644025978223e-01],
        [6.544185977825304201e-01, 7.565137308188258913e-01, 7.914204294842384080e-01],
        [6.662315287143806275e-01, 7.624048800378464552e-01, 7.954941819359623301e-01],
        [6.779850393157120791e-01, 7.683332855369554570e-01, 7.996659972294575258e-01],
        [6.896755013217630292e-01, 7.743024253591546113e-01, 8.039360994237751967e-01],
        [7.013107513266423343e-01, 7.803126348729136907e-01, 8.082975524678305268e-01],
        [7.128885314512861671e-01, 7.863668558670167119e-01, 8.127502175082055302e-01],
        [7.244112448085553435e-01, 7.924667152464015540e-01, 8.172911293271547528e-01],
        [7.358836989688380958e-01, 7.986130654557248576e-01, 8.219158971644889844e-01],
        [7.473044386446877629e-01, 8.048084510111997991e-01, 8.266243361574353576e-01],
        [7.586759860087319840e-01, 8.110542493572184819e-01, 8.314137476978961105e-01],
        [7.700007022560961811e-01, 8.173518180665149124e-01, 8.362815657919246970e-01],
        [7.812789490175476859e-01, 8.237030526155880716e-01, 8.412265533654796901e-01],
        [7.925116214732782494e-01, 8.301096652946458043e-01, 8.462470956714009951e-01],
        [8.036997510351909790e-01, 8.365733017623517842e-01, 8.513414099007207136e-01],
        [8.148431081888104499e-01, 8.430959697406819053e-01, 8.565084542610862384e-01],
        [8.259421593641688153e-01, 8.496794646156250463e-01, 8.617465433522450979e-01],
        [8.369967539127278755e-01, 8.563257710703112702e-01, 8.670541605111352634e-01],
        [8.480038340013845710e-01, 8.630377874332209043e-01, 8.724315628924932398e-01],
        [8.589628398368314155e-01, 8.698176873531217046e-01, 8.778768407867350021e-01],
        [8.698718779534676537e-01, 8.766681056859056964e-01, 8.833884311630415542e-01],
        [8.807225950585577667e-01, 8.835937613774932364e-01, 8.889689808541467730e-01],
        [8.915125639987498962e-01, 8.905976582376062822e-01, 8.946157932523199907e-01],
        [9.022321856472953483e-01, 8.976851819173250480e-01, 9.003303399902121695e-01],
        [9.128629530771473766e-01, 9.048646775143293075e-01, 9.061201920398328502e-01],
        [9.233906674988954233e-01, 9.121434538185491103e-01, 9.119872701021832784e-01],
        [9.337690699519377580e-01, 9.195389121458987791e-01, 9.179604265763980919e-01],
        [9.438768578707728008e-01, 9.270905817099515112e-01, 9.241478407896098757e-01],
        [9.450241336950316873e-01, 9.267273985243987822e-01, 9.232017297254778709e-01],
        [9.401771503305338396e-01, 9.175010969420787088e-01, 9.127353023021862466e-01],
        [9.357788176131993652e-01, 9.081849602977229985e-01, 9.019958970504049489e-01],
        [9.316195516453253944e-01, 8.988455936080792519e-01, 8.911247259869568005e-01],
        [9.276366903952597553e-01, 8.895015346080178409e-01, 8.801625091446737548e-01],
        [9.237963723082156520e-01, 8.801619939913720714e-01, 8.691306632065185500e-01],
        [9.200767818087643990e-01, 8.708323115565800299e-01, 8.580426479951916985e-01],
        [9.164622665155582881e-01, 8.615158650696722598e-01, 8.469079246742292622e-01],
        [9.129409700010679973e-01, 8.522148302070590153e-01, 8.357335125969563849e-01],
        [9.095033897880691054e-01, 8.429306461313940124e-01, 8.245249535921664874e-01],
        [9.061413505699446036e-01, 8.336643536120030840e-01, 8.132870275157044748e-01],
        [9.028482401464246188e-01, 8.244164969479621519e-01, 8.020234992942889551e-01],
        [8.996183458250350817e-01, 8.151873435674267254e-01, 7.907375926293952473e-01],
        [8.964464017336835067e-01, 8.059770371403549571e-01, 7.794323253122593664e-01],
        [8.933280984986637918e-01, 7.967854062668440207e-01, 7.681100636805964221e-01],
        [8.902585423162623357e-01, 7.876125240246927284e-01, 7.567737971546929510e-01],
        [8.872341531517662361e-01, 7.784580066111700392e-01, 7.454255275413548265e-01],
        [8.842515223931736168e-01, 7.693214239645329577e-01, 7.340672060990318659e-01],
        [8.813075692568397290e-01, 7.602022354826803996e-01, 7.227005864751234743e-01],
        [8.783989821496545058e-01, 7.511000050313838550e-01, 7.113277185683902770e-01],
        [8.755220238171187441e-01, 7.420144833045193566e-01, 6.999511354610528091e-01],
        [8.726749843514796101e-01, 7.329446408023255755e-01, 6.885716411869530207e-01],
        [8.698547215416584377e-01, 7.238900130170270453e-01, 6.771913952144653637e-01],
        [8.670596624933959440e-01, 7.148495108503407636e-01, 6.658111988100340328e-01],
        [8.642855405275950975e-01, 7.058231520382152180e-01, 6.544344321908397433e-01],
        [8.615312235931757989e-01, 6.968096810882964398e-01, 6.430616521710770250e-01],
        [8.587945613193220806e-01, 6.878082471826545419e-01, 6.316944172411573799e-01],
        [8.560737697641845889e-01, 6.788178389092562881e-01, 6.203340096274330140e-01],
        [8.533647514077651319e-01, 6.698384520573987810e-01, 6.089840337795546787e-01],
        [8.506671813652186831e-01, 6.608684511065675560e-01, 5.976445430267850467e-01],
        [8.479803760976425409e-01, 6.519062997089123401e-01, 5.863159553827915760e-01],
        [8.452992890124730874e-01, 6.429524288345007665e-01, 5.750030931030669645e-01],
        [8.426233261680482478e-01, 6.340052727647743636e-01, 5.637064935396088883e-01],
        [8.399526706457652869e-01, 6.250628349958033958e-01, 5.524259435430849408e-01],
        [8.372823606159069953e-01, 6.161255232979981900e-01, 5.411665126797099434e-01],
        [8.346115013722664733e-01, 6.071918418882036317e-01, 5.299292934604437066e-01],
        [8.319416971332159738e-01, 5.982589838531851001e-01, 5.187128588454869016e-01],
        [8.292658393187906096e-01, 5.893284247613858051e-01, 5.075248627530006829e-01],
        [8.265865191963318592e-01, 5.803968068112989043e-01, 4.963630791145096643e-01],
        [8.239007716165898110e-01, 5.714634777707676694e-01, 4.852311209906218226e-01],
        [8.212047236427109098e-01, 5.625283035002011101e-01, 4.741337367172645534e-01],
        [8.185028441784485409e-01, 5.535866371885466153e-01, 4.630669974760600605e-01],
        [8.157857974447502158e-01, 5.446412013022012832e-01, 4.520417208585162938e-01],
        [8.130598755024439628e-01, 5.356861530869529986e-01, 4.410523109242584505e-01],
        [8.103157295614864530e-01, 5.267242547499885186e-01, 4.301100025814295069e-01],
        [8.075600763067809496e-01, 5.177491168092126506e-01, 4.192090517728162546e-01],
        [8.047829983640772955e-01, 5.087638530967844019e-01, 4.083617627821872209e-01],
        [8.019913643823087801e-01, 4.997616265469864705e-01, 3.975626288212918968e-01],
        [7.991776069093209367e-01, 4.907441098507538402e-01, 3.868219510427612362e-01],
        [7.963412506983238437e-01, 4.817086347924898759e-01, 3.761426799347312722e-01],
        [7.934853391750592566e-01, 4.726500967551418020e-01, 3.655242898980974875e-01],
        [7.906020861628313412e-01, 4.635701843716890092e-01, 3.549783159786080722e-01],
        [7.876922078438237662e-01, 4.544650164439674178e-01, 3.445075235304189132e-01],
        [7.847584433242353885e-01, 4.453290095612297272e-01, 3.341130019968927001e-01],
        [7.817943763481589592e-01, 4.361626378195018194e-01, 3.238062118505327658e-01],
        [7.787986023472407426e-01, 4.269628178617235204e-01, 3.135938243777520174e-01],
        [7.757700306772615795e-01, 4.177259860608659170e-01, 3.034828822113839197e-01],
        [7.727073763310282617e-01, 4.084484227667745659e-01, 2.934814547614346680e-01],
        [7.696090956246998127e-01, 3.991262801626034307e-01, 2.835988305456279002e-01],
        [7.664733140591651894e-01, 3.897556205902359405e-01, 2.738457322824414675e-01],
        [7.632977462662783319e-01, 3.803324674237734127e-01, 2.642345539395078435e-01],
        [7.600796083228246180e-01, 3.708528707479538111e-01, 2.547796171102231777e-01],
        [7.568155232311498670e-01, 3.613129902046505748e-01, 2.454974414736316723e-01],
        [7.535014210471865370e-01, 3.517091973617619272e-01, 2.364070204678299647e-01],
        [7.501324359996863755e-01, 3.420381997805444496e-01, 2.275300884680255264e-01],
        [7.467083678923864820e-01, 3.322917332197801166e-01, 2.188868097223075626e-01],
        [7.432206214135255173e-01, 3.224689513722865386e-01, 2.105072965395320406e-01],
        [7.396626352495903056e-01, 3.125667176366879740e-01, 2.024226257801388651e-01],
        [7.360276592028781595e-01, 3.025817058357924139e-01, 1.946669682951213953e-01],
        [7.323075054306246168e-01, 2.925115926125090304e-01, 1.872788656593587786e-01],
        [7.284886793139783157e-01, 2.823599622393618280e-01, 1.803025816545419935e-01],
        [7.245597795551689257e-01, 2.721283507524605572e-01, 1.737830391183990686e-01],
        [7.205052554891407945e-01, 2.618237699935750395e-01, 1.677681078164939554e-01],
        [7.163077524522897255e-01, 2.514568470079543427e-01, 1.623050371038979034e-01],
        [7.119477511381474555e-01, 2.410431671523047270e-01, 1.574376915741905747e-01],
        [7.074046106878864038e-01, 2.306029576903746436e-01, 1.532027782639572566e-01],
        [7.026577763956233236e-01, 2.201603247696940491e-01, 1.496264194674281345e-01],
        [6.976856380676357272e-01, 2.097462458983016809e-01, 1.467193374830310926e-01],
        [6.924700993857928477e-01, 1.993923480969033712e-01, 1.444757571309586708e-01],
        [6.869956304794752056e-01, 1.891326217641629281e-01, 1.428720296451389260e-01],
        [6.812509389222788370e-01, 1.790005719286615893e-01, 1.418684919672574540e-01],
        [6.752290404511711586e-01, 1.690283951735306323e-01, 1.414126182563193168e-01],
        [6.689272347019628029e-01, 1.592460113853382819e-01, 1.414436246187784352e-01],
        [6.623462930327670417e-01, 1.496814992323431404e-01, 1.418966965532167945e-01],
        [6.554894621920681619e-01, 1.403622590219790744e-01, 1.427060758527507467e-01],
        [6.483618361407726960e-01, 1.313154491044398742e-01, 1.438093776439538507e-01],
        [6.409690900196458596e-01, 1.225708994915949840e-01, 1.451466621124405387e-01],
        [6.333171868548845840e-01, 1.141616381299322275e-01, 1.466635532234118466e-01],
        [6.254117682555888624e-01, 1.061263207405454406e-01, 1.483083323541042609e-01],
        [6.172580943089347461e-01, 9.850955940169045522e-02, 1.500342818055006577e-01],
        [6.088612137441752337e-01, 9.136271116346880716e-02, 1.517946748017894032e-01],
        [6.002260075568476294e-01, 8.474268845605749390e-02, 1.535471889644061949e-01],
        [5.913580665313180607e-01, 7.870937974751122945e-02, 1.552475962263118736e-01],
        [5.822640724597829553e-01, 7.332110668924821106e-02, 1.568528524628541587e-01],
        [5.729523242155735163e-01, 6.862870182587510470e-02, 1.583209522546889236e-01],
        [5.634337248699358147e-01, 6.466696013382158825e-02, 1.596097119552595534e-01],
        [5.537224099506778963e-01, 6.144626935987178989e-02, 1.606779590153868675e-01],
        [5.438351395676241928e-01, 5.894914800814857886e-02, 1.614895452047331870e-01],
        [5.337912133736735232e-01, 5.712858102881844535e-02, 1.620138116792186611e-01],
        [5.236119994512118403e-01, 5.591095129374230172e-02, 1.622265257547594042e-01],
        [5.133214710039554207e-01, 5.519900277454217047e-02, 1.621082697921440163e-01],
        [5.029415119053961547e-01, 5.489268743951671026e-02, 1.616521201270082198e-01],
        [4.924920560465744224e-01, 5.489497800522934179e-02, 1.608594568967110505e-01],
        [4.819970419875420631e-01, 5.509874164212420766e-02, 1.597294678457327477e-01],
        [4.714685312956432006e-01, 5.543752958786138385e-02, 1.582803570073196830e-01],
        [4.609298385556733768e-01, 5.581817450175154821e-02, 1.565161535498545142e-01],
        [4.503882306974699712e-01, 5.620093240974462917e-02, 1.544603609580012249e-01],
        [4.398550445667638309e-01, 5.653967482715421822e-02, 1.521296397207116124e-01],
        [4.293395854267749168e-01, 5.679892905513854451e-02, 1.495413040881575784e-01],
        [4.188488052114383020e-01, 5.695351275720081374e-02, 1.467131019928892832e-01],
        [4.083874753510262079e-01, 5.698679735961746651e-02, 1.436626150429021476e-01],
        [3.979584206972520133e-01, 5.688899115379054960e-02, 1.404067946849407167e-01],
        [3.875661805934746962e-01, 5.664744510513378128e-02, 1.369596232193354413e-01],
        [3.772162562473511671e-01, 5.624858727791105101e-02, 1.333332882463785507e-01],
        [3.669009710312429173e-01, 5.571027577451325569e-02, 1.295456315830630090e-01],
        [3.566289201162299305e-01, 5.501236188184371184e-02, 1.256041268313332904e-01],
        [3.463946141954395985e-01, 5.416713051157899528e-02, 1.215221064681567403e-01],
        [3.362018241761821069e-01, 5.316577293008726418e-02, 1.173074037138401304e-01],
        [3.260424402261492549e-01, 5.202497987647033972e-02, 1.129713889339670624e-01],
        [3.159278573165507087e-01, 5.071934147936141973e-02, 1.085175153831856448e-01],
        [3.058440467352613878e-01, 4.927677960771512794e-02, 1.039569210271578392e-01],
        [2.957906289005873823e-01, 4.769542811326495796e-02, 9.929501197500162357e-02],
        [2.857761694878986902e-01, 4.595516903310007534e-02, 9.453469664208309642e-02],
        [2.757883929056377248e-01, 4.407729543414404955e-02, 8.968329380554104779e-02],
        [2.658251433737037206e-01, 4.206161274965801444e-02, 8.474472186508703875e-02],
        [2.558840557281191197e-01, 3.990046570244704105e-02, 7.972236454569985031e-02],
        [2.459622220783502511e-01, 3.762595141506584057e-02, 7.461913567560218841e-02],
        [2.360563646646140490e-01, 3.529747994604028744e-02, 6.943744239412558139e-02]];

% Interpolate to requested number of colors.

P = size(cmap,1);

if (P ~= M)
  cmap = interp1(1:size(cmap,1), cmap, linspace(1,P,M), 'linear');
end

return
