function cmap = cm_amp(varargin)

% CM_AMP: 256 color palette from CMOCEAN
%
% cmap = cm_amp(M)
%
% AMP colormap by Kristen Thyng.
%
% On Input:
%
%    M        Number of colors (integer, OPTIONAL)
%
% On Ouput:
%
%    cmap     Mx3 colormap matrix
%
% Usage:
%
%    colormap(cm_amp)
%    colormap(flipud(cm_amp))
%
% https://github.com/matplotlib/cmocean/tree/master/cmocean/rgb
%
% Thyng, K.M., C.A. Greene, R.D. Hetland, H.M. Zimmerle, and S.F DiMarco, 2016:
%   True colord of oceanography: Guidelines for effective and accurate colormap
%   selection, Oceanography, 29(3), 9-13, http://dx.doi.org/10.5670/oceanog.2016.66 
% 

% svn $Id: cm_amp.m 895 2018-02-11 23:15:37Z arango $

% Initialize.

switch numel(varargin)
  case 0
    M = 256;
  case 1
    M = varargin{1};
end

% Set 256 colormap.

cmap = [[9.463470914425774483e-01, 9.290101343908121478e-01, 9.257532417012246384e-01],
        [9.437115115548888600e-01, 9.244624965319422349e-01, 9.206701514370421169e-01],
        [9.413263164430620833e-01, 9.198473615841167295e-01, 9.154240958990897958e-01],
        [9.390547090113202655e-01, 9.152093965940418796e-01, 9.101090387889319011e-01],
        [9.368634575300728295e-01, 9.105592179043572321e-01, 9.047473920040983719e-01],
        [9.347358946162058757e-01, 9.059020202913443676e-01, 8.993502288257003707e-01],
        [9.326614522721177192e-01, 9.012410121503533489e-01, 8.939244930449518067e-01],
        [9.306333250978273686e-01, 8.965781745298962990e-01, 8.884745648022901454e-01],
        [9.286461606427048876e-01, 8.919150224616214651e-01, 8.830038737434344753e-01],
        [9.266960476646858291e-01, 8.872526027444326280e-01, 8.775148739503740858e-01],
        [9.247795820079757201e-01, 8.825918040419664656e-01, 8.720097084454925263e-01],
        [9.228944807039246578e-01, 8.779331456742857087e-01, 8.664897344910690302e-01],
        [9.210380342808240917e-01, 8.732773006486703737e-01, 8.609566713320465636e-01],
        [9.192087851735465387e-01, 8.686245228987975464e-01, 8.554113284148980867e-01],
        [9.174048150925064871e-01, 8.639752297661511538e-01, 8.498548926033711037e-01],
        [9.156244455582711606e-01, 8.593297631172468476e-01, 8.442883976261035262e-01],
        [9.138671371679708555e-01, 8.546880756641417332e-01, 8.387120160257571788e-01],
        [9.121305737300281491e-01, 8.500507404321120397e-01, 8.331273220967562176e-01],
        [9.104149075499773369e-01, 8.454174764656698926e-01, 8.275339791691540547e-01],
        [9.087182868982504047e-01, 8.407887046755945226e-01, 8.219332381316957203e-01],
        [9.070398066265998871e-01, 8.361645202367321561e-01, 8.163256242481420344e-01],
        [9.053796160871283583e-01, 8.315446471258203243e-01, 8.107108259382036497e-01],
        [9.037352419915254398e-01, 8.269297416714002091e-01, 8.050906531516163200e-01],
        [9.021080083908009639e-01, 8.223191128622155954e-01, 7.994638601040017223e-01],
        [9.004956244333240933e-01, 8.177133605075642686e-01, 7.938321412777887831e-01],
        [8.988977241110835958e-01, 8.131124010808855607e-01, 7.881956419539296599e-01],
        [8.973148627806266653e-01, 8.085158161746068828e-01, 7.825537446961500221e-01],
        [8.957442417382828204e-01, 8.039244072828748422e-01, 7.769086245337948338e-01],
        [8.941881096565635900e-01, 7.993371392915321616e-01, 7.712582600059587623e-01],
        [8.926437234223070227e-01, 7.947548018176209261e-01, 7.656048088583016220e-01],
        [8.911109613594879741e-01, 7.901772295732085727e-01, 7.599482475326526654e-01],
        [8.895909134152744091e-01, 7.856038035950861920e-01, 7.542875143411862382e-01],
        [8.880802871606852111e-01, 7.810355387672826000e-01, 7.486252986030703660e-01],
        [8.865819248532246233e-01, 7.764711589075004028e-01, 7.429590373479496579e-01],
        [8.850930260657449145e-01, 7.719115034698935673e-01, 7.372910251414285243e-01],
        [8.836131402967402071e-01, 7.673565360639147404e-01, 7.316215502737657417e-01],
        [8.821444223454562028e-01, 7.628052217660783452e-01, 7.259486135652994943e-01],
        [8.806827953756125593e-01, 7.582589101067193083e-01, 7.202756895379377466e-01],
        [8.792311851397603961e-01, 7.537162649935950087e-01, 7.146000961578288235e-01],
        [8.777875677079440830e-01, 7.491778548550656058e-01, 7.089235227883947665e-01],
        [8.763501988878248383e-01, 7.446441541668697983e-01, 7.032474436364752890e-01],
        [8.749232756241082098e-01, 7.401133023432254765e-01, 6.975679937396324082e-01],
        [8.735014600514631189e-01, 7.355871888710872053e-01, 6.918898915870100863e-01],
        [8.720870217729678187e-01, 7.310647072768980959e-01, 6.862110066741609060e-01],
        [8.706800348126626510e-01, 7.265456103843925817e-01, 6.805311805702053407e-01],
        [8.692770022519556994e-01, 7.220310948598716028e-01, 6.748535454654478460e-01],
        [8.678827146915726320e-01, 7.175190094979648769e-01, 6.691736166956238074e-01],
        [8.664927921052477666e-01, 7.130109157552886323e-01, 6.634953613259193528e-01],
        [8.651068719926267025e-01, 7.085067580022798017e-01, 6.578190657407729791e-01],
        [8.637289803901067042e-01, 7.040046558915140640e-01, 6.521408976142408775e-01],
        [8.623534679961476490e-01, 6.995067341461493893e-01, 6.464660893001026309e-01],
        [8.609830606578612322e-01, 6.950116457163946215e-01, 6.407920274183934728e-01],
        [8.596180478330472940e-01, 6.905190440208218705e-01, 6.351183727606340979e-01],
        [8.582544825018789680e-01, 6.860303869186620274e-01, 6.294488360238388314e-01],
        [8.568970944227636277e-01, 6.815434400545420379e-01, 6.237788543057761759e-01],
        [8.555425925651013452e-01, 6.770593865574592307e-01, 6.181115291897923969e-01],
        [8.541886800910097888e-01, 6.725790118919016125e-01, 6.124490539806487499e-01],
        [8.528418735895523239e-01, 6.680992506239646911e-01, 6.067850786519378703e-01],
        [8.514956700712879023e-01, 6.636227191543088155e-01, 6.011258775897345696e-01],
        [8.501500355486913962e-01, 6.591492264653023847e-01, 5.954714806881288292e-01],
        [8.488106382652110815e-01, 6.546760150904927800e-01, 5.898162979999663769e-01],
        [8.474706581846417341e-01, 6.502059048227525340e-01, 5.841670108646530579e-01],
        [8.461313452075343022e-01, 6.457381204225883797e-01, 5.785223911431566224e-01],
        [8.447969154607379849e-01, 6.412705018379197819e-01, 5.728782339090506825e-01],
        [8.434612056654142709e-01, 6.368056357299208825e-01, 5.672406638938772838e-01],
        [8.421258352164873173e-01, 6.323425572542190620e-01, 5.616080798917625350e-01],
        [8.407944708783339216e-01, 6.278793105389963713e-01, 5.559767932481035624e-01],
        [8.394611847956942041e-01, 6.234184331258648681e-01, 5.503527766345649441e-01],
        [8.381273683455257029e-01, 6.189590462186138620e-01, 5.447346560426542528e-01],
        [8.367972635859407537e-01, 6.144988712509784623e-01, 5.391181340824646728e-01],
        [8.354646463246349075e-01, 6.100406459813725313e-01, 5.335095625632335636e-01],
        [8.341299717058989760e-01, 6.055839279215072812e-01, 5.279085280772741751e-01],
        [8.327994021627661558e-01, 6.011254425561419756e-01, 5.223087380798424606e-01],
        [8.314657754399900069e-01, 5.966684488411785336e-01, 5.167175843922774403e-01],
        [8.301288592609736838e-01, 5.922128365915518833e-01, 5.111353769747372100e-01],
        [8.287951011685089631e-01, 5.877551092176589442e-01, 5.055554913593263144e-01],
        [8.274588476811213233e-01, 5.832978393600145584e-01, 4.999838390239015884e-01],
        [8.261188250087038165e-01, 5.788414339387950580e-01, 4.944218283197156505e-01],
        [8.247786369803286055e-01, 5.743837798031475872e-01, 4.888657757771856516e-01],
        [8.234381838800088893e-01, 5.699246359812502050e-01, 4.833158537977020885e-01],
        [8.220935149852323098e-01, 5.654657957469002572e-01, 4.777762994077761616e-01],
        [8.207444566974767541e-01, 5.610071021581608530e-01, 4.722474096096786478e-01],
        [8.193981033425531413e-01, 5.565444762341525964e-01, 4.667217962382390062e-01],
        [8.180472685091408902e-01, 5.520814646564632389e-01, 4.612071590527028753e-01],
        [8.166916431769154494e-01, 5.476179715812223847e-01, 4.557039631596026541e-01],
        [8.153328745786677656e-01, 5.431528161626910656e-01, 4.502105997079735578e-01],
        [8.139743540529152943e-01, 5.386837997184832361e-01, 4.447235925743368568e-01],
        [8.126106579688792131e-01, 5.342136249170785778e-01, 4.392488743242201066e-01],
        [8.112416585089723409e-01, 5.297420805368263652e-01, 4.337867573467541482e-01],
        [8.098689150112462487e-01, 5.252679783528519941e-01, 4.283357546423488538e-01],
        [8.084956135344389949e-01, 5.207891399756702233e-01, 4.228926326123328416e-01],
        [8.071166424763304148e-01, 5.163081809730883931e-01, 4.174630770396351442e-01],
        [8.057318945579315939e-01, 5.118248549122679236e-01, 4.120474263101407963e-01],
        [8.043412708255589516e-01, 5.073389039757838503e-01, 4.066460228640024210e-01],
        [8.029498733805645605e-01, 5.028469116894594970e-01, 4.012536130705923743e-01],
        [8.015531888402489535e-01, 4.983512104818560995e-01, 3.958753217358975118e-01],
        [8.001502657810105612e-01, 4.938520308181937879e-01, 3.905124577505094119e-01],
        [7.987410157112331266e-01, 4.893490771437783438e-01, 3.851654167818974739e-01],
        [7.973253554907255847e-01, 4.848420416222078422e-01, 3.798346066585175373e-01],
        [7.959075773999774173e-01, 4.803278114438007118e-01, 3.745157291750967898e-01],
        [7.944838857609586302e-01, 4.758083650556605426e-01, 3.692132449197628175e-01],
        [7.930533836294737515e-01, 4.712838795689627269e-01, 3.639285059842314873e-01],
        [7.916159847493996482e-01, 4.667540085796573757e-01, 3.586620124504662499e-01],
        [7.901716040813833164e-01, 4.622183930878590030e-01, 3.534142884263108408e-01],
        [7.887201567691978221e-01, 4.576766614569128255e-01, 3.481858850345221357e-01],
        [7.872638957915846225e-01, 4.531268310219068174e-01, 3.429748729037092048e-01],
        [7.858016971109998972e-01, 4.485691650403910713e-01, 3.377829921447058070e-01],
        [7.843319196766078694e-01, 4.440043051111859929e-01, 3.326125640359084423e-01],
        [7.828544529945841157e-01, 4.394318439857143876e-01, 3.274643000606006771e-01],
        [7.813691807701973469e-01, 4.348513628187685720e-01, 3.223389566893520852e-01],
        [7.798759793897394044e-01, 4.302624315207902450e-01, 3.172373399087716761e-01],
        [7.783747162977331380e-01, 4.256646092089760858e-01, 3.121603100704657408e-01],
        [7.768652482649208713e-01, 4.210574447687118194e-01, 3.071087870719240720e-01],
        [7.753474195428932125e-01, 4.164404775377301138e-01, 3.020837558793280642e-01],
        [7.738210599017090185e-01, 4.118132381262810671e-01, 2.970862723999735389e-01],
        [7.722859825475274498e-01, 4.071752493875019363e-01, 2.921174697090146433e-01],
        [7.707419819180442166e-01, 4.025260275530667675e-01, 2.871785646313976814e-01],
        [7.691888313545882649e-01, 3.978650835500125438e-01, 2.822708646751007633e-01],
        [7.676262806509283054e-01, 3.931919245154482101e-01, 2.773957753058901021e-01],
        [7.660540534803422785e-01, 3.885060555265225091e-01, 2.725548075466420750e-01],
        [7.644718447042359033e-01, 3.838069815635994364e-01, 2.677495858756240299e-01],
        [7.628793175676447103e-01, 3.790942097250059595e-01, 2.629818563878072446e-01],
        [7.612761007893139586e-01, 3.743672517119065457e-01, 2.582534951710902527e-01],
        [7.596617855567490141e-01, 3.696256266018116965e-01, 2.535665168349998111e-01],
        [7.580359224396768791e-01, 3.648688639288839575e-01, 2.489230831128432242e-01],
        [7.563980182387591844e-01, 3.600965070884658559e-01, 2.443255114391649219e-01],
        [7.547475327902162245e-01, 3.553081170821107415e-01, 2.397762833825934359e-01],
        [7.530838757510928128e-01, 3.505032766177708092e-01, 2.352780527895846907e-01],
        [7.514064033944252152e-01, 3.456815945775675858e-01, 2.308336534671754370e-01],
        [7.497144154482878742e-01, 3.408427108627715696e-01, 2.264461062026797977e-01],
        [7.480093931719870026e-01, 3.359841374696425076e-01, 2.221167453210010634e-01],
        [7.462904219476443890e-01, 3.311055722690471881e-01, 2.178492138304993775e-01],
        [7.445546708594931173e-01, 3.262086086142511610e-01, 2.136488350090644528e-01],
        [7.428011522578348291e-01, 3.212930797652773784e-01, 2.095194932063288440e-01],
        [7.410289292300998865e-01, 3.163587556773898579e-01, 2.054651883130465539e-01],
        [7.392422371017411953e-01, 3.113999367010875097e-01, 2.014864526930904010e-01],
        [7.374344355234756510e-01, 3.064221768888288899e-01, 1.975919663992890540e-01],
        [7.356041908206575330e-01, 3.014256456718681365e-01, 1.937864841719280640e-01],
        [7.337546411878117514e-01, 2.964055318272263428e-01, 1.900722381207737011e-01],
        [7.318814451569350954e-01, 2.913651536558918287e-01, 1.864564514321402355e-01],
        [7.299813549163196580e-01, 2.863068267986909055e-01, 1.829454454677189867e-01],
        [7.280589696708802405e-01, 2.812237436541007995e-01, 1.795417572234761505e-01],
        [7.261058295804370122e-01, 2.761243371138519809e-01, 1.762545002124356330e-01],
        [7.241247102013246284e-01, 2.710038520778982329e-01, 1.730875525793737491e-01],
        [7.221106804386585587e-01, 2.658668602953934146e-01, 1.700480125370592843e-01],
        [7.200637636280236009e-01, 2.607119201605753722e-01, 1.671411340183387162e-01],
        [7.179797241720924372e-01, 2.555430923618877692e-01, 1.643731951674216596e-01],
        [7.158585660201038925e-01, 2.503590497486887223e-01, 1.617494125495184398e-01],
        [7.136946458601574061e-01, 2.451661844345556784e-01, 1.592752687470095629e-01],
        [7.114894074734618989e-01, 2.399613853901303440e-01, 1.569555549892431845e-01],
        [7.092368038757341786e-01, 2.347521795395665634e-01, 1.547943364998323190e-01],
        [7.069352804131667778e-01, 2.295401028324536297e-01, 1.527950884695459255e-01],
        [7.045831993890990796e-01, 2.243269505217069248e-01, 1.509608633015488421e-01],
        [7.021764206472544956e-01, 2.191186683316911910e-01, 1.492928085088980894e-01],
        [6.997128684389145592e-01, 2.139184608731344861e-01, 1.477916611410667047e-01],
        [6.971911916356166028e-01, 2.087286324898059431e-01, 1.464577951274126655e-01],
        [6.946080256946649545e-01, 2.035552197097931226e-01, 1.452888805599515110e-01],
        [6.919615635162069678e-01, 1.984021504802455094e-01, 1.442823442764895880e-01],
        [6.892502621260994111e-01, 1.932732898312458647e-01, 1.434346916240710201e-01],
        [6.864728173440260983e-01, 1.881724668500568132e-01, 1.427415573021981465e-01],
        [6.836276497375878280e-01, 1.831044861638990162e-01, 1.421968539256191488e-01],
        [6.807138936899735926e-01, 1.780732451543534933e-01, 1.417942947939738185e-01],
        [6.777309286205458472e-01, 1.730825547177755885e-01, 1.415269568275668299e-01],
        [6.746783856387729150e-01, 1.681360921159456845e-01, 1.413874528291547972e-01],
        [6.715560313350845689e-01, 1.632376302346780217e-01, 1.413677792054587046e-01],
        [6.683639211377226941e-01, 1.583906644890515358e-01, 1.414598772073469568e-01],
        [6.651023056640176234e-01, 1.535985670708633066e-01, 1.416556412086291405e-01],
        [6.617715794982882427e-01, 1.488646699200451562e-01, 1.419469640184388703e-01],
        [6.583721731985413550e-01, 1.441925388486675619e-01, 1.423253876471278490e-01],
        [6.549047613747174257e-01, 1.395853626420375526e-01, 1.427832909133252004e-01],
        [6.513700233144809060e-01, 1.350465677963595956e-01, 1.433130440041158193e-01],
        [6.477686724727176326e-01, 1.305797355595543496e-01, 1.439072462489923432e-01],
        [6.441014028993071738e-01, 1.261888040474711814e-01, 1.445583185074540422e-01],
        [6.403689740006455189e-01, 1.218777495533199251e-01, 1.452593821489098769e-01],
        [6.365721433135939078e-01, 1.176507620626412731e-01, 1.460041387809807023e-01],
        [6.327116135602410818e-01, 1.135124987936143026e-01, 1.467862349801432043e-01],
        [6.287880597206695343e-01, 1.094681045314993273e-01, 1.475989566519263774e-01],
        [6.248021600743940418e-01, 1.055229431116234684e-01, 1.484364140781085362e-01],
        [6.207545450778898521e-01, 1.016827736772349666e-01, 1.492933020681679601e-01],
        [6.166458126074587653e-01, 9.795388132578869422e-02, 1.501640386258630555e-01],
        [6.124766416655831325e-01, 9.434293988806133346e-02, 1.510418818628477822e-01],
        [6.082475860694411818e-01, 9.085689252672626837e-02, 1.519224424106922766e-01],
        [6.039592307964848361e-01, 8.750309254173271878e-02, 1.528005492303129986e-01],
        [5.996123270243045589e-01, 8.428892340087804080e-02, 1.536699242631612283e-01],
        [5.952075850399283219e-01, 8.122188415501030434e-02, 1.545253736600938343e-01],
        [5.907456431322212209e-01, 7.830966313722748096e-02, 1.553624952709374007e-01],
        [5.862275380722600238e-01, 7.555913263658070589e-02, 1.561749022891834038e-01],
        [5.816543085194019191e-01, 7.297679500504322680e-02, 1.569571524895727321e-01],
        [5.770267606447557762e-01, 7.056924923284621509e-02, 1.577054842373717958e-01],
        [5.723466647463710810e-01, 6.834024207619035507e-02, 1.584124407437495219e-01],
        [5.676151929412465158e-01, 6.629402087598951221e-02, 1.590741634973840690e-01],
        [5.628336935771917071e-01, 6.443348056543876656e-02, 1.596865619581833706e-01],
        [5.580050003714496221e-01, 6.275633232081309631e-02, 1.602413164863800144e-01],
        [5.531297300263749994e-01, 6.126496600367018625e-02, 1.607383872225261745e-01],
        [5.482116402359448193e-01, 5.995167246350390639e-02, 1.611686284256901580e-01],
        [5.432516061451815315e-01, 5.881547808076787592e-02, 1.615323341086055964e-01],
        [5.382535120903690906e-01, 5.784532671126727671e-02, 1.618221724924289173e-01],
        [5.332186175206464762e-01, 5.703660923770780683e-02, 1.620384025483199708e-01],
        [5.281513818389996784e-01, 5.637398150597446728e-02, 1.621742451273615881e-01],
        [5.230520756324539278e-01, 5.585383743496476899e-02, 1.622329744665089168e-01],
        [5.179273401770114749e-01, 5.545235617321788574e-02, 1.622049347095048388e-01],
        [5.127760391281988017e-01, 5.516900039838320419e-02, 1.620968226308776017e-01],
        [5.076034324141470711e-01, 5.498326606891081741e-02, 1.619030677004743290e-01],
        [5.024122108869354397e-01, 5.488240340299161552e-02, 1.616236282627719067e-01],
        [4.972028565812885437e-01, 5.486041454189729411e-02, 1.612621553479370584e-01],
        [4.919800125101927990e-01, 5.489873490341760226e-02, 1.608156853259256336e-01],
        [4.867469976088732442e-01, 5.498319810891529741e-02, 1.602839538682285792e-01],
        [4.815035401048063934e-01, 5.511074616505500651e-02, 1.596718589083305773e-01],
        [4.762519241645499224e-01, 5.527092475320084103e-02, 1.589804323039821221e-01],
        [4.709943156232950234e-01, 5.545404644646995812e-02, 1.582109529908402590e-01],
        [4.657362887691403608e-01, 5.564106402926658618e-02, 1.573608184133624133e-01],
        [4.604760106385220042e-01, 5.583489737898188893e-02, 1.564363997859181399e-01],
        [4.552150906427448462e-01, 5.602873466021515009e-02, 1.554396278095509509e-01],
        [4.499550509587917912e-01, 5.621638605393316362e-02, 1.543724780354263082e-01],
        [4.446972616844994119e-01, 5.639243657216582578e-02, 1.532370205267698793e-01],
        [4.394429409822757093e-01, 5.655220574247237647e-02, 1.520353945457279254e-01],
        [4.341931570608791313e-01, 5.669170022106548995e-02, 1.507697850177304177e-01],
        [4.289488317782668703e-01, 5.680756188500035025e-02, 1.494424009624717165e-01],
        [4.237107456338875533e-01, 5.689701352302534848e-02, 1.480554560097830374e-01],
        [4.184795439135307604e-01, 5.695780383827742793e-02, 1.466111510548973595e-01],
        [4.132557437526688804e-01, 5.698815310778364979e-02, 1.451116590521219496e-01],
        [4.080397418937663501e-01, 5.698670052046273665e-02, 1.435591118993865545e-01],
        [4.028318229277383922e-01, 5.695245393890951274e-02, 1.419555893285963655e-01],
        [3.976321678282654926e-01, 5.688474259913823411e-02, 1.403031096878759043e-01],
        [3.924408626085833518e-01, 5.678317307342812398e-02, 1.386036224809996942e-01],
        [3.872615129675306966e-01, 5.663896210711539397e-02, 1.368568732654815434e-01],
        [3.820928251575063661e-01, 5.645532265747305739e-02, 1.350656214594591342e-01],
        [3.769329700865952648e-01, 5.623657775378711893e-02, 1.332326547817182794e-01],
        [3.717817181595340914e-01, 5.598316066775241989e-02, 1.313596470261583493e-01],
        [3.666387821359218258e-01, 5.569561666867810928e-02, 1.294481844724836295e-01],
        [3.615063297404105258e-01, 5.536890534251808632e-02, 1.274985831214487109e-01],
        [3.563880603817025094e-01, 5.499475479736596478e-02, 1.255105734342905621e-01],
        [3.512776042297060530e-01, 5.458755525687735560e-02, 1.234884411194991649e-01],
        [3.461744793988128510e-01, 5.414817693699586904e-02, 1.214334602338749125e-01],
        [3.410813090262644343e-01, 5.367068674831452363e-02, 1.193455923090092352e-01],
        [3.360026615292399654e-01, 5.314516420281268499e-02, 1.172242123426087412e-01],
        [3.309302966511110111e-01, 5.258939733233552322e-02, 1.150735180048746420e-01],
        [3.258636162106021694e-01, 5.200433045735335796e-02, 1.128944817728364247e-01],
        [3.208133832347068171e-01, 5.136699574271335472e-02, 1.106843415414836551e-01],
        [3.157696216592825178e-01, 5.069836482305852682e-02, 1.084473347788683095e-01],
        [3.107301266925714400e-01, 5.000263599039595636e-02, 1.061847548036680688e-01],
        [3.057061331880795430e-01, 4.925629172594595678e-02, 1.038940386221758327e-01],
        [3.006879268630521240e-01, 4.847913366710451116e-02, 1.015787046192155041e-01],
        [2.956726217207689689e-01, 4.767654364208809975e-02, 9.923998323658683729e-02],
        [2.906746306466351792e-01, 4.681900231021129261e-02, 9.687492161154248604e-02],
        [2.856782002647242358e-01, 4.593789236755790178e-02, 9.448789214269404102e-02],
        [2.806890017083342181e-01, 4.502128372335665457e-02, 9.207800935320636926e-02],
        [2.757102955542003464e-01, 4.406225179606895054e-02, 8.964513100796869804e-02],
        [2.707312541226000180e-01, 4.308157177910076213e-02, 8.719176105781661912e-02],
        [2.657667372933599781e-01, 4.204947038025994704e-02, 8.471559044612611555e-02],
        [2.608025053402583393e-01, 4.099314121499578883e-02, 8.221947676879418077e-02],
        [2.558451747035172530e-01, 3.989182795135969711e-02, 7.970262452812598708e-02],
        [2.508938137991353901e-01, 3.876029441108298085e-02, 7.716551375026653448e-02],
        [2.459428063629143790e-01, 3.762148549775875400e-02, 7.460911056507216199e-02],
        [2.410021600694670640e-01, 3.645746689804394564e-02, 7.203245689473128377e-02],
        [2.360563646646140490e-01, 3.529747994604028744e-02, 6.943744239412558139e-02]];

% Interpolate to requested number of colors.

P = size(cmap,1);

if (P ~= M)
  cmap = interp1(1:size(cmap,1), cmap, linspace(1,P,M), 'linear');
end

return
