%
% Colormaps Matlab scripts
% ========================
%
% This directory contains several colormaps and related processing
% functions
%
% Colormaps or Color Palettes:
%
%   cm_algae      - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for phytoplankton (sequential).
%   cm_amp        - A perceptually-uniform 256 colormap by Kristen Thyng
%                     (sequential).
%   cm_balance    - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for sea surface height (diverging)
%   cm_curl       - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for wind curl (diverging).
%   cm_deep       - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for bathymetry (sequential).
%   cm_delta      - A perceptually-uniform 512 colormap by Kristen Thyng
%                     it can be used for freshwater (diverging).
%   cm_dense      - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for density (sequential).
%   cm_gray       - A perceptually-uniform 256 colormap by Kristen Thyng
%                     (sequential).
%   cm_haline     - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for salinity (sequential).
%   cm_ice        - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for sea ice (sequential).
%   cm_matter     - A perceptually-uniform 256 colormap by Kristen Thyng
%                     (sequential).
%   cm_oxy        - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for oxygen concentration (sequential).
%   cm_phase      - A perceptually-uniform 256 colormap by Kristen Thyng
%                     (constant lightness).
%   cm_solar      - A perceptually-uniform 256 colormap by Kristen Thyng
%                     (sequential).
%   cm_speed      - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for velocity magnitude (sequential).
%   cm_tempo      - A perceptually-uniform 256 colormap by Kristen Thyng
%                     (sequential).
%   cm_thermal    - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for temperature (sequential).
%   cm_turbid     - A perceptually-uniform 256 colormap by Kristen Thyng,
%                     it can be used for sediment (sequential).
%   inferno       - A 256 colormap by Nathaniel J. Smith and Stefan van
%                     der Walt.
%   magma         - A 256 colormap by Nathaniel J. Smith and Stefan van
%                     der Walt.
%   plasma        - A 256 colormap by Nathaniel J. Smith and Stefan van
%                     der Walt.
%   viridis       - A 256 colormap by Eric Firing.
%   vivid         - A personalized colormap bh Joseph Kirk.
%   zebra         - A banded colormap by S.B. Hooker et al. (1995).
%
% Colormap Processing:
%
%   cbarrow       - Places triangle-shaped endmembers on both ends of the
%                     current colorbar by Chad A. Greene.
%   cmocean       - Colormap package for oceanographic applications by 
%                     Chad A. Greene.
%   colorspace    - Transform a color image between color representations
%                     by Pascal Getreuer.

% svn $Id: Contents.m 895 2018-02-11 23:15:37Z arango $
%=========================================================================%
%  Copyright (c) 2002-2018 The ROMS/TOMS Group                            %
%    Licensed under a MIT/X style license                                 %
%    See License_ROMS.txt                           Hernan G. Arango      %
%=========================================================================%
