% roms_combine_clm_bdy.m
%
% This routine :
%   combines user-defined series of ROMS climatology and boundary condition files corresponding to different times on the same grid (between times).
% Boundaries are at east and south in this example; user needs to modify the "Boundary" part of the routine in presence of different boundary settings.
% 
% The climatology and boundary files can be generated by using roms_master_climatology_coawst_mw.m
% 
%   user-   selects the name of the files to combine (*_files2combine)
%
%   outputs- the combo files with user-defined names (*_combo_file)
%
% 2012 - 06: Ilgar Safak

%%%%%%%%%%%%%%%%%%%%%   START OF USER INPUT  %%%%%%%%%%%%%%%%%%%%%%%%%%

clm_files2combine={'/home/isafak-pr/Models/COAWST/Tools/mfiles/roms_clm/useast_20100101_clm.nc','/home/isafak-pr/Models/COAWST/Tools/mfiles/roms_clm/useast_20100201_clm.nc'};
bdy_files2combine={'/home/isafak-pr/Models/COAWST/Tools/mfiles/roms_clm/useast_20100101_bdy.nc','/home/isafak-pr/Models/COAWST/Tools/mfiles/roms_clm/useast_20100201_bdy.nc'};

clm_combo_file='useast_clm.nc';
bdy_combo_file='useast_bdy.nc';

%%%%%%%%%%%%%%%%%%%%%   END OF USER INPUT  %%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%   START OF CLIMATOLOGY  %%%%%%%%%%%%%%%%%%%%%%%%%%

% Create the climatology file

nc = netcdf.create(clm_combo_file,'nc_clobber');

% Write global variables

netcdf.putAtt(nc,netcdf.getConstant('NC_GLOBAL'),'history', ['Created by "' mfilename '" on ' datestr(now)]);
netcdf.putAtt(nc,netcdf.getConstant('NC_GLOBAL'),'type', 'climate forcing file from http://hycom.coaps.fsu.edu:8080/thredds/dodsC/glb_analysis');

nfile=length(clm_files2combine);

% Extract the climatology variables from the files to combine

for i=1:nfile

nc1         = netcdf.open(char(clm_files2combine(i)),'NC_NOWRITE');                    
varid = netcdf.inqVarID(nc1,'ocean_time'); ocean_time(i) = netcdf.getVar(nc1,varid);    varid = netcdf.inqVarID(nc1,'zeta_time'); zeta_time(i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'v2d_time'); v2d_time(i) = netcdf.getVar(nc1,varid);        varid = netcdf.inqVarID(nc1,'v3d_time'); v3d_time(i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'salt_time'); salt_time(i) = netcdf.getVar(nc1,varid);      varid = netcdf.inqVarID(nc1,'temp_time'); temp_time(i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'lon_rho'); lon_rho = netcdf.getVar(nc1,varid);             varid = netcdf.inqVarID(nc1,'lat_rho'); lat_rho = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'zeta'); zeta(:,:,i) = netcdf.getVar(nc1,varid);            varid = netcdf.inqVarID(nc1,'u'); u(:,:,:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'v'); v(:,:,:,i) = netcdf.getVar(nc1,varid);                varid = netcdf.inqVarID(nc1,'ubar'); ubar(:,:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'vbar'); vbar(:,:,i) = netcdf.getVar(nc1,varid);            varid = netcdf.inqVarID(nc1,'salt'); salt(:,:,:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'temp'); temp(:,:,:,i) = netcdf.getVar(nc1,varid);

end

% Extract the dimensions

dimensions=size(v);
LP=dimensions(1);
MP=dimensions(2)+1;
s=dimensions(3);

L=LP-1;
M=MP-1;

% Write dimensions

psidimID = netcdf.defDim(nc,'xpsi',L);
xrhodimID = netcdf.defDim(nc,'xrho',LP);
xudimID = netcdf.defDim(nc,'xu',L);
xvdimID = netcdf.defDim(nc,'xv',LP);

epsidimID = netcdf.defDim(nc,'epsi',M);
erhodimID = netcdf.defDim(nc,'erho',MP);
eudimID = netcdf.defDim(nc,'eu',MP);
evdimID = netcdf.defDim(nc,'ev',M);
s_rhodimID = netcdf.defDim(nc,'s_rho',s);

octdimID = netcdf.defDim(nc,'ocean_time',nfile);
zttdimID = netcdf.defDim(nc,'zeta_time',nfile);
v2tdimID = netcdf.defDim(nc,'v2d_time',nfile);
v3tdimID = netcdf.defDim(nc,'v3d_time',nfile);
sltdimID = netcdf.defDim(nc,'salt_time',nfile);
tptdimID = netcdf.defDim(nc,'temp_time',nfile);
onedimID = netcdf.defDim(nc,'one',1);

% Write variables

ocID = netcdf.defVar(nc,'ocean_time','double',octdimID);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,ocID,ocean_time);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,ocID,'long_name','wind field time');
netcdf.putAtt(nc,ocID,'units','days');
netcdf.putAtt(nc,ocID,'field','wave_time, scalar, series');

ztID = netcdf.defVar(nc,'zeta_time','double',zttdimID);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,ztID,zeta_time);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,ztID,'long_name','zeta_time');
netcdf.putAtt(nc,ztID,'units','days');
netcdf.putAtt(nc,ztID,'field','zeta_time, scalar, series');

v2ID = netcdf.defVar(nc,'v2d_time','double',v2tdimID);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,v2ID,v2d_time);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,v2ID,'long_name','v2d_time');
netcdf.putAtt(nc,v2ID,'units','days');
netcdf.putAtt(nc,v2ID,'field','v2d_time, scalar, series');

v3ID = netcdf.defVar(nc,'v3d_time','double',v3tdimID);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,v3ID,v3d_time);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,v3ID,'long_name','v3d_time');
netcdf.putAtt(nc,v3ID,'units','days');
netcdf.putAtt(nc,v3ID,'field','v3d_time, scalar, series');

slID = netcdf.defVar(nc,'salt_time','double',sltdimID);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,slID,salt_time);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,slID,'long_name','salt_time');
netcdf.putAtt(nc,slID,'units','days');
netcdf.putAtt(nc,slID,'field','salt_time, scalar, series');

tpID = netcdf.defVar(nc,'temp_time','double',tptdimID);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,tpID,temp_time);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,tpID,'long_name','temp_time');
netcdf.putAtt(nc,tpID,'units','days');
netcdf.putAtt(nc,tpID,'field','temp_time, scalar, series');

lonID = netcdf.defVar(nc,'lon_rho','float',[xrhodimID erhodimID]);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,lonID,lon_rho);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,lonID,'long_name','lon_rho');
netcdf.putAtt(nc,lonID,'units','degrees');
netcdf.putAtt(nc,lonID,'FillValue_',100000.);
netcdf.putAtt(nc,lonID,'missing_value',100000.);
netcdf.putAtt(nc,lonID,'field','xp, scalar, series');

latID = netcdf.defVar(nc,'lat_rho','float',[xrhodimID erhodimID]);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,latID,lat_rho);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,latID,'long_name','lon_rho');
netcdf.putAtt(nc,latID,'units','degrees');
netcdf.putAtt(nc,latID,'FillValue_',100000.);
netcdf.putAtt(nc,latID,'missing_value',100000.);
netcdf.putAtt(nc,latID,'field','yp, scalar, series');

zetID = netcdf.defVar(nc,'zeta','double',[xrhodimID erhodimID zttdimID]);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,zetID,zeta);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,zetID,'long_name','zeta');
netcdf.putAtt(nc,zetID,'units','meter');
netcdf.putAtt(nc,zetID,'field','zeta, scalar, series');

salID = netcdf.defVar(nc,'salt','float',[xrhodimID erhodimID s_rhodimID sltdimID]);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,salID,salt);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,salID,'long_name','salt');
netcdf.putAtt(nc,salID,'units','psu');
netcdf.putAtt(nc,salID,'field','salt, scalar, series');

tmpID = netcdf.defVar(nc,'temp','float',[xrhodimID erhodimID s_rhodimID tptdimID]);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,tmpID,temp);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,tmpID,'long_name','temp');
netcdf.putAtt(nc,tmpID,'units','C');
netcdf.putAtt(nc,tmpID,'field','temp, scalar, series');

uID = netcdf.defVar(nc,'u','float',[xudimID eudimID s_rhodimID v3tdimID]);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,uID,u);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,uID,'long_name','velx');
netcdf.putAtt(nc,uID,'units','meter second-1');
netcdf.putAtt(nc,uID,'field','velx, scalar, series');

vID = netcdf.defVar(nc,'v','float',[xvdimID evdimID s_rhodimID v3tdimID]);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,vID,v);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,vID,'long_name','vely');
netcdf.putAtt(nc,vID,'units','meter second-1');
netcdf.putAtt(nc,vID,'field','vely, scalar, series');

ubID = netcdf.defVar(nc,'ubar','float',[xudimID eudimID v2tdimID]);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,ubID,ubar);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,ubID,'long_name','mean velx');
netcdf.putAtt(nc,ubID,'units','meter second-1');
netcdf.putAtt(nc,ubID,'field','mean velx, scalar, series');

vbID = netcdf.defVar(nc,'vbar','float',[xvdimID evdimID v2tdimID]);
netcdf.endDef(nc);                                                               
netcdf.putVar(nc,vbID,vbar);                                                    
netcdf.reDef(nc);                                                               
netcdf.putAtt(nc,vbID,'long_name','mean vely');
netcdf.putAtt(nc,vbID,'units','meter second-1');
netcdf.putAtt(nc,vbID,'field','mean vely, scalar, series');

% Close the climatology file

netcdf.close(nc)

disp(['------------ wrote ',clm_combo_file,' ------------']);

%%%%%%%%%%%%%%%%%%%%%   END OF CLIMATOLOGY  %%%%%%%%%%%%%%%%%%%%%%%%%%

clearvars -except bdy_combo_file bdy_files2combine

%%%%%%%%%%%%%%%%%%%%%   START OF BOUNDARY  %%%%%%%%%%%%%%%%%%%%%%%%%%

% Create the boundary file

nc_bndry = netcdf.create(bdy_combo_file,'nc_clobber');

% Write global variables

netcdf.putAtt(nc_bndry,netcdf.getConstant('NC_GLOBAL'),'history', ['Created by "' mfilename '" on ' datestr(now)]);
netcdf.putAtt(nc_bndry,netcdf.getConstant('NC_GLOBAL'),'type', 'boundary forcing file from http://hycom.coaps.fsu.edu:8080/thredds/dodsC/glb_analysis');

nfile=length(bdy_files2combine);

% Extract the boundary variables from the files to combine

for i=1:nfile
    nc1         = netcdf.open(char(bdy_files2combine(i)),'NC_NOWRITE');  
    
varid = netcdf.inqVarID(nc1,'zeta_time'); zeta_time(i) = netcdf.getVar(nc1,varid);       varid = netcdf.inqVarID(nc1,'v2d_time'); v2d_time(i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'v3d_time'); v3d_time(i) = netcdf.getVar(nc1,varid);         varid = netcdf.inqVarID(nc1,'salt_time'); salt_time(i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'temp_time'); temp_time(i) = netcdf.getVar(nc1,varid);       varid = netcdf.inqVarID(nc1,'zeta_south'); zeta_south(:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'zeta_east'); zeta_east(:,i) = netcdf.getVar(nc1,varid);     varid = netcdf.inqVarID(nc1,'u_south'); u_south(:,:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'u_east'); u_east(:,:,i) = netcdf.getVar(nc1,varid);         varid = netcdf.inqVarID(nc1,'v_south'); v_south(:,:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'v_east'); v_east(:,:,i) = netcdf.getVar(nc1,varid);         varid = netcdf.inqVarID(nc1,'ubar_south'); ubar_south(:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'ubar_east'); ubar_east(:,i) = netcdf.getVar(nc1,varid);     varid = netcdf.inqVarID(nc1,'vbar_south'); vbar_south(:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'vbar_east'); vbar_east(:,i) = netcdf.getVar(nc1,varid);     varid = netcdf.inqVarID(nc1,'salt_south'); salt_south(:,:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'salt_east'); salt_east(:,:,i) = netcdf.getVar(nc1,varid);   varid = netcdf.inqVarID(nc1,'temp_south'); temp_south(:,:,i) = netcdf.getVar(nc1,varid);
varid = netcdf.inqVarID(nc1,'temp_east'); temp_east(:,:,i) = netcdf.getVar(nc1,varid);
    
end

% Extract the dimensions

dimensions=size(v_south);
LP=dimensions(1);
s= dimensions(2);

dimensions=size(v_east);
MP=dimensions(1)+1;

L=LP-1;
Lm=L-1;
M=MP-1;
Mm=M-1;
L  = Lm+1;
M  = Mm+1;
xpsi  = L;
xrho  = LP;
xu    = L;
xv    = LP;
epsi = M;
erho = MP;
eu   = MP;
ev   = M;

% Write dimensions

psidimID = netcdf.defDim(nc_bndry,'xpsi',L);
xrhodimID = netcdf.defDim(nc_bndry,'xrho',LP);
xudimID = netcdf.defDim(nc_bndry,'xu',L);
xvdimID = netcdf.defDim(nc_bndry,'xv',LP);

epsidimID = netcdf.defDim(nc_bndry,'epsi',M);
erhodimID = netcdf.defDim(nc_bndry,'erho',MP);
eudimID = netcdf.defDim(nc_bndry,'eu',MP);
evdimID = netcdf.defDim(nc_bndry,'ev',M);
s_rhodimID = netcdf.defDim(nc_bndry,'s_rho',s);

zttdimID = netcdf.defDim(nc_bndry,'zeta_time',nfile);
v2tdimID = netcdf.defDim(nc_bndry,'v2d_time',nfile);
v3tdimID = netcdf.defDim(nc_bndry,'v3d_time',nfile);
sltdimID = netcdf.defDim(nc_bndry,'salt_time',nfile);
tptdimID = netcdf.defDim(nc_bndry,'temp_time',nfile);

% Write variables

ztID = netcdf.defVar(nc_bndry,'zeta_time','double',zttdimID);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,ztID,zeta_time);                                                    
netcdf.reDef(nc_bndry);                                                               
netcdf.putAtt(nc_bndry,ztID,'long_name','zeta_time');
netcdf.putAtt(nc_bndry,ztID,'units','days');
netcdf.putAtt(nc_bndry,ztID,'field','zeta_time, scalar, series');

v2ID = netcdf.defVar(nc_bndry,'v2d_time','double',v2tdimID);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,v2ID,v2d_time);                                                    
netcdf.reDef(nc_bndry);                                                               
netcdf.putAtt(nc_bndry,v2ID,'long_name','v2d_time');
netcdf.putAtt(nc_bndry,v2ID,'units','days');
netcdf.putAtt(nc_bndry,v2ID,'field','v2d_time, scalar, series');

v3ID = netcdf.defVar(nc_bndry,'v3d_time','double',v3tdimID);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,v3ID,v3d_time);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,v3ID,'long_name','v3d_time');
netcdf.putAtt(nc_bndry,v3ID,'units','days');
netcdf.putAtt(nc_bndry,v3ID,'field','v3d_time, scalar, series');

slID = netcdf.defVar(nc_bndry,'salt_time','double',sltdimID);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,slID,salt_time);                                                    
netcdf.reDef(nc_bndry);    
netcdf.putAtt(nc_bndry,slID,'long_name','salt_time');
netcdf.putAtt(nc_bndry,slID,'units','days');
netcdf.putAtt(nc_bndry,slID,'field','salt_time, scalar, series');

tpID = netcdf.defVar(nc_bndry,'temp_time','double',tptdimID);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,tpID,temp_time);                                                    
netcdf.reDef(nc_bndry);       
netcdf.putAtt(nc_bndry,tpID,'long_name','temp_time');
netcdf.putAtt(nc_bndry,tpID,'units','days');
netcdf.putAtt(nc_bndry,tpID,'field','temp_time, scalar, series');

zetsID = netcdf.defVar(nc_bndry,'zeta_south','double',[xrhodimID zttdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,zetsID,zeta_south);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,zetsID,'long_name','free-surface southern boundary condition');
netcdf.putAtt(nc_bndry,zetsID,'units','meter');
netcdf.putAtt(nc_bndry,zetsID,'field','zeta_south, scalar, series');

zeteID = netcdf.defVar(nc_bndry,'zeta_east','double',[erhodimID zttdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,zeteID,zeta_east);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,zeteID,'long_name','free-surface eastern boundary condition');
netcdf.putAtt(nc_bndry,zeteID,'units','meter');
netcdf.putAtt(nc_bndry,zeteID,'field','zeta_east, scalar, series');

ubsID = netcdf.defVar(nc_bndry,'ubar_south','float',[xudimID v2tdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,ubsID,ubar_south);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,ubsID,'long_name','2D u-momentum southern boundary condition');
netcdf.putAtt(nc_bndry,ubsID,'units','meter second-1');
netcdf.putAtt(nc_bndry,ubsID,'field','ubar_south, scalar, series');

ubeID = netcdf.defVar(nc_bndry,'ubar_east','float',[eudimID v2tdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,ubeID,ubar_east);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,ubeID,'long_name','2D u-momentum eastern boundary condition');
netcdf.putAtt(nc_bndry,ubeID,'units','meter second-1');
netcdf.putAtt(nc_bndry,ubeID,'field','ubar_east, scalar, series');

vbsID = netcdf.defVar(nc_bndry,'vbar_south','float',[xvdimID v2tdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,vbsID,vbar_south);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,vbsID,'long_name','2D v-momentum southern boundary condition');
netcdf.putAtt(nc_bndry,vbsID,'units','meter second-1');
netcdf.putAtt(nc_bndry,vbsID,'field','vbar_south, scalar, series');

vbeID = netcdf.defVar(nc_bndry,'vbar_east','float',[evdimID v2tdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,vbeID,vbar_east);                                                    
netcdf.reDef(nc_bndry); 
netcdf.putAtt(nc_bndry,vbeID,'long_name','2D v-momentum eastern boundary condition');
netcdf.putAtt(nc_bndry,vbeID,'units','meter second-1');
netcdf.putAtt(nc_bndry,vbeID,'field','vbar_east, scalar, series');

usID = netcdf.defVar(nc_bndry,'u_south','float',[xudimID s_rhodimID v3tdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,usID,u_south);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,usID,'long_name','3D u-momentum southern boundary condition');
netcdf.putAtt(nc_bndry,usID,'units','meter second-1');
netcdf.putAtt(nc_bndry,usID,'field','u_south, scalar, series');

ueID = netcdf.defVar(nc_bndry,'u_east','float',[eudimID s_rhodimID v3tdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,ueID,u_east);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,ueID,'long_name','3D u-momentum eastern boundary condition');
netcdf.putAtt(nc_bndry,ueID,'units','meter second-1');
netcdf.putAtt(nc_bndry,ueID,'field','u_east, scalar, series');

vsID = netcdf.defVar(nc_bndry,'v_south','float',[xvdimID s_rhodimID v3tdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,vsID,v_south);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,vsID,'long_name','3D v-momentum southern boundary condition');
netcdf.putAtt(nc_bndry,vsID,'units','meter second-1');
netcdf.putAtt(nc_bndry,vsID,'field','v_south, scalar, series');

veID = netcdf.defVar(nc_bndry,'v_east','float',[evdimID s_rhodimID v3tdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,veID,v_east);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,veID,'long_name','3D v-momentum eastern boundary condition');
netcdf.putAtt(nc_bndry,veID,'units','meter second-1');
netcdf.putAtt(nc_bndry,veID,'field','v_east, scalar, series');

tmpsID = netcdf.defVar(nc_bndry,'temp_south','float',[xrhodimID s_rhodimID tptdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,tmpsID,temp_south);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,tmpsID,'long_name','3D temperature southern boundary condition');
netcdf.putAtt(nc_bndry,tmpsID,'units','C');
netcdf.putAtt(nc_bndry,tmpsID,'field','temp_south, scalar, series');

tmpeID = netcdf.defVar(nc_bndry,'temp_east','float',[erhodimID s_rhodimID tptdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,tmpeID,temp_east);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,tmpeID,'long_name','3D temperature eastern boundary condition');
netcdf.putAtt(nc_bndry,tmpeID,'units','C');
netcdf.putAtt(nc_bndry,tmpeID,'field','temp_east, scalar, series');

salsID = netcdf.defVar(nc_bndry,'salt_south','float',[xrhodimID s_rhodimID sltdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,salsID,salt_south);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,salsID,'long_name','3D salinity southern boundary condition');
netcdf.putAtt(nc_bndry,salsID,'units','psu');
netcdf.putAtt(nc_bndry,salsID,'field','salt_south, scalar, series');

saleID = netcdf.defVar(nc_bndry,'salt_east','float',[erhodimID s_rhodimID sltdimID]);
netcdf.endDef(nc_bndry);                                                               
netcdf.putVar(nc_bndry,saleID,salt_east);                                                    
netcdf.reDef(nc_bndry);  
netcdf.putAtt(nc_bndry,saleID,'long_name','3D salinity eastern boundary condition');
netcdf.putAtt(nc_bndry,saleID,'units','psu');
netcdf.putAtt(nc_bndry,saleID,'field','salt_east, scalar, series');

% Close the boundary file
netcdf.close(nc_bndry)

disp(['------------ wrote ',bdy_combo_file,' ------------']);
%%%%%%%%%%%%%%%%%%%%%   END OF BOUNDARY  %%%%%%%%%%%%%%%%%%%%%%%%%%
