subroutine SwanReadGrid ( basenm, lenfnm )
!
!   --|-----------------------------------------------------------|--
!     | Delft University of Technology                            |
!     | Faculty of Civil Engineering and Geosciences              |
!     | Environmental Fluid Mechanics Section                     |
!     | P.O. Box 5048, 2600 GA  Delft, The Netherlands            |
!     |                                                           |
!     | Programmer: Marcel Zijlema                                |
!   --|-----------------------------------------------------------|--
!
!
!     SWAN (Simulating WAves Nearshore); a third generation wave model
!     Copyright (C) 1993-2017  Delft University of Technology
!
!     This program is free software; you can redistribute it and/or
!     modify it under the terms of the GNU General Public License as
!     published by the Free Software Foundation; either version 2 of
!     the License, or (at your option) any later version.
!
!     This program is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
!     GNU General Public License for more details.
!
!     A copy of the GNU General Public License is available at
!     http://www.gnu.org/copyleft/gpl.html#SEC3
!     or by writing to the Free Software Foundation, Inc.,
!     59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
!
!
!   Authors
!
!   40.80: Marcel Zijlema
!
!   Updates
!
!   40.80, July 2007: New subroutine
!
!   Purpose
!
!   Reads unstructured grid generated by a grid generator
!
!   Method
!
!   Reads data from either ADCIRC, Triangle or Easymesh
!
!   Modules used
!
    use ocpcomm4
    use SwanGriddata
!
    implicit none
!
!   Argument variables
!
    integer, intent(in)           :: lenfnm ! length of file names
    character(lenfnm), intent(in) :: basenm ! base name of unstructured grid files
!
!   Local variables
!
    integer, save :: ient = 0 ! number of entries in this subroutine
!
!   Structure
!
!   Description of the pseudo code
!
!   Source text
!
    if (ltrace) call strace (ient,'SwanReadGrid')
    !
    if ( grid_generator == meth_adcirc ) then
       !
       ! grid is given in ADCIRC grid file (fort.14)
       !
       call SwanReadADCGrid
       !
    elseif ( grid_generator == meth_triangle ) then
       !
       ! grid is generated by Triangle
       !
       call SwanReadTriangleGrid ( basenm, lenfnm )
       !
    elseif ( grid_generator == meth_easy ) then
       !
       ! grid is generated by Easymesh
       !
       call SwanReadEasymeshGrid ( basenm, lenfnm )
       !
    else
       !
       call msgerr ( 4, 'Unknown grid generator' )
       return
       !
    endif
    !
end subroutine SwanReadGrid
