/*
** svn $Id: red_tide_def.h 859 2017-08-02 01:45:30Z arango $
*************************************************** Hernan G. Arango ***
** Copyright (c) 2002-2018 The ROMS/TOMS Group                        **
**   Licensed under a MIT/X style license                             **
**   See License_ROMS.txt                                             **
************************************************************************
**                                                                    **
**  Defines red tide (Stock et al., 2005; He et al., 2008) biological **
**  model input  parameters in  output  NetCDF files.  It is included **
**  in routine "def_info.F".                                          **
**                                                                    **
************************************************************************
*/

!
!  Define red tide (Stock et al., 2005; He et al., 2008) biological
!  model parameters.
!
      Vinfo( 1)='BioIter'
      Vinfo( 2)='number of iterations to achieve convergence'
      status=def_var(ng, model, ncid, varid, nf90_int,                  &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='Gmax'
      Vinfo( 2)='maximum grow rate at optimal T/S'
      Vinfo( 3)='day-1'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='Dg'
      Vinfo( 2)='depth of sediment for cysts germination'
      Vinfo( 3)='meter'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='Kn'
      Vinfo( 2)='half-saturation for nutrient limited growth'
      Vinfo( 3)='millimole meter-3'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='G_eff'
      Vinfo( 2)='growth efficiency'
      Vinfo( 3)='meter2 watt-1 day-1'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='G_r'
      Vinfo( 2)='maintanenance respiration rate'
      Vinfo( 3)='day-1'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='AttW'
      Vinfo( 2)='mean light diffuse attenuation in water column'
      Vinfo( 3)='meter-1'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='AttS'
      Vinfo( 2)='mean light diffuse attenuation in sediment'
      Vinfo( 3)='meter-1'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='E_light'
      Vinfo( 2)='light level for germination under light conditions'
      Vinfo( 3)='watt meter-2'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='E_dark'
      Vinfo( 2)='light level for germination under dark conditions'
      Vinfo( 3)='watt meter-2'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='Tmin_growth'
      Vinfo( 2)='coldest temperature used in growth factor cubic ' //   &
     &          'polynomial term'
      Vinfo( 3)='Celsius'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='DIN_Cdepth'
      Vinfo( 2)='Dissolved Inorganic Nutrient concentration below ' //  &
     &          'of growth critical depth'
      Vinfo( 3)='millimole meter-3'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='wDino'
      Vinfo( 2)='Dinoflagellate swimming/migration rate'
      Vinfo( 3)='meter day-1'
          Vinfo(11)='downward motion, sinking'
          Vinfo(12)='upward motion, swimming'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='Mor_a'
      Vinfo( 2)='Mortality rate equation, Q10 amplitude term'
      Vinfo( 3)='day-1'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='Mor_b'
      Vinfo( 2)='Mortality rate equation, Q10 intercept term'
      Vinfo( 3)='day-1'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='Mor_Q10'
      Vinfo( 2)='Mortality rate equation, Q10 reaction rate base'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN

      Vinfo( 1)='Mor_T0'
      Vinfo( 2)='Mortality rate equation, Q10 background temperature'
      Vinfo( 3)='Celsius'
      status=def_var(ng, model, ncid, varid, NF_TYPE,                   &
     &               1, (/0/), Aval, Vinfo, ncname,                     &
     &               SetParAccess = .FALSE.)
      IF (FoundError(exit_flag, NoError, __LINE__,                      &
     &               __FILE__)) RETURN
