# Script to shape and save the final matrices from the models for coexistence computing
# BOTH YEARS TOGETHER

### CONTROL ###
#results from model5 --- I use this one by default
lambda_control <- as.vector(t(read.table(file = "M5_lambda_control.txt", header = TRUE, sep = "\t")))
alpha_control <- read.table(file = "M5_alpha_control.txt", header = TRUE, sep = "\t")
theta_control <- as.vector(t(read.table(file = "M5_theta_control.txt", header = TRUE, sep = "\t")))
omega_control <- as.vector(t(read.table(file = "M5_omega_control.txt", header = TRUE, sep = "\t")))

#making a 8x8 matrix out of the vector omega_control (repeated value for all species)
omega_control <- rep(omega_control, 8)
omega_control <- as.data.frame(matrix(omega_control, 8, 8))
colnames(omega_control) <- names(alpha_control)
rownames(omega_control) <- names(alpha_control)


### NITROGEN ###
#results from model5 --- I use this one by default
lambda_nitrogen <- as.vector(t(read.table(file = "M5_lambda_nitrogen.txt", header = TRUE, sep = "\t")))
alpha_nitrogen <- read.table(file = "M5_alpha_nitrogen.txt", header = TRUE, sep = "\t")
theta_nitrogen <- as.vector(t(read.table(file = "M5_theta_nitrogen.txt", header = TRUE, sep = "\t")))
omega_nitrogen <- as.vector(t(read.table(file = "M5_omega_nitrogen.txt", header = TRUE, sep = "\t")))

#making a 8x8 matrix out of the vector omega_nitrogen (repeated value for all species)
omega_nitrogen <- rep(omega_nitrogen, 8)
omega_nitrogen <- as.data.frame(matrix(omega_nitrogen, 8, 8))
colnames(omega_nitrogen) <- names(alpha_nitrogen)
rownames(omega_nitrogen) <- names(alpha_nitrogen)


### FUNGICIDE ###
#results from model5 --- I use this one by default
lambda_fungicide <- as.vector(t(read.table(file = "M5_lambda_fungicide.txt", header = TRUE, sep = "\t")))
alpha_fungicide <- read.table(file = "M5_alpha_fungicide.txt", header = TRUE, sep = "\t")
theta_fungicide <- as.vector(t(read.table(file = "M5_theta_fungicide.txt", header = TRUE, sep = "\t")))
omega_fungicide <- as.vector(t(read.table(file = "M5_omega_fungicide.txt", header = TRUE, sep = "\t")))

#making a 8x8 matrix out of the vector omega_fungicide (repeated value for all species)
omega_fungicide <- rep(omega_fungicide, 8)
omega_fungicide <- as.data.frame(matrix(omega_fungicide, 8, 8))
colnames(omega_fungicide) <- names(alpha_fungicide)
rownames(omega_fungicide) <- names(alpha_fungicide)


### COMBINED ###
#results from model5 --- I use this one by default
lambda_combined <- as.vector(t(read.table(file = "M5_lambda_combined.txt", header = TRUE, sep = "\t")))
alpha_combined <- read.table(file = "M5_alpha_combined.txt", header = TRUE, sep = "\t")
theta_combined <- as.vector(t(read.table(file = "M5_theta_combined.txt", header = TRUE, sep = "\t")))
omega_combined <- as.vector(t(read.table(file = "M5_omega_combined.txt", header = TRUE, sep = "\t")))

#making a 8x8 matrix out of the vector omega_combined (repeated value for all species)
omega_combined <- rep(omega_combined, 8)
omega_combined <- as.data.frame(matrix(omega_combined, 8, 8))
colnames(omega_combined) <- names(alpha_combined)
rownames(omega_combined) <- names(alpha_combined)


## SHAPE ALL MATRICES INTO DATAFRAMES AND SAVE
lambda_control <- data.frame(lambda_control)
rownames(lambda_control) <- names(alpha_control)
theta_control <- data.frame(theta_control)
rownames(theta_control) <- names(alpha_control)
write.table(lambda_control, file = "lambda_control.txt", row.names = TRUE, sep = "\t")
write.table(alpha_control, file = "alpha_control.txt", row.names = TRUE, sep = "\t")
write.table(omega_control, file = "omega_control.txt", row.names = TRUE, sep = "\t")
write.table(theta_control, file = "theta_control.txt", row.names = TRUE, sep = "\t")

lambda_nitrogen <- data.frame(lambda_nitrogen)
rownames(lambda_nitrogen) <- names(alpha_nitrogen)
theta_nitrogen <- data.frame(theta_nitrogen)
rownames(theta_nitrogen) <- names(alpha_nitrogen)
write.table(lambda_nitrogen, file = "lambda_nitrogen.txt", row.names = TRUE, sep = "\t")
write.table(alpha_nitrogen, file = "alpha_nitrogen.txt", row.names = TRUE, sep = "\t")
write.table(omega_nitrogen, file = "omega_nitrogen.txt", row.names = TRUE, sep = "\t")
write.table(theta_nitrogen, file = "theta_nitrogen.txt", row.names = TRUE, sep = "\t")

lambda_fungicide <- data.frame(lambda_fungicide)
rownames(lambda_fungicide) <- names(alpha_fungicide)
theta_fungicide <- data.frame(theta_fungicide)
rownames(theta_fungicide) <- names(alpha_fungicide)
write.table(lambda_fungicide, file = "lambda_fungicide.txt", row.names = TRUE, sep = "\t")
write.table(alpha_fungicide, file = "alpha_fungicide.txt", row.names = TRUE, sep = "\t")
write.table(omega_fungicide, file = "omega_fungicide.txt", row.names = TRUE, sep = "\t")
write.table(theta_fungicide, file = "theta_fungicide.txt", row.names = TRUE, sep = "\t")

lambda_combined <- data.frame(lambda_combined)
rownames(lambda_combined) <- names(alpha_combined)
theta_combined <- data.frame(theta_combined)
rownames(theta_combined) <- names(alpha_combined)
write.table(lambda_combined, file = "lambda_combined.txt", row.names = TRUE, sep = "\t")
write.table(alpha_combined, file = "alpha_combined.txt", row.names = TRUE, sep = "\t")
write.table(omega_combined, file = "omega_combined.txt", row.names = TRUE, sep = "\t")
write.table(theta_combined, file = "theta_combined.txt", row.names = TRUE, sep = "\t")

#remove everything except for the sixteen matrices
rm(list = ls()[!(ls() %in% c("lambda_control", "alpha_control", "theta_control", "omega_control",
                             "lambda_nitrogen", "alpha_nitrogen", "theta_nitrogen", "omega_nitrogen",
                             "lambda_fungicide", "alpha_fungicide", "theta_fungicide", "omega_fungicide",
                             "lambda_combined", "alpha_combined", "theta_combined", "omega_combined"))]) #clear environment

#and save them as an R image
save.image(file = "matrices.RData") #saved!
rm(list = ls())

#end of the script