## BOTH YEARS TOGETHER
# selecting the coefficients based on the best model and adding the size effect when needed

library(data.table)


### CONTROL

aic <- fread("AIC_control.txt"); aic$model <- aic$model - 3
spp <- unique(aic$species)

#which model for each species
selected <- NULL
for (i in 1:length(spp)){
  selected <- c(selected, aic$model[which(aic$AIC_Burnham_Anderson == min(aic$AIC_Burnham_Anderson[which(aic$species == spp[i])]))])
}

l <- list(as.vector(t(read.table(file = "M4_lambda_control.txt", header = TRUE, sep = "\t"))),
               as.vector(t(read.table(file = "M5_lambda_control.txt", header = TRUE, sep = "\t"))),
               as.vector(t(read.table(file = "M6_lambda_control.txt", header = TRUE, sep = "\t"))))

a <- list(read.table(file = "M4_alpha_control.txt", header = TRUE, sep = "\t"),
              read.table(file = "M5_alpha_control.txt", header = TRUE, sep = "\t"),
              read.table(file = "M6_alpha_control.txt", header = TRUE, sep = "\t"))

t <- list(rep(1, length(spp)), #needs to be one because lambda * theta
              as.vector(t(read.table(file = "M5_theta_control.txt", header = TRUE, sep = "\t"))),
              as.vector(t(read.table(file = "M6_theta_control.txt", header = TRUE, sep = "\t"))))

o <- list(matrix(0, length(spp), length(spp)), #needs to be zero because alpha + omega
              as.vector(t(read.table(file = "M5_omega_control.txt", header = TRUE, sep = "\t"))),
              read.table(file = "M6_omega_control.txt", header = TRUE, sep = "\t"))
o[[2]] <- as.data.frame(matrix(rep(o[[2]], length(spp)), length(spp), length(spp))) #un apaño

#create alpha and lambda objects based on the best selected model
alpha <- matrix(NA, nrow = length(spp), ncol = length(spp)); colnames(alpha) <- spp; rownames(alpha) <- spp
lambda <- rep(NA, length(spp)); names(lambda) <- spp

#loop to integrate the size effects (when needed)
for (i in 1:length(spp)){
  alpha[i,] <- a[[selected[i]]][,i] + o[[selected[i]]][,i]
  lambda[i] <- l[[selected[i]]][i] * (1 + t[[selected[i]]][i])
}

#name them accordingly
alpha_control <- data.frame(alpha)
lambda_control <- data.frame(lambda)



### NITROGEN

aic <- fread("AIC_nitrogen.txt"); aic$model <- aic$model - 3
spp <- unique(aic$species)

#which model for each species
selected <- NULL
for (i in 1:length(spp)){
  selected <- c(selected, aic$model[which(aic$AIC_Burnham_Anderson == min(aic$AIC_Burnham_Anderson[which(aic$species == spp[i])]))])
}

l <- list(as.vector(t(read.table(file = "M4_lambda_nitrogen.txt", header = TRUE, sep = "\t"))),
          as.vector(t(read.table(file = "M5_lambda_nitrogen.txt", header = TRUE, sep = "\t"))),
          as.vector(t(read.table(file = "M6_lambda_nitrogen.txt", header = TRUE, sep = "\t"))))

a <- list(read.table(file = "M4_alpha_nitrogen.txt", header = TRUE, sep = "\t"),
          read.table(file = "M5_alpha_nitrogen.txt", header = TRUE, sep = "\t"),
          read.table(file = "M6_alpha_nitrogen.txt", header = TRUE, sep = "\t"))

t <- list(rep(1, length(spp)), #needs to be one because lambda * theta
          as.vector(t(read.table(file = "M5_theta_nitrogen.txt", header = TRUE, sep = "\t"))),
          as.vector(t(read.table(file = "M6_theta_nitrogen.txt", header = TRUE, sep = "\t"))))

o <- list(matrix(0, length(spp), length(spp)), #needs to be zero because alpha + omega
          as.vector(t(read.table(file = "M5_omega_nitrogen.txt", header = TRUE, sep = "\t"))),
          read.table(file = "M6_omega_nitrogen.txt", header = TRUE, sep = "\t"))
o[[2]] <- as.data.frame(matrix(rep(o[[2]], length(spp)), length(spp), length(spp))) #un apaño

#create alpha and lambda objects based on the best selected model
alpha <- matrix(NA, nrow = length(spp), ncol = length(spp)); colnames(alpha) <- spp; rownames(alpha) <- spp
lambda <- rep(NA, length(spp)); names(lambda) <- spp

#loop to integrate the size effects (when needed)
for (i in 1:length(spp)){
  alpha[i,] <- a[[selected[i]]][,i] + o[[selected[i]]][,i]
  lambda[i] <- l[[selected[i]]][i] * (1 + t[[selected[i]]][i])
}

#name them accordingly
alpha_nitrogen <- data.frame(alpha)
lambda_nitrogen <- data.frame(lambda)



### FUNGICIDE

aic <- fread("AIC_fungicide.txt"); aic$model <- aic$model - 3
spp <- unique(aic$species)

#which model for each species
selected <- NULL
for (i in 1:length(spp)){
  selected <- c(selected, aic$model[which(aic$AIC_Burnham_Anderson == min(aic$AIC_Burnham_Anderson[which(aic$species == spp[i])]))])
}

l <- list(as.vector(t(read.table(file = "M4_lambda_fungicide.txt", header = TRUE, sep = "\t"))),
          as.vector(t(read.table(file = "M5_lambda_fungicide.txt", header = TRUE, sep = "\t"))),
          as.vector(t(read.table(file = "M6_lambda_fungicide.txt", header = TRUE, sep = "\t"))))

a <- list(read.table(file = "M4_alpha_fungicide.txt", header = TRUE, sep = "\t"),
          read.table(file = "M5_alpha_fungicide.txt", header = TRUE, sep = "\t"),
          read.table(file = "M6_alpha_fungicide.txt", header = TRUE, sep = "\t"))

t <- list(rep(1, length(spp)), #needs to be one because lambda * theta
          as.vector(t(read.table(file = "M5_theta_fungicide.txt", header = TRUE, sep = "\t"))),
          as.vector(t(read.table(file = "M6_theta_fungicide.txt", header = TRUE, sep = "\t"))))

o <- list(matrix(0, length(spp), length(spp)), #needs to be zero because alpha + omega
          as.vector(t(read.table(file = "M5_omega_fungicide.txt", header = TRUE, sep = "\t"))),
          read.table(file = "M6_omega_fungicide.txt", header = TRUE, sep = "\t"))
o[[2]] <- as.data.frame(matrix(rep(o[[2]], length(spp)), length(spp), length(spp))) #un apaño

#create alpha and lambda objects based on the best selected model
alpha <- matrix(NA, nrow = length(spp), ncol = length(spp)); colnames(alpha) <- spp; rownames(alpha) <- spp
lambda <- rep(NA, length(spp)); names(lambda) <- spp

#loop to integrate the size effects (when needed)
for (i in 1:length(spp)){
  alpha[i,] <- a[[selected[i]]][,i] + o[[selected[i]]][,i]
  lambda[i] <- l[[selected[i]]][i] * (1 + t[[selected[i]]][i])
}

#name them accordingly
alpha_fungicide <- data.frame(alpha)
lambda_fungicide <- data.frame(lambda)



### COMBINED

aic <- fread("AIC_combined.txt"); aic$model <- aic$model - 3
spp <- unique(aic$species)

#which model for each species
selected <- NULL
for (i in 1:length(spp)){
  selected <- c(selected, aic$model[which(aic$AIC_Burnham_Anderson == min(aic$AIC_Burnham_Anderson[which(aic$species == spp[i])]))])
}

l <- list(as.vector(t(read.table(file = "M4_lambda_combined.txt", header = TRUE, sep = "\t"))),
          as.vector(t(read.table(file = "M5_lambda_combined.txt", header = TRUE, sep = "\t"))),
          as.vector(t(read.table(file = "M6_lambda_combined.txt", header = TRUE, sep = "\t"))))

a <- list(read.table(file = "M4_alpha_combined.txt", header = TRUE, sep = "\t"),
          read.table(file = "M5_alpha_combined.txt", header = TRUE, sep = "\t"),
          read.table(file = "M6_alpha_combined.txt", header = TRUE, sep = "\t"))

t <- list(rep(1, length(spp)), #needs to be one because lambda * theta
          as.vector(t(read.table(file = "M5_theta_combined.txt", header = TRUE, sep = "\t"))),
          as.vector(t(read.table(file = "M6_theta_combined.txt", header = TRUE, sep = "\t"))))

o <- list(matrix(0, length(spp), length(spp)), #needs to be zero because alpha + omega
          as.vector(t(read.table(file = "M5_omega_combined.txt", header = TRUE, sep = "\t"))),
          read.table(file = "M6_omega_combined.txt", header = TRUE, sep = "\t"))
o[[2]] <- as.data.frame(matrix(rep(o[[2]], length(spp)), length(spp), length(spp))) #un apaño

#create alpha and lambda objects based on the best selected model
alpha <- matrix(NA, nrow = length(spp), ncol = length(spp)); colnames(alpha) <- spp; rownames(alpha) <- spp
lambda <- rep(NA, length(spp)); names(lambda) <- spp

#loop to integrate the size effects (when needed)
for (i in 1:length(spp)){
  alpha[i,] <- a[[selected[i]]][,i] + o[[selected[i]]][,i]
  lambda[i] <- l[[selected[i]]][i] * (1 + t[[selected[i]]][i])
}

#name them accordingly
alpha_combined <- data.frame(alpha)
lambda_combined <- data.frame(lambda)

rm(list=ls()[! ls() %in% c("alpha_control", "alpha_nitrogen",
                           "alpha_fungicide", "alpha_combined",
                           "lambda_control", "lambda_nitrogen",
                           "lambda_fungicide", "lambda_combined")])

save.image(file = "matrices_NewPhytol.RData")

#done