# -*- coding: utf-8 -*-
"""
Created on Sat Jan 16 14:10:32 2021

@author: Kjeld
"""

import matplotlib.pyplot as plt
import numpy as np
from matplotlib import ticker

time = np.linspace(0,(8)*3600,(8)*3600)
Tir = 3*3600
Ttr = 900
Tin = 3*3600

isomer = np.logspace(0,4,100)
popprob = np.linspace(0.14,0.93,100)
totphot = np.zeros((np.size(popprob),np.size(isomer)))

NRa228 = 10**15*np.ones(np.size(time))
NRa229 = np.zeros(np.size(time))
NAc229 = np.zeros(np.size(time))
NTh229 = np.zeros((np.size(time),np.size(isomer)))
NThm229 = np.zeros((np.size(time),np.size(isomer)))


labmdaRa226 = np.log(2)/1600/3600/24/365.25
lambdaRa228 = np.log(2)/5.75/3600/24/365.25
lambdaRa229 = np.log(2)/4/60
lambdaAc229 = np.log(2)/62.7/60
lambdaTh229 = np.log(2)/7917/3600/24/365.25
lambdaisomer = np.log(2)/1800

for i in range(np.size(time)-1):
    if i<Tir:
        NRa229[i+1] = (1-lambdaRa229)*NRa229[i]+3.6*10**-10*NRa228[i]
        NRa228[i+1] = (1-lambdaRa228)*NRa228[i]-NRa229[i]
    if i>=Tir: 
        NRa229[i+1] = (1-lambdaRa229)*NRa229[i]
        NRa228[i+1] = (1-lambdaRa228)*NRa228[i]
    
    NAc229[i+1] = (1-lambdaAc229)*NAc229[i]+lambdaRa229*NRa229[i]
    
    for k in range(np.size(isomer)):
        NThm229[i+1,k] = (1-lambdaTh229-np.log(2)/isomer[k])*NThm229[i,k]+lambdaAc229*NAc229[i]
        NTh229[i+1,k] = (1-lambdaTh229)*NTh229[i,k]+np.log(2)/isomer[k]*NThm229[i,k]+0.07*lambdaAc229*NAc229[i]
    
for i in range(np.size(isomer)):
    for j in range(np.size(popprob)):
        totphot[j,i] =  np.sum(np.log(2)/isomer[i]*NThm229[int(Tir+Ttr):int(Tin+Tir+Ttr),i]*popprob[j])
        
 
plt.figure(1)        
plt.semilogy(time/3600,NRa228,time/3600,NAc229,time/3600,0.93*NThm229[:,44],time/3600,0.93*NThm229[:,96],time/3600,NTh229[:,44],time/3600,NRa229)
plt.axis([0, 8, 1, 10**17])
plt.axvspan(0, Tir/3600, facecolor='purple', alpha=0.4)
plt.axvspan(Tir/3600, (Tir+Ttr)/3600, facecolor='purple', alpha=0.2)
plt.axvspan((Tir+Ttr)/3600, (Tir+Ttr+Tin)/3600, facecolor='yellow', alpha=0.3)
plt.title('Activation of Ra228')
plt.xlabel('Time ($h$)')
plt.ylabel('concentration ($cm^{-3}$)')
plt.legend(['$^{228}Ra$','$^{229}Ac$','$^{229m}Th$ 1 min','$^{229m}Th$ 2 hrs','$^{229}Th$ 2 hrs','$^{229}Ra$','Activate','Transfer','Measure'])
plt.savefig('Isotope abundance over time.png',dpi = 300)

plt.figure(2)
plt.semilogy(time/3600,lambdaRa228*NRa228*4,time/3600,lambdaRa229*NRa229+lambdaAc229*NAc229,time/3600,np.log(2)/isomer[91]*NThm229[:,91]*0.14,time/3600,np.log(2)/isomer[91]*NThm229[:,91]*0.93)
plt.axis([0, 8, 1, 10**8])
plt.axvspan(0, Tir/3600, facecolor='purple', alpha=0.4)
plt.axvspan(Tir/3600, (Tir+Ttr)/3600, facecolor='purple', alpha=0.2)
plt.axvspan((Tir+Ttr)/3600, (Tir+Ttr+Tin)/3600, facecolor='yellow', alpha=0.3)
plt.title('Beta decays and isomer photons per second (isomer lifetime = 2 hrs)')
plt.xlabel('Time ($h$)')
plt.ylabel('Rate ($s^{-1}$)')
plt.legend(['Beta decays $^{228}Ra$','Beta decays activation','Isomer photons (14%)','Isomer photons (93%)','Activate','Transfer','Measure'])
plt.savefig('Rates over time.png',dpi = 300)

plt.figure(3)
plt.contourf(isomer,popprob,totphot/Tin*3*10**-4)#,locator=ticker.LogLocator())
plt.xscale('log')
plt.title('Average photons per second on detector')
plt.xlabel('Lifetime ($s$)')
plt.ylabel('Population probability (%)')
plt.colorbar()
plt.savefig('totalphotons.png',dpi = 300)

plt.figure(4)
plt.contourf(isomer,popprob,totphot*3*10**-4/np.sqrt(totphot*3*10**-4+0.5*np.sum(lambdaRa228*NRa228[int(Tir+Ttr):int(Tin+Tir+Ttr)]*4 + lambdaRa229*NRa229[int(Tir+Ttr):int(Tin+Tir+Ttr)]+lambdaAc229*NAc229[int(Tir+Ttr):int(Tin+Tir+Ttr)])*3*10**-4))#,locator=ticker.LogLocator())
plt.xscale('log')
plt.title('Signal to Noise Ratio')
plt.xlabel('Lifetime ($s$)')
plt.ylabel('Population probability (%)')
plt.colorbar()
plt.savefig('SNR.png',dpi = 300)
