# -*- coding: utf-8 -*-
"""
Created on Thu Jun 24 14:17:28 2021

@author: kjeld
"""
import matplotlib.pyplot as plt
from matplotlib import rcParams as pltrc
def getWaveLength(energy):
    return (1240)/(energy)


pltrc["figure.figsize"] = (8, 6)

import pandas as pd
import numpy as np

from scipy import optimize as opti

import analysis as ana

refall = ana.MonoSF("2021-08-23_bandgapedge_ref.txt")
ref = refall.consolidate_data().values
refb = 9
refw = refall.wls.values
refl = "Open hole"

ref2all = ana.MonoSF("2021-08-23_bandgapedge2_ref.txt")
ref2 = ref2all.consolidate_data().values
ref2b = 9
ref2w = ref2all.wls.values
ref2l = "Open hole 2"

C13Tall = ana.MonoSF("2021-08-23_bandgapedge_C13top.txt")
C13T = C13Tall.consolidate_data().values
C13Tb = np.mean(C13T[0:2,0])
C13Tw = C13Tall.wls.values
C13Tt = 100*(C13T[:,0]-C13Tb)/(ref[:,0]-refb)
C13Te = 100*(C13T[:,1]/ref[:,0]+ref[:,1]*C13T[:,0]/ref[:,0]**2)
C13Tl = "$^{229}$Th:CaF$_2$  1.0$\cdot$10$^{18}$ cm$^{-3}$ 1.8 mm"# C13 Top 229 doped  prec"

Cal3all = ana.MonoSF("2021-08-23_bandgapedge_Cal3top.txt")
Cal3 = Cal3all.consolidate_data().values
Cal3b = np.mean(Cal3[0:2,0])
Cal3w = Cal3all.wls.values
Cal3t = 100*(Cal3[:,0]-Cal3b)/(ref[:,0]-refb)
Cal3e = 100*(Cal3[:,1]/ref[:,0]+ref[:,1]*Cal3[:,0]/ref[:,0]**2)
Cal3l = "$^{232}$Th:CaF$_2$  1.0$\cdot$10$^{17}$ cm$^{-3}$ 2.0 mm"#Cal3 Top 232 doped   prec"

V9all = ana.MonoSF("2021-08-23_bandgapedge_V9top.txt")
V9 = V9all.consolidate_data().values
V9b = np.mean(V9[0:2,0])
V9w = V9all.wls.values
V9t = 100*(V9[:,0]-V9b)/(ref[:,0]-refb)
V9e = 100*(V9[:,1]/ref[:,0]+ref[:,1]*V9[:,0]/ref[:,0]**2)
V9l = "$^{232}$Th:CaF$_2$ 4.0$\cdot 10^{19}$ cm$^{-3}$ 1.7 mm"#V9 Top 232 doped  mix"

Wall = ana.MonoSF("2021-08-23_bandgapedge_window.txt")
W = Wall.consolidate_data().values
Wb = np.mean(W[0:2,0])
Ww = Wall.wls.values
Wt = 100*(W[:,0]-Wb)/(ref[:,0]-refb)
We = 100*(W[:,1]/ref[:,0]+ref[:,1]*W[:,0]/ref[:,0]**2)
Wl = "CaF$_2$ VUV window 5.0 mm" #5 mm RAMAN

C132all = ana.MonoSF("2021-08-23_bandgapedge2_C13_2.txt")
C132 = C132all.consolidate_data().values
C132b = np.mean(C132[0:2,0])
C132w = C132all.wls.values
C132t = 100*(C132[:,0]-C132b)/(ref2[:,0]-ref2b)
C132e = 100*(C132[:,1]/ref2[:,0]+ref2[:,1]*C132[:,0]/ref2[:,0]**2)
C132l = "$^{229}$Th:CaF$_2$ 5.4$\cdot 10^{17}$ cm$^{-3}$ 0.85 mm"#C13_2 229 doped  prec"

C13botall = ana.MonoSF("2021-08-23_bandgapedge2_C13bot.txt")
C13bot = C13botall.consolidate_data().values
C13botb = np.mean(C13bot[0:2,0])
C13botw = C13botall.wls.values
C13bott = 100*(C13bot[:,0]-C13botb)/(ref2[:,0]-ref2b)
C13bote = 100*(C13bot[:,1]/ref2[:,0]+ref2[:,1]*C13bot[:,0]/ref2[:,0]**2)
C13botl = "$^{229}$Th:CaF$_2$ 5.8$\cdot 10^{16}$ cm$^{-3}$ 0.9 mm"# C13_bot 229 undoped " prec"

Cal32all = ana.MonoSF("2021-08-23_bandgapedge2_Cal3top.txt")
Cal32 = Cal32all.consolidate_data().values
Cal32b = np.mean(Cal32[0:2,0])
Cal32w = Cal32all.wls.values
Cal32t = 100*(Cal32[:,0]-Cal32b)/(ref2[:,0]-ref2b)
Cal32e = 100*(Cal32[:,1]/ref2[:,0]+ref2[:,1]*Cal32[:,0]/ref2[:,0]**2)
Cal32l = "$^{232}$Th:CaF$_2$ 1.0$\cdot$10$^{17}$ cm$^{-3}$ 2.0 mm"#Cal3 Top 232 doped  prec V2"

t_list = [Wt, C13bott, C132t, C13Tt, Cal3t, Cal32t, V9t]
l_list = [Wl, C13botl, C132l, C13Tl, Cal3l, Cal32l, V9l]
e_list = [We, C13bote, C132e, C13Te, Cal3e, Cal32e, V9e]
c_list = ["royalblue", "lightcoral", "indianred", "brown", "palegreen", "lightgreen", "darkgreen"]
#ls_list = ["--", ":", "-.", (0, (4, 2, 8, 2)) ]

plt.figure(figsize=(10, 5))

for i, n, e, clr in zip(t_list, l_list, e_list, c_list):
    plt.errorbar(refw, i, e,
        label=n, color = clr, linewidth=3, capsize=3, elinewidth=1, capthick=1,
        #ls=k
    )

plt.legend(prop={'size': 11},loc='upper center',bbox_to_anchor=(0.5, 1.4),ncol=2, fancybox=True, shadow=True)
# plt.title("Transmission")
plt.xlabel("Wavelength [nm]")
plt.ylabel("Transmission [%]")
plt.axis([120,140,0.1,100])
plt.minorticks_on()
plt.grid()
#plt.yscale("log")
plt.savefig("Bandgapedge_transmissions.pdf",bbox_inches='tight',dpi=400)
plt.show()

Wa = -np.log(Wt/100)/5
C13bota = -np.log(C13bott/100)/0.9
C132a = -np.log(C132t/100)/0.85
C13Ta = -np.log(C13Tt/100)/1.8
Cal3a = -np.log(Cal3t/100)/2
Cal32a = -np.log(Cal32t/100)/2
V9a = -np.log(V9t/100)/1.7

t_list = [Wt, C13bott, C132t, Cal32t, V9t]
l_list = [Wl, C13botl, C132l, Cal32l, V9l]
e_list = [We, C13bote, C132e, Cal32e, V9e]
c_list = ["royalblue", "lightcoral", "indianred", "lightgreen", "darkgreen"]

absco_list = [Wa, C13bota, C132a, Cal32a, V9a]
d_list = [5,0.9,0.85,2,1.7]

plt.figure(figsize=(10, 5))

for i, n, j, d, e, clr in zip(absco_list, l_list, t_list, d_list, e_list, c_list):
    plt.errorbar(1240/refw, i, e/j/d,
        label=n, color = clr,linewidth=3, capsize=3, elinewidth=1, capthick=1,
        #ls=k
    )

plt.errorbar(1240/refw[15:61], C13Ta[15:61], C13Te[15:61]/We[15:61]/C13Tt[15:61]/1.8, label=C13Tl, color='brown', linewidth=3, capsize=3, elinewidth=1, capthick=1)

plt.legend(prop={'size': 11},ncol=2, fancybox=True, shadow=True)
# plt.title("Transmission")
plt.xlabel("Energy [eV]")
plt.ylabel("Absorption [mm$^{-1}$]")
plt.yscale("log")
plt.axis([8.3,10.12,0.05,17])
plt.minorticks_on()
plt.grid()
left,right = plt.xlim()
xtickloc,labels = plt.xticks() 
ax2 = plt.twiny()


# set the second axis ticks to the same locations
ax2.set_xticks(xtickloc)
# calculate new values for the second axis tick labels, format them, and set them
x2labels = ['{:.3g}'.format(x) for x in getWaveLength(xtickloc)]
ax2.set_xticklabels(x2labels)
# force the bounds to be the same
ax2.set_xlim([left,right]) 
ax2.set_xlabel('Wavelength (nm)')
plt.rcParams.update({'font.size': 16})
plt.savefig("Bandgapedge_absco.pdf",bbox_inches='tight',dpi=400)
plt.show()


C13bota = -np.log(C13bott/Wt)/0.9
C132a = -np.log(C132t/Wt)/0.85
C13Ta = -np.log(C13Tt/Wt)/1.8
Cal3a = -np.log(Cal3t/Wt)/2
Cal32a = -np.log(Cal32t/Wt)/2
V9a = -np.log(V9t/Wt)/1.7


absco_list = [C13bota, C132a, Cal32a, V9a]
e_list = [C13bote/We, C132e/We, Cal32e/We/10, V9e/We]
l_list = [C13botl, C132l, Cal32l, V9l]
c_list = ["lightcoral", "indianred", "lightgreen", "darkgreen"]
d_list = [0.9,0.85,2,1.7]


plt.figure(figsize=(10, 5))
plt.errorbar(1240/refw[15:61], C13Ta[15:61], C13Te[15:61]/We[15:61]/C13Tt[15:61]/1.8, label=C13Tl[0:-7], color='brown', linewidth=3, capsize=3, elinewidth=1, capthick=1)

for i, n, j, d, e, clr in zip(absco_list, l_list, t_list, d_list, e_list, c_list):
    plt.errorbar(1240/refw, i, e/j/d,
        label=n[0:-7], color=clr, linewidth=3, capsize=3, elinewidth=1, capthick=1,
        #ls=k
    )
    


plt.legend(prop={'size': 13},ncol=2, fancybox=True, shadow=True)
# plt.title("Transmission")
plt.xlabel("Energy [eV]")
plt.ylabel("Relative Absorption [mm$^{-1}$]")
#plt.yscale("log")
plt.axis([1240/150,10.12,0,5])
plt.minorticks_on()
plt.grid()
left,right = plt.xlim()
xtickloc,labels = plt.xticks() 
ax2 = plt.twiny()


# set the second axis ticks to the same locations
ax2.set_xticks(xtickloc)
# calculate new values for the second axis tick labels, format them, and set them
x2labels = ['{:.3g}'.format(x) for x in getWaveLength(xtickloc)]
ax2.set_xticklabels(x2labels)
# force the bounds to be the same
ax2.set_xlim([left,right]) 
ax2.set_xlabel('Wavelength (nm)')
plt.rcParams.update({'font.size': 16})
plt.savefig("Bandgapedge_abscorel.pdf",bbox_inches='tight',dpi=400)
plt.show()