 # -*- coding: utf-8 -*-
"""
Created on Thu Jun 24 14:17:28 2021

@author: kjeld
"""
import matplotlib.pyplot as plt
from matplotlib import rcParams as pltrc
def getWaveLength(energy):
    return (1240)/(energy)


pltrc["figure.figsize"] = (8, 6)

import pandas as pd
import numpy as np

from scipy import optimize as opti

import analysis as ana

v9      = ana.MonoSF("2021-07-21_V9_top.txt")
v9_ref  = ana.MonoSF("2021-07-21_X2_top_ref.txt")
v9t = 100*ana.transmission(v9, v9_ref)
v9l = "$^{232}$Th:CaF$_2$  4.0*10$^{19}$ cm$^{-3}$ 1.7 mm"

v10     = ana.MonoSF("2021-08-09_232doped_v10.txt")
v10_ref = ana.MonoSF("2021-08-09_232doped_ref.txt")
v10t = 100*ana.transmission(v10, v10_ref)
v10l = "$^{232}$Th:CaF$_2$  4.0*10$^{19}$ cm$^{-3}$ 2.0 mm"

v11     = ana.MonoSF("2021-08-09_232doped_v11.txt")
v11_ref = ana.MonoSF("2021-08-09_232doped_ref.txt")
v11t = 100*ana.transmission(v11, v11_ref)
v11l = "$^{232}$Th:CaF$_2$  7.0*10$^{19}$ cm$^{-3}$ 1.65 mm"

v12     = ana.MonoSF("2021-08-09_232doped_v12.txt")
v12_ref = ana.MonoSF("2021-08-09_232doped_ref.txt")
v12t = 100*ana.transmission(v12, v12_ref)
v12l = "$^{232}$Th:CaF$_2$  8.0*10$^{19}$ cm$^{-3}$ 1.05 mm"

v14_ref = ana.MonoSF("2021-08-11_232doped_ref.txt")
v14 = ana.MonoSF("2021-08-11_232doped_V14_2.txt")
v14t = 100*ana.transmission(v14, v14_ref)
v14l = "$^{232}$Th:CaF$_2$  2.6*10$^{20}$ cm$^{-3}$ 1.35 mm"

v15_ref = ana.MonoSF("2021-08-11_232doped_ref.txt")
v15 = ana.MonoSF("2021-08-11_232doped_V15_2.txt")
v15t = 100*ana.transmission(v15, v15_ref)
v15l = "$^{232}$Th:CaF$_2$  9.0*10$^{19}$ cm$^{-3}$ 2.85 mm"

v15_refd = ana.MonoSF("2022-05-24_X2 round5_after12days_ref.txt")
v15d = ana.MonoSF("2022-05-24_V15.txt")
v15dwls = v15d.wls.values
v15td = 100*v15d.consolidate_data().values[:,0]/v15_refd.consolidate_data().values[:,0]
v15ld = "$^{232}$Th:CaF$_2$ damaged  9.0*10$^{19}$ cm$^{-3}$ 2.85 mm"

korth_ref = ana.MonoSF("2021-08-12_window_ref.txt")
korth = ana.MonoSF("2021-08-12_window_caf2.txt")
korth_ref.consolidate_data()
korth.consolidate_data()
korth_ref._consolidated_buffer.loc[:, "mean"] -= korth_ref._consolidated_buffer.loc[:, "mean"].min()
korth._consolidated_buffer.loc[:, "mean"] -= korth._consolidated_buffer.loc[:, "mean"].min()
kortht = 100*ana.transmission(korth, korth_ref)
korthl = "CaF$_2$ VUV window 5.0 mm"



t_list = [kortht,v9t, v10t, v11t, v12t, v15t, v14t]
l_list = [korthl,v9l, v10l, v11l, v12l, v15l, v14l]

#ls_list = ["--", ":", "-.", (0, (4, 2, 8, 2)) ]

plt.figure(figsize=(10, 5))

for i, n in zip(t_list, l_list):
    plt.errorbar(i.index, i.iloc[:, 0], i.iloc[:, 1],
        label=n,linewidth=3, capsize=3, elinewidth=1, capthick=1,
        #ls=k
    )

plt.legend(prop={'size': 13},loc='upper center',bbox_to_anchor=(0.53, 1.2),ncol=2, fancybox=True, shadow=True)
# plt.title("Transmission")
plt.xlabel("Wavelength [nm]")
plt.ylabel("Transmission [%]")
plt.axis([120,160,0,100])
plt.minorticks_on()
plt.grid()
plt.savefig("ThCaF2_transmissions.pdf",bbox_inches='tight',dpi=400)
plt.show()

v9a = -np.log(ana.transmission(v9, v9_ref))/1.7
v10a = -np.log(ana.transmission(v10, v10_ref))/2
v11a = -np.log(ana.transmission(v11, v11_ref))/1.65
v12a = -np.log(ana.transmission(v12, v12_ref))/1.05
v15a = -np.log(ana.transmission(v15, v15_ref))/2.85
v14a = -np.log(ana.transmission(v14, v14_ref))/1.35
kortha = -np.log(ana.transmission(korth, korth_ref))/5

absco_list = [v9a, v10a, v11a, v12a, v15a, v14a, kortha]
d_list = [1.7,2,1.65,1.05,2.85,1.35,5]

plt.figure(figsize=(10, 5))

for i, n, j, d in zip(absco_list, l_list, t_list, d_list):
    plt.errorbar(1240/i.index[:61], i.iloc[:61, 0], j.iloc[:61, 1]/j.iloc[:61,0]/d,
        label=n,linewidth=3, capsize=3, elinewidth=1, capthick=1,
        #ls=k
    )

plt.legend(prop={'size': 11},ncol=2, fancybox=True, shadow=True)
# plt.title("Transmission")
plt.xlabel("Energy [eV]")
plt.ylabel("Absorption [mm$^{-1}$]")
plt.yscale("log")
plt.axis([1240/160,10,0.1,30])
plt.minorticks_on()
plt.grid()
left,right = plt.xlim()
xtickloc,labels = plt.xticks() 
ax2 = plt.twiny()


# set the second axis ticks to the same locations
ax2.set_xticks(xtickloc)
# calculate new values for the second axis tick labels, format them, and set them
x2labels = ['{:.3g}'.format(x) for x in getWaveLength(xtickloc)]
ax2.set_xticklabels(x2labels)
# force the bounds to be the same
ax2.set_xlim([left,right]) 
ax2.set_xlabel('Wavelength (nm)')
plt.rcParams.update({'font.size': 16})
plt.savefig("ThCaF2_absco.pdf",bbox_inches='tight',dpi=400)
plt.show()

kortha = -np.log(ana.transmission(korth, korth_ref))/5
v9a = -np.log(ana.transmission(v9, v9_ref)/ana.transmission(korth, korth_ref))/1.7
v10a = -np.log(ana.transmission(v10, v10_ref)/ana.transmission(korth, korth_ref))/2
v11a = -np.log(ana.transmission(v11, v11_ref)/ana.transmission(korth, korth_ref))/1.65
v12a = -np.log(ana.transmission(v12, v12_ref)/ana.transmission(korth, korth_ref))/1.05
v15a = -np.log(ana.transmission(v15, v15_ref)/ana.transmission(korth, korth_ref))/2.85
v14a = -np.log(ana.transmission(v14, v14_ref)/ana.transmission(korth, korth_ref))/1.35


absco_list = [v9a, v10a, v11a, v12a, v15a, v14a]

plt.figure(figsize=(10, 5))

for i, n, j, d in zip(absco_list, l_list, t_list, d_list):
    plt.errorbar(1240/i.index[:61], i.iloc[:61, 0], j.iloc[:61,1]/(j.iloc[:61,0])/d,
        label=n[0:-7],linewidth=3, capsize=3, elinewidth=1, capthick=1,
        #ls=k
    )

plt.legend(prop={'size': 14},ncol=2, fancybox=True, shadow=True)
# plt.title("Transmission")
plt.xlabel("Energy [eV]")
plt.ylabel("Relative Absorption [mm$^{-1}$]")
#plt.yscale("log")
plt.axis([1240/160,10,0.1,7])
plt.minorticks_on()
plt.grid()
left,right = plt.xlim()
xtickloc,labels = plt.xticks() 
ax2 = plt.twiny()


# set the second axis ticks to the same locations
ax2.set_xticks(xtickloc)
# calculate new values for the second axis tick labels, format them, and set them
x2labels = ['{:.3g}'.format(x) for x in getWaveLength(xtickloc)]
ax2.set_xticklabels(x2labels)
# force the bounds to be the same
ax2.set_xlim([left,right]) 
ax2.set_xlabel('Wavelength (nm)')
plt.rcParams.update({'font.size': 16})
plt.savefig("ThCaF2_abscorel.pdf",bbox_inches='tight',dpi=400)
plt.show()