# -*- coding: utf-8 -*-
"""
Created on Tue Jan 11 16:01:45 2022

@author: Kjeld
"""
import matplotlib.pyplot as plt
from matplotlib import rcParams as pltrc
def getWaveLength(energy):
    return (1240)/(energy)


pltrc["figure.figsize"] = (8, 6)

import pandas as pd
import numpy as np



import analysis as ana

background = np.mean([7, 6, 6,5, 11, 5,13, 4, 2])


x2top      = ana.MonoSF("2021-07-21_X2_top.txt")
x2top_ref  = ana.MonoSF("2021-07-21_X2_top_ref.txt")
x2top_b = ana.MonoSF("2021-07-21_X2_top_background.txt")
x2trans = 100*(x2top.consolidate_data().values[:,0]-np.mean(x2top_b.consolidate_data().values[:,0]))/(x2top_ref.consolidate_data().values[:,0]-2)
x2err = 100*((x2top_ref.consolidate_data().values[:,1]+np.mean(x2top_b.consolidate_data().values[:,1]))/x2top_ref.consolidate_data().values[:,0]+(x2top.consolidate_data().values[:,0]/(x2top_ref.consolidate_data().values[:,0]**2))*x2top_ref.consolidate_data().values[:,1])
X2l = "$^{229}$Th:CaF$_2$  2.0*10$^{19}$ cm$^{-3}$ 3.0 mm"
wvlng = np.array(x2top.wls)

c10_5      = ana.MonoSF("2021-07-15_C10_5.txt")
c10_5_ref  = ana.MonoSF("2021-07-15_C10_5_ref.txt")
c10_5_b = np.mean([35, 16, 16,22, 20, 24,23, 27, 16])-2
c10_5_berr = np.std([35, 16, 16,22, 20, 24,23, 27, 16])
c105trans = 100*(c10_5.consolidate_data().values[:,0]-c10_5_b)/(c10_5_ref.consolidate_data().values[:,0]-2)
c105err = 100*((c10_5_ref.consolidate_data().values[:,1]+c10_5_berr)/c10_5_ref.consolidate_data().values[:,0]+(c10_5.consolidate_data().values[:,0]/(c10_5_ref.consolidate_data().values[:,0]**2))*c10_5_ref.consolidate_data().values[:,1])
c105l = "$^{229}$Th:CaF$_2$  2.0*10$^{19}$ cm$^{-3}$ 3.0 mm"


c132      = ana.MonoSF("2021-07-14_C13_2.txt")
c132_ref  = ana.MonoSF("2021-07-14_ref.txt")
c132_b = np.mean([47, 36, 42,40, 46, 44,25 ,45, 49])-2
c132_berr = np.std([47, 36, 42,40, 46, 44,25 ,45, 49])
c132trans = 100*(c132.consolidate_data().values[:,0]-c132_b)/(c132_ref.consolidate_data().values[:,0]-2)
c132err = 100*((c132_ref.consolidate_data().values[:,1]+c132_berr)/c132_ref.consolidate_data().values[:,0]+(c132.consolidate_data().values[:,0]/(c132_ref.consolidate_data().values[:,0]**2))*c132_ref.consolidate_data().values[:,1])
c132l = "$^{229}$Th:CaF$_2$  2.0*10$^{19}$ cm$^{-3}$ 3.0 mm"


c13bot      = ana.MonoSF("2021-07-14_C13_bottom.txt")
c13bot_ref  = ana.MonoSF("2021-07-14_ref.txt")
c13bot_b = 2-2
c13bot_berr = 0
c13bottrans = 100*(c13bot.consolidate_data().values[:,0]-c13bot_b)/(c13bot_ref.consolidate_data().values[:,0])
c13boterr = 100*((c13bot_ref.consolidate_data().values[:,1]+c13bot_berr)/c13bot_ref.consolidate_data().values[:,0]+(c13bot.consolidate_data().values[:,0]/(c13bot_ref.consolidate_data().values[:,0]**2))*c13bot_ref.consolidate_data().values[:,1])
c13botl = "$^{229}$Th:CaF$_2$  2.0*10$^{19}$ cm$^{-3}$ 3.0 mm"

x2u      = ana.MonoSF("2021-07-12_X2.txt")
x2u_ref  = ana.MonoSF("2021-07-12_X2_ref.txt")
x2u_b = np.mean(ana.MonoSF("2021-07-12_X2_lampoff.txt").consolidate_data().values[:,0])
x2u_berr = 0
x2utrans = 100*(x2u.consolidate_data().values[:,0]-x2u_b)/(x2u_ref.consolidate_data().values[:,0]-np.mean(x2u_ref.consolidate_data().values[-3:-1,0]))
x2unerr = 100*((x2u_ref.consolidate_data().values[:,1]+x2u_berr)/x2u_ref.consolidate_data().values[:,0]+(x2u.consolidate_data().values[:,0]/(x2u_ref.consolidate_data().values[:,0]**2))*x2u_ref.consolidate_data().values[:,1])
x2ul = "$^{229}$Th:CaF$_2$  2.0*10$^{19}$ cm$^{-3}$ 3.0 mm"

x2ua      = ana.MonoSF("2021-06-10_x2_undoped.txt")
x2ua_ref  = ana.MonoSF("2021-06-10_x2_undoped_ref.txt")
x2ua_b = background
x2ua_berr = 0
x2uatrans = 100*(x2ua.consolidate_data().values[:,0]-x2ua_b)/(x2ua_ref.consolidate_data().values[:,0]-np.mean(x2ua_ref.consolidate_data().values[-3:-1,0]))
x2uanerr = 100*((x2ua_ref.consolidate_data().values[:,1]+x2ua_berr)/x2ua_ref.consolidate_data().values[:,0]+(x2ua.consolidate_data().values[:,0]/(x2ua_ref.consolidate_data().values[:,0]**2))*x2ua_ref.consolidate_data().values[:,1])
x2ual = "$^{229}$Th:CaF$_2$  2.0*10$^{19}$ cm$^{-3}$ 3.0 mm"




plt.figure(figsize=(10, 5))
#plt.errorbar(kortht.index, kortht.iloc[:, 0],yerr= kortht.iloc[:, 1],linewidth = 3,elinewidth = 1,capsize = 2)
plt.errorbar(np.linspace(120,200,41),c105trans,yerr=c105err,linewidth = 3,elinewidth = 1,capsize = 3)
plt.errorbar(wvlng,c132trans,yerr=c132err,linewidth = 3,elinewidth = 1,capsize = 3)
plt.errorbar(wvlng,c13bottrans,yerr=c13boterr,linewidth = 3,elinewidth = 1,capsize = 3)
plt.errorbar(wvlng,x2u2trans,yerr=x2u2err,linewidth = 3,elinewidth = 1,capsize = 3)
#plt.errorbar(wvlng,x2u3trans,yerr=x2u3err,linewidth = 2,capsize = 3)
plt.xlabel('Wavelength [nm]')
plt.ylabel('Transmission [%]')
#plt.yscale('log')
#plt.legend(['c10_5 100 kBq','c13_2 300 kBq','C13_5 300 kBq','X2u_1 1 MBq','X2u_2 F annealed 1 MBq'],prop={'size': 11},ncol=2, fancybox=True, shadow=True)
plt.legend(['Pure CaF$_2$ 5 mm','$^{229}$Th:CaF$_2$ $5.4 \cdot 10^{17}$ cm$^{-3}$ 100 kBq','$^{229}$Th:CaF$_2$ $5.4 \cdot 10^{17}$ cm$^{-3}$ 300 kBq','$^{229}$Th:CaF$_2$ $5.8 \cdot 10^{16}$ cm$^{-3}$ 300 kBq','$^{229}$Th:CaF$_2$ $2.4 \cdot 10^{17}$ cm$^{-3}$ 1 MBq'],prop={'size': 11},ncol=2, fancybox=True, shadow=True)
plt.axis([120,160,0,100])
plt.minorticks_on()
plt.grid()
plt.rcParams.update({'font.size': 16})
plt.savefig('Radioactivetransmissionall3.pdf', format='pdf',bbox_inches='tight',dpi=400)

plt.figure(figsize=(10, 5))
#plt.errorbar(1240/kortht.index, -np.log(kortht.iloc[:, 0]/100)/5, yerr = kortht.iloc[:, 1],linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/np.linspace(120,200,41),-np.log(c105trans/100)/2.5,yerr=c105err/c105trans/2.5,linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(c132trans/100),yerr=c132err/c132trans,linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(c13bottrans/100),yerr=c13boterr/c13bottrans,linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(x2utrans/100)/0.5,yerr=x2unerr/x2utrans/0.5,linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(x2u3trans/100)/1.7,yerr=x2u3err/x2u3trans/1.7,linewidth=2,elinewidth=1,capsize=3)
plt.xlabel('Photon energy [eV]')
plt.ylabel('Absorption coefficient [mm$^{-1}$]')
plt.legend(['C10_5 100 kBq','C13_2 300 kBq','C13_5 300 kBq','X2u_1 1 MBq','X2u_2 F annealed'],prop={'size': 11},ncol=2, fancybox=True, shadow=True)
plt.axis([1240/160,10,0,10])
plt.grid()
plt.savefig('Radioactivetransmissionabsco3.pdf', format='pdf')

plt.figure(figsize=(10, 5))
plt.errorbar(1240/np.linspace(120,200,41),-np.log(c105trans/100)/2.5,yerr=c105err/c105trans/2.5,linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(c132trans/100),yerr=c132err/c132trans,linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(c13bottrans/100),yerr=c13boterr/c13bottrans,linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(x2utrans/100)/0.5,yerr=x2unerr/x2utrans/0.5,linewidth = 2,elinewidth = 1,capsize = 3)
#plt.errorbar(1240/wvlng,-np.log(x2u2trans/kortht.iloc[:, 0]/0.7)/1.8,yerr=x2u2err/x2u2trans/1.8,linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(x2u3trans/100)/1.4,yerr=x2u3err/x2u3trans/1.4,linewidth = 2,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(np.abs(x2u4trans/100))/0.9,yerr=x2u4err/x2u4trans/0.9,linewidth = 2,elinewidth = 1,capsize = 3)
plt.xlabel('Photon energy [eV]')
plt.ylabel('Relative absorption coefficient [mm$^{-1}$]')
plt.legend(['C10_5 100 kBq','C13_2 300 kBq','C13_5 300 kBq','X2u_1 1 MBq','X2u_2 F annealed','X2u_2 no F annealed'],prop={'size': 11},ncol=2, fancybox=True, shadow=True)
plt.axis([1240/160,10,0,15])
plt.grid()
plt.rcParams.update({'font.size': 16})
plt.savefig('Radioactivetransmissionabsco3.pdf', format='pdf',bbox_inches='tight',dpi=400)


plt.figure(figsize=(10, 5))
plt.errorbar(1240/np.linspace(120,200,41),-np.log(c105trans/100/0.7)/2.5,yerr=c105err/c105trans/2.5,linewidth = 3,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(c132trans/100),yerr=c132err/c132trans,linewidth = 3,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng,-np.log(c13bottrans/100),yerr=c13boterr/c13bottrans,linewidth = 3,elinewidth = 1,capsize = 3)
plt.errorbar(1240/wvlng[33:81],-np.log(x2u2trans[33:81]/100)/0.5,yerr=x2u2err[33:81]/x2u2trans[33:81]/0.5,linewidth = 3,elinewidth = 1,capsize = 3)
plt.xlabel('Photon energy [eV]')
plt.ylabel('Relative Absorption [mm$^{-1}$]')
plt.legend(['$^{229}$Th:CaF$_2$ $4.0 \cdot 10^{17}$ cm$^{-3}$ 100 kBq','$^{229}$Th:CaF$_2$ $5.4 \cdot 10^{17}$ cm$^{-3}$ 300 kBq','$^{229}$Th:CaF$_2$ $5.8 \cdot 10^{16}$ cm$^{-3}$ 300 kBq','$^{229}$Th:CaF$_2$ $2.4 \cdot 10^{17}$ cm$^{-3}$ 1 MBq'],prop={'size': 11},ncol=2, fancybox=True, shadow=True)
plt.axis([1240/160,1240/124,1e-1,7])
plt.minorticks_on() 
plt.grid()
#plt.yscale('log')
left,right = plt.xlim()
xtickloc,labels = plt.xticks() 
ax2 = plt.twiny()


# set the second axis ticks to the same locations
ax2.set_xticks(xtickloc)
# calculate new values for the second axis tick labels, format them, and set them
x2labels = ['{:.3g}'.format(x) for x in getWaveLength(xtickloc)]
ax2.set_xticklabels(x2labels)
# force the bounds to be the same
ax2.set_xlim([left,right]) 
ax2.set_xlabel('wavelength (nm)')
plt.rcParams.update({'font.size': 16})
plt.savefig('Radioactivetransmissionabscologpaper3.pdf', format='pdf',bbox_inches='tight',dpi=400)



