library(pgirmess)
require(investr)
library(qpcR)
library(nlstools)
library(dplyr)
library(ggplot2)
library(matrixStats)
library(car)
library(lmtest)

#https://rdrr.io/github/mtcruz/mtcruzr/man/format_sys_time.html
library(mtcruzr)

library(plotrix)

################### Use of code ####################
# This code provides an example of how to read in the models made in Heinrich et al. (in Review)




simple_growth_rate = function(model_nls, agemax, forest_type) { # where forest_type is: "secondary" or "degraded"
  
  age = data.frame(age=seq(1, agemax, 1))
  params=model_nls$m$getPars()
  A = model_nls$call$formula[[3]][[2]]
  
  if(A == "theta1"){
    print(paste0("Theta1 never reached, applying theta1 found by model"))
    Y = bquote((.(params[[1]])*(1-exp(-(.(params[[2]])*t)))^.(params[[3]])))
  } else {
    Y = bquote((.(A)*(1-exp(-(.(params[[1]])*t)))^.(params[[2]])))}
  
  old_AGC = eval(A)
  
  print(paste0(params[[1]]))
  print(paste0(params[[2]]))
  dy.dt = deriv(Y,"t", func=T)
  
  model_deriv=dy.dt(age)
  growth_rate=attr(model_deriv, "gradient")
  age["growth.rate"] = growth_rate
  
  if (forest_type != "secondary"){
    # do not include 0 as we do not want to start at 0 for degraded and plantation forest at least
    mean_growth = mean(age$growth.rate[2:21])
  } else if (forest_type == "secondary"){
    mean_growth = mean(age$growth.rate[1:20])
    
  }
  #asymptote_max = which.min(age$growth.rate[which(age$growth.rate > 0.05)])
  
  #asymptote_min = which.min(age$growth.rate[which(age$growth.rate > 1.0)])
  
  # Determine the average regrowth rate as a %
  age2 = data.frame(age=seq(1, agemax, 1))
  
  asPerc=data.frame("age" = age2,"AGC"=predict(model_nls, age2))
  
  asPerc$AGCperc = asPerc$AGC/(old_AGC)*100
  asPerc$AGCpercDiff = 1
  asPerc = mutate(asPerc, AGCpercDiff = lag(AGCperc) - AGCperc)
  
  av_20yrPerc=-mean(na.omit(asPerc$AGCpercDiff[1:20]))
  
  asPerc$percRound = round(asPerc$AGCperc)
  perc95 = asPerc[asPerc$percRound == 95,]
  avAsym = mean(perc95$age)
  minAsym = min(perc95$age)
  maxAsym = max(perc95$age)
  
  
  outputs = list("age_growth" = age, "PFasymptote_mean" = avAsym, "PFasymptote_min" = minAsym, "PFasymptote_max" = maxAsym, "Av20yrRate" = mean_growth, "Av20yrPercR" = av_20yrPerc, "growth_rate"=age$growth.rate, "AGC_output" = asPerc)
  
  return(outputs)
}


# change to where models are
setwd("<instert your directory here>")

model1 = readRDS("regrowthModel_borneo_sec_agb_fix_noOilPalm.rds")

outputs = simple_growth_rate(model1, 300, "secondary")

