library(pgirmess)
require(investr)
library(qpcR)
library(nlstools)
library(dplyr)
library(ggplot2)
library(matrixStats)

#https://rdrr.io/github/mtcruz/mtcruzr/man/format_sys_time.html
library(mtcruzr)
library(plotrix)

library(inauguration)
colBar=inauguration("inauguration_2021")
colBar2 = inauguration("bernie_mittens")

if (!require("RColorBrewer")) install.packages("RColorBrewer")
library(RColorBrewer)
brewer.pal.info

########################## Purpose of code #######################
#This code will read in the nls models in the format of .rds files created in step 3 to create the Figures 2
# and the extended data figure 3 to 5 depending on the user input - see "Change variable here"

#----------------------------------------------------------------#



########## All my functions ############

variable_table = function(variable_files){
  age_list = list()
  for (i in (1:length(variable_files))){
    print(i)
    file = variable_files[i]
    print(file)
    dbf_data = foreign::read.dbf(file)
    colnames(dbf_data) = c("Value", "Count")
    age_list[[i]] = dbf_data
  }
  data_merge = Reduce(function(x,y)merge (x, y, by="Value",all=TRUE), age_list)
  
  return(data_merge)
}

variable_table_V2 = function(variable_files){
  age_list = list()
  for (i in (1:length(variable_files))){
    print(i)
    file = variable_files[i]
    print(file)
    dbf_data = foreign::read.dbf(file)
    #colnames(dbf_data) = c("Value", "Count")
    age_list[[i]] = dbf_data
  }
  #data_merge = Reduce(function(x,y)merge (x, y, by="Value",all=TRUE), age_list)
  data_merge =  do.call(rbind, age_list)
  return(data_merge)
}

old_AGB = function(biome_str) {
  
  main_folder = "D:\\Chapter3\\JRC_recovery\\"
  folder = paste0(main_folder,"\\",biome_str, "\\")
  setwd(folder)
  if (biome_str == "atlantic"){
    pattern_name = paste0('ESA_AGB_fix_large_patches_undist_TMF_.*.dbf$')
  } else{
    pattern_name = paste0('ESA_AGB_fix_undist_TMF_.*.dbf$')
  }
  all_files = list.files(pattern = pattern_name, full.names = T)
  print(all_files)
  
  agb_old = variable_table(all_files)
  if (biome_str != "borneo"){
    agb_old$sum = rowSums(agb_old[, -1] ,na.rm=TRUE)
    agb_old = agb_old[agb_old$Value>0,]
    weighted_median = weightedMedian(agb_old$Value, agb_old$sum)
  } else{
    agb_old = agb_old[agb_old$Value>0,]
    colnames(agb_old) = c("Value", "sum")
    weighted_median = weightedMedian(agb_old$Value, agb_old$sum)
  }
  
  return(weighted_median)
}

old_AGB_by_Var = function(variable_str, biome_str, bin_str) {
  
  main_folder = "D:\\Chapter3\\variables\\"
  folder = paste0(main_folder,"\\", biome_str,"_oldG_AGB")
  setwd(folder)
  

  pattern_name = paste0(biome_str,'_undisturbed_AGB_fix_',variable_str,'_zonal_stats_.*.dbf$')
  
  all_files = list.files(pattern = pattern_name, full.names = T)
  print(all_files)
  
  agb_old = variable_table_V2(all_files)
  
  return(agb_old)
}

old_AGB_by_limits = function(old_growth_table, limit_str, biome_str, minmax_table){
  ##Step 1 - determine the limits using minmax limits csv file
  
  AGB_biome_limits = minmax_table[minmax_table$biome == biome_str,]
  biome_limit = AGB_biome_limits[AGB_biome_limits$group == limit_str,] # e.g. "Lower 25%" #Middle 50% etc
  #Step 2 - extract the associated undisturbed TMF AGB values within those limits
  colnames(old_growth_table)[1] = "VALUE"
  limit = old_growth_table[old_growth_table$VALUE >= biome_limit$min & old_growth_table$VALUE <= biome_limit$max,]
  #Step 3 - my mini test analysis showed that the MEDIAN of the MEDIAN values is the most similar to the original approach
  #(which was extract the AGB overlying a tiff of the range of variable values)
  limit_AGB = median(limit$MEDIAN)
  
  return(limit_AGB)
}

plot_recovery = function(variable_str,Biome, modelL, modelM, modelH, label_df, forest_type, old_low, old_mid, old_high, xaxis, yaxis, subplot_str){
  
  units = expression(" Mg C"~ha^-1)
  stats1=simple_growth_rate(modelL, 300, forest_type)
  stats2=simple_growth_rate(modelM, 300, forest_type)
  stats3=simple_growth_rate(modelH, 300, forest_type)
  str1 = toString(label_df$label[1])

  open_bracket = "("
  close_bracket = ")"
  leg1 = bquote(.(toString(label_df$label[1]))) #~ .(open_bracket) * .(toString(round(stats1$Av20yrRate, 2))) ~"Mg C" ~ ha^-1  ~ yr^-1* .(close_bracket))
  leg2 = bquote(.(toString(label_df$label[2]))) #~ .(open_bracket) * .(toString(round(stats2$Av20yrRate, 2))) ~"Mg C" ~ ha^-1  ~ yr^-1* .(close_bracket))
  leg3 = bquote(.(toString(label_df$label[3])))# ~ .(open_bracket) * .(toString(round(stats3$Av20yrRate, 2))) ~"Mg C" ~ ha^-1  ~ yr^-1* .(close_bracket))
  

  if (forest_type == "degraded"){
    maintitle = paste("Degraded Forests,",Biome)
    xlims = c(1,50)
    ylims = c(0,140)
  } else if (forest_type == "secondary"){
    maintitle = paste("Secondary Forests,",Biome) 
    xlims = c(0,50)
    ylims = c(0,140)
  } else if (forest_type == "plantation"){
    maintitle = paste("Plantation Forests,",Biome)
    xlims = c(1,50)
    ylims = c(0,140)
  }
  
  print(maintitle)

  #original colours = "#18BECF", "#BCBD23", "#7F7F7F"
  if (variable_str == "MaxTemp"){
    lowCol = colBar[3] ##F4C485
    midCol = colBar[5] #CE3341
    highCol = colBar[4] # #5E1A33

  } else if (variable_str == "MCWD"){
    lowCol = colBar[3]
    midCol = "#78C7BC"
    highCol = "#046860"
  } else if (variable_str == "HAND"){
    lowCol = "#57AD00"
    midCol = "#F3CA3A"
    highCol = "grey50"
  } else if (variable_str == "distance_from_undisturbed"){
    lowCol = "#00492B"
    midCol = "#258644"
    highCol =  "#CAEA9C"
  }
  


  par()
  plotFit(modelL,col = lowCol,interval="confidence",xlim=xlims,ylim=ylims,pch=19,cex = 0.5,col.fit = lowCol,lwd.fit=2.5, col.conf=adjustcolor(lowCol, 0.3), shade=TRUE,  xlab = '',  xaxt="n",yaxt="n", ylab='')
  #par(new = TRUE, mar=c(5,6,4,1)+.05)
  par(new = TRUE)
  plotFit(modelM,col = midCol,interval="confidence",xlim=xlims,ylim=ylims,pch=19,cex = 0.5,col.fit= midCol, lwd.fit=2.5,col.conf=adjustcolor(midCol, 0.3), shade=TRUE,  xlab = '', ylab='',  xaxt="n",yaxt="n")
  #par(new = TRUE, mar=c(5,6,4,1)+.05)
  par(new = TRUE)
  
  if (xaxis == T){
    if (yaxis == T){
      plotFit(modelH,col = highCol,interval="confidence",xlim=xlims,ylim=ylims,pch=19,cex = 0.5,col.fit= highCol, lwd.fit=2.5,col.conf=adjustcolor(highCol, 0.3),
              las =1,
              cex.lab = 1.25,
              
              cex.axis = 1.25,
              cex.main = 1.25,
              cex.sub = 1.25,
              shade=TRUE, xaxt="n",
              #xlab = xLAB, ylab=YLAB,  xaxt=xAXT, yaxt=yAXT)
              xlab='', ylab="")
      axis(side = 1, labels=F, tck = -0.03)
      rect(xleft = 44, xright = 51, ybottom = 0, ytop = 140, col = "white", border ="white")
      axis(1, at = seq(0, 50, by = 10), labels = c(0, 10, 20, 30, 40, "OG"), cex.axis = 1.25)
      axis.break(axis = 1, 45,style="slash") 
      
      
      
    }
    if (yaxis == F){
      plotFit(modelH,col = highCol,interval="confidence",xlim=xlims,ylim=ylims,pch=19,cex = 0.5,col.fit= highCol, lwd.fit=2.5,col.conf=adjustcolor(highCol, 0.3),
              las =1,
              cex.lab = 1.25,
              
              cex.axis = 1.25,
              cex.main = 1.25,
              cex.sub = 1.25,
              shade=TRUE, yaxt = "n", ylab = '', xaxt="n",
              #xlab = xLAB, ylab=YLAB,  xaxt=xAXT, yaxt=yAXT)
              xlab='')
      axis(side = 2, labels=F, tck = -0.03)
      rect(xleft = 44, xright = 51, ybottom = 0, ytop = 140, col = "white", border ="white")
      axis(1, at = seq(0, 50, by = 10), labels = c(0, 10, 20, 30, 40, "OG"), cex.axis = 1.25)
      axis.break(axis = 1, 45,style="slash")
      
      
    }
  } 
  
  else if (xaxis == F){
    if (yaxis == T){
      plotFit(modelH,col = highCol,interval="confidence",xlim=xlims,ylim=ylims,pch=19,cex = 0.5,col.fit= highCol, lwd.fit=2.5,col.conf=adjustcolor(highCol, 0.3),
              las =1,
              cex.lab = 1.25,
              
              cex.axis = 1.25,
              cex.main = 1.25,
              cex.sub = 1.25,
              shade=TRUE, xaxt = 'n',
              xlab='',  ylab="")
      axis(side = 1, labels=F, tck = -0.03)
      rect(xleft = 44, xright = 51, ybottom = 0, ytop = 140, col = "white", border ="white")
      axis.break(axis = 1, 45,style="slash")

    }
    if (yaxis == F){
      plotFit(modelH,col = highCol,interval="confidence",xlim=xlims,ylim=ylims,pch=19,cex = 0.5,col.fit= highCol, lwd.fit=2.5,col.conf=adjustcolor(highCol, 0.3),
              las =1,
              cex.lab = 1.25,
              
              cex.axis = 1.25,
              cex.main = 1.25,
              cex.sub = 1.25,
              shade=TRUE, yaxt = "n", xaxt="n",
              xlab='', ylab = '')
      axis(side = 1, labels=F, tck = -0.03)
      axis(side = 2, labels=F, tck = -0.03)
      rect(xleft = 44, xright = 51, ybottom = 0, ytop = 140, col = "white", border ="white")
      axis.break(axis = 1, 45,style="slash")
      
      
    }
    
    
  }
    
  if ("secondary" %in% forest_type){
    legend("topleft", inset = 0.01,legend=(c(as.expression(leg1), as.expression(leg2), as.expression(leg3))),
           col=c(lowCol, midCol, highCol), pch = 19, box.lty = 0, bg="transparent", cex=1.1, pt.cex=1.1)
  } else (legend("bottomright", inset = 0.01,legend=(c(as.expression(leg1), as.expression(leg2), as.expression(leg3))),
                 col=c(lowCol, midCol, highCol), pch = 19, box.lty = 0, bg="transparent", cex=1.1, pt.cex=1.1)
  )
  #title(maintitle, line =0.5, cex.main=1.4, font.main =1)
  mtext(text = bquote(bold(.(subplot_str)) ~ .(maintitle)), line=0, adj=0.0, cex=1.05)  
  par(new = TRUE)
  plot(49.5, old_low*0.456, xlim=c(1,50),ylim=c(0.5,140), pch=4, col=lowCol, xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
  par(new = TRUE)
  plot(50, old_mid*0.456, xlim=c(1,50),ylim=c(0.5,140), pch=4, col=midCol,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
  par(new = TRUE)
  plot(49.8, old_high*0.456, xlim=c(1,50),ylim=c(0.5,140), pch=4, col=highCol,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
  axis.break(axis = 1, 45,style="slash") 
  
  
}

simple_growth_rate = function(model_nls, agemax, forest_type){
  
  age = data.frame(age=seq(1, agemax, 1))
  params=model_nls$m$getPars()
  A = model_nls$call$formula[[3]][[2]]
  
  if(A == "theta1"){
    print(paste0("Theta1 never reached, applying theta1 found by model"))
    Y = bquote((.(params[[1]])*(1-exp(-(.(params[[2]])*t)))^.(params[[3]])))
  } else {
    Y = bquote((.(A)*(1-exp(-(.(params[[1]])*t)))^.(params[[2]])))}
  
  print(paste0(params[[1]]))
  print(paste0(params[[2]]))
  dy.dt = deriv(Y,"t", func=T)
  
  model_deriv=dy.dt(age)
  growth_rate=attr(model_deriv, "gradient")
  age["growth.rate"] = growth_rate
  
  if (forest_type != "secondary"){
    # do not include 0 as we do not want to start at 0 for degraded  forest 
    mean_growth = mean(age$growth.rate[2:21])
  } else if (forest_type == "secondary"){
    mean_growth = mean(age$growth.rate[1:20])
    
  }
  asymptote = which.min(age$growth.rate[which(age$growth.rate > 0.05)])
  
  age2 = data.frame(age=seq(1, agemax, 1))
  
  asPerc=data.frame("age" = age2,"AGC"=predict(model_nls, age2))
  
  
  old_AGC = eval(model_nls$call$formula[[3]][[2]][[2]])
  asPerc$AGCperc = asPerc$AGC/old_AGC*100
  asPerc$AGCpercDiff = 1
  asPerc = mutate(asPerc, AGCpercDiff = lag(AGCperc) - AGCperc)
  
  av_20yrPerc=-mean(na.omit(asPerc$AGCpercDiff[1:20]))
  
  
  age3 = data.frame(age = seq(20, 20))
  
  AGC20=data.frame(predFit(model_nls, age3, interval = "confidence"))
  AGC20_diff = AGC20$fit - AGC20$lwr
  
  print(paste0("the AGC after 20 years is: ", round(AGC20$fit,1), " and the difference is: ", round(AGC20_diff, 1)))
  
  outputs = list("age_growth" = age, "PFasymptote" = asymptote, "Av20yrRate" = mean_growth, "growth_rate"=age$growth.rate, "growth_rate_AsPerc" = av_20yrPerc)
  
  return(outputs)
}


calc_kruskal_wallis = function(outputLow, outputMid, outputHigh){
  
  lowdf = data.frame("values" = outputLow$growth_rate)
  lowdf$range = "Low"
  
  middf = data.frame("values" = outputMid$growth_rate)
  middf$range = "Mid"
  
  highdf = data.frame("values" = outputHigh$growth_rate)
  highdf$range = "High"
  
  all_ranges = rbind(lowdf, middf, highdf)
  
  KW_models=kruskalmc(all_ranges$values,all_ranges$range, probs = 0.05)
  
  return(KW_models)
  
}

################ Change variable here #####################

variable_str = "MaxTemp" #MaxTemp MCWD HAND distance_from_undisturbed

############ in degraded forests #################

if (variable_str == "MaxTemp"){
  unit = "\u00B0C"
} else if (variable_str == "MCWD"){
  unit = "mm"
} else if (variable_str == "HAND"){
  unit = "m"
} 

if (variable_str == "MaxTemp"){
  lowCol = colBar[3]
  midCol = colBar[5]
  highCol = colBar[4]
  
} else if (variable_str == "MCWD"){
  lowCol = colBar[3]
  midCol = "#78C7BC"
  highCol = "#046860"
} else if (variable_str == "HAND"){
  lowCol = "#57AD00"
  midCol = "#F3CA3A"
  highCol = "grey50"
} else if (variable_str == "distance_from_undisturbed"){
  lowCol = "#00492B"
  midCol = "#258644"
  highCol =  "#CAEA9C"
}

if (variable_str != "distance_from_undisturbed"){
  AGB_borneo_deg = old_AGB_by_Var(variable_str, "borneo")
  AGB_amazon_deg = old_AGB_by_Var(variable_str, "amazon_basin")
  AGB_congo_deg = old_AGB_by_Var(variable_str, "congo")
  
  
  main_folder = "D:\\Chapter3\\JRC_recovery\\results"
  setwd(main_folder)
  biome = c("amazon_basin", "borneo", "congo")
  
  CR_amazonL_deg = readRDS(paste0("regrowthModel_amazon_basin_deg_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_amazonM_deg =readRDS( paste0("regrowthModel_amazon_basin_deg_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_amazonH_deg = readRDS(paste0("regrowthModel_amazon_basin_deg_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  CR_borneoL_deg =readRDS( paste0("regrowthModel_borneo_deg_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_borneoM_deg =readRDS( paste0("regrowthModel_borneo_deg_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_borneoH_deg =readRDS( paste0("regrowthModel_borneo_deg_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  CR_congoL_deg =readRDS( paste0("regrowthModel_congo_basin_deg_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_congoM_deg =readRDS( paste0("regrowthModel_congo_basin_deg_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_congoH_deg =readRDS( paste0("regrowthModel_congo_basin_deg_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  simp_amzL_deg = simple_growth_rate(CR_amazonL_deg, 300, "degraded")
  simp_amzM_deg = simple_growth_rate(CR_amazonM_deg, 300, "degraded")
  simp_amzH_deg = simple_growth_rate(CR_amazonH_deg, 300, "degraded")

  
  simp_borL_deg = simple_growth_rate(CR_borneoL_deg, 300, "degraded")
  simp_borM_deg = simple_growth_rate(CR_borneoM_deg, 300, "degraded")
  simp_borH_deg = simple_growth_rate(CR_borneoH_deg, 300, "degraded")
  
  simp_conL_deg = simple_growth_rate(CR_congoL_deg, 300, "degraded")
  simp_conM_deg = simple_growth_rate(CR_congoM_deg, 300, "degraded")
  simp_conH_deg = simple_growth_rate(CR_congoH_deg, 300, "degraded")
  
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_amzL_deg$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_amzM_deg$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_amzH_deg$growth_rate_AsPerc,1)))
  
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_borL_deg$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_borM_deg$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_borH_deg$growth_rate_AsPerc,1)))
  
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_conL_deg$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_conM_deg$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_conH_deg$growth_rate_AsPerc,1)))
  
  amz_deg = calc_kruskal_wallis(simp_amzL_deg, simp_amzM_deg, simp_amzH_deg)
  bor_deg = calc_kruskal_wallis(simp_borL_deg, simp_borM_deg, simp_borH_deg)
  con_deg = calc_kruskal_wallis(simp_conL_deg, simp_conM_deg, simp_conH_deg)
  
  age = data.frame(age = seq(1, 37))
  
  AGC20=data.frame(predFit(CR_amazonH_deg, age, interval = "confidence"))
  print(AGC20)
  
  age = data.frame(age = seq(31, 34))
  
  AGC_predict = data.frame(predFit(CR_congoH_deg, age, interval = "confidence"))
  AGC_predict
  
  degraded_data = read.csv(paste0("overall_stats_all_basins_degraded_for_",variable_str,"_agb_fix.csv"))
  minmax_limits_deg = read.csv(paste0("minmax_limits_all_basins_degraded_for_",variable_str,"_agb_fix.csv"))
  minmax_table_deg=minmax_limits_deg

  if (variable_str == "MaxTemp"){
    minmax_table_deg$min = minmax_table_deg$min*10
    minmax_table_deg$max = minmax_table_deg$max*10
  }
  minmax_table_deg$mean = ((minmax_table_deg$max - minmax_table_deg$min)/2) + minmax_table_deg$min
  
  
  #extract the AGB of undsitrubed forest in the different limits for each biome
  amz_low_deg = old_AGB_by_limits(AGB_amazon_deg, "Lower 25%", "amazon_basin", minmax_table_deg)
  amz_mid_deg = old_AGB_by_limits(AGB_amazon_deg, "Middle 50%", "amazon_basin", minmax_table_deg)
  amz_high_deg = old_AGB_by_limits(AGB_amazon_deg, "Upper 25%", "amazon_basin", minmax_table_deg)
  
  bor_low_deg = old_AGB_by_limits(AGB_borneo_deg, "Lower 25%", "borneo", minmax_table_deg)
  bor_mid_deg = old_AGB_by_limits(AGB_borneo_deg, "Middle 50%", "borneo", minmax_table_deg)
  bor_high_deg = old_AGB_by_limits(AGB_borneo_deg, "Upper 25%", "borneo", minmax_table_deg)
  
  con_low_deg = old_AGB_by_limits(AGB_congo_deg, "Lower 25%", "congo_basin", minmax_table_deg)
  con_mid_deg = old_AGB_by_limits(AGB_congo_deg, "Middle 50%", "congo_basin", minmax_table_deg)
  con_high_deg = old_AGB_by_limits(AGB_congo_deg, "Upper 25%", "congo_basin", minmax_table_deg)
  
  amzL_data_deg = degraded_data[degraded_data$biome == "amazon_basin" & degraded_data$group == "Lower 25%",]
  amzM_data_deg = degraded_data[degraded_data$biome == "amazon_basin" & degraded_data$group == "Middle 50%",]
  amzH_data_deg = degraded_data[degraded_data$biome == "amazon_basin" & degraded_data$group == "Upper 25%",]
  
  borL_data_deg = degraded_data[degraded_data$biome == "borneo" & degraded_data$group == "Lower 25%",]
  borM_data_deg = degraded_data[degraded_data$biome == "borneo" & degraded_data$group == "Middle 50%",]
  borH_data_deg = degraded_data[degraded_data$biome == "borneo" & degraded_data$group == "Upper 25%",]
  
  conL_data_deg = degraded_data[degraded_data$biome == "congo_basin" & degraded_data$group == "Lower 25%",]
  conM_data_deg = degraded_data[degraded_data$biome == "congo_basin" & degraded_data$group == "Middle 50%",]
  conH_data_deg = degraded_data[degraded_data$biome == "congo_basin" & degraded_data$group == "Upper 25%",]
  
  
  labelAmz_deg = minmax_table_deg[minmax_table_deg$biome == "amazon_basin",]
  
  labelBor_deg = minmax_table_deg[minmax_table_deg$biome == "borneo",]
  labelCon_deg = minmax_table_deg[minmax_table_deg$biome == "congo_basin",]
  
  labelAmz_deg$label = paste0(labelAmz_deg$label, unit)
  labelBor_deg$label = paste0(labelBor_deg$label, unit)
  labelCon_deg$label = paste0(labelCon_deg$label, unit)

  
  #############################  in secondary forests ########################
  
  AGB_borneo_sec = old_AGB_by_Var(variable_str, "borneo")
  AGB_amazon_sec = old_AGB_by_Var(variable_str, "amazon_basin")
  AGB_congo_sec = old_AGB_by_Var(variable_str, "congo")
  
  
  main_folder = "D:\\Chapter3\\JRC_recovery\\results"
  setwd(main_folder)
  biome = c("amazon_basin", "borneo", "congo_basin")
  
  CR_amazonL_sec = readRDS(paste0("regrowthModel_amazon_basin_sec_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_amazonM_sec =readRDS( paste0("regrowthModel_amazon_basin_sec_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_amazonH_sec =readRDS( paste0("regrowthModel_amazon_basin_sec_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  CR_borneoL_sec =readRDS( paste0("regrowthModel_borneo_sec_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_borneoM_sec =readRDS( paste0("regrowthModel_borneo_sec_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_borneoH_sec =readRDS( paste0("regrowthModel_borneo_sec_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  CR_congoL_sec =readRDS( paste0("regrowthModel_congo_basin_sec_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_congoM_sec =readRDS( paste0("regrowthModel_congo_basin_sec_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_congoH_sec =readRDS( paste0("regrowthModel_congo_basin_sec_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  
  age = data.frame(age = seq(1, 32))
  AGC_predict = data.frame(predFit(CR_congoH_sec, age, interval = "confidence"))
  AGC_predict
  
  secondary_data_sec = read.csv(paste0("overall_stats_all_basins_secondary_for_",variable_str,"_agb_fix.csv"))
  minmax_limits_sec = read.csv(paste0("minmax_limits_all_basins_secondary_for_",variable_str,"_agb_fix.csv"))
  minmax_table_sec=minmax_limits_sec
  
  if (variable_str == "MaxTemp"){
    minmax_table_sec$min = minmax_table_sec$min*10
    minmax_table_sec$max = minmax_table_sec$max*10
  }
  
  minmax_table_sec$mean = ((minmax_table_sec$max - minmax_table_sec$min)/2) + minmax_table_sec$min

  
  pointRange = ggplot(data = minmax_table_sec, aes(x=biome, y=mean, ymin=min, ymax=max, fill=group, colour =group)) +
    geom_linerange(size=3)+
    geom_pointrange(size=0.001)+
    scale_color_manual(values = c(lowCol, midCol, highCol))+
    theme_bw() +
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          axis.text.x = element_text(color="black", size=12),axis.text.y = element_text(color="black", size=12),
          text=element_text(size=12),
          #legend.position = c(0.26, 0.85),
          legend.direction = "vertical", legend.box="horizontal", legend.background = element_blank())+
    labs(x = "Biome", y= "MCWD (-mm)", colour = "Limits", fill="Limits") +
    coord_flip()
  
  print(pointRange)
  
  #extract the AGB of undsitrubed forest in the different limits for each biome
  amz_low_sec = old_AGB_by_limits(AGB_amazon_sec, "Lower 25%", "amazon_basin", minmax_table_sec)
  amz_mid_sec = old_AGB_by_limits(AGB_amazon_sec, "Middle 50%", "amazon_basin", minmax_table_sec)
  amz_high_sec = old_AGB_by_limits(AGB_amazon_sec, "Upper 25%", "amazon_basin", minmax_table_sec)
  bor_low_sec = old_AGB_by_limits(AGB_borneo_sec, "Lower 25%", "borneo", minmax_table_sec)
  bor_mid_sec = old_AGB_by_limits(AGB_borneo_sec, "Middle 50%", "borneo", minmax_table_sec)
  bor_high_sec = old_AGB_by_limits(AGB_borneo_sec, "Upper 25%", "borneo", minmax_table_sec)
  
  con_low_sec = old_AGB_by_limits(AGB_congo_sec, "Lower 25%", "congo_basin", minmax_table_sec)
  con_mid_sec = old_AGB_by_limits(AGB_congo_sec, "Middle 50%", "congo_basin", minmax_table_sec)
  con_high_sec = old_AGB_by_limits(AGB_congo_sec, "Upper 25%", "congo_basin", minmax_table_sec)
  
  amzL_data_sec = secondary_data_sec[secondary_data_sec$biome == "amazon_basin" & secondary_data_sec$group == "Lower 25%",]
  amzM_data_sec = secondary_data_sec[secondary_data_sec$biome == "amazon_basin" & secondary_data_sec$group == "Middle 50%",]
  amzH_data_sec = secondary_data_sec[secondary_data_sec$biome == "amazon_basin" & secondary_data_sec$group == "Upper 25%",]
  
  amzL_data_sec$weighted_median_C = amzL_data_sec$weighted_median - min(amzL_data_sec$weighted_median)
  amzM_data_sec$weighted_median_C = amzM_data_sec$weighted_median - min(amzM_data_sec$weighted_median)
  amzH_data_sec$weighted_median_C = amzH_data_sec$weighted_median - min(amzH_data_sec$weighted_median)
  
  
  borL_data_sec = secondary_data_sec[secondary_data_sec$biome == "borneo" & secondary_data_sec$group == "Lower 25%",]
  borM_data_sec = secondary_data_sec[secondary_data_sec$biome == "borneo" & secondary_data_sec$group == "Middle 50%",]
  borH_data_sec = secondary_data_sec[secondary_data_sec$biome == "borneo" & secondary_data_sec$group == "Upper 25%",]
  
  borL_data_sec$weighted_median_C = borL_data_sec$weighted_median - min(borL_data_sec$weighted_median)
  borM_data_sec$weighted_median_C = borM_data_sec$weighted_median - min(borM_data_sec$weighted_median)
  borH_data_sec$weighted_median_C = borH_data_sec$weighted_median - min(borH_data_sec$weighted_median)
  
  
  conL_data_sec = secondary_data_sec[secondary_data_sec$biome == "congo_basin" & secondary_data_sec$group == "Lower 25%",]
  conM_data_sec = secondary_data_sec[secondary_data_sec$biome == "congo_basin" & secondary_data_sec$group == "Middle 50%",]
  conH_data_sec = secondary_data_sec[secondary_data_sec$biome == "congo_basin" & secondary_data_sec$group == "Upper 25%",]
  

  
  conL_data_sec$weighted_median_C = conL_data_sec$weighted_median - min(conL_data_sec$weighted_median)
  conM_data_sec$weighted_median_C = conM_data_sec$weighted_median - min(conM_data_sec$weighted_median)
  conH_data_sec$weighted_median_C = conH_data_sec$weighted_median - min(conH_data_sec$weighted_median)
  
  
  labelAmz_sec = minmax_table_sec[minmax_table_sec$biome == "amazon_basin",]
  labelBor_sec = minmax_table_sec[minmax_table_sec$biome == "borneo",]
  labelCon_sec = minmax_table_sec[minmax_table_sec$biome == "congo_basin",]
  
  labelAmz_sec$label = paste0(labelAmz_sec$label, unit)
  labelBor_sec$label = paste0(labelBor_sec$label, unit)
  labelCon_sec$label = paste0(labelCon_sec$label, unit)
  

  
  simp_amzL_sec = simple_growth_rate(CR_amazonL_sec, 300, "secondary")
  simp_amzM_sec = simple_growth_rate(CR_amazonM_sec, 300, "secondary")
  simp_amzH_sec = simple_growth_rate(CR_amazonH_sec, 300, "secondary")
  
  simp_borL_sec = simple_growth_rate(CR_borneoL_sec, 300, "secondary")
  simp_borM_sec = simple_growth_rate(CR_borneoM_sec, 300, "secondary")
  simp_borH_sec = simple_growth_rate(CR_borneoH_sec, 300, "secondary")
  
  simp_conL_sec = simple_growth_rate(CR_congoL_sec, 300, "secondary")
  simp_conM_sec = simple_growth_rate(CR_congoM_sec, 300, "secondary")
  simp_conH_sec = simple_growth_rate(CR_congoH_sec, 300, "secondary")
  
  amz_sec = calc_kruskal_wallis(simp_amzL_sec, simp_amzM_sec, simp_amzH_sec)
  bor_sec = calc_kruskal_wallis(simp_borL_sec, simp_borM_sec, simp_borH_sec)
  con_sec = calc_kruskal_wallis(simp_conL_sec, simp_conM_sec, simp_conH_sec)
  
  
  
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_amzL_sec$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_amzM_sec$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_amzH_sec$growth_rate_AsPerc,1)))
  
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_borL_sec$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_borM_sec$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_borH_sec$growth_rate_AsPerc,1)))
  
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_conL_sec$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_conM_sec$growth_rate_AsPerc,1)))
  print(paste0("The Av. 20yr growth rate as a percentage is: ", round(simp_conH_sec$growth_rate_AsPerc,1)))
  
  results_folder2 = "C:\\Users\\ky18705\\OneDrive - University of Bristol\\Brazil_trip_2019\\Chapter3_analysis\\results\\"
  
  setwd(results_folder2)
  #################################### Figure ###############################
  #pdf(paste0('regrowth_by_',variable_str, '_',format_sys_time(),'.jpg'), width = 7.5, height = 6)
  #jpeg(paste0('regrowth_by_',variable_str, '_',Sys.Date(),'.jpg'), res = 600, width = 7.5, height = 6, units = 'in')

  par(mfrow = c(3,2), mar=c(0.7, 0.5, 1.0, 0.2), oma = c(4, 5, 0.5, 0.2), xpd = NA) # (bottom, left, top, right) #orig: mar=c(0.5, 0.5, 0.2, 0.2)
  par(family = "sans")
  
  plot_recovery(variable_str,"Amazon", CR_amazonL_deg, CR_amazonM_deg, CR_amazonH_deg, labelAmz_deg, "degraded", amz_low_deg, amz_mid_deg, amz_high_deg, F, T, "a.")
  plot_recovery(variable_str,"Amazon", CR_amazonL_sec, CR_amazonM_sec, CR_amazonH_sec, labelAmz_sec, "secondary", amz_low_sec, amz_mid_sec, amz_high_sec, F, F,  "b.")
  
  plot_recovery(variable_str,"Borneo", CR_borneoL_deg, CR_borneoM_deg, CR_borneoH_deg, labelBor_deg, "degraded", bor_low_deg, bor_mid_deg, bor_high_deg, F, T, "c.")
  plot_recovery(variable_str,"Borneo", CR_borneoL_sec, CR_borneoM_sec, CR_borneoH_sec, labelBor_sec, "secondary", bor_low_sec, bor_mid_sec, bor_high_sec, F, F,  "d.")
  
  plot_recovery(variable_str,"Central Africa", CR_congoL_deg, CR_congoM_deg, CR_congoH_deg, labelCon_deg, "degraded", con_low_deg, con_mid_deg, con_high_deg, T, T,  "e.")
  plot_recovery(variable_str,"Central Africa", CR_congoL_sec, CR_congoM_sec, CR_congoH_sec, labelCon_sec, "secondary", con_low_sec, con_mid_sec, con_high_sec, T, F,  "f.")
  
  mtext(expression('AGC (Mg C ha'^-1*')'),side=2,line=2,outer=TRUE,cex=1,las=0)
  mtext("Years since last disturbance event",side=1,line=2,outer=TRUE,cex=1)
  
  #dev.off()
  #dev.off()
  graphics.off()
  
  #jpeg(paste0('regrowth_by_',variable_str, '_',format_sys_time(),'.jpg'), res = 600, width = 7.5, height = 6, units = 'in')
  #svg(paste0('regrowth_by_',variable_str, '_',Sys.Date(),'.svg'), width = 7.5, height = 6)
  pdf(paste0('regrowth_by_',variable_str, '_',Sys.Date(),'.pdf'), width = 7.5, height = 6)
  
  par(mfrow = c(3,2), mar=c(0.7, 0.5, 1.0, 0.2), oma = c(4, 5, 0.5, 0.2), xpd = NA) # (bottom, left, top, right) #orig: mar=c(0.5, 0.5, 0.2, 0.2)
  par(family = "sans")
  
  plot_recovery(variable_str,"Amazon", CR_amazonL_deg, CR_amazonM_deg, CR_amazonH_deg, labelAmz_deg, "degraded", amz_low_deg, amz_mid_deg, amz_high_deg, F, T, "a.")
  plot_recovery(variable_str,"Amazon", CR_amazonL_sec, CR_amazonM_sec, CR_amazonH_sec, labelAmz_sec, "secondary", amz_low_sec, amz_mid_sec, amz_high_sec, F, F,  "b.")
  
  plot_recovery(variable_str,"Borneo", CR_borneoL_deg, CR_borneoM_deg, CR_borneoH_deg, labelBor_deg, "degraded", bor_low_deg, bor_mid_deg, bor_high_deg, F, T, "c.")
  plot_recovery(variable_str,"Borneo", CR_borneoL_sec, CR_borneoM_sec, CR_borneoH_sec, labelBor_sec, "secondary", bor_low_sec, bor_mid_sec, bor_high_sec, F, F,  "d.")
  
  plot_recovery(variable_str,"Central Africa", CR_congoL_deg, CR_congoM_deg, CR_congoH_deg, labelCon_deg, "degraded", con_low_deg, con_mid_deg, con_high_deg, T, T,  "e.")
  plot_recovery(variable_str,"Central Africa", CR_congoL_sec, CR_congoM_sec, CR_congoH_sec, labelCon_sec, "secondary", con_low_sec, con_mid_sec, con_high_sec, T, F,  "f.")
  
  #dev.off()
  #dev.off()
  graphics.off()
  
  
} else if (variable_str == "distance_from_undisturbed"){
  
  ################## Distance from undisturbed forests ######################
  
  AGB_borneo = old_AGB("borneo")
  AGB_amazon = old_AGB("amazon_basin")
  AGB_congo = old_AGB("congo_basin")
  
  
  main_folder = "D:\\Chapter3\\JRC_recovery\\results"
  setwd(main_folder)
  biome = c("amazon","atlantic", "borneo", "congo")
  
  ############## in degraded forests ################
  
  CR_amazonL_deg = readRDS(paste0("regrowthModel_amazon_basin_deg_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_amazonM_deg =readRDS( paste0("regrowthModel_amazon_basin_deg_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_amazonH_deg = readRDS(paste0("regrowthModel_amazon_basin_deg_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  CR_borneoL_deg =readRDS( paste0("regrowthModel_borneo_deg_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_borneoM_deg =readRDS( paste0("regrowthModel_borneo_deg_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_borneoH_deg =readRDS( paste0("regrowthModel_borneo_deg_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  
  CR_congoL_deg =readRDS( paste0("regrowthModel_congo_basin_deg_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_congoM_deg =readRDS( paste0("regrowthModel_congo_basin_deg_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_congoH_deg =readRDS( paste0("regrowthModel_congo_basin_deg_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  #conH_data_deg = conH_data_deg[conH_data_deg$age !=33,]
  
  simp_amzL_deg = simple_growth_rate(CR_amazonL_deg, 300, "degraded")
  simp_amzM_deg = simple_growth_rate(CR_amazonM_deg, 300, "degraded")
  simp_amzH_deg = simple_growth_rate(CR_amazonH_deg, 300, "degraded")
  
  simp_borL_deg = simple_growth_rate(CR_borneoL_deg, 300, "degraded")
  simp_borM_deg = simple_growth_rate(CR_borneoM_deg, 300, "degraded")
  simp_borH_deg = simple_growth_rate(CR_borneoH_deg, 300, "degraded")
  
  simp_conL_deg = simple_growth_rate(CR_congoL_deg, 300, "degraded")
  simp_conM_deg = simple_growth_rate(CR_congoM_deg, 300, "degraded")
  simp_conH_deg = simple_growth_rate(CR_congoH_deg, 300, "degraded")
  
  amz_deg = calc_kruskal_wallis(simp_amzL_deg, simp_amzM_deg, simp_amzH_deg)
  bor_deg = calc_kruskal_wallis(simp_borL_deg, simp_borM_deg, simp_borH_deg)
  con_deg = calc_kruskal_wallis(simp_conL_deg, simp_conM_deg, simp_conH_deg)

  
  degraded_data_deg = read.csv(paste0("overall_stats_all_basins_degraded_for_",variable_str,"_agb_fix.csv"))
  minmax_limits_deg = read.csv(paste0("minmax_limits_all_basins_degraded_for_",variable_str,"_agb_fix.csv"))
  minmax_table_deg=minmax_limits_deg
  minmax_table_deg$mean = ((minmax_table_deg$max - minmax_table_deg$min)/2) + minmax_table_deg$min
  
  
  amzL_data_deg = degraded_data_deg[degraded_data_deg$biome == "amazon_basin" & degraded_data_deg$group == "< 120m",]
  amzM_data_deg = degraded_data_deg[degraded_data_deg$biome == "amazon_basin" & degraded_data_deg$group == "120m to 1000m",]
  amzH_data_deg = degraded_data_deg[degraded_data_deg$biome == "amazon_basin" & degraded_data_deg$group == "1000m+",]
  
  borL_data_deg = degraded_data_deg[degraded_data_deg$biome == "borneo" & degraded_data_deg$group == "< 120m",]
  borM_data_deg = degraded_data_deg[degraded_data_deg$biome == "borneo" & degraded_data_deg$group == "120m to 1000m",]
  borH_data_deg = degraded_data_deg[degraded_data_deg$biome == "borneo" & degraded_data_deg$group == "1000m+",]
  
  conL_data_deg = degraded_data_deg[degraded_data_deg$biome == "congo_basin" & degraded_data_deg$group == "< 120m",]
  conM_data_deg = degraded_data_deg[degraded_data_deg$biome == "congo_basin" & degraded_data_deg$group == "120m to 1000m",]
  conH_data_deg = degraded_data_deg[degraded_data_deg$biome == "congo_basin" & degraded_data_deg$group == "1000m+",]
  
  labelAmz_deg = minmax_table_deg[minmax_table_deg$biome == "amazon_basin",]
  labelAmz_deg = labelAmz_deg[c(1,3,2),]
  
  labelBor_deg = minmax_table_deg[minmax_table_deg$biome == "borneo",]
  labelBor_deg = labelBor_deg[c(1,3,2),]
  
  labelCon_deg = minmax_table_deg[minmax_table_deg$biome == "congo_basin",]
  labelCon_deg = labelCon_deg[c(1,3,2),]
  
  #amz_deg = calc_kruskal_wallis(amzL_data_deg, amzM_data_deg, amzH_data_deg)
  
  ############## in secondary forests ################
  
  
  main_folder = "D:\\Chapter3\\JRC_recovery\\results"
  setwd(main_folder)
  biome = c("amazon_basin", "borneo", "congo_basin")
  
  CR_amazonL_sec = readRDS(paste0("regrowthModel_amazon_basin_sec_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_amazonM_sec =readRDS( paste0("regrowthModel_amazon_basin_sec_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_amazonH_sec =readRDS( paste0("regrowthModel_amazon_basin_sec_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  CR_borneoL_sec =readRDS( paste0("regrowthModel_borneo_sec_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_borneoM_sec =readRDS( paste0("regrowthModel_borneo_sec_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_borneoH_sec =readRDS( paste0("regrowthModel_borneo_sec_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  CR_congoL_sec =readRDS( paste0("regrowthModel_congo_basin_sec_",variable_str,"_low_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_congoM_sec =readRDS( paste0("regrowthModel_congo_basin_sec_",variable_str,"_mid_agb_fix_noOilPalm_2022-08-23.rds"))
  CR_congoH_sec =readRDS( paste0("regrowthModel_congo_basin_sec_",variable_str,"_high_agb_fix_noOilPalm_2022-08-23.rds"))
  
  
  secondary_data_sec = read.csv(paste0("overall_stats_all_basins_secondary_for_",variable_str,"_agb_fix.csv"))
  minmax_limits_sec = read.csv(paste0("minmax_limits_all_basins_secondary_for_",variable_str,"_agb_fix.csv"))

  minmax_table_sec=minmax_limits_sec
  minmax_table_sec$mean = ((minmax_table_sec$max - minmax_table_sec$min)/2) + minmax_table_sec$min
  
  
  amzL_data_sec = secondary_data_sec[secondary_data_sec$biome == "amazon_basin" & secondary_data_sec$group == "< 120m",]
  amzM_data_sec = secondary_data_sec[secondary_data_sec$biome == "amazon_basin" & secondary_data_sec$group == "120m to 1000m",]
  amzH_data_sec = secondary_data_sec[secondary_data_sec$biome == "amazon_basin" & secondary_data_sec$group == "1000m+",]
  
  borL_data_sec = secondary_data_sec[secondary_data_sec$biome == "borneo" & secondary_data_sec$group == "< 120m",]
  borM_data_sec = secondary_data_sec[secondary_data_sec$biome == "borneo" & secondary_data_sec$group == "120m to 1000m",]
  borH_data_sec = secondary_data_sec[secondary_data_sec$biome == "borneo" & secondary_data_sec$group == "1000m+",]
  
  conL_data_sec = secondary_data_sec[secondary_data_sec$biome == "congo_basin" & secondary_data_sec$group == "< 120m",]
  conM_data_sec = secondary_data_sec[secondary_data_sec$biome == "congo_basin" & secondary_data_sec$group == "120m to 1000m",]
  conH_data_sec = secondary_data_sec[secondary_data_sec$biome == "congo_basin" & secondary_data_sec$group == "1000m+",]
  
  amzH_data_sec = amzH_data_sec[amzH_data_sec$age >0,]
  conH_data_sec = conH_data_sec[conH_data_sec$age !=15,]
  
  
  amzL_data_sec$weighted_median_C = amzL_data_sec$weighted_median - min(amzL_data_sec$weighted_median)
  amzM_data_sec$weighted_median_C = amzM_data_sec$weighted_median - min(amzM_data_sec$weighted_median)
  amzH_data_sec$weighted_median_C = amzH_data_sec$weighted_median - min(amzH_data_sec$weighted_median)
  
  borL_data_sec$weighted_median_C = borL_data_sec$weighted_median - min(borL_data_sec$weighted_median)
  borM_data_sec$weighted_median_C = borM_data_sec$weighted_median - min(borM_data_sec$weighted_median)
  borH_data_sec$weighted_median_C = borH_data_sec$weighted_median - min(borH_data_sec$weighted_median)
  
  
  conL_data_sec$weighted_median_C = conL_data_sec$weighted_median - min(conL_data_sec$weighted_median)
  conM_data_sec$weighted_median_C = conM_data_sec$weighted_median - min(conM_data_sec$weighted_median)
  conH_data_sec$weighted_median_C = conH_data_sec$weighted_median - min(conH_data_sec$weighted_median)

  labelAmz_sec = minmax_table_sec[minmax_table_sec$biome == "amazon_basin",]
  labelAmz_sec = labelAmz_sec[c(1,3,2),]
  
  labelBor_sec = minmax_table_sec[minmax_table_sec$biome == "borneo",]
  labelBor_sec = labelBor_sec[c(1,3,2),]
  
  labelCon_sec = minmax_table_sec[minmax_table_sec$biome == "congo_basin",]
  labelCon_sec = labelCon_sec[c(1,3,2),]
  
  
  simp_amzL_sec = simple_growth_rate(CR_amazonL_sec, 300, "secondary")
  simp_amzM_sec = simple_growth_rate(CR_amazonM_sec, 300, "secondary")
  simp_amzH_sec = simple_growth_rate(CR_amazonH_sec, 300, "secondary")
  
  simp_borL_sec = simple_growth_rate(CR_borneoL_sec, 300, "secondary")
  simp_borM_sec = simple_growth_rate(CR_borneoM_sec, 300, "secondary")
  simp_borH_sec = simple_growth_rate(CR_borneoH_sec, 300, "secondary")
  
  simp_conL_sec = simple_growth_rate(CR_congoL_sec, 300, "secondary")
  simp_conM_sec = simple_growth_rate(CR_congoM_sec, 300, "secondary")
  simp_conH_sec = simple_growth_rate(CR_congoH_sec, 300, "secondary")
  
  amz_sec = calc_kruskal_wallis(simp_amzL_sec, simp_amzM_sec, simp_amzH_sec)
  bor_sec = calc_kruskal_wallis(simp_borL_sec, simp_borM_sec, simp_borH_sec)
  con_sec = calc_kruskal_wallis(simp_conL_sec, simp_conM_sec, simp_conH_sec)
  
  plot_recovery(variable_str,"Amazon", CR_amazonL_sec, CR_amazonM_sec, CR_amazonH_sec, labelAmz_sec, "secondary", AGB_amazon, AGB_amazon, AGB_amazon, T, T, "a. ")
  
  ################### Figure #######################
  
  results_folder2 = "C:\\Users\\ky18705\\OneDrive - University of Bristol\\Brazil_trip_2019\\Chapter3_analysis\\results\\"
  
  setwd(results_folder2)
  #pdf(paste0('regrowth_by_',variable_str,'.jpg'), width = 7.5, height = 6)
  #jpeg(paste0('regrowth_by_',variable_str, '_',Sys.Date(),'.jpg'), res = 600, width = 7.5, height = 6, units = 'in')
  svg(paste0('regrowth_by_',variable_str, '_',format_sys_time(),'.svg'), width = 7.5, height = 6)
  
  par(mfrow = c(3,2), mar=c(0.7, 0.5, 1.0, 0.2), oma = c(4, 5, 0.5, 0.2), xpd = NA) # (bottom, left, top, right) #orig: mar=c(0.5, 0.5, 0.2, 0.2)
  par(family = "sans")
  
  plot_recovery(variable_str,"Amazon", CR_amazonL_deg, CR_amazonM_deg, CR_amazonH_deg, labelAmz_deg, "degraded", AGB_amazon, AGB_amazon, AGB_amazon, F, T, "a.")
  plot_recovery(variable_str,"Amazon", CR_amazonL_sec, CR_amazonM_sec, CR_amazonH_sec, labelAmz_sec, "secondary", AGB_amazon, AGB_amazon, AGB_amazon, F, F,  "b.")
  
  plot_recovery(variable_str,"Borneo", CR_borneoL_deg, CR_borneoM_deg, CR_borneoH_deg, labelBor_deg, "degraded", AGB_borneo, AGB_borneo, AGB_borneo, F, T, "c.")
  plot_recovery(variable_str,"Borneo", CR_borneoL_sec, CR_borneoM_sec, CR_borneoH_sec, labelBor_sec, "secondary", AGB_borneo, AGB_borneo, AGB_borneo, F, F,  "d.")
  
  plot_recovery(variable_str,"Central Africa", CR_congoL_deg, CR_congoM_deg, CR_congoH_deg, labelCon_deg, "degraded", AGB_congo, AGB_congo, AGB_congo, T, T,  "e.")
  plot_recovery(variable_str,"Central Africa", CR_congoL_sec, CR_congoM_sec, CR_congoH_sec, labelCon_sec, "secondary", AGB_congo, AGB_congo, AGB_congo, T, F,  "f.")
  mtext(expression('AGC (Mg C ha'^-1*')'),side=2,line=2,outer=TRUE,cex=1,las=0)
  mtext("Years since last disturbance event",side=1,line=2,outer=TRUE,cex=1)
  
  
  dev.off()
  
  jpeg(paste0('regrowth_by_',variable_str, '_',format_sys_time(),'.jpg'), res = 600, width = 7.5, height = 6, units = 'in')

  par(mfrow = c(3,2), mar=c(0.7, 0.5, 1.0, 0.2), oma = c(4, 5, 0.5, 0.2), xpd = NA) # (bottom, left, top, right) #orig: mar=c(0.5, 0.5, 0.2, 0.2)
  par(family = "sans")
  
  plot_recovery("Amazon", CR_amazonL_deg, CR_amazonM_deg, CR_amazonH_deg, labelAmz_deg, "degraded", AGB_amazon, AGB_amazon, AGB_amazon, F, T, "a.")
  plot_recovery("Amazon", CR_amazonL_sec, CR_amazonM_sec, CR_amazonH_sec, labelAmz_sec, "secondary", AGB_amazon, AGB_amazon, AGB_amazon, F, F,  "b.")
  
  plot_recovery("Borneo", CR_borneoL_deg, CR_borneoM_deg, CR_borneoH_deg, labelBor_deg, "degraded", AGB_borneo, AGB_borneo, AGB_borneo, F, T, "c.")
  plot_recovery("Borneo", CR_borneoL_sec, CR_borneoM_sec, CR_borneoH_sec, labelBor_sec, "secondary", AGB_borneo, AGB_borneo, AGB_borneo, F, F,  "d.")
  
  plot_recovery("Central Africa", CR_congoL_deg, CR_congoM_deg, CR_congoH_deg, labelCon_deg, "degraded", AGB_congo, AGB_congo, AGB_congo, T, T,  "e.")
  plot_recovery("Central Africa", CR_congoL_sec, CR_congoM_sec, CR_congoH_sec, labelCon_sec, "secondary", AGB_congo, AGB_congo, AGB_congo, T, F,  "f.")
  
  dev.off()
  
  secondary_data_sec$type = "Secondary"
  degraded_data_deg$type = "Degraded"
  both_data = rbind(secondary_data_sec, degraded_data_deg)
  
  distance_spread = both_data %>%
    group_by(biome, group, type) %>% 
    summarise(freq2 = sum(freq))
  
  distance_spread2 = distance_spread %>%
    group_by(biome, type) %>% 
    mutate(percentage = (freq2/sum(freq2)*100)) %>%
    ungroup
  
  
  biomes = c("Amazon", "Borneo", "Central Africa")
  names(biomes) = c("amazon_basin", "borneo", "congo_basin")
  
  stacked_bar = ggplot(data = distance_spread2, aes(x = type, y = percentage, fill = factor(group, levels = c("< 120m", "120m to 1000m", "1000m+")))) +
    geom_bar(stat = "identity") +
    geom_text(aes(label = round(percentage)),position = position_stack(vjust = 0.5))+
    guides(fill = guide_legend(title = "Distance from \n undisturbed forest"))+
    facet_grid(~biome, labeller = labeller(biome=biomes)) +
    ylab("Percentage (%)") +
    xlab("Forest Type") +
    theme_bw() +
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
          axis.text.x = element_text(color="black", size=12),axis.text.y = element_text(color="black", size=12),
          text=element_text(size=12),)+
    theme(text = element_text(size=12))
  
  print(stacked_bar)
  
}

