library(pgirmess)
require(investr)
library(qpcR)
library(nlstools)
library(dplyr)
library(ggplot2)
library(matrixStats)
library(car)
library(lmtest)

#https://rdrr.io/github/mtcruz/mtcruzr/man/format_sys_time.html
library(mtcruzr)

library(plotrix)
library(stats)


#library(inauguration)
#colBar=inauguration("inauguration_2021")

########################## Purpose of code #######################
#This code will read in the nls models in the format of .rds files created in step 3 to create the Figure 1

#----------------------------------------------------------------#


########## All my functions ############

variable_table = function(variable_files){
  age_list = list()
  for (i in (1:length(variable_files))){
    print(i)
    file = variable_files[i]
    print(file)
    dbf_data = foreign::read.dbf(file)
    colnames(dbf_data) = c("Value", "Count")
    age_list[[i]] = dbf_data
  }
  data_merge = Reduce(function(x,y)merge (x, y, by="Value",all=TRUE), age_list)
  
  return(data_merge)
}

variable_table_V2 = function(variable_files){
  age_list = list()
  for (i in (1:length(variable_files))){
    print(i)
    file = variable_files[i]
    print(file)
    dbf_data = foreign::read.dbf(file)
    #colnames(dbf_data) = c("Value", "Count")
    age_list[[i]] = dbf_data
  }
  #data_merge = Reduce(function(x,y)merge (x, y, by="Value",all=TRUE), age_list)
  data_merge =  do.call(rbind, age_list)
  return(data_merge)
}

old_AGB = function(biome_str) {
  
  main_folder = "D:\\Chapter3\\JRC_recovery\\"
  folder = paste0(main_folder,"\\",biome_str, "_oldG_AGB", "\\")
  setwd(folder)
  if (biome_str == "atlantic"){
    pattern_name = paste0('ESA_AGB_large_patches_undist_TMF_.*.dbf$')
  } else{
    pattern_name = paste0('ESA_AGB_fix_undist_TMF_.*.dbf$')
  }
  all_files = list.files(pattern = pattern_name, full.names = T)
  print(all_files)
  
  agb_old = variable_table(all_files)
  if (biome_str != "borneo"){
    agb_old$sum = rowSums(agb_old[, -1] ,na.rm=TRUE)
    agb_old = agb_old[agb_old$Value>0,]
    weighted_median = weightedMedian(agb_old$Value, agb_old$sum)
  } else{
    agb_old = agb_old[agb_old$Value>0,]
    colnames(agb_old) = c("Value", "sum")
    weighted_median = weightedMedian(agb_old$Value, agb_old$sum)
  }
  
  return(weighted_median)
}

plot_recovery = function(Biome, modelL, modelM, modelH, label_df, forest_type){
  
  units = expression(" Mg C"~ha^-1)
  stats1=simple_growth_rate(modelL, 300, forest_type)
  stats2=simple_growth_rate(modelM, 300, forest_type)
  stats3=simple_growth_rate(modelH, 300, forest_type)
  str1 = toString(label_df$label[1])
  #r1 = round(stats1$Av20yrRate, 2)
  

  open_bracket = "("
  close_bracket = ")"
  leg1 = bquote(.(toString(label_df$label[1])) ~ .(open_bracket) * .(toString(round(stats1$Av20yrRate, 2))) ~"Mg C" ~ ha^-1 * .(close_bracket))
  leg2 = bquote(.(toString(label_df$label[2])) ~ .(open_bracket) * .(toString(round(stats2$Av20yrRate, 2))) ~"Mg C" ~ ha^-1 * .(close_bracket))
  leg3 = bquote(.(toString(label_df$label[3])) ~ .(open_bracket) * .(toString(round(stats3$Av20yrRate, 2))) ~"Mg C" ~ ha^-1 * .(close_bracket))

  

  if (forest_type == "degraded"){
    maintitle = paste("Recovery in Degraded Forests,",Biome)
    xlims = c(1,40)
    ylims = c(0.5,140)
  } else if (forest_type == "secondary"){
    maintitle = paste("Regrowth in Secondary Forests,",Biome) 
    xlims = c(0,40)
    ylims = c(0,140)
  } else if (forest_type == "plantation"){
    maintitle = paste("Recovery in Plantation Forests,",Biome)
    xlims = c(1,40)
    ylims = c(0.5,140)
  }
  
  print(maintitle)
  
  par(mar=c(5,6,4,1)+.05)
  plotFit(modelL,col = "#18BECF",interval="confidence",xlim=xlims,ylim=ylims,pch=19,col.fit = "#18BECF", col.conf=adjustcolor("#18BECF", 0.3), shade=TRUE,  xlab = '',  xaxt="n",yaxt="n", ylab='')
  par(new = TRUE, mar=c(5,6,4,1)+.05)
  plotFit(modelM,col = "#BCBD23",interval="confidence",xlim=xlims,ylim=ylims,pch=19,col.fit= "#BCBD23",col.conf=adjustcolor("#BCBD23", 0.3), shade=TRUE,  xlab = '', ylab='',  xaxt="n",yaxt="n")
  par(new = TRUE, mar=c(5,6,4,1)+.05)
  plotFit(modelH,col = "#7F7F7F",interval="confidence",xlim=xlims,ylim=ylims,pch=19,col.fit= "#7F7F7F",col.conf=adjustcolor("#7F7F7F", 0.3),
          las =1,
          cex.lab = 1.5,
          
          cex.axis = 1.5,
          cex.main = 1.25,
          cex.sub = 1.5,
          shade=TRUE,  xlab='Years since last disturbance',  ylab=expression('AGC (Mg C ha'^-1*')'))
  #legend("topleft", inset = 0.01,legend=(c("Lower 25%", "Middle 50%", "Upper 25%")),
  #      col=c("#18BECF", "#BCBD23", "#7F7F7F"), pch = 19, box.lty = 0, bg="transparent", cex=1.25, pt.cex=1.25)
  if ("secondary" %in% forest_type){
    legend("topleft", inset = 0.01,legend=(c(as.expression(leg1), as.expression(leg2), as.expression(leg3))),
           col=c("#18BECF", "#BCBD23", "#7F7F7F"), pch = 19, box.lty = 0, bg="transparent", cex=1.25, pt.cex=1.25)
  } else (legend("bottomright", inset = 0.01,legend=(c(as.expression(leg1), as.expression(leg2), as.expression(leg3))),
                 col=c("#18BECF", "#BCBD23", "#7F7F7F"), pch = 19, box.lty = 0, bg="transparent", cex=1.25, pt.cex=1.25)
  )
  title(maintitle, line =0.5, cex.main=1.4, font.main =1)
  
}

simple_growth_rate = function(model_nls, agemax, forest_type, old_AGB){
  
  age = data.frame(age=seq(1, agemax, 1))
  params=model_nls$m$getPars()
  A = model_nls$call$formula[[3]][[2]]
  
  if(A == "theta1"){
    print(paste0("Theta1 never reached, applying theta1 found by model"))
    Y = bquote((.(params[[1]])*(1-exp(-(.(params[[2]])*t)))^.(params[[3]])))
  } else {
    Y = bquote((.(A)*(1-exp(-(.(params[[1]])*t)))^.(params[[2]])))}
  
  print(paste0(params[[1]]))
  print(paste0(params[[2]]))
  dy.dt = deriv(Y,"t", func=T)
  
  model_deriv=dy.dt(age)
  growth_rate=attr(model_deriv, "gradient")
  age["growth.rate"] = growth_rate
  
  if (forest_type != "secondary"){
    # do not include 0 as we do not want to start at 0 for degraded and plantation forest at least
    mean_growth = mean(age$growth.rate[2:21])
  } else if (forest_type == "secondary"){
    mean_growth = mean(age$growth.rate[1:20])
    
  }
  #asymptote_max = which.min(age$growth.rate[which(age$growth.rate > 0.05)])
  
  #asymptote_min = which.min(age$growth.rate[which(age$growth.rate > 1.0)])
  
  # Determine the average regrowth rate as a %
  age2 = data.frame(age=seq(1, agemax, 1))
  
  asPerc=data.frame("age" = age2,"AGC"=predict(model_nls, age2))
  
  asPerc$AGCperc = asPerc$AGC/(old_AGB*0.456)*100
  asPerc$AGCpercDiff = 1
  asPerc = mutate(asPerc, AGCpercDiff = lag(AGCperc) - AGCperc)
  
  av_20yrPerc=-mean(na.omit(asPerc$AGCpercDiff[1:20]))
  
  asPerc$percRound = round(asPerc$AGCperc)
  perc95 = asPerc[asPerc$percRound == 95,]
  avAsym = mean(perc95$age)
  minAsym = min(perc95$age)
  maxAsym = max(perc95$age)
  
  
  outputs = list("age_growth" = age, "PFasymptote_mean" = avAsym, "PFasymptote_min" = minAsym, "PFasymptote_max" = maxAsym, "Av20yrRate" = mean_growth, "Av20yrPercR" = av_20yrPerc, "growth_rate"=age$growth.rate, "AGC_output" = asPerc)
  
  return(outputs)
}


AGB_borneo = old_AGB("borneo")
AGB_amazon_basin = old_AGB("amazon_basin")
#AGB_atlantic = old_AGB("atlantic")
AGB_congo = old_AGB("congo_basin")

main_folder = "D:\\Chapter3\\JRC_recovery\\results"
setwd(main_folder)
names = c("Amazon", "Borneo", "Central Africa")

################## Degraded Forest ####################
degraded_borneo = read.csv("overall_stats_borneo_degraded_for.csv")
degraded_amazon_basin = read.csv("overall_stats_amazon_basin_degraded_for.csv")
degraded_congo = read.csv("overall_stats_congo_basin_degraded_for.csv")


degraded_borneo = degraded_borneo[degraded_borneo$age <37,]
degraded_amazon_basin = degraded_amazon_basin[degraded_amazon_basin$age <37,]
degraded_congo = degraded_congo[degraded_congo$age <37,]


CR_amazon_basin_deg=readRDS("regrowthModel_amazon_basin_deg.rds")
CR_borneo_deg=readRDS("regrowthModel_borneo_deg.rds")
CR_congo_deg=readRDS("regrowthModel_congo_basin_deg.rds")

qpcR::RMSE(CR_amazon_basin_deg)
qpcR::RMSE(CR_borneo_deg)
qpcR::RMSE(CR_congo_deg)



amz_deg = simple_growth_rate(CR_amazon_basin_deg, 300, "degraded", AGB_amazon_basin)
born_deg = simple_growth_rate(CR_borneo_deg, 300, "degraded", AGB_borneo)
congo_deg = simple_growth_rate(CR_congo_deg, 300, "degraded", AGB_congo)


open_bracket = "("
close_bracket = ")"
#legAm_deg = bquote(.(toString(names[1])) ~ .(open_bracket) * .(toString(round(amz_deg$Av20yrRate, 2))) ~"Mg C" ~ ha^-1 ~ yr^-1* .(close_bracket))
#legBor_deg = bquote(.(toString(names[2])) ~ .(open_bracket) * .(toString(round(born_deg$Av20yrRate, 2))) ~"Mg C" ~ ha^-1 ~ yr^-1* .(close_bracket))
#legCon_deg = bquote(.(toString(names[3])) ~ .(open_bracket) * .(toString(round(congo_deg$Av20yrRate, 2))) ~"Mg C" ~ ha^-1 ~ yr^-1 * .(close_bracket))


legAm_deg = bquote(.(toString(names[1])))
legBor_deg = bquote(.(toString(names[2])))
legCon_deg = bquote(.(toString(names[3])))


pred_borneo_deg = data.frame("values" = born_deg$growth_rate)
pred_borneo_deg$biome = "Borneo"

pred_amz_deg = data.frame("values" = amz_deg$growth_rate)
pred_amz_deg$biome = "Amazon"

pred_con_deg = data.frame("values" = congo_deg$growth_rate)
pred_con_deg$biome = "Congo"

all_deg = rbind(pred_amz_deg, pred_borneo_deg, pred_con_deg)

KW_biomass_region_deg=kruskalmc(all_deg$values,all_deg$biome, probs = 0.05)


# amz_col = colBar[1]
# bor_col = colBar[2]
# con_col = colBar[3]

amz_col = "#18BECF" 
bor_col = "#BCBD23" 
con_col = "#7F7F7F"


################### Secondary Forest ######################

secondary_borneo = read.csv("overall_stats_borneo_secondary_for.csv")
secondary_amazon_basin = read.csv("overall_stats_amazon_basin_secondary_for.csv")
secondary_congo = read.csv("overall_stats_congo_basin_secondary_for.csv")

secondary_borneo = secondary_borneo[secondary_borneo$age <37,]
secondary_amazon_basin = secondary_amazon_basin[secondary_amazon_basin$age <37,]
secondary_congo = secondary_congo[secondary_congo$age <37,]



secondary_borneo$weighted_median_C = secondary_borneo$weighted_median - min(secondary_borneo$weighted_median)
secondary_amazon_basin$weighted_median_C = secondary_amazon_basin$weighted_median - min(secondary_amazon_basin$weighted_median)
secondary_congo$weighted_median_C = secondary_congo$weighted_median - min(secondary_congo$weighted_median)


CR_amazon_basin_sec=readRDS("regrowthModel_amazon_basin_sec.rds")
CR_borneo_sec=readRDS("regrowthModel_borneo_sec.rds")
CR_congo_sec=readRDS("regrowthModel_congo_basin_sec.rds")


born_sec = simple_growth_rate(CR_borneo_sec, 300, "secondary", AGB_borneo)
amz_sec = simple_growth_rate(CR_amazon_basin_sec, 300, "secondary", AGB_amazon_basin)
congo_sec = simple_growth_rate(CR_congo_sec, 300, "secondary", AGB_congo)

qpcR::RMSE(CR_amazon_basin_sec)
qpcR::RMSE(CR_borneo_sec)
qpcR::RMSE(CR_congo_sec)

pred_borneo_sec = data.frame("values" = born_sec$growth_rate)
pred_borneo_sec$biome = "Borneo"

pred_amz_sec = data.frame("values" = amz_sec$growth_rate)
pred_amz_sec$biome = "Amazon"

pred_con_sec = data.frame("values" = congo_sec$growth_rate)
pred_con_sec$biome = "Congo"

all_sec = rbind(pred_amz_sec, pred_borneo_sec, pred_con_sec)

KW_biomass_region=kruskalmc(all_sec$values,all_sec$biome, probs = 0.05)



open_bracket = "("
close_bracket = ")"
#legAm_sec = bquote(.(toString(names[1])) ~ .(open_bracket) * .(toString(round(amz_sec$Av20yrRate, 2))) ~"Mg C" ~ ha^-1 ~ yr^-1* .(close_bracket))
#legBor_sec = bquote(.(toString(names[2])) ~ .(open_bracket) * .(toString(round(born_sec$Av20yrRate, 2))) ~"Mg C" ~ ha^-1 ~ yr^-1* .(close_bracket))
#legCon_sec = bquote(.(toString(names[3])) ~ .(open_bracket) * .(toString(round(congo_sec$Av20yrRate, 2))) ~"Mg C" ~ ha^-1 ~ yr^-1 * .(close_bracket))

legAm_sec = bquote(.(toString(names[1])))
legBor_sec = bquote(.(toString(names[2])))
legCon_sec = bquote(.(toString(names[3])))

############# read in MC old-growth forest ranges to plot on graph
old_g_borneo=read.csv("monte_carlo_old_growth_ranges_borneo.csv")
old_g_amz=read.csv("monte_carlo_old_growth_ranges_amazon_basin.csv")
old_g_congo=read.csv("monte_carlo_old_growth_ranges_congo_basin.csv")


################# Fig 1 plot ######################

#################### Figure 1 - plotting ####################
#svg(paste0('Fig1_',Sys.Date(),'.svg'), width = 9, height = 5)


results_folder2 = "change to your results folder using \\"

setwd(results_folder2)

jpeg(paste0('Fig1_',Sys.Date(),'.jpg'), width = 9, height = 5, units = "in", res = 600)
par(mfrow = c(1,2), mar=c(0.7, 0.5, 1.0, 0.2), oma = c(4, 5, 0.2, 0.2),  xpd = NA) # (bottom, left, top, right) #orig: mar=c(0.5, 0.5, 0.2, 0.2)
plotFit(CR_amazon_basin_deg,data=degraded_amazon_basin,col = amz_col,interval="confidence",xlim=c(1,50),ylim=c(0.5,140),pch=19,cex = 0.5, col.fit= amz_col, lwd.fit=2.5,col.conf=adjustcolor(amz_col, 0.3), shade=TRUE,  xlab = '', ylab='',  xaxt="n",yaxt="n")
axis(side = 1, labels=F, tck = -0.03)
par(new = TRUE)
plotFit(CR_congo_deg,data=degraded_congo,col = con_col,interval="confidence",xlim=c(1,50),ylim=c(0.5,140),pch=19,cex = 0.5,col.fit = con_col, lwd.fit=2.5, col.conf=adjustcolor(con_col, 0.3), shade=TRUE,  xlab = '',  xaxt="n",yaxt="n", ylab='')
par(new = TRUE)
plotFit(CR_borneo_deg,data=degraded_borneo,col = bor_col,interval="confidence",xlim=c(1,50),ylim=c(0.5,140),pch=19,cex = 0.5,col.fit= bor_col, lwd.fit=2.5,col.conf=adjustcolor(bor_col, 0.3),
        las =1,
        cex.lab = 1.25,
        
        cex.axis = 1.25,
        cex.sub = 1.5,  xaxt="n",
        shade=TRUE,  xlab='',  ylab="")
rect(xleft = 44, xright = 51, ybottom = 0, ytop = 140, col = "white", border ="white")
par(new = TRUE)
plot(50, AGB_borneo*0.456, xlim=c(1,50),ylim=c(0.5,140), pch=4, col=bor_col, xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
axis(1, at = seq(0, 50, by = 10), labels = c(0, 10, 20, 30, 40, "OG"), cex.axis = 1.15)
par(new = TRUE)
plot(49, AGB_amazon_basin*0.456, xlim=c(1,50),ylim=c(0.5,140), pch=4, col=amz_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
plot(48, AGB_congo*0.456, xlim=c(1,50),ylim=c(0.5,140), pch=4, col=con_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
arrows(x0 = 50,x1 = 50, y0=min(old_g_borneo$old_vals)*0.456, y1=max(old_g_borneo$old_vals)*0.456, angle=90,code=3,length=0.00,col = bor_col, lwd=2)
par(new = TRUE)
arrows(x0 = 49,x1 = 49, y0=min(old_g_amz$old_vals)*0.456, y1=max(old_g_amz$old_vals)*0.456, angle=90,code=3,length=0.00,col = amz_col, lwd=2)
par(new = TRUE)
arrows(x0 = 48,x1 = 48.0, y0=min(old_g_congo$old_vals)*0.456, y1=max(old_g_congo$old_vals)*0.456, angle=90,code=3,length=0.00,col = con_col, lwd=2)
par(new = TRUE)
# segments(x0=1, y0= AGB_borneo*0.456, x1=40, y1 = AGB_borneo*0.456,  lty = "longdash", col=bor_col, xlim = c(1, 40), xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=2)
# par(new = TRUE)
# segments(x0=1, y0= AGB_amazon_basin*0.456, x1=40, y1 = AGB_amazon_basin*0.456,  lty = "dashed", col=amz_col, xlim = c(1, 40), xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=2)
# par(new = TRUE)
# segments(x0=1, y0= AGB_congo*0.456, x1=40, y1 = AGB_congo*0.456,  lty = "dashed", col=con_col, xlim = c(1, 40), xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=2)
# par(new = TRUE)
plot(degraded_amazon_basin$age[1], degraded_amazon_basin$weighted_median[1]*0.456, col = "white", xlim=c(1,50),ylim=c(0.5,140), pch=19,  xlab = '', ylab='',  xaxt="n",yaxt="n")
par(new = TRUE)
plot(degraded_congo$age[1], degraded_congo$weighted_median[1]*0.456, col = "white", xlim=c(1,50),ylim=c(0.5,140), pch=19,  xlab = '', ylab='',  xaxt="n",yaxt="n")
par(new = TRUE)
plot(degraded_borneo$age[1], degraded_borneo$weighted_median[1]*0.456, col = "white", xlim=c(1,50),ylim=c(0.5,140), pch=19,  xlab = '', ylab='',  xaxt="n",yaxt="n")
par(new = TRUE)
axis.break(axis = 1, 45,style="slash") 
#axis(1, at = seq(0, 50, by = 10), labels = c(NA, NA, NA, NA, NA, "Old growth"), cex.axis = 1)
#axis.break(axis = 1, 45,style="slash") 


# Add a legend
#title("Recovery in Degraded Forests", line =0.5, cex.main=1.4, font.main =1)
mtext(text = bquote(bold(.("a ")) ~ .("Recovering Degraded Forest")), line=0, adj=0.0, cex=1.05)  
#title("a", font= 2,adj=0.01,line =0.4, cex.main=1.5, font.main =1, family = "sans")
#title("a", font= 2,adj=0.01,line =0.4, cex.main=1.5, font.main =1, family = "sans")
# 
# par(new = TRUE)
# plot(39.5, AGB_borneo*0.456, xlim=c(1,40),ylim=c(0.5,140), pch=4, col=bor_col, xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
# par(new = TRUE)
# plot(40, AGB_amazon_basin*0.456, xlim=c(1,40),ylim=c(0.5,140), pch=4, col=amz_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
# par(new = TRUE)
# plot(40, AGB_congo*0.456, xlim=c(1,40),ylim=c(0.5,140), pch=4, col=con_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)

legend("bottomright", inset = 0.01,legend=(c(as.expression(legAm_deg), as.expression(legBor_deg), as.expression(legCon_deg), "Old growth forest")),
       col=c(amz_col, bor_col, con_col, "black"), pch = c(19, 19, 19, 4),  box.lty = 0, bg="transparent", cex=1.1, pt.cex=1.1)

### SF plot
plotFit(CR_amazon_basin_sec,data=secondary_amazon_basin,col = amz_col,interval="confidence",xlim=c(0,50),ylim=c(0.0,140),pch=19,cex = 0.5, col.fit= amz_col, lwd.fit=2.5,col.conf=adjustcolor(amz_col, 0.3), shade=TRUE,  xlab = '', ylab='',  xaxt="n",yaxt="n")
axis(side = 1, labels=F, tck = -0.03)
axis(side = 2, labels=F, tck = -0.03)
par(new = TRUE)
plotFit(CR_congo_sec,data=secondary_congo,col = con_col,interval="confidence",xlim=c(0,50),ylim=c(0.0,140),pch=19,cex = 0.5,col.fit = con_col, lwd.fit=2.5, col.conf=adjustcolor(con_col, 0.3), shade=TRUE,  xlab = '',  xaxt="n",yaxt="n", ylab='')
par(new = TRUE)
plotFit(CR_borneo_sec,data=secondary_borneo,col = bor_col,interval="confidence",xlim=c(0,50),ylim=c(0.0,140),pch=19,cex = 0.5,col.fit= bor_col, lwd.fit=2.5,col.conf=adjustcolor(bor_col, 0.3),
        las =1,
        cex.lab = 1.25,
        
        cex.axis = 1.25,
        cex.sub = 1.5, xaxt="n",
        shade=TRUE,  xlab='',   ylab='', yaxt="n")
rect(xleft = 44, xright = 51, ybottom = 0, ytop = 140, col = "white", border ="white")
axis(1, at = seq(0, 50, by = 10), labels = c(0, 10, 20, 30, 40, "OG"), cex.axis = 1.15)

# Add a legend
#title("Recovery in Secondary Forests", line =0.5, cex.main=1.4, font.main =1)
mtext(text = bquote(bold(.("b ")) ~ .("Recovering Secondary Forest")), line=0, adj=0.0, cex=1.05)  
mtext(expression('AGC (Mg C ha'^-1*')'),side=2,line=2,outer=TRUE,cex=1.25,las=0)
mtext("Years since last disturbance event",side=1,line=2,outer=TRUE,cex=1.25)

#title("b", font= 2,adj=0.01,line =0.4, cex.main=1.5, font.main =1, family = "sans")
#title("b", font= 2,adj=0.01,line =0.4, cex.main=1.5, font.main =1, family = "sans") # plot twice to make nice and bold
#title("b", font= 2,adj=0.01,line =0.4, cex.main=1.5, font.main =1, family = "sans")

par(new = TRUE)
# segments(x0=1, y0= AGB_borneo*0.456, x1=40, y1 = AGB_borneo*0.456,  lty = "longdash", col=bor_col, xlim = c(1, 40), xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=2)
# par(new = TRUE)
# segments(x0=1, y0= AGB_amazon_basin*0.456, x1=40, y1 = AGB_amazon_basin*0.456,  lty = "dashed", col=amz_col, xlim = c(1, 40), xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=2)
# par(new = TRUE)
# segments(x0=1, y0= AGB_congo*0.456, x1=40, y1 = AGB_congo*0.456,  lty = "dashed", col=con_col, xlim = c(1, 40), xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=2)


# par(new = TRUE)
plot(50, AGB_borneo*0.456, xlim=c(0,50),ylim=c(0.0,140), pch=4, col=bor_col, xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
plot(49, AGB_amazon_basin*0.456, xlim=c(0,50),ylim=c(0.0,140), pch=4, col=amz_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
plot(48, AGB_congo*0.456, xlim=c(0,50),ylim=c(0.0,140), pch=4, col=con_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
arrows(x0 = 50,x1 = 50, y0=min(old_g_borneo$old_vals)*0.456, y1=max(old_g_borneo$old_vals)*0.456, angle=90,code=3,length=0.00,col = bor_col, lwd=2)
par(new = TRUE)
arrows(x0 = 49,x1 = 49, y0=min(old_g_amz$old_vals)*0.456, y1=max(old_g_amz$old_vals)*0.456, angle=90,code=3,length=0.00,col = amz_col, lwd=2)
par(new = TRUE)
arrows(x0 = 48,x1 = 48.0, y0=min(old_g_congo$old_vals)*0.456, y1=max(old_g_congo$old_vals)*0.456, angle=90,code=3,length=0.00,col = con_col, lwd=2)
par(new = TRUE)
axis.break(axis = 1, 45,style="slash") 
#axis(1, at = seq(0, 50, by = 10), labels = c(NA, NA, NA, NA, NA, "Old growth"), cex.axis = 1)
#axis.break(axis = 1, 45,style="slash") 

# par(new = TRUE)
# legend("topleft", inset = 0.01,legend=(c(as.expression(legAm_sec), as.expression(legBor_sec), as.expression(legCon_sec))),
#        col=c(amz_col, bor_col, con_col), pch = 19, box.lty = 0, bg="transparent", cex=1.1, pt.cex=1.1)

dev.off()


################## Save as a vector type #######################
svg(paste0('Fig1_',Sys.Date(),'.svg'), width = 9, height = 5)
par(mfrow = c(1,2), mar=c(0.7, 0.5, 1.0, 0.2), oma = c(4, 5, 0.2, 0.2),  xpd = NA) # (bottom, left, top, right) #orig: mar=c(0.5, 0.5, 0.2, 0.2)
plotFit(CR_amazon_basin_deg,data=degraded_amazon_basin,col = amz_col,interval="confidence",xlim=c(1,50),ylim=c(0.5,140),pch=19,cex = 0.5, col.fit= amz_col, lwd.fit=2.5,col.conf=adjustcolor(amz_col, 0.3), shade=TRUE,  xlab = '', ylab='',  xaxt="n",yaxt="n")
axis(side = 1, labels=F, tck = -0.03)
par(new = TRUE)
plotFit(CR_congo_deg,data=degraded_congo,col = con_col,interval="confidence",xlim=c(1,50),ylim=c(0.5,140),pch=19,cex = 0.5,col.fit = con_col, lwd.fit=2.5, col.conf=adjustcolor(con_col, 0.3), shade=TRUE,  xlab = '',  xaxt="n",yaxt="n", ylab='')
par(new = TRUE)
plotFit(CR_borneo_deg,data=degraded_borneo,col = bor_col,interval="confidence",xlim=c(1,50),ylim=c(0.5,140),pch=19,cex = 0.5,col.fit= bor_col, lwd.fit=2.5,col.conf=adjustcolor(bor_col, 0.3),
        las =1,
        cex.lab = 1.25,
        
        cex.axis = 1.25,
        cex.sub = 1.5,  xaxt="n",
        shade=TRUE,  xlab='',  ylab="")
rect(xleft = 44, xright = 51, ybottom = 0, ytop = 140, col = "white", border ="white")
par(new = TRUE)
plot(50, AGB_borneo*0.456, xlim=c(1,50),ylim=c(0.5,140), pch=4, col=bor_col, xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
axis(1, at = seq(0, 50, by = 10), labels = c(0, 10, 20, 30, 40, "OG"), cex.axis = 1.15)
par(new = TRUE)
plot(49, AGB_amazon_basin*0.456, xlim=c(1,50),ylim=c(0.5,140), pch=4, col=amz_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
plot(48, AGB_congo*0.456, xlim=c(1,50),ylim=c(0.5,140), pch=4, col=con_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
arrows(x0 = 50,x1 = 50, y0=min(old_g_borneo$old_vals)*0.456, y1=max(old_g_borneo$old_vals)*0.456, angle=90,code=3,length=0.00,col = bor_col, lwd=2)
par(new = TRUE)
arrows(x0 = 49,x1 = 49, y0=min(old_g_amz$old_vals)*0.456, y1=max(old_g_amz$old_vals)*0.456, angle=90,code=3,length=0.00,col = amz_col, lwd=2)
par(new = TRUE)
arrows(x0 = 48,x1 = 48.0, y0=min(old_g_congo$old_vals)*0.456, y1=max(old_g_congo$old_vals)*0.456, angle=90,code=3,length=0.00,col = con_col, lwd=2)
par(new = TRUE)

plot(degraded_amazon_basin$age[1], degraded_amazon_basin$weighted_median[1]*0.456, col = "white", xlim=c(1,50),ylim=c(0.5,140), pch=19,  xlab = '', ylab='',  xaxt="n",yaxt="n")
par(new = TRUE)
plot(degraded_congo$age[1], degraded_congo$weighted_median[1]*0.456, col = "white", xlim=c(1,50),ylim=c(0.5,140), pch=19,  xlab = '', ylab='',  xaxt="n",yaxt="n")
par(new = TRUE)
plot(degraded_borneo$age[1], degraded_borneo$weighted_median[1]*0.456, col = "white", xlim=c(1,50),ylim=c(0.5,140), pch=19,  xlab = '', ylab='',  xaxt="n",yaxt="n")
par(new = TRUE)
axis.break(axis = 1, 45,style="slash") 
mtext(text = bquote(bold(.("a ")) ~ .("Recovering Degraded Forest")), line=0, adj=0.0, cex=1.05)  
par(new = TRUE)
legend("bottomright", inset = 0.01,legend=(c(as.expression(legAm_deg), as.expression(legBor_deg), as.expression(legCon_deg), "Old growth forest")),
       col=c(amz_col, bor_col, con_col, "black"), pch = c(19, 19, 19, 4),  box.lty = 0, bg="transparent", cex=1.1, pt.cex=1.1)

### SF plot
plotFit(CR_amazon_basin_sec,data=secondary_amazon_basin,col = amz_col,interval="confidence",xlim=c(0,50),ylim=c(0.0,140),pch=19,cex = 0.5, col.fit= amz_col, lwd.fit=2.5,col.conf=adjustcolor(amz_col, 0.3), shade=TRUE,  xlab = '', ylab='',  xaxt="n",yaxt="n")
axis(side = 1, labels=F, tck = -0.03)
axis(side = 2, labels=F, tck = -0.03)
par(new = TRUE)
plotFit(CR_congo_sec,data=secondary_congo,col = con_col,interval="confidence",xlim=c(0,50),ylim=c(0.0,140),pch=19,cex = 0.5,col.fit = con_col, lwd.fit=2.5, col.conf=adjustcolor(con_col, 0.3), shade=TRUE,  xlab = '',  xaxt="n",yaxt="n", ylab='')
par(new = TRUE)
plotFit(CR_borneo_sec,data=secondary_borneo,col = bor_col,interval="confidence",xlim=c(0,50),ylim=c(0.0,140),pch=19,cex = 0.5,col.fit= bor_col, lwd.fit=2.5,col.conf=adjustcolor(bor_col, 0.3),
        las =1,
        cex.lab = 1.25,
        
        cex.axis = 1.25,
        cex.sub = 1.5, xaxt="n",
        shade=TRUE,  xlab='',   ylab='', yaxt="n")
rect(xleft = 44, xright = 51, ybottom = 0, ytop = 140, col = "white", border ="white")
axis(1, at = seq(0, 50, by = 10), labels = c(0, 10, 20, 30, 40, "OG"), cex.axis = 1.15)

# Add a legend
#title("Recovery in Secondary Forests", line =0.5, cex.main=1.4, font.main =1)
mtext(text = bquote(bold(.("b ")) ~ .("Recovering Secondary Forest")), line=0, adj=0.0, cex=1.05)  
mtext(expression('AGC (Mg C ha'^-1*')'),side=2,line=2,outer=TRUE,cex=1.25,las=0)
mtext("Years since last disturbance event",side=1,line=2,outer=TRUE,cex=1.25)

#title("b", font= 2,adj=0.01,line =0.4, cex.main=1.5, font.main =1, family = "sans")
#title("b", font= 2,adj=0.01,line =0.4, cex.main=1.5, font.main =1, family = "sans") # plot twice to make nice and bold
#title("b", font= 2,adj=0.01,line =0.4, cex.main=1.5, font.main =1, family = "sans")

par(new = TRUE)
# segments(x0=1, y0= AGB_borneo*0.456, x1=40, y1 = AGB_borneo*0.456,  lty = "longdash", col=bor_col, xlim = c(1, 40), xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=2)
# par(new = TRUE)
# segments(x0=1, y0= AGB_amazon_basin*0.456, x1=40, y1 = AGB_amazon_basin*0.456,  lty = "dashed", col=amz_col, xlim = c(1, 40), xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=2)
# par(new = TRUE)
# segments(x0=1, y0= AGB_congo*0.456, x1=40, y1 = AGB_congo*0.456,  lty = "dashed", col=con_col, xlim = c(1, 40), xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=2)


# par(new = TRUE)
plot(50, AGB_borneo*0.456, xlim=c(0,50),ylim=c(0.0,140), pch=4, col=bor_col, xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
plot(49, AGB_amazon_basin*0.456, xlim=c(0,50),ylim=c(0.0,140), pch=4, col=amz_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
plot(48, AGB_congo*0.456, xlim=c(0,50),ylim=c(0.0,140), pch=4, col=con_col,  xlab = '',  xaxt="n",yaxt="n", ylab='', lwd=4)
par(new = TRUE)
arrows(x0 = 50,x1 = 50, y0=min(old_g_borneo$old_vals)*0.456, y1=max(old_g_borneo$old_vals)*0.456, angle=90,code=3,length=0.00,col = bor_col, lwd=2)
par(new = TRUE)
arrows(x0 = 49,x1 = 49, y0=min(old_g_amz$old_vals)*0.456, y1=max(old_g_amz$old_vals)*0.456, angle=90,code=3,length=0.00,col = amz_col, lwd=2)
par(new = TRUE)
arrows(x0 = 48,x1 = 48.0, y0=min(old_g_congo$old_vals)*0.456, y1=max(old_g_congo$old_vals)*0.456, angle=90,code=3,length=0.00,col = con_col, lwd=2)
par(new = TRUE)
axis.break(axis = 1, 45,style="slash") 
#axis(1, at = seq(0, 50, by = 10), labels = c(NA, NA, NA, NA, NA, "Old growth"), cex.axis = 1)
#axis.break(axis = 1, 45,style="slash") 

# par(new = TRUE)
# legend("topleft", inset = 0.01,legend=(c(as.expression(legAm_sec), as.expression(legBor_sec), as.expression(legCon_sec))),
#        col=c(amz_col, bor_col, con_col), pch = 19, box.lty = 0, bg="transparent", cex=1.1, pt.cex=1.1)

dev.off()


