#library(Rcpp, lib.loc = "C:/Program Files/R/R-3.6.1/library")
library(pgirmess)
require(investr)
library(qpcR)
library(nlstools)
library(dplyr)
library(ggplot2)
library(matrixStats)
library(ggrepel)
library(ggpubr)

########################## Purpose of code #######################
#This code will read in the regrowth model in .rds format  to estimate the current (2018)
# and future (2030) AGC (in TgC) for each region/biome and per country for each forest type

# This code takes the 95% CI from the Monte Carlo simulations rather than the 95% CI as calculated by the NLS model

#----------------------------------------------------------------#



variable_table = function(variable_files, biome_str, forest_str){
  age_list = list()
  for (i in (1:length(variable_files))){
    print(i)
    file = variable_files[i]
    print(file)
    dbf_data = foreign::read.dbf(file)
    print(nrow(dbf_data))
    if (nrow(dbf_data) ==0){
      print("Empty data")
    }else{
      colnames(dbf_data) = c("Value", "Count", "age", "country_code")
      dbf_data$biome = biome_str
      dbf_data$forest_type = forest_str
      dbf_data$fileNum = toString(i)
      age_list[[i]] = dbf_data
    }
    
  }
  variable_data = do.call(rbind, age_list)
  return(variable_data)
}


################### Carbon stock/sink ##################

biome = c("amazon_basin","congo_basin", "borneo")

forest_type = c("degraded_for","secondary_for")
forest_short = c("deg","sec")

main_folder = "D:\\Chapter3\\JRC_recovery\\"

result_folder = "D:\\Chapter3\\JRC_recovery\\results\\" 

all_biomes = list()


########### Add the new CI from the Monte Carlo runs #####################

setwd(result_folder)
all_biomes_CI = list()

for (i in 1:length(biome)){
  b = biome[i]
  print(b)
  
  all_forest  = list()
  for(j in 1:length(forest_type)){
    t = forest_type[j]
    print(t)
    s = forest_short[j]
    
    CI_data=read.csv(paste0("monte_carlo_95CI_",b,"_",t,".csv"))
    CI_data$forest_type = t
    CI_data$biome = b
    
    #add an "age 0" category to degraded forest and let is equal the same value as Age 1 degraded forest
    if (t == "degraded_for"){
      age0 = CI_data[CI_data$age == 1.0,]
      age0$age = 0
      CI_data = rbind(CI_data, age0)
    }
    
    all_forest[[j]] = CI_data
    
  }
  all_forest_combined = do.call(rbind, all_forest)
  all_biomes_CI[[i]] = all_forest_combined
}

all_CI = do.call(rbind, all_biomes_CI)

age2030 = data.frame("age" = all_CI$age+12, "forest_type" = all_CI$forest_type, "biome" = all_CI$biome)

all_CI2030 = merge(age2030, all_CI, by = c("age", "forest_type", "biome"))

#change col names to show its 2030 data

original_col = colnames(all_CI2030)
colnames(all_CI2030) = paste(original_col, "2030", sep = "_")

names(all_CI2030)[names(all_CI2030)=="forest_type_2030"] <- "forest_type"
names(all_CI2030)[names(all_CI2030)=="biome_2030"] <- "biome"

setwd(result_folder)

all_data_biomes = read.csv("regrowth_in_all_basins_by_country_input_data.csv")


data = all_data_biomes

#remove NA values
data = data[data$age >=0,]

data2 = merge(data, all_CI, by= c("age", "forest_type", "biome"))

data3 = merge(data2, all_CI2030, by = c("age_2030", "forest_type", "biome"))

data = na.omit(data3)

data$ACD_px = data$fit/(10000/900)
data$ACD_px_2030 = data$fit_2030/(10000/900)


# in secondary forest - remove all 0 values for good. 

data = data[!(data$forest_type == "secondary_for" & data$age ==0),]
all_data_biomes = na.omit(data)


all_data_biomes$Age_group = NA
all_data_biomes$Age_group[which(all_data_biomes$age <=5)] = "< 6"
all_data_biomes$Age_group[which(all_data_biomes$age >5 & all_data_biomes$age <=10)] = "6 - 10"
all_data_biomes$Age_group[which(all_data_biomes$age >10 & all_data_biomes$age <=15)] = "11 - 15"
all_data_biomes$Age_group[which(all_data_biomes$age >15 & all_data_biomes$age <=20)] = "16 - 20"
all_data_biomes$Age_group[which(all_data_biomes$age >20 & all_data_biomes$age <=25)] = "21 - 25"
all_data_biomes$Age_group[which(all_data_biomes$age >25 & all_data_biomes$age <37)] = "26 +"


all_data_biomes$AGCSum = all_data_biomes$ACD_px * all_data_biomes$Count
all_data_biomes$AGCSum_2030 = all_data_biomes$ACD_px_2030* all_data_biomes$Count

all_data_biomes$MClowerSum = (all_data_biomes$lowerMargin/(10000/900))*all_data_biomes$Count
all_data_biomes$MCupperSum = (all_data_biomes$upperMargin/(10000/900))*all_data_biomes$Count

all_data_biomes$MClowerSum_2030 = (all_data_biomes$lowerMargin_2030/(10000/900))*all_data_biomes$Count
all_data_biomes$MCupperSum_2030 = (all_data_biomes$upperMargin_2030/(10000/900))*all_data_biomes$Count


 #### By Biome - forest type
summary_data = all_data_biomes %>%
  group_by(biome, forest_type) %>%
  summarise(totalAGC = (sum(AGCSum))*0.000001, #convert the data into the correct units -  convert to Tg of carbon
            lowerAGC=(sum(MClowerSum))*0.000001, #convert to Tg of carbon 
            upperAGC=(sum(MCupperSum))*0.000001
            ) #convert to Tg of carbon 
summary_data$year = "2018 C Stock"
summary_data$pat = 1

### Summary table 2 below can be used for Extended data Table 1 - column 6
summary_data2 = all_data_biomes %>%
  group_by(biome) %>%
  summarise(totalAGC = (sum(AGCSum))*0.000001, #convert the data into the correct units -  convert to Tg of carbon 
            lowerAGC=(sum(MClowerSum))*0.000001, #convert to Tg of carbon 
            upperAGC=(sum(MCupperSum))*0.000001
  ) #convert to Tg of carbon 



summary_data_fut = all_data_biomes %>%
  group_by(biome, forest_type) %>%
  summarise(totalAGC = ((sum(AGCSum_2030) - sum(AGCSum))*0.000001),
            lowerAGC = (sum(MClowerSum_2030) - sum(MClowerSum))*0.000001,
            upperAGC = (sum(MCupperSum_2030) - sum(MCupperSum))*0.000001)
summary_data_fut$year = "2018 - 2030 C gain"
summary_data_fut$pat = 2

both_summary = rbind(summary_data, summary_data_fut)

both_summary$biome[both_summary$biome == "amazon_basin"] = "Amazon"
both_summary$biome[both_summary$biome == "borneo"] = "Borneo"
both_summary$biome[both_summary$biome == "congo_basin"] = "Central Africa"

both_summary = na.omit(both_summary)
both_summary$upDiff = both_summary$upperAGC - both_summary$totalAGC
both_summary$LowDiff = both_summary$totalAGC - both_summary$lowerAGC

both_summary$meanDiff = rowMeans(both_summary[, c(8,9)])
both_summary$meanDiff = with(both_summary, ifelse(meanDiff < 0, -meanDiff, meanDiff))

both_summary$label = paste(round(both_summary$totalAGC, digits = 1), "\n  ", round(both_summary$meanDiff))

both_summary$forest_type2 = with(both_summary, ifelse(forest_type == "degraded_for", "Degraded", "Secondary"))

both_summary$label2 = paste(round(both_summary$totalAGC, digits = 1), "\n  ", round(both_summary$meanDiff,1))



summary_data_country = all_data_biomes %>%
  group_by(biome, country) %>%
  summarise(totalAGC = (sum(AGCSum))*0.000001, #convert the data into the correct units -  convert to Tg of carbon 
            lowerAGC=(sum(MClowerSum))*0.000001, #convert to Tg of carbon 
            upperAGC=(sum(MCupperSum))*0.000001) #convert to Tg of carbon 
summary_data_country$time = "2018 C Stock"


summary_data_fut_country = all_data_biomes %>%
  group_by(biome, country) %>%
  summarise(totalAGC = ((sum(AGCSum_2030) - sum(AGCSum))*0.000001),
            lowerAGC = (sum(MClowerSum_2030) - sum(MClowerSum))*0.000001,
            upperAGC = (sum(MCupperSum_2030) - sum(MCupperSum))*0.000001)

summary_data_fut_country$time = "2018 - 2030 C gain"

both_summary_country = rbind(summary_data_country, summary_data_fut_country)

both_summary_country$biome[both_summary_country$biome == "amazon_basin"] = "Amazon"
both_summary_country$biome[both_summary_country$biome == "borneo"] = "Borneo"
both_summary_country$biome[both_summary_country$biome == "congo_basin"] = "Central Africa"

both_summary_country = na.omit(both_summary_country)
both_summary_country$upDiff = both_summary_country$upperAGC - both_summary_country$totalAGC
both_summary_country$LowDiff = both_summary_country$totalAGC - both_summary_country$lowerAGC

both_summary_country$meanDiff = rowMeans(both_summary_country[, c(7,8)])
both_summary_country$meanDiff = with(both_summary_country, ifelse(meanDiff < 0, -meanDiff, meanDiff))

both_summary_country$label = paste(round(both_summary_country$totalAGC, digits = 1), " ", round(both_summary_country$meanDiff,1))


## By Age
summary_data_byAge = all_data_biomes %>%
  group_by(biome,Age_group, forest_type) %>%
  summarise(totalAGC = (sum(AGCSum))*0.000001, #convert the data into the correct units -  convert to Tg of carbon 
            lowerAGC=(sum(MClowerSum))*0.000001, #convert to Tg of carbon 
            upperAGC=(sum(MCupperSum))*0.000001) #convert to Tg of carbon  
summary_data_byAge$year = "2018 C Stock"
summary_data_byAge$pat = 1


summary_data_byAge_future = all_data_biomes %>%
  group_by(biome, Age_group, forest_type) %>%
  summarise(totalAGC = ((sum(AGCSum_2030) - sum(AGCSum))*0.000001),
            lowerAGC = (sum(MClowerSum_2030) - sum(MClowerSum))*0.000001,
            upperAGC = (sum(MCupperSum_2030) - sum(MCupperSum))*0.000001)

summary_data_byAge_future$year = "2018 - 2030 C gain"
summary_data_byAge_future$pat = 2

both_summary_age = rbind(summary_data_byAge, summary_data_byAge_future)


both_summary_age$biome[both_summary_age$biome == "amazon_basin"] = "Amazon"
both_summary_age$biome[both_summary_age$biome == "borneo"] = "Borneo"
both_summary_age$biome[both_summary_age$biome == "congo_basin"] = "Central Africa"

both_summary_age = na.omit(both_summary_age)

both_summary_age$upDiff = both_summary_age$upperAGC - both_summary_age$totalAGC
both_summary_age$LowDiff = both_summary_age$totalAGC - both_summary_age$lowerAGC

both_summary_age$meanDiff = rowMeans(both_summary_age[, c(8,9)])
both_summary_age$meanDiff = with(both_summary_age, ifelse(meanDiff < 0, -meanDiff, meanDiff))

both_summary_age$label = paste(round(both_summary_age$totalAGC, digits = 1), " ", round(both_summary_age$meanDiff))


amz_col = "#18BECF" 
bor_col = "#BCBD23" 
con_col = "#7F7F7F"


totals <- both_summary %>%
  group_by(forest_type2, biome, year) %>%
  summarise(total=sum(totalAGC),
            totalDiff = sum(meanDiff)) 

totals_country<- both_summary_country %>%
  group_by(country, biome) %>%
  summarise(total=sum(totalAGC),
            totalDiff = sum(meanDiff))

totals_age<- both_summary_age %>%
  group_by(Age_group, biome) %>%
  summarise(total=sum(totalAGC),
            totalDiff = sum(meanDiff))

totals_age$Age_group_num = 1
totals_age$Age_group_num[which(totals_age$Age_group == "< 6")] = 1
totals_age$Age_group_num[which(totals_age$Age_group == "6 - 10")] = 2
totals_age$Age_group_num[which(totals_age$Age_group == "11 - 15")] = 3
totals_age$Age_group_num[which(totals_age$Age_group == "16 - 20")] = 4
totals_age$Age_group_num[which(totals_age$Age_group == "21 - 25")] = 5
totals_age$Age_group_num[which(totals_age$Age_group == "26 +")] = 6


totals_age2 <- both_summary_age %>%
  group_by(Age_group, biome, forest_type) %>%
  summarise(total=sum(totalAGC),
            totalDiff = sum(meanDiff))

totals_age2$Age_group_num = 1
totals_age2$Age_group_num[which(totals_age2$Age_group == "< 6")] = 1
totals_age2$Age_group_num[which(totals_age2$Age_group == "6 - 10")] = 2
totals_age2$Age_group_num[which(totals_age2$Age_group == "11 - 15")] = 3
totals_age2$Age_group_num[which(totals_age2$Age_group == "16 - 20")] = 4
totals_age2$Age_group_num[which(totals_age2$Age_group == "21 - 25")] = 5
totals_age2$Age_group_num[which(totals_age2$Age_group == "26 +")] = 6


totals_age_cumsum = totals_age2 %>%
  group_by(biome, forest_type) %>%
  arrange(Age_group_num) %>%
  mutate(cs=cumsum(total),
         n = sum(total),
         percCS = cumsum(total)/sum(total)*100)

totals_age_by_year <- both_summary_age %>%
  group_by(Age_group, biome, forest_type, year) %>%
  summarise(total=sum(totalAGC),
            totalDiff = sum(meanDiff))




########### Future scenarios #############
scenarios_2018_2030 = both_summary_age[both_summary_age$year == "2018 - 2030 C gain",]

summary_scenario = scenarios_2018_2030 %>%
  group_by(Age_group, biome) %>%
  summarise(totalAGC = sum(totalAGC),
            total_difference = sum(meanDiff))

summary_scenario$Age_group = factor(summary_scenario$Age_group, c("< 6", "6 - 10", "11 - 15", "16 - 20", "21 - 25", "26 +"))

summary_scenario$Age_group = factor(summary_scenario$Age_group, c("26 +","21 - 25","16 - 20","11 - 15","6 - 10","< 6" ))

summary_scenario$label = paste0(scales::comma(round(summary_scenario$totalAGC),accuracy = 1),"", round(summary_scenario$total_difference))

library(readxl)


percentage_deforestation = read_excel(paste0("C:\\Users\\ky18705\\OneDrive - University of Bristol\\Brazil_trip_2019\\Chapter3_analysis\\results\\post_R2_future_C_scenarios.xlsx"), sheet=1)
percentage_deforestation$percentage_of_total = percentage_deforestation$percentage_effected*0.35

#################### Plotting ######################

## By secondary and degraded forest 
p.Stock_forest=ggplot(both_summary) + 
  geom_bar(stat = "identity", color = "white", aes(x= forest_type2, y = totalAGC, fill = biome, alpha = year),
                   #pattern_fill = "white" ,
                   #pattern_angle = 45,
                   #pattern_density = 0.01,
                   #pattern_spacing = 0.025,
                   #pattern_key_scale_factor = 0.6
           ) +
    scale_alpha_manual(values = c(0.5, 1.0), guide = guide_legend(reverse= TRUE)) +

  theme_bw() +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
        axis.text.x = element_text(color="black", size=12),axis.text.y = element_text(color="black", size=12), 
        text=element_text(size=12)) + 
  #scale_fill_manual(values = c("#DC267F","#648FFF", "#40B0A6")) + 
  scale_fill_manual(values = c(amz_col, bor_col, con_col)) +
  scale_x_discrete(name ="Forest Type") +
  #facet_grid(~biome) +
  facet_grid(rows = vars(biome), scales = "free_y", space = "free") +
  #scale_y_continuous(name = expression('AGC (Tg C)')) + 
  theme(legend.title=element_blank(), legend.text = element_text(size=12),
        strip.background=element_rect(fill=NA, colour=NA),
        panel.spacing = unit(0, "lines"))+
  #geom_text_repel(aes(x= forest_type2, y = totalAGC,label=label),position = position_stack(vjust = 0.5), size=3, color="black")+
  geom_text_repel(aes(x= forest_type2, y = totalAGC,label=scales::comma(round(totalAGC), accuracy=1)),position = position_stack(vjust = 0.5),size=3, color="black", seed = 1)+
  geom_text(data = totals, (aes(x= forest_type2, y = total, label = paste0(scales::comma(round(total),accuracy=1), "  ", round(totalDiff)), fill = NULL, hjust = -0.3))) +
  coord_flip() +
  scale_y_continuous(limits = c(0,3000), name = expression('AGC (Tg C)'),labels = scales::comma)+
  theme(legend.position = "none")
  

print(p.Stock_forest)

p.Stock_forest2=ggplot(both_summary) + 
  geom_bar(stat = "identity", color = "white", aes(x= forest_type2, y = totalAGC, fill = biome, alpha = year),
           #pattern_fill = "white" ,
           #pattern_angle = 45,
           #pattern_density = 0.01,
           #pattern_spacing = 0.025,
           #pattern_key_scale_factor = 0.6
  ) +
    scale_alpha_manual(values = c(0.5, 1.0), guide = guide_legend(reverse= TRUE)) +
  
  theme_bw() +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
        axis.text.x = element_text(color="black", size=12),axis.text.y = element_text(color="black", size=12), 
        text=element_text(size=12)) + 
  #scale_fill_manual(values = c("#DC267F","#648FFF", "#40B0A6")) + 
  scale_fill_manual(values = c(amz_col, bor_col, con_col)) +
  scale_x_discrete(name ="Forest Type") +
  #facet_grid(~biome) +
  facet_grid(rows = vars(biome), scales = "free_y", space = "free") +
  #scale_y_continuous(name = expression('AGC (Tg C)')) + 
  theme(legend.title=element_blank(), legend.text = element_text(size=12),
        strip.background=element_rect(fill=NA, colour=NA),
        panel.spacing = unit(0, "lines"))+
  #geom_text_repel(aes(x= forest_type2, y = totalAGC,label=label),position = position_stack(vjust = 0.5), size=3, color="black")+
  geom_text_repel(aes(x= forest_type2, y = totalAGC,label=scales::comma(round(totalAGC),accuracy=1)),position = position_stack(vjust = 0.5),size=4, color="black", seed = 1)+
  geom_text(data = totals, (aes(x= forest_type2, y = total, label = paste0(scales::comma(round(total),accuracy=1), "  ", round(totalDiff)), fill = NULL, hjust = -0.4)), size = 5) +
  coord_flip() +
  scale_y_continuous(limits = c(0,3000), name = expression('AGC (Tg C)'), labels = scales::comma)#+
#theme(legend.position = "none")


print(p.Stock_forest2)


#by country
p.Stock_country_leg = ggplot(both_summary_country) + 
  geom_bar(stat = "identity", color = "white", aes(x= factor(country), 
                                                   y = totalAGC, fill = biome, alpha = time)) +
    scale_alpha_manual(values = c(0.5, 1.0), guide = guide_legend(reverse= TRUE)) +
  theme_bw() +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
        axis.text.x = element_text(color="black", size=12),axis.text.y = element_text(color="black", size=12), 
        text=element_text(size=12)) + 
  #scale_fill_manual(values = c("#DC267F","#648FFF", "#40B0A6")) + 
  scale_fill_manual(values = c(amz_col, bor_col, con_col), guide = "none") +
  scale_x_discrete(name ="Country") +
  facet_grid(rows = vars(biome), scales = "free_y", space = "free") +
  labs(alpha = "Time period") +
  #scale_y_continuous(name = expression('AGC (Tg C)')) + 
  #facet_grid(rows = vars(biome), scales = "free_y", space = "free") +
  theme(legend.text = element_text(size=10),
        strip.background=element_rect(fill=NA, colour=NA),
        panel.spacing = unit(0, "lines"),
        legend.position = "bottom",
        legend.background = element_rect(fill = "white", color = "white")) +
  #geom_text_repel(aes(x= country, y = totalAGC,label=label),position = position_stack(vjust = 0.5), size=3, color="black")+
  geom_text(data = totals_country, (aes(x= country, y = total, label = paste(scales::comma(round(total),accuracy=1),"", round(totalDiff)), 
                                        fill = NULL, hjust=-0.2))) + #hjust=ifelse(total> 1500, 1, -0.2)
  scale_y_continuous(limits = c(0,2250), name = expression('AGC (Tg C)'), labels = scales::comma)+
coord_flip() #theme(legend.position = "none") +


print(p.Stock_country_leg)

legend = get_legend(p.Stock_country_leg)
p.Stock_country = p.Stock_country_leg + theme(legend.position = "none")
print(p.Stock_country)


both_summary_age1 = both_summary_age %>%
  group_by(Age_group, biome, year, pat) %>%
  summarise(totalAGC = sum(totalAGC))
  
#by age/YSLD
p.Stock_age = ggplot(both_summary_age1) + 
  geom_bar(stat = "identity", color = "white", aes(x=factor(Age_group, c("< 6", "6 - 10", "11 - 15", "16 - 20", "21 - 25", "26 +")),
                                                   y = totalAGC, fill = biome, alpha = year)) +
    scale_alpha_manual(values = c(0.5, 1.0), guide = guide_legend(reverse= TRUE)) +
  
  theme_bw() +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
        axis.text.x = element_text(color="black", size=12),axis.text.y = element_text(color="black", size=12), 
        text=element_text(size=12)) + 
  #scale_fill_manual(values = c("#DC267F","#648FFF", "#40B0A6")) + 
  scale_fill_manual(values = c(amz_col, bor_col, con_col)) +
  scale_x_discrete(name ="Years since last disturbance") +
  #facet_grid(~biome) +
  facet_grid(rows = vars(biome),  space = "free") +
  #scale_y_continuous(name = expression('AGC (Tg C)')) + 
  theme(legend.title=element_blank(), legend.text = element_text(size=12),
        strip.background=element_rect(fill=NA, colour=NA),
        panel.spacing = unit(0, "lines")) +
  #geom_text_repel(aes(x= forest_type2, y = totalAGC,label=label),position = position_stack(vjust = 0.5), size=3, color="black")+
  #geom_text_repel(aes(x= Age_group, y = totalAGC,label=round(totalAGC)),position = position_stack(vjust = 0.5),size=3, color="black", seed = 1)+
  geom_text(data = totals_age, (aes(x= Age_group, y = total, label = paste (scales::comma(round(total),accuracy=1), "", round(totalDiff) ), fill = NULL, hjust = -0.2))) +
  scale_y_continuous(limits = c(0,1600), name = expression('AGC (Tg C)'), labels = scales::comma)+
  theme(legend.position = "none") +
  coord_flip()


print(p.Stock_age)

both_summary_age2 = both_summary_age[both_summary_age$forest_type == "secondary_for",]


both_summary_age$forest_type[both_summary_age$forest_type == "degraded_for"] = "Degraded Forest"
both_summary_age$forest_type[both_summary_age$forest_type == "secondary_for"] = "Secondary Forest"

totals_age_cumsum$forest_type[totals_age_cumsum$forest_type == "degraded_for"] = "Degraded Forest"
totals_age_cumsum$forest_type[totals_age_cumsum$forest_type == "secondary_for"] = "Secondary Forest"


library(data.table)
both_summary_age2 <- data.table(both_summary_age)

both_summary_age2[forest_type == "Degraded Forest",y_min := 0]
both_summary_age2[forest_type == "Degraded Forest",y_max := 1300]
both_summary_age2[forest_type == "Secondary Forest",y_min := 0]
both_summary_age2[forest_type == "Secondary Forest",y_max := 170]

totals_age3 = totals_age_by_year%>%
  group_by(forest_type, biome, Age_group) %>%
  summarise(age_total = sum(total))

totals_age_by_year2 = merge(totals_age_by_year, totals_age3)

totals_age_by_year2$forest_type[which(totals_age_by_year2$forest_type == "degraded_for")] = "Degraded Forest"
totals_age_by_year2$forest_type[which(totals_age_by_year2$forest_type == "secondary_for")] = "Secondary Forest"

totals_age_2018 = totals_age_by_year2[totals_age_by_year2$year == "2018 C Stock", ]
totals_age_2030 = totals_age_by_year2[totals_age_by_year2$year == "2018 - 2030 C gain", ]

sum_2018 = totals_age_2018 %>%
  group_by(forest_type, biome)%>%
  summarise(sum2018 = sum(total),
            sum2018error = sum(totalDiff))

sum_2030 = totals_age_2030 %>%
  group_by(forest_type, biome)%>%
  summarise(sum2030 = sum(total),
            sum2030error = sum(totalDiff))

######################################### new figure 4 of paper ##################
p.Stock_age_forest_type = ggplot(both_summary_age2) + 
  geom_bar(stat = "identity", color = "white", aes(x=factor(Age_group, c("< 6", "6 - 10", "11 - 15", "16 - 20", "21 - 25", "26 +")),
                                                   y = totalAGC, fill = biome, alpha =year)) +
  scale_alpha_manual(values = c(0.5, 1.0), guide = guide_legend(reverse= TRUE)) +
  
  theme_bw() +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
        axis.text.x = element_text(color="black", size=12),axis.text.y = element_text(color="black", size=12), 
        text=element_text(size=12)) + 
  #scale_fill_manual(values = c("#DC267F","#648FFF", "#40B0A6")) + 
  scale_fill_manual(values = c(amz_col, bor_col, con_col)) +
  scale_x_discrete(name ="Years since last disturbance") +
  #geom_text(data = totals_age, (aes(x= Age_group, y = total, angle = 90,label = paste (round(total), "", round(totalDiff) ), fill = NULL,  hjust = -0.05))) +
  geom_text(data = totals_age_2018, (aes(x = Age_group, y = ifelse(forest_type=="Degraded Forest", age_total+30, age_total+5),colour = biome, 
                                         label = paste0(ifelse(total<2 & forest_type == "Secondary Forest", round(total,1), round(total)), "", ifelse(totalDiff<1.5, round(totalDiff,1), round(totalDiff))),
                                         vjust = -0.5)), colour = "black")+
  geom_text(data = totals_age_2030, (aes(x = Age_group, y = ifelse(forest_type=="Degraded Forest", age_total+150, age_total+20),colour = biome, 
                                         label = paste0(ifelse(total<2 & forest_type == "Secondary Forest", round(total,1), round(total)), "", ifelse(totalDiff<1.5, round(totalDiff,1), round(totalDiff))),
                                         vjust = -0.5)), alpha= 0.5, colour = "black")+
  geom_text(data=sum_2018, aes(x = 4.5, y =  ifelse(forest_type == "Degraded Forest", 1200, 150),
                                     label = paste0("2018 total: ", scales::comma(round(sum2018)), "", round(sum2018error))),
            fontface = "bold")+
  geom_text(data=sum_2030, aes(x = 4.5, y =  ifelse(forest_type == "Degraded Forest", 1100, 135),
                               label = paste0("2030 gain: ", scales::comma(round(sum2030)), "", round(sum2030error))),
            fontface = "bold")+
  facet_grid(rows = vars(forest_type), cols = vars(biome), scales = "free_y") +
  #facet_wrap(forest_type~biome, scales = "free_y") +
  #scale_y_continuous(name = expression('AGC (Tg C)')) + 
  theme(legend.title=element_blank(), legend.text = element_text(size=12),
        strip.background=element_rect(fill=NA, colour=NA),
        panel.spacing = unit(0, "lines"),
        legend.position = "bottom",
        strip.text.x = element_text(size = 14),
        strip.text.y = element_text(size = 14)) +#legend.position = c(0.83, 0.35)) +
  #scale_colour_manual(values = c(amz_col, bor_col, con_col), guide = "none")+
  #geom_text_repel(aes(x= forest_type2, y = totalAGC,label=label),position = position_stack(vjust = 0.5), size=3, color="black")+
  #geom_text_repel(aes(x= Age_group, y = totalAGC,label=round(totalAGC)),position = position_stack(vjust = 0.5),size=3, color="black", seed = 1)+
  scale_y_continuous(name = expression('AGC (Tg C)'), labels = scales::comma)+ 
  geom_blank(aes(y = y_min)) +
  geom_blank(aes(y = y_max)) +
  guides( fill = "none")
  #coord_flip()


print(p.Stock_age_forest_type)

p.Stock_age_forest_type_bw = ggplot(both_summary_age2) + 
  geom_bar(stat = "identity", color = "white", aes(x=factor(Age_group, c("< 6", "6 - 10", "11 - 15", "16 - 20", "21 - 25", "26 +")),
                                                   y = totalAGC, fill = biome, alpha =year)) +
  scale_alpha_manual(values = c(0.5, 1.0), guide = guide_legend(reverse= TRUE)) +
  
  theme_bw() +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
        axis.text.x = element_text(color="black", size=10),axis.text.y = element_text(color="black", size=9), 
        text=element_text(size=12)) + 
  #scale_fill_manual(values = c("#DC267F","#648FFF", "#40B0A6")) + 
  scale_fill_manual(values = c("#595959", "#595959", "#595959")) +
  scale_x_discrete(name ="Years since last disturbance") +
  #geom_text(data = totals_age, (aes(x= Age_group, y = total, angle = 90,label = paste (round(total), "", round(totalDiff) ), fill = NULL,  hjust = -0.05))) +
  geom_text(data = totals_age_2018, (aes(x = Age_group, y = ifelse(forest_type=="Degraded Forest", age_total+30, age_total+5),colour = biome, 
                                         label = paste0(ifelse(total<2 & forest_type == "Secondary Forest", round(total,1), round(total)), "", ifelse(totalDiff<1.5, round(totalDiff,1), round(totalDiff))),
                                         vjust = -0.5)), colour = "black", size=2.5)+
  geom_text(data = totals_age_2030, (aes(x = Age_group, y = ifelse(forest_type=="Degraded Forest", age_total+150, age_total+20),colour = biome, 
                                         label = paste0(ifelse(total<2 & forest_type == "Secondary Forest", round(total,1), round(total)), "", ifelse(totalDiff<1.5, round(totalDiff,1), round(totalDiff))),
                                         vjust = -0.5)), alpha= 0.5, colour = "black", size=2.5)+
  geom_text(data=sum_2018, aes(x = 4.5, y =  ifelse(forest_type == "Degraded Forest", 1200, 150),
                               label = paste0("2018 total: ", scales::comma(round(sum2018)), "", round(sum2018error))),
            fontface = "bold", size=3.25)+
  geom_text(data=sum_2030, aes(x = 4.5, y =  ifelse(forest_type == "Degraded Forest", 1090, 135),
                               label = paste0("2030 gain: ", scales::comma(round(sum2030)), "", round(sum2030error))),
            fontface = "bold", size=3.25)+
  facet_grid(rows = vars(forest_type), cols = vars(biome), scales = "free_y") +
  #facet_wrap(forest_type~biome, scales = "free_y") +
  #scale_y_continuous(name = expression('AGC (Tg C)')) + 
  theme(legend.title=element_blank(), legend.text = element_text(size=8),
        strip.background=element_rect(fill=NA, colour=NA),
        panel.spacing = unit(0, "lines"),
        legend.position = "bottom",
        strip.text.x = element_text(size = 10),
        strip.text.y = element_text(size = 10),
        axis.text.x = element_text(angle=90)) +#legend.position = c(0.83, 0.35)) +
  #scale_colour_manual(values = c(amz_col, bor_col, con_col), guide = "none")+
  #geom_text_repel(aes(x= forest_type2, y = totalAGC,label=label),position = position_stack(vjust = 0.5), size=3, color="black")+
  #geom_text_repel(aes(x= Age_group, y = totalAGC,label=round(totalAGC)),position = position_stack(vjust = 0.5),size=3, color="black", seed = 1)+
  scale_y_continuous(name = expression('AGC (Tg C)'), labels = scales::comma)+ 
  geom_blank(aes(y = y_min)) +
  geom_blank(aes(y = y_max)) +
  guides( fill = "none")
#coord_flip()


print(p.Stock_age_forest_type_bw)


p.future_stock = ggplot(summary_scenario, aes(x = biome,  y = totalAGC,alpha = Age_group)) + 
  geom_bar(stat = "identity", color = "white", aes( fill = biome), position = position_stack()) +
  scale_alpha_manual(values = c( 0.1428571, 0.2857143, 0.4285714, 0.5714286, 0.7142857, 0.8571429, 1.0000000),
                     name = "Years since \n last disturbance event") +
  
  theme_bw() +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
        axis.text.x = element_text(color="black", size=12),axis.text.y = element_text(color="black", size=12), 
        text=element_text(size=12)) + 
  #scale_fill_manual(values = c("#DC267F","#648FFF", "#40B0A6")) + 
  scale_fill_manual(values = c(amz_col, bor_col, con_col), name = "Region") +
  scale_x_discrete(name ="Regions") +
  #facet_grid(~biome) +
  facet_grid(rows = vars(biome),  space = "free", scales = "free") +
  #scale_y_continuous(name = expression('AGC (Tg C)')) + 
  theme(legend.text = element_text(size=12),
        strip.background=element_rect(fill=NA, colour=NA),
        panel.spacing = unit(0, "lines"),
        strip.text.y = element_blank()) +
  #geom_text_repel(aes(x= forest_type2, y = totalAGC,label=label),position = position_stack(vjust = 0.5), size=3, color="black")+
  # geom_text_repel(aes(x= biome, y = totalAGC, 
  #               label= label),
  #           position = position_stack(vjust = 0.5),size=4,  seed = 4, colour = "black", show.legend = F,
  #           colour = ifelse(summary_scenario$totalAGC > 3, "white", "black"))+
  #scale_colour_manual(values = c("black", "black", "black","black", "black", "black"))+
  #geom_text((aes(x= biome, y = totalAGC, label = label, fill = NULL, hjust = -0.2))) +
  scale_y_continuous( name = expression('AGC (Tg C)'), label = scales::comma)+
  guides(alpha = guide_legend(reverse=TRUE))+
  coord_flip()

p.future_stock 



all_graphs = list(p.Stock_forest, p.Stock_country, p.Stock_age, legend)
p.all = ggarrange(plotlist = all_graphs, labels = c("a", "b", "c"), ncol=2, nrow=2)


p.both = ggarrange(p.Stock_forest,  p.Stock_age, labels = c("a", "b"), ncol=2, common.legend = TRUE, legend="bottom")

print(p.both)

print(p.all)


p.both_country = ggarrange(p.Stock_forest,  p.Stock_country, labels = c("a", "b"), ncol=2, common.legend = TRUE, legend="bottom")

print(p.both_country)


setwd(result_folder)

############# Save new figure 4 + supplementary Figure #############
#ggsave(paste0("Fig4_potential_C_gain_",Sys.Date(), ".png"),p.Stock_age_forest_type , width = 11.5, height=6.5, units="in")

#ggsave(paste0("country_2030_carbon_stock_",Sys.Date(),"_agb_fix_MC.png"), p.Stock_country_leg,width =7, height=5, units="in" , dpi=900)


ggsave(paste0("Fig4_potential_C_gain_",Sys.Date(), ".png"),p.Stock_age_forest_type, width = 11.5, height=6.5, units="in")
ggsave(paste0("Fig4_potential_C_gain_",Sys.Date(), ".pdf"),p.Stock_age_forest_type, width = 11.5, height=6.5, units="in")

ggsave(paste0("Fig4_potential_C_gain_",Sys.Date(), "_bw.pdf"),p.Stock_age_forest_type_bw, width = 180, height=115, units="mm")


ggsave(paste0("country_2030_carbon_stock_",Sys.Date(),"_agb_fix_MC.png"), p.Stock_country_leg,width =7, height=5, units="in" , dpi=900)


## older versions
ggsave(paste0("for_country_2030_carbon_stock_",Sys.Date(),"_agb_fix_MC.png"), p.both_country,width =10.85, height=4.0, units="in" , dpi=900)
ggsave(paste0("forest_2030_carbon_stock_",Sys.Date(), "agb_fix_MC_single_fig.png"), p.Stock_forest2, width =10.5, height=6.0, units="in")
ggsave(paste0("forest_2030_carbon_stock_",Sys.Date(),"_agb_fix_MC.png"), p.Stock_forest,width =7, height=5, units="in" , dpi=900)
ggsave(paste0("age_2030_carbon_stock_",Sys.Date(),"_agb_fix_MC.png"), p.Stock_age,width =7, height=5, units="in" , dpi=900)


ggsave(paste0("future_scenarios_",Sys.Date(),"_agb_fix_MC.svg"), p.future_stock,width =10.60, height=4.62, units="in")
ggsave(paste0("future_scenarios_",Sys.Date(),"_agb_fix_MC.png"), p.future_stock,width =10.60, height=4.62, units="in")


ggsave(paste0("age_2030_carbon_stock_by_Forest_",Sys.Date(),"_agb_fix_MC_asPerc.png"), p.Stock_age_forest_type,width =11, height=7, units="in" , dpi=900)

ggsave(paste0("all_2030_carbon_stock_",Sys.Date(),"_agb_fix_MC.png"), p.all,width =13.90, height=6.5, units="in" , dpi=900)
ggsave(paste0("all_2030_carbon_stock_",Sys.Date(),"_agb_fix_MC.svg"), p.all,width =13.90, height=6.5, units="in")

ggsave(paste0("both_2030_carbon_stock_",Sys.Date(),"_agb_fix_MC.png"), p.both,width =10.85, height=4.0, units="in" , dpi=900)
ggsave(paste0("both_2030_carbon_stock_",Sys.Date(),"_agb_fix_MC.svg"), p.both,width =10.85, height=4.0, units="in")


