library(foreign)
library(raster)
library(stringr)
require(ggplot2)
library(dplyr)
library(data.table)
library(xlsx)


main_folder = "C:\\Users\\ky18705\\OneDrive - University of Bristol\\Brazil_trip_2019\\Chapter3_analysis\\paper_drafts\\All_author_access\\nature_initial_submission\\rebuttal\\review_R2"
setwd(main_folder)

data = read.xlsx("relative_recovery.xlsx", sheetIndex=1)

amz_col = "#18BECF" 
bor_col = "#BCBD23" 
con_col = "#7F7F7F"

jitter <- position_jitter(width = 0.3, height = 0.3)

study_order = c("This study", "Cook-Patton et al. 2020", 
                "Poorter et al. 2021 (Amazon)", "Poorter et al. 2021 (W. Africa)", "Poorter et al. 2021 (Neotropics)",
                "Rutishauser et al. 2015 (50% loss)", "Rutishauser et al. 2015 (20% loss)", 
                "Rappaport et al. 2018 (Logged)", "Rappaport et al. 2018 (Burned x1)", "Bullock and Woodcock, 2021",
                "Philipson et al. 2020 (Sabah - natural)", "Philipson et al. 2020 (Sabah - active)", 
                "Lawrence, 2005 (W. Kalimantan)", "N'Guessan et al. 2019 (W. Africa)")

data$Study = factor(data$Study, levels = study_order)

data$relative_recovery_20_yrs = data$relative_recovery_20_yrs*100
data$error.min = data$error.min*100
data$error.max = data$error.max*100


comparison=ggplot(data) +
  #geom_pointrange(size = 1)+
  geom_pointrange(aes(x = Study, y = relative_recovery_20_yrs,  ymin = (error.min),
                      ymax =error.max, colour = factor(Region, levels = c("Amazon", "Borneo", "Central Africa")), linetype =Error.type), size=1, position=jitter) +
  #geom_pointrange(aes(x = Study, y = Av20yrRate,  ymin = ci_lower, ymax = ci_upper, colour = Region, shape= Study),  size=1) +
  facet_grid(rows = vars(Forest.type), scales = "free", space = "free") +
  scale_color_manual(values = c(amz_col, bor_col, con_col, "black")) +
  ylab(expression('20 yr AGC recovery relative to old-growth AGC (%)')) +
  xlab("") +
  #labs(shape = "This Study: Forest Type", color = "Cook-Patton regrowth rates") +
  theme_bw() +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),axis.text.y = element_text(color="black", size=12),
        text=element_text(size=12), axis.text.x=element_text(size=12, color = "black"), # angle=90
        strip.background=element_rect(fill=NA, colour=NA),
        panel.spacing = unit(0, "lines"))+
  theme(text = element_text(size=12)) +
  coord_flip() +
  labs(linetype='Uncertainty type', colour = "Region") +
  guides(linetype = guide_legend(override.aes = list(shape = NA)),
         shape = guide_legend(override.aes = list(linetype = "blank")))

print(comparison)

ggsave(paste0("AGC_20y_recovery_comp_",Sys.Date(),".png"), comparison,width =10.5, height=7.3, units="in", dpi=600)

ggsave(paste0("AGC_20y_recovery_comp_",Sys.Date(),".jpeg"), comparison,width =9.5, height=7.3, units="in", dpi=600)

