library(pgirmess)
require(investr)
library(qpcR)
library(nlstools)
library(dplyr)
library(ggplot2)
library(matrixStats)
library(ggrepel)
library(ggpubr)
library(dplyr)
library(tidyverse)
library(cowplot)

library(inauguration)
colBar=inauguration("inauguration_2021")


########################## Purpose of code #######################
#This code will read in various .dbf files from geotiff data e.g. the original geotiff files 
#where each pixel has value of "years since last disturbance" i.e. an age up to 34/35
#and calculate the associated gains/losses of carbon due to deforestation/degradation and regrowth
# Used to create extended data Tables 1 and 2.
#----------------------------------------------------------------#



variable_table = function(variable_files){
  age_list = list()
  for (i in (1:length(variable_files))){
    print(i)
    file = variable_files[i]
    print(file)
    dbf_data = foreign::read.dbf(file)
    colnames(dbf_data) = c("Value", "Count")
    age_list[[i]] = dbf_data
  }
  data_merge = Reduce(function(x,y)merge (x, y, by="Value",all=TRUE), age_list)
  
  return(data_merge)
}


####################### ANALYSIS AS LOOP ##########################

all_def_deg = list()
all_regions_deg = list()
plot_list = list()

biomes = c("amazon_basin", "borneo", "congo_basin")

for (j in 1:length(biomes)){
  print(j)
  biome_str = biomes[j]
  print(biome_str)

  ######################## Degraded recovery ####################
  forest_types = c("degraded_for", "secondary_for")
  gain_type = c("Degraded forest growth", "Secondary forest growth")
  
  all_growth = list()
  for (i in (1:length(forest_types))){
    forest_t = forest_types[i]
    
    growth_folder = paste0("D:\\Chapter3\\JRC_recovery\\", biome_str,"\\",biome_str,"_",forest_t)
    setwd(growth_folder)
    #read in the files of degradation/secondary forest and their ages
    growth_files =  list.files(pattern = paste0(biome_str,"_",forest_t,'_extract_oilPalm_.*.dbf$'), full.names = T)
    growth_data =  variable_table(growth_files)
    growth_data = growth_data[growth_data$Value >=0,]
    
    #calculate the total number of pixels of the recovering forest type
    if (biome_str != "borneo"){
      growth_data$pixelTotal = rowSums(growth_data[, -1] ,na.rm=TRUE)
    } else {
      if (forest_t == "degraded_for"){
        growth_data$pixelTotal = growth_data$Count.x
        
      } else {growth_data$pixelTotal = growth_data$Count
      }
    }
    growth_data$Year = (growth_data$Value - 2018)*-1
    growth_data$GainLoss = gain_type[i]
    
    growth_data = growth_data %>% dplyr::select(-contains("Count"))
    
    all_growth[[i]] = growth_data
  }
  
  growth  = do.call(rbind, all_growth)
  growth = growth[growth$Value<37 &growth$Value >0,] #only look at those that were considered recovering in the analysis 
  #growth = growth %>% dplyr::select(-contains("Count"))
  growth$areaKm = growth$pixelTotal*900/1000000
  
  # emissions from degradation - i.e. old-growth forest AGC - AGC @ 1YSLD
  
  if (biome_str == "amazon_basin"){
    degraded_emissions = 61.14293 # corrected using new conversion factor - 0.456
    degraded_emissions_lower = 43.5024
    degraded_emissions_upper = 78.7056
  } else if(biome_str == "borneo"){ 
    degraded_emissions = 105.1711
    degraded_emissions_lower = 84.6336
    degraded_emissions_upper =  120.384
  } else if(biome_str == "congo_basin"){
    degraded_emissions = 59.3605 
    degraded_emissions_lower = 39.672
    degraded_emissions_upper = 77.064
  }
  
  degraded_growth = growth[growth$GainLoss == "Degraded forest growth",]
  degraded_growth$emissions = degraded_growth$pixelTotal*(degraded_emissions/(10000/900))
  degraded_growth$emissions_lower = degraded_growth$pixelTotal*(degraded_emissions_lower/(10000/900))
  degraded_growth$emissions_upper = degraded_growth$pixelTotal*(degraded_emissions_upper/(10000/900))
  
  
  total_degraded_emissions = sum(degraded_growth$emissions)
  degraded_emissions_TgC = total_degraded_emissions*0.000001
  print(degraded_emissions_TgC)
  
  total_degraded_emissions_lower = sum(degraded_growth$emissions_lower)
  degraded_emissions_TgC_lower = total_degraded_emissions_lower*0.000001
  print(degraded_emissions_TgC_lower)
  
  total_degraded_emissions_upper = sum(degraded_growth$emissions_upper)
  degraded_emissions_TgC_upper = total_degraded_emissions_upper*0.000001
  print(degraded_emissions_TgC_upper)
  
  
  ############################ Old-growth DEForestation #######
  
  # read in the folder looking at the year of deforestation
  init_folder = paste0("D:\\Chapter3\\variables\\old_growth_deforestation\\",biome_str, "_jrc_DeforestationYear\\")
  setwd(init_folder)
  
  deforestation_files =  list.files(pattern = paste0(biome_str,'_jrc_DeforestationYear.*.dbf$'), full.names = T)
  loss = variable_table(deforestation_files)
  
  if (biome_str == "borneo"){
    loss$pixelTotal = loss$Count
  } else {
    loss$pixelTotal = rowSums(loss[, -1] ,na.rm=TRUE)
  }
  #calculate the area lost to deforestation in km2
  loss$areaKm = loss$pixelTotal*900/1000000
  loss = loss[loss$Value >0,]
  #only look at values between 1994 to 2018
  loss = loss[loss$Value < 2019,]
  

  # drop count columns 
  loss = loss %>% dplyr::select(-contains("Count"))
  loss$Year = loss$Value
  loss$areaKm = -loss$areaKm
  loss$GainLoss = "Old-growth deforestation"
  

  all_changes = rbind(loss, growth)
  
  net_change = all_changes %>%
    group_by(Year) %>%
    summarise(netChange = sum(areaKm))
  
  if (biome_str == "amazon_basin"){
    old_growth_value = 121.0104
    old_growth_value_lower = 120.2928
    old_growth_value_upper = 122.664
  } else if(biome_str == "borneo"){
    old_growth_value = 121.174
    old_growth_value_lower = 119.472
    old_growth_value_upper = 122.9376
  } else if(biome_str == "congo_basin"){
    old_growth_value = 116.6176
    old_growth_value_lower = 115.6416
    old_growth_value_upper = 117.5568
  }
  
  old_growth_value_MgPix = (old_growth_value/(10000/900))
  loss$emissions = loss$pixelTotal*old_growth_value_MgPix
  total_deforestation_emissions = sum(loss$emissions)
  deforestation_emissions_TgC = total_deforestation_emissions*0.000001
  #total Carbon lost up to 2018 due to deforestation (of old-growth and degraded deforestation)
  print(deforestation_emissions_TgC)
  
  ## lower limit
  old_growth_value_MgPix_lower = (old_growth_value_lower/(10000/900))
  loss$emissions_lower = loss$pixelTotal*old_growth_value_MgPix_lower
  total_deforestation_emissions_lower = sum(loss$emissions_lower)
  deforestation_emissions_TgC_lower = total_deforestation_emissions_lower*0.000001
  #total Carbon lost up to 2018 due to deforestation (of old-growth and degraded deforestation)
  print(deforestation_emissions_TgC_lower)
  
  ## upper limit
  old_growth_value_MgPix_upper = (old_growth_value_upper/(10000/900))
  loss$emissions_upper = loss$pixelTotal*old_growth_value_MgPix_upper
  total_deforestation_emissions_upper = sum(loss$emissions_upper)
  deforestation_emissions_TgC_upper = total_deforestation_emissions_upper*0.000001
  #total Carbon lost up to 2018 due to deforestation (of old-growth and degraded deforestation)
  print(deforestation_emissions_TgC_upper)
  
 
  
  
  ########################### 2018 old-growth carbon stock #########################
  # here we calculate the totcal carbon still stored in old-growth standing forests
  init_folder = paste0("D:\\Chapter3\\variables\\JRC_transitions\\",biome_str)
  setwd(init_folder)
  
  old_growth_files =  list.files(pattern = paste0(biome_str,'_undisturbed_TMF.*.dbf$'), full.names = T)
  
  
  old_growth = variable_table(old_growth_files)
  
  if (biome_str == "borneo"){
    old_growth$pixelTotal = old_growth$Count
  } else {
    old_growth$pixelTotal = rowSums(old_growth[, -1] ,na.rm=TRUE)
  }
  
  if (biome_str == "amazon_basin"){
    old_growth_value = 121.0104
    old_growth_value_lower = 120.2928
    old_growth_value_upper = 122.664
  } else if(biome_str == "borneo"){
    old_growth_value = 121.174
    old_growth_value_lower = 119.472
    old_growth_value_upper = 122.9376
  } else if(biome_str == "congo_basin"){
    old_growth_value = 116.6176
    old_growth_value_lower = 115.6416
    old_growth_value_upper = 117.5568
  }
  

  Mg_C_pix = old_growth_value/(10000/900)
  Mg_C_pix_lower = old_growth_value_lower/(10000/900)
  Mg_C_pix_upper = old_growth_value_upper/(10000/900)
  
  
  old_growth$MgCPix = old_growth$pixelTotal*Mg_C_pix
  old_growth$MgCPix_lower = old_growth$pixelTotal*Mg_C_pix_lower
  old_growth$MgCPix_upper = old_growth$pixelTotal*Mg_C_pix_upper
  
  
  total_MgC = (sum(old_growth$MgCPix))
  total_TgC = total_MgC*0.000001
  print(total_TgC)
  
  total_MgC_lower = (sum(old_growth$MgCPix_lower))
  total_TgC_lower = total_MgC_lower*0.000001
  print(total_TgC_lower)
  
  total_MgC_upper = (sum(old_growth$MgCPix_upper))
  total_TgC_upper = total_MgC_lower*0.000001
  print(total_TgC_upper)
  
  
  ########################## Old growth degradation ##############################
  #read in files relating to the year of forest degradation
  
  init_folder = paste0("D:\\Chapter3\\variables\\old_growth_degradation\\",biome_str, "_jrc_DegradationYear\\")
  setwd(init_folder)
  
  degradation_files =  list.files(pattern = paste0(biome_str,'_jrc_DegradationYear.*.dbf$'), full.names = T)
  degraded = variable_table(degradation_files)
  
  
  if (biome_str == "borneo"){
    degraded$degradedTotal = degraded$Count
  } else {
    degraded$degradedTotal = rowSums(degraded[, -1] ,na.rm=TRUE)
  }
  
  degraded = degraded[loss$Value >0,]
  
  # drop count columns 
  degraded = degraded %>% dplyr::select(-contains("Count"))
  
  # make a new dataframe linking the total deforestation and degradation
  deforested_degraded_ratio = merge(loss, degraded, by= "Value")
  
  deforested_degraded_ratio$percent_defor = deforested_degraded_ratio$pixelTotal/ (deforested_degraded_ratio$pixelTotal + deforested_degraded_ratio$degradedTotal)
  deforested_degraded_ratio$percent_degrade = deforested_degraded_ratio$degradedTotal/ (deforested_degraded_ratio$pixelTotal + deforested_degraded_ratio$degradedTotal)
  
  deforested_degraded_ratio$region = biome_str
  
  all_regions_deg[[j]] = deforested_degraded_ratio
  
  defor = sum(deforested_degraded_ratio$pixelTotal)
  deg = sum(deforested_degraded_ratio$degradedTotal)
  
  total_forest_lost = defor + deg
  
  #print(defor/total_forest_lost*100)
  #print(deg/total_forest_lost*100)
  deforested_degraded_ratio_1990 = deforested_degraded_ratio[deforested_degraded_ratio$Year > 1989,]
  
  #print(mean(deforested_degraded_ratio$percent_defor))
  #print(mean(deforested_degraded_ratio$percent_degrade))
  
  #Average forest area lost per year due to Deforestation and Degradation between 1990 - 2018
  #Goes into Extended Table 1 - columns 4 and 5
  print(mean(deforested_degraded_ratio_1990$percent_defor))
  print(mean(deforested_degraded_ratio_1990$percent_degrade))
  
  
  
  degraded2 = degraded
  degraded2$areaKm = -degraded2$degradedTotal*900/1000000
  degraded2$Year = degraded2$Value
  degraded2$GainLoss = "Old-growth degradation"
  
  degraded2 = degraded2[degraded2$Value >=1985 & degraded2$Value<2019,]
  
  loss2 =loss %>%  dplyr::select(-contains("emissions"))
  loss2 = loss2[loss2$Value >=1985 & loss2$Value<2019,]
  
  growth2 = growth
  growth2$Year = growth2$Year + 1 # add 1 to the growht year to account for the fact that the forst has already been growing for one year
  
  all_changes = rbind(loss2, growth2)
  names(degraded2)[names(degraded2) == "degradedTotal"] = "pixelTotal"
  all_changes = rbind(all_changes, degraded2)
  
  net_change = all_changes %>%
    group_by(Year) %>%
    summarise(netChange = sum(areaKm))
  
  
  
  b = biome_str
  if (b == "amazon_basin"){
    name = "a. Amazon"
  } else if (b == "borneo"){
    name = "b. Borneo"
  } else if (b == "congo_basin"){
    name = "b. Central Africa"
  }
  
    
    def_area = ggplot(data = all_changes) +
      geom_bar(aes(x = Year, y = areaKm,  fill = factor(GainLoss, levels = c("Old-growth deforestation", "Old-growth degradation", "Degraded forest growth", "Secondary forest growth"))), stat = "identity", position="stack") +
      scale_fill_manual(values = c( colBar[5], colBar[4],colBar[1], colBar[2])) +
      geom_line(data = net_change, aes(x = Year, y = netChange), size = 1) +
      geom_segment(x = 1983, y = 2000, xend = 1983, yend = 50000,
                   arrow = arrow(length = unit(0.03, "npc")), size=0.7) +
      geom_segment(x = 1983, y = -2000, xend = 1983, yend = -60000,
                   arrow = arrow(length = unit(0.03, "npc")), size=0.7) +
      geom_text(aes(x=1984, y= (50000/2), label="Gains"),size=4, color="black", angle = 90) +
      geom_text(aes(x=1984, y= (-60000/2), label="Losses"),size=4, color="black", angle = 90) +
      xlim(c(1983, 2019)) +
      ylim(c(-60000, 50000))+
      theme_bw() +
      theme(axis.text.x = element_text(color = "black", size= 12),axis.text.y = element_text(color="black", size=12),
            text=element_text(size=14),
            strip.background=element_rect(fill=NA, colour=NA),
            panel.spacing = unit(0, "lines"))+
      theme(text = element_text(size=12)) +
      theme(plot.title = element_text(size=12, face = "bold"))+
      ggtitle(name)+
      ylab(bquote('Area'~(Km^2)))+
      scale_y_continuous(label = scales::comma)+
      labs(fill = "") #+
      #theme(legend.position = "none")
    
    print(def_area)

    
  plot_list[[j]] = def_area
  

  
  ############################# Degradation followed by deforestation #######################
  
  #look at the pixels of forest that were either just deforested, just degraded or degraded and then deforested
  init_folder = paste0("D:\\Chapter3\\variables\\degradation_followed_by_deforesation\\",biome_str,"\\")
  setwd(init_folder)
  
  dd_files =  list.files(pattern = paste0(biome_str,'_degradation_minus_deforestation.*.dbf$'), full.names = T)
  dd_data = variable_table(dd_files)
  
  if (biome_str == "borneo"){
    dd_data$total = dd_data$Count
  } else {
    dd_data$total = rowSums(dd_data[, -1] ,na.rm=TRUE)
  }
  
  #label the different types of forest loss
  dd_data$type = 1
  dd_data$type[dd_data$Value >0] = "Degraded only"
  dd_data$type[dd_data$Value <0 & dd_data$Value > -1980] = "Degraded then Deforested"
  dd_data$type[dd_data$Value < -1980] = "Deforested only"
  
  #remove no data
  dd_data = dd_data[dd_data$Value !=0,]
  dd_data$region = biome_str
  
  # drop count columns 
  dd_data = dd_data %>% dplyr::select(-contains("Count"))
  
  all_def_deg[[j]] = dd_data
  
  #remove deforested only 
  deg_all = dd_data[dd_data$Value >-1980,] # all degraded forest (including degraded then deforested)
  
  deg_all_sum = sum(deg_all$total)
  
  #make a df of deforestation of old-growth only
  def_only = dd_data[dd_data$type == "Deforested only",]
  def_only$emissions = (def_only$total)*(old_growth_value/(10000/900)) # total number of pix * AGC of OF in Mg/pixel
  def_only$emissions_lower = (def_only$total)*(old_growth_value_lower/(10000/900)) # total number of pix * AGC of OF in Mg/pixel
  def_only$emissions_upper = (def_only$total)*(old_growth_value_upper/(10000/900)) # total number of pix * AGC of OF in Mg/pixel
  
    
  #deforestation up to 2018 only
  def_only_2018 = def_only[def_only$Value != -2019,]
  def_only_emissions_TgC = sum(def_only_2018$emissions)*0.000001
  def_only_emissions_TgC_lower = sum(def_only_2018$emissions_lower)*0.000001
  def_only_emissions_TgC_upper = sum(def_only_2018$emissions_upper)*0.000001
  
  
    
  # dataframe of those that were degraded and then deforested
  deg_def = dd_data[dd_data$type == "Degraded then Deforested",]
  #Calculating emissions from deforested degraded forests directly is not possible as this includes numbers from 2019
  #deg_def$emissions = (deg_def$total)*(old_growth_value/(10000/900)) # total number of pix * AGC of OF in Mg/pixel
  #deg_def_emissions_TgC = sum(deg_def$emissions)*0.000001
  
  #emissions from deforestation
  #total_deforestation_emissions_TgC = def_only_emissions_TgC + deg_def_emissions_TgC 
  #Need to calculate emissions from deforested degraded forests using "loss" value
  deg_def_emissions_TgC_2018 = deforestation_emissions_TgC - def_only_emissions_TgC
  print(deg_def_emissions_TgC_2018)
  
  deg_def_emissions_TgC_2018_lower = deforestation_emissions_TgC_lower - def_only_emissions_TgC_lower
  print(deg_def_emissions_TgC_2018_lower)
  
  deg_def_emissions_TgC_2018_upper = deforestation_emissions_TgC_upper - def_only_emissions_TgC_upper
  print(deg_def_emissions_TgC_2018_upper)
  #total number of pixels that were degraded and then deforested
  deg_def_sum = sum(deg_def$total)
  
  #percentage of degraded pixels that were degraded and then deforested
  deg_then_def =  ((deg_def_sum/deg_all_sum)*100)
  
  deg_def$age = deg_def$Value*-1
  
  #get the files corresponding to the year in which a forest was degraded within a deforested area
  deg_then_def_files =  list.files(pattern = paste0(biome_str,'_degradation_year_in_def_area.*.dbf$'), full.names = T)
  degdef_data = variable_table(deg_then_def_files)
  
  
  if (biome_str == "borneo"){
    degdef_data$total = degdef_data$Count
  } else {
    degdef_data$total = rowSums(degdef_data[, -1] ,na.rm=TRUE)
  }
  
  # calculate the age when these forests were deforested
  degdef_data$age =   2018 - degdef_data$Value
  degdef_data = degdef_data[degdef_data$Value >2,]
  
  ## read in the corresponding regrowth curve for degraded forest for the region
  result_folder = "D:\\Chapter3\\JRC_recovery\\results\\" 
  
  ######################### Calculate carbon stock potential in deforested degraded forest
  
  #read in the regrowth model for the correct region of degraded forest
  model = readRDS(paste0(result_folder, "regrowthModel_", biome_str, "_deg_agb_fix_noOilPalm_2022-08-23.rds"))
  
  result_folder = "D:\\Chapter3\\JRC_recovery\\results\\" 
  
  #read in the 95% Confidence intervals derived from the Monte Carlo simulations
  CI_mc95 = read.csv(paste0(result_folder, "monte_carlo_95CI_",biome_str,"_degraded_for.csv"))
  
  age = data.frame(age = seq(0, 35, 1))
  
  age$ACD_2018= predict(model, age)
  #merge the data of the degraded-deforested with their age and associated AGC
  all_data = merge(degdef_data, age, all=T)
  

  all_data = merge(all_data, CI_mc95)
  
  all_data$ACD_px = all_data$ACD_2018/(10000/900) #MgC/pixel 30m*30m - 900m2
  all_data$ACD_px_lower = all_data$lowerMargin/(10000/900)
  all_data$ACD_px_upper = all_data$upperMargin/(10000/900)
  
  #emissions from degradation
  all_data$emissions = all_data$total*(degraded_emissions/(10000/900))
  all_data$emissions_lower = all_data$total*(degraded_emissions_lower/(10000/900))
  all_data$emissions_upper = all_data$total*(degraded_emissions_upper/(10000/900))
  
  
  #emissions from deforestation
  all_data$potential_def_emissions = all_data$total*(old_growth_value/(10000/900))
  all_data$potential_def_emissions_lower = all_data$total*(old_growth_value_lower/(10000/900))
  all_data$potential_def_emissions_upper = all_data$total*(old_growth_value_upper/(10000/900))
  
    
  potential_def_emissions = sum(all_data$potential_def_emissions, na.rm=TRUE)
  potential_def_emissions_TgC = potential_def_emissions*0.000001
  #emissions from deforestation of the degraded forests (assuming committed emissions)
  print (potential_def_emissions_TgC)
  
  
  # potential emissions from degradation only
  deg_emissions = sum(all_data$emissions, na.rm = TRUE)
  deg_emissions_TgC = deg_emissions*0.000001
  print(deg_emissions_TgC)
  
  # potential emissions from degradation only - lower
  deg_emissions_lower = sum(all_data$emissions_lower, na.rm = TRUE)
  deg_emissions_TgC_lower = deg_emissions_lower*0.000001
  print(deg_emissions_TgC_lower)
  
  # potential emissions from degradation only - upper 
  deg_emissions_upper = sum(all_data$emissions_upper, na.rm = TRUE)
  deg_emissions_TgC_upper = deg_emissions_upper*0.000001
  print(deg_emissions_TgC_upper)
  
  all_data = na.omit(all_data)
  
  all_data$AGC_total = all_data$ACD_px*all_data$total
  all_data$AGC_total_lower = all_data$ACD_px_lower*all_data$total
  all_data$AGC_total_upper = all_data$ACD_px_upper*all_data$total
  
  
  additional_C_potential=sum(all_data$AGC_total, na.rm=TRUE) # MgC
  print(additional_C_potential*0.000001)
  
  additional_C_potential_lower=sum(all_data$AGC_total_lower, na.rm=TRUE) # MgC
  print(additional_C_potential_lower*0.000001)
  
  additional_C_potential_upper=sum(all_data$AGC_total_upper, na.rm=TRUE) # MgC
  print(additional_C_potential_upper*0.000001)
  
  #take away the emissions that were lost from degradation
  C_potential_TgC = (additional_C_potential*0.000001) - deg_emissions_TgC
  print(C_potential_TgC)
  
  
  
}

##################### Outside loop  ###################
#library(egg)

p_no_legend = lapply(plot_list, function(x) x + theme(legend.position = "none"))

leg = cowplot::get_legend(plot_list[[1]] + theme(legend.position = "bottom"))


main_folder = "D:\\Chapter3\\JRC_recovery\\"


all_subplots=egg::ggarrange(p_no_legend[[1]],
                                p_no_legend[[2]] + theme(axis.text.y = element_blank(),
                                                       axis.title.y = element_blank()),
                                p_no_legend[[3]] + theme(axis.text.y = element_blank(),
                                                       axis.title.y = element_blank()),
                                nrow=1)
all_forest_changes=cowplot::plot_grid(all_subplots, leg, ncol=1, rel_heights = c(1, .1))

print(all_forest_changes)

ggsave(paste0(main_folder,"results\\gains_losses_km2",Sys.Date(),".png"),all_forest_changes, width =12, height=5, units="in" , dpi=900)

all_data_deg = do.call(rbind, all_regions_deg)
all_data_loss = do.call(rbind, all_def_deg)

#calculate the amount of deforestation/degradation per year over all the regions
deg_by_year = all_data_deg %>%
  group_by(Year) %>%
  summarise(deforestedPix = sum(pixelTotal),
            degradedPix = sum(degradedTotal))

deg_by_year$sum = deg_by_year$deforestedPix + deg_by_year$degradedPix
deg_by_year$deforestedPercentage = deg_by_year$deforestedPix/deg_by_year$sum

#considering only degradation/deforestation from 1990 as beofre this there is a lot of uncertainty in the datasets
deg_by_year_1990 = deg_by_year[deg_by_year$Year>1989,]

all_data_deg_1990 = all_data_deg[all_data_deg$Year>1989,]

av_deg_year_1990 = all_data_deg_1990 %>%
  group_by(region) %>%
  summarise(avDef = mean(percent_defor))

mean(deg_by_year$deforestedPercentage)
mean(deg_by_year_1990$deforestedPercentage)

#calculate the % of degraded forests that were later deforested by 2018

def_only = all_data_loss[all_data_loss$type == "Deforested only",]


deg_def = all_data_loss[all_data_loss$type == "Degraded then Deforested",]

deg_def_sum = sum(deg_def$total)

deg_all = all_data_loss[all_data_loss$Value >-1980,]

deg_all_sum = sum(deg_all$total)

deg_then_def =  ((deg_def_sum/deg_all_sum)*100)
print(deg_then_def)


#Lower: ((1808 + 1348) + (589 + 384) + (597 + 384))/((5811 + 1746 + 1603) +(1339 + 1261 + 632) +(449 + 595 + 351))
#Upper: ((2541 + 1603) +(913 + 495) +(836 + 454))/((5699 + 1746 + 710) +(1301 + 886 + 444) + (441 + 306 + 181))
