# Machine Learning Foundations 

Sumudu Tennakoon, Ph.D.

## Course Description

Machine-Learning enables us to uncover trends and patterns hidden in data and make predictions based on historical observations. Machine-Learning is crucial in implementing Artificial Intelligence (AI) systems and helps industry and academia in complex problem-solving, predictive analytics, automation, etc. Therefore, Machine-Learning is an essential skill a Data Science and related technical professionals should carry in their toolboxes. 

This course aims to provide a fundamental understanding of the core principles of Machine Learning (ML) with hands-on training on applying machine learning to solve real-world problems. A learner who completes this course should be able to define a machine learning problem, understand the solution path, and display the ability to carry out the end-to-end process of building a machine learning application.

## Topics Covered
1. Introduction to Machine Learning (ML), History, and Applications
2. Setting up a Computing Environment, Python and Required Libraries.
3. Knowledge Foundations for ML (Computing, Statistics, and Mathematics)
4. Exploratory Data Analysis (EDA) and Feature Engineering
5. Supervised Machine Learning
6. Unsupervised Machine Learning
7. Explaining ML Models and Predictions
8. Introduction to Deep Learning and Neural Networks
9. Design, Develop and Deploy ML Solutions
10. Capstone Project

## Prerequisites: 
- Basics of computer programming, mathematics, and statistics.
- Basic knowledge in computer applications: spreadsheet, word processor and presentation authoring.

## About Instructor
Sumudu Tennakoon is a Data Scientist with five years of experience working in the industry. Sumudu earned his Ph.D. in physics from the University of Mississippi, USA, Bachelor's degree from the University of Kelaniya, Sri Lanka, and Advanced Certificate in Information technology (ACIT) from the University of Colombo School of Computing, Sri Lanka. Before starting his career in Data Science, he worked as a postdoctoral scholar at Florida State University, USA. Even though he is a physics major, he learned computer science by taking a significant amount of coursework during his university education and is proficient in multiple programming languages. In his current role, he is responsible for research and develop analytics solutions based on machine learning and predictive analytics. Sumudu is passionate about teaching and mentoring. He believes empowering youth to achieve their educational and professional goals is one of the most impactful ways to build a better future.

- LinkedIn : https://www.linkedin.com/in/sptennakoon
- Twitter : https://twitter.com/sptennakoon
- Medium: https://sumudutennakoon.medium.com/membership
- YouTube: https://www.youtube.com/channel/UC1YPSsjZIpFhZGTk83Nrd3A

<hr/>

<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License</a>
