: Comment: The persistent component of the K current
: Reference:		Voltage-gated K+ channels in layer 5 neocortical pyramidal neurones from young rats:subtypes and gradients,Korngreen and Sakmann, J. Physiology, 2000


NEURON	{
	SUFFIX K_P
	USEION k READ ek WRITE ik
	RANGE gbar, g, ik
}

UNITS	{
	(S) = (siemens)
	(mV) = (millivolt)
	(mA) = (milliamp)
}

PARAMETER	{
	gbar = 0.00001 (S/cm2)
	vshift = 0 (mV)
	tauF = 1
}

ASSIGNED	{
	v	(mV)
	g	(S/cm2)
	celsius (degC)
	mInf
	mTau
	hInf
	hTau
}

STATE	{
	m
	h
}

BREAKPOINT	{
	SOLVE states METHOD cnexp
	g = gbar*m*m*h
	ik = g*(v-ek)
}

DERIVATIVE states	{
	rates(v)
	m' = (mInf-m)/mTau
	h' = (hInf-h)/hTau
}

INITIAL{
	rates(v)
	m = mInf
	h = hInf
}

PROCEDURE rates(v) {
       LOCAL qt
       qt = 2.3^((celsius-21)/10)
       UNITSOFF
       mInf =  1 / (1 + exp(-(v - (-14.3 + vshift)) / 14.6))
       if (v < -50 + vshift){
           mTau = tauF * (1.25+175.03*exp(-(v - vshift) * -0.026))/qt
       } else {
           mTau = tauF * (1.25+13*exp(-(v - vshift) * 0.026))/qt
       }
       hInf =  1/(1 + exp(-(v - (-54 + vshift))/-11))
       hTau =  (360+(1010+24*(v - (-55 + vshift)))*exp(-((v - (-75 + vshift))/48)^2))/qt
       UNITSON
}
