# based on a script from the llvm project:
#   http://releases.llvm.org/4.0.0/LICENSE.TXT

# CMake find_package() Module for Sphinx documentation generator
# http://sphinx-doc.org/
#
# Example usage:
#
# find_package(Sphinx)
#
# If successful the following variables will be defined
# SPHINX_FOUND
# SPHINX_EXECUTABLE
find_program(
    SPHINX_EXECUTABLE
    NAMES sphinx-build sphinx-build2
    DOC "Path to sphinx-build executable")

# this will also set SPHINX_FOUND to true if SPHINX_EXECUTABLE exists
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    Sphinx
    "Failed to locate sphinx-build executable"
    SPHINX_EXECUTABLE)
