#!/usr/bin/python3
import os
import sys
import numpy as np
import pandas as pd
import glob
import io

kdeg = 0.043
Proteins_MW = pd.read_excel('/Users/pranas/surfdrive/MEmodels/pcYeast8/pcYeast8_dynamicInfo.xls', sheet_name = 'proteinProperties')

Proteins_MW = Proteins_MW[['Gene names  (ordered locus)', 'Entry', 'Mass']]

Proteins_MW = Proteins_MW.rename(columns = {'Gene names  (ordered locus)': 'Protein'})
Proteins_MW['Protein'] = Proteins_MW['Protein'].str.replace('-', '')

directory = sys.argv[1]
os.chdir(directory)
outputs = glob.glob('*.out')
outputs.sort()

for i in range(0, len(outputs)): 
	with open(outputs[i], 'r') as f:
		soplex_output = f.readlines()
		f.close()
	for j in range(0, len(soplex_output)):
		if soplex_output[j] == "Primal solution (name, value):\n": begin_of_table = j + 1
		if soplex_output[j].find('All other variables') >=0:
			end_of_table = j
			break
	fluxes = soplex_output[begin_of_table:end_of_table]
	for j in range(0, len(fluxes)):	fluxes[j] = fluxes[j].replace('    ','')
	flux_table = pd.read_csv(io.StringIO('\n'.join(fluxes)), sep = '\t', header=None)
	flux_table.columns = ['flux', 'value']
	mu = round(flux_table['value'].loc[flux_table['flux'] == 'r_4041'].values[0], 7)
	flux_table.columns = ['Entry', mu]
	
	flux_table['Entry'] = flux_table['Entry'].str.replace('_translation_Ribosome', '')
	flux_table['Entry'] = flux_table['Entry'].str.replace('_translation_MitoRibosome', '')
	
	Proteins_MW = Proteins_MW.merge(flux_table, on = 'Entry', how = 'left').fillna(0)
	Proteins_MW[mu] = (Proteins_MW[mu] * Proteins_MW['Mass']/1000.0)/(mu + kdeg)
	Proteins_MW[mu] = Proteins_MW[mu]/sum(Proteins_MW[mu])

Proteins_MW = Proteins_MW.loc[(Proteins_MW[Proteins_MW.columns[3:]].sum(axis = 1) != 0), :]
Proteins_MW.to_csv('ProteinAbundance.csv', index=False)
