##Prerequisites to run the model
The model should work under `Python3.10`, using the pip packages `numpy, pandas, cbmpy` and their dependencies. For solving linear programs, solvers `CPLEX` and `SoPlex` were used (both available for free with a academic license). For running CBMpy in Py3.10, one should modify the code to get it running (some changes are not backwards-compatible).

##How to run the model
Model essentially consists of two parts: static and dynamic. Static part is stored in the SBML file `pcYeast8_static_v0.22.xml`, and the dynamic part is handled through a binary search. The binary search is initiated by calling
`python3 dynamicSolverRunner.py <str:parameter_name> <float:initial_value> <float:step_size> <integer:number_of_steps> <str:output_directory>`

For instance, to vary parameter `sat_f` between 0.1 and 1.0 for 10 consecutive steps:
`python3 dynamicSolverRunner.py 'sat_f' 0.1 1.0 10 './results/tmp'`

##Model analysis
Two scripts are provided for this: `analysisRunner.py` and `proteinParsing.py`. You only need to run `python3 analysisRunner.py ./path/to/results/folder`, and `proteinParsing.py` will be called as well. Note that you might need to modify the path for the auxiliary files (dynamicInfo and others), but that should be relatively easy.

Have the following in mind: the folder you specify for results in the `dynamicSolverRunner` call will contain *all* the linear programs & their solution outputs. The subfolder `./results` contains the solutions you need to analyze (i.e. these with determined maximal growth rate at the fixed parameter value). Thus if your target folder was `./results/tmp`, run `python3 analysisRunner.py ./results/tmp/results`.

##Sample run - aerobic glucose-limited chemostat
I've also provided a sample run, a classical case of glc-limited chemostats, both raw output and analyzed data (.csv files with the meaningful names). The analysis pipeline should help you get hold of what's happening in this huge model.