import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from matplotlib import gridspec

plt.rcParams['font.size'] = '14'
fig = plt.figure(tight_layout = True, figsize = (6, 6))
ax = fig.subplots(1,1)
#ax = ax.ravel()

mpl.style.use('default')

growthRates = pd.read_excel('FigureS7_data.xlsx')

color_scheme = []
for i in range(0,3): 
	color = next(ax._get_lines.prop_cycler)['color']
	color_scheme.append(color)

width = 0.2  # the width of the bars
ax.set_title('Predicted batch growth rate')
labelsMu = [r'GAM = 24', r'GAM = 40']
labels_nosplit = ['WT', r'$\Delta$Mae1', r'$\Delta$Adh3']
x = np.arange(len(labelsMu))  # the label locations

for j in [['WT', -1.0, labels_nosplit[0]], ['dMae1', 0.0, labels_nosplit[1]], ['dAdh3', +1.0, labels_nosplit[2]]]:
	ax.bar(x + (j[1] * width), growthRates['mu'].loc[growthRates['Strain'] == j[0]], width, label = j[2], edgecolor = 'black', color = color_scheme[1 + int(j[1])])

ax.set_xticks(x, labelsMu, size = 10)
ax.set_ylabel(r'$\mu$ ($h^{-1}$)')
ax.set_ylim(0.0,0.45)
ax.legend(fontsize = 'small')
ax.set_aspect(1./ax.get_data_ratio())

plt.savefig('FigureS7.pdf')
#plt.show()

