import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from matplotlib import gridspec

plt.rcParams['font.size'] = '14'
fig = plt.figure(tight_layout = True, figsize = (12,12))

gs = gridspec.GridSpec(5,3)
gs_main = gridspec.GridSpecFromSubplotSpec(1,3, gs[0:2,0:3], wspace = 0.5)
gs_005 = gridspec.GridSpecFromSubplotSpec(1,4, gs[2,0:3], wspace = 0.5)
gs_010 = gridspec.GridSpecFromSubplotSpec(1,4, gs[3,0:3], wspace = 0.5)
gs_batch = gridspec.GridSpecFromSubplotSpec(1,4, gs[4,0:3], wspace = 0.5)

ax = list(range(15))

ax[0] = plt.subplot(gs_main[0,0])
ax[1] = plt.subplot(gs_main[0,1])
ax[2] = plt.subplot(gs_main[0,2])

ax[3] = plt.subplot(gs_005[0,0])
ax[4] = plt.subplot(gs_005[0,1])
ax[5] = plt.subplot(gs_005[0,2])
ax[6] = plt.subplot(gs_005[0,3])

ax[7] = plt.subplot(gs_010[0,0])
ax[8] = plt.subplot(gs_010[0,1])
ax[9] = plt.subplot(gs_010[0,2])
ax[10] = plt.subplot(gs_010[0,3])

ax[11] = plt.subplot(gs_batch[0,0])
ax[12] = plt.subplot(gs_batch[0,1])
ax[13] = plt.subplot(gs_batch[0,2])
ax[14] = plt.subplot(gs_batch[0,3])

mpl.style.use('default')

pp_Clim = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_anaerobic_GAM40')
pp_Clim_dMae1 = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'pp_Clim_dMae1')
pp_Clim_dAdh3_dGpd2 = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'pp_Clim_dAdh3_dGpd2')
pp_Nlim = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'pp_Nlim_GAM40')
pp_Nlim_dMae1 = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'pp_Nlim_dMae1')
pp_Nlim_dAdh3_dGpd2 = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'pp_Nlim_dAdh3_dGpd2')

exp_Clim = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'experimentalData_anaerobic')
exp_Nlim = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'chemostatMeasured')
exp_Nlim = exp_Nlim.loc[(exp_Nlim['Limitation'] == 'N-limited') & (exp_Nlim['Phenotype'] == 'WT')]

chemostatData = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'chemostatPred')
chemostatMeas = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'chemostatMeasured')

batchData = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'batchPred')
batchMeas = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'batchMeasured')

batchClim = batchData.loc[batchData['Limitation'] == 'C-limited']

color_scheme = []
for i in range(0,2): 
	color = next(ax[0]._get_lines.prop_cycler)['color']
	color_scheme.append(color)

ax[0] = pp_Clim.plot('mu', 'Yxs', ax = ax[0], c = color_scheme[0], lw = 2.5, label = 'C-limited')
ax[0] = pp_Nlim.plot('mu', 'Yxs', ax = ax[0], c = color_scheme[1], lw = 2.5, label = 'N-limited')

ax[1] = pp_Clim_dMae1.plot('mu', 'Yxs', ax = ax[1], c = color_scheme[0], lw = 2.5, label = 'C-limited')
ax[1] = pp_Nlim_dMae1.plot('mu', 'Yxs', ax = ax[1], c = color_scheme[1], lw = 2.5, label = 'N-limited')

ax[2] = pp_Clim_dAdh3_dGpd2.plot('mu', 'Yxs', ax = ax[2], c = color_scheme[0], lw = 2.5, label = 'C-limited')
ax[2] = pp_Nlim_dAdh3_dGpd2.plot('mu', 'Yxs', ax = ax[2], c = color_scheme[1], lw = 2.5, label = 'N-limited')

for i in range(0,3):
	ax[i].axvline(batchClim['mu'][batchClim.index[i]], lw = 1.0, color = 'grey')
	ax[i] = exp_Clim.plot('mu', 'Yxs', ax = ax[i], ls='', c = color_scheme[0], marker='o', markeredgecolor = 'black', markersize = 9, label = 'C-limited')
	ax[i] = exp_Nlim.plot('Approx_mu', 'Yxs', ax = ax[i], ls='', c = color_scheme[1], marker='o', markeredgecolor = 'black', markersize = 9, label = 'N-limited')
	ax[i].axvline(0.05, lw = 1.0, color = 'grey')
	ax[i].axvline(0.10, lw = 1.0, color = 'grey')
	ax[i].axvline(max(pp_Clim['mu']) * 1.005, 0.0, 1, lw = 1.0, color = 'grey')
	ax[i].text(max(pp_Clim['mu']) * 0.92, 0.12, r'$\mu_{max}$',rotation=90)
	ax[i].set_xlim(0.0,0.4)
	ax[i].set_ylim(0.0,0.14)
	ax[i].set_aspect(1./ax[i].get_data_ratio())
	ax[i].set_xlabel(r'Growth rate ($h^{-1}$)')
	ax[i].set_ylabel(r'$Y_{X/S}$ ($gDW/g Glc$)')
	h, l = ax[i].get_legend_handles_labels()
	ax[i].legend(handles=zip(h[0:2], h[2:4]), labels=l[0:2], title = 'Condition', fontsize = 'large')

########### CHEMOSTATS
fluxesToPlot = ['qGlc', 'qEtOH', 'qGlyc', 'qCO2']
fluxesForLabels = [r'$q_{Glc}$', r'$q_{EtOH}$', r'$q_{Glyc}$', r'$q_{CO_{2}}$']
labels = ['WT', 'dMae1', 'dAdh3_dGpd2']
labelsForLabels = ['WT', r'$\Delta$Mae1', r'$\Delta$Adh3']
x = np.arange(len(labels))  # the label locations
width = 0.35  # the width of the bars

for i in zip(fluxesToPlot, range(3,7), [10, 15, 1.0, 15], fluxesForLabels):
	fluxValues = chemostatData.loc[chemostatData['Approx_mu'] == 0.05]
	measValues = chemostatMeas.loc[chemostatMeas['Approx_mu'] == 0.05]
	for j in [['C-limited', -1.0, 0], ['N-limited', +1.0, 1]]:
		ax[i[1]].bar(x + (j[1] * width/2.0), fluxValues[i[0]].loc[fluxValues['Limitation'] == j[0]], width, label = j[0], edgecolor = 'black')
		mC = measValues[i[0]].loc[measValues['Limitation'] == j[0]]
		ax[i[1]].scatter([(x + (j[1] * width/2.0))], mC.values, label = None, color = color_scheme[j[2]], edgecolors = 'black')
	ax[i[1]].set_xticks(x, labelsForLabels, size = 10)
	ax[i[1]].set_title(i[3])
	ax[i[1]].axvline(0.5, lw = 1.0, color = 'grey')
	ax[i[1]].axvline(1.5, lw = 1.0, color = 'grey')
	ax[i[1]].set_ylabel('Specific flux \n' + r'($mmol\ gDW^{-1}\ h^{-1}$)')
	ax[i[1]].set_ylim(0.0, i[2])

for i in zip(fluxesToPlot, range(7,11), [10, 15, 1, 15], fluxesForLabels):
	fluxValues = chemostatData.loc[chemostatData['Approx_mu'] == 0.10]
	measValues = chemostatMeas.loc[chemostatMeas['Approx_mu'] == 0.10]
	for j in [['C-limited', -1.0, 0], ['N-limited', +1.0, 1]]:
		ax[i[1]].bar(x + (j[1] * width/2.0), fluxValues[i[0]].loc[fluxValues['Limitation'] == j[0]], width, label = j[0], edgecolor = 'black')
		mC = measValues[i[0]].loc[measValues['Limitation'] == j[0]]
		ax[i[1]].scatter([(x + (j[1] * width/2.0))], mC.values, label = None, color = color_scheme[j[2]], edgecolors = 'black')
	ax[i[1]].set_xticks(x, labelsForLabels, size = 10)
	ax[i[1]].set_title(i[3])
	ax[i[1]].axvline(0.5, lw = 1.0, color = 'grey')
	ax[i[1]].axvline(1.5, lw = 1.0, color = 'grey')
	ax[i[1]].set_ylabel('Specific flux \n' + r'($mmol\ gDW^{-1}\ h^{-1}$)')
	ax[i[1]].set_ylim(0.0, i[2])

########### Batch comparison
fluxesToPlot = ['mu', 'qGlc', 'qEtOH', 'qGlyc']
fluxesForLabels = [r'Growth rate $\mu$', r'$q_{Glc}$', r'$q_{EtOH}$', r'$q_{Glyc}$']
labels = ['WT', 'dMae1', 'dAdh3_dGpd2']
labelsForLabels = ['WT', r'$\Delta$Mae1', r'$\Delta$Adh3']
x = np.arange(len(labels))  # the label locations
width = 0.35  # the width of the bars

for i in zip(fluxesToPlot, range(11,15), [0.35, 20, 30, 6], fluxesForLabels):
	for j in [['C-limited', 0, 0]]:
		ax[i[1]].bar(x + (j[1] * width/2.0), batchData[i[0]].loc[batchData['Limitation'] == j[0]], width, label = j[0], edgecolor = 'black')
		mC = batchMeas[i[0]].loc[batchMeas['Limitation'] == j[0]]
		ax[i[1]].scatter(x + (j[1] * width/2.0), mC.values, label = None, color = color_scheme[j[2]], edgecolors = 'black')
	ax[i[1]].set_xticks(x, labelsForLabels, size = 10)
	ax[i[1]].set_title(i[3])
	ax[i[1]].axvline(0.5, lw = 1.0, color = 'grey')
	ax[i[1]].axvline(1.5, lw = 1.0, color = 'grey')
	ax[i[1]].set_ylabel('Specific flux \n' + r'($mmol\ gDW^{-1}\ h^{-1}$)')
	ax[i[1]].set_ylim(0.0, i[2])

########### GENERAL
ax[0].set_title('Anaerobic WT', fontsize = 14)
ax[1].set_title(r'Anaerobic $\Delta$Mae1', fontsize = 14)
ax[2].set_title(r'Anaerobic $\Delta$Adh3', fontsize = 14)

for i in range(len(ax)): ax[i].set_aspect(1./ax[i].get_data_ratio())

plt.savefig('FigureS6.pdf')
#plt.show()

