import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from matplotlib import gridspec

plt.rcParams['font.size'] = '14'
fig = plt.figure(tight_layout = True, figsize = (10, 5))
ax = fig.subplots(1,2)
ax = ax.ravel()
mpl.style.use('default')

phi_ribosome = pd.read_excel('../Figure3/Figure3_data.xlsx', sheet_name = 'predictedPhiRibosome')
phi_measured = pd.read_excel('../Figure3/Figure3_data.xlsx', sheet_name = 'measuredPhiRibosome')

ax[0].set_title(r'Ribosomal proteome fraction $\Phi_{R}$')
ax[0] = phi_ribosome.plot(x = 'mu', y = 'RiboMassFraction', ax = ax[0], lw = 2.5, legend = None)

for i in phi_measured['Source'].unique(): ax[0] = phi_measured.loc[phi_measured['Source'] == i].plot('mu', 'RiboMassFraction', ax = ax[0], marker = 'o', ls='', markeredgecolor = 'black', markersize = 9, label = i)

color_scheme = []
for i in range(0,2): 
	color = next(ax[1]._get_lines.prop_cycler)['color']
	color_scheme.append(color)


########### PROTEOME
mappings = pd.read_excel('/home/pranas/SURFdrive/MEmodels/data/PG_annotations/AnnotationSetPG.xls', sheet_name = 'S. cerevisiae')

predP = pd.read_excel('../Figure3/Figure3_data.xlsx', sheet_name = 'predictedProteome')
measP = pd.read_excel('../Figure3/Figure3_data.xlsx', sheet_name = 'measuredProteome')
measP = measP.fillna(0)

predictedCl = pd.DataFrame(columns = ['Pathway'] + list(predP.columns[3:]))
predictedCl.Pathway = ['Ribosome']
for i in predictedCl.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clusterPredicted = predP.loc[predP['Protein'].isin(clusterMapped['Protein'])]
	for j in predictedCl.columns[1:]:
		predictedCl.loc[predictedCl.Pathway == i, j] = sum(clusterPredicted[j])

measuredCl = pd.DataFrame(columns = ['Pathway'] + list(measP.columns[3:]))
measuredCl.Pathway = ['Ribosome']
for i in measuredCl.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clustermeasured = measP.loc[measP['Gene'].isin(clusterMapped['Protein'])]
	for j in measuredCl.columns[1:]:
		measuredCl.loc[measuredCl.Pathway == i, j] = sum(clustermeasured[j])

for i in ['Rich_aerobic', 'Min_aerobic']: 
	predictedCl[i] = predictedCl[i]/predictedCl['Min_aerobic']
	for j in [x for x in measuredCl.columns if x.find(i) >= 0]: measuredCl[j] = measuredCl[j]/measuredCl[j.replace('Rich', 'Min')]

for i in ['Rich_anaerobic', 'Min_anaerobic']: 
	predictedCl[i] = predictedCl[i]/predictedCl['Min_anaerobic']
	for j in [x for x in measuredCl.columns if x.find(i) >= 0]: measuredCl[j] = measuredCl[j]/measuredCl[j.replace('Rich', 'Min')]

labels = ['Aerobic', 'Anaerobic']
x = np.arange(len(labels))  # the label locations
width = 0.35  # the width of the bars

for j in [['Min', -1.0, 0], ['Rich', +1.0, 1]]:
	predCluster = predictedCl[[x for x in predictedCl.columns if x.find(j[0]) >= 0]]
	measCluster = measuredCl[[x for x in measuredCl.columns if x.find(j[0]) >= 0]]
	ax[1].bar(x + (j[1] * width/2.0), predCluster.values.tolist()[0], width, label = j[0], edgecolor = 'black')
	for k in [['_aerobic', 0], ['_anaerobic', 1]]:
		mC = measCluster[[x for x in measCluster.columns if x.find(k[0]) >= 0]]
		ax[1].scatter([(x + (j[1] * width/2.0))[k[1]]] * len(mC.columns), mC.values.tolist()[0], label = None, color = color_scheme[j[2]], edgecolors = 'black')
	ax[1].set_xticks(x, labels)
	ax[1].set_title(r'Relative $\Phi_{R}$')
	ax[1].axvline(0.5, lw = 1.0, color = 'grey')
	ax[1].set_ylabel('Relative proteome fraction')
	ax[1].set_ylim(0.0, 1.4)

########### GENERAL
ax[0].set_xlabel(r'Growth rate ($h^{-1}$)')
ax[0].set_ylabel(r'Proteome fraction ($g\ (g\ protein)^{-1}$)')
ax[0].set_xlim(0.0,0.5)
ax[0].set_ylim(0.0,0.4)

ax[1].legend()

for i in range(len(ax)): ax[i].set_aspect(1./ax[i].get_data_ratio())

plt.savefig('FigureS5.pdf')
#plt.show()

