import numpy as np
import pandas as pd
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc

anaerobic_022 = pd.read_excel('FigureS4_data.xlsx', sheet_name = 'pp_anaerobic_GAM40_up0.22')
anaerobic_032 = pd.read_excel('FigureS4_data.xlsx', sheet_name = 'pp_anaerobic_GAM40_up0.32')

AAmeasurements = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'experimentalData_anaerobic')

mpl.style.use('default')

plt.rcParams['font.size'] = '14'
fig = plt.figure(tight_layout = True, figsize = (10, 5))
ax = fig.subplots(1,2)
ax = ax.ravel()

ax[0].set_title(r'$UP_{min} = 0.22\ g\ (g\ protein)^{-1}$')
ax[1].set_title(r'$UP_{min} = 0.32\ g\ (g\ protein)^{-1}$')

for i in [['qGlc', r'$qGlc$'], ['qO2', r'$qO_{2}$'], ['qEtOH', r'$qEtOH$'], ['qCO2', r'$qCO_{2}$'], ['qGlyc', r'$qGlyc$']]:
	color = next(ax[0]._get_lines.prop_cycler)['color']
	ax[0] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CEN.PK'].plot(x = 'mu', y = i[0], ax = ax[0], ls='', c = color, marker='o', markeredgecolor = 'black', markersize = 9, label = i[1])
	ax[0] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CBS8066'].plot(x = 'mu', y = i[0], ax = ax[0], ls='', c = color, marker='v', markeredgecolor = 'black', markersize = 9, label = i[1])
	ax[1] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CEN.PK'].plot(x = 'mu', y = i[0], ax = ax[1], ls='', c = color, marker='o', markeredgecolor = 'black', markersize = 9, legend = None)
	ax[1] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CBS8066'].plot(x = 'mu', y = i[0], ax = ax[1], ls='', c = color, marker='v', markeredgecolor = 'black', markersize = 9, legend = None)
	ax[0] = anaerobic_022.plot(x = 'mu', y = i[0], ax = ax[0], c = color, lw = 2.5, label = i[1])
	ax[1] = anaerobic_032.plot(x = 'mu', y = i[0], ax = ax[1], c = color, lw = 2.5, legend = None)

plt.setp(ax, xlim = [0.0,0.40], ylim = [0.0, 30.0])

h, l = ax[0].get_legend_handles_labels()
ax[0].legend(handles=[(h[0], h[1])] + list(zip(h[6::3], h[7::3])), labels=[l[0]] + l[6::3], handler_map = {tuple: mpl.legend_handler.HandlerTuple(None)}, title = 'Flux', fontsize = 'medium')

h, l = ax[1].get_legend_handles_labels()
ax[1].legend(handles=h[0:2], labels=['CEN.PK', 'CBS8066'], handler_map = {tuple: mpl.legend_handler.HandlerTuple(None)}, title = 'Strain', fontsize = 'medium')

for i in range(len(ax)):
	ax[i].set_aspect(1./ax[i].get_data_ratio())
	ax[i].set_xlabel(r'Growth rate ($h^{-1}$)')
	ax[i].set_ylabel('Specific flux ($mmol\ gDW^{-1}\ h^{-1}$)')

plt.savefig('FigureS4.pdf')
#plt.show()

