import numpy as np
import pandas as pd
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from mpl_toolkits.axes_grid.inset_locator import inset_axes

WTmodel = pd.read_excel('../Figure1/Figure1_data.xlsx', sheet_name = 'physiologicalParameters')
OEmodel = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'physiologicalParameters_Hap4OE')
DMmodel = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_Hap4delta_GAM40')
DMmodel_24 = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_Hap4delta_GAM24')
anaerobic = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_anaerobic_GAM40')
anaerobic_24 = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_anaerobic_GAM24')

anaerobic_Nlim = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'pp_Nlim_GAM40')
anaerobic_Nlim_24 = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'pp_Nlim_GAM24')

mpl.style.use('default')

plt.rcParams['font.size'] = '14'
fig = plt.figure(tight_layout = True, figsize = (12, 8))
ax = fig.subplots(2,3)
ax = ax.ravel()

ax[0].set_title('Aerobic WT')
ax[1].set_title('Hap4 overexpression')
ax[2].set_title(r'$\Delta$Hap4')
ax[3].set_title(r'Anaerobic C-limited')
ax[4].set_title(r'Anaerobic N-limited')

for i in [WTmodel, OEmodel, DMmodel, DMmodel_24, anaerobic, anaerobic_24, anaerobic_Nlim, anaerobic_Nlim_24]: i['EtOH_Glc_ratio'] = i['qEtOH']/i['qGlc']

ax[0] = WTmodel.plot(x = 'mu', y = 'EtOH_Glc_ratio', ax = ax[0], lw = 2.5, legend = None)
ax[1] = OEmodel.plot(x = 'mu', y = 'EtOH_Glc_ratio', ax = ax[1], lw = 2.5, legend = None)
ax[2] = DMmodel_24.plot(x = 'mu', y = 'EtOH_Glc_ratio', ax = ax[2], lw = 2.5, label = '24')
ax[2] = DMmodel.plot(x = 'mu', y = 'EtOH_Glc_ratio', ax = ax[2], lw = 2.5, label = '40')
ax[3] = anaerobic_24.plot(x = 'mu', y = 'EtOH_Glc_ratio', ax = ax[3], lw = 2.5, label = '24')
ax[3] = anaerobic.plot(x = 'mu', y = 'EtOH_Glc_ratio', ax = ax[3], lw = 2.5, label = '40')

ax[4] = anaerobic_Nlim_24.plot(x = 'mu', y = 'EtOH_Glc_ratio', ax = ax[4], lw = 2.5, label = '24')
ax[4] = anaerobic_Nlim.plot(x = 'mu', y = 'EtOH_Glc_ratio', ax = ax[4], lw = 2.5, label = '40')

plt.setp(ax, xlim = [0.0,0.50], ylim = [0.0, 2.0])
'''
for i in zip(range(0,4), [0.30, 0.30, 0.12, 0.06]): 
	ax[i[0]].set_ylim(0.0, i[1])
	
'''
for i in [2,3,4]: ax[i].legend(title = 'GAM value', fontsize = 'small')

for i in range(len(ax)):
	ax[i].set_aspect(1./ax[i].get_data_ratio())
	ax[i].set_ylabel(r'$q_{EtOH}/q_{Glc}$')
	ax[i].set_xlabel(r'Growth rate ($h^{-1}$)')

plt.savefig('FigureS3.pdf')
#plt.show()

