import numpy as np
import pandas as pd
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from mpl_toolkits.axes_grid.inset_locator import inset_axes

WTmodel = pd.read_excel('../Figure1/Figure1_data.xlsx', sheet_name = 'physiologicalParameters')
OEmodel = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'physiologicalParameters_Hap4OE')
DMmodel = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_Hap4delta_GAM40')
DMmodel_24 = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_Hap4delta_GAM24')
anaerobic = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_anaerobic_GAM40')
anaerobic_24 = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_anaerobic_GAM24')

mpl.style.use('default')

plt.rcParams['font.size'] = '14'
fig = plt.figure(tight_layout = True, figsize = (14, 8))
ax = fig.subplots(2,4)
ax = ax.ravel()

ax[0].set_title('Batch growth rate')

width = 0.25  # the width of the bars
ax[1].set_title('Growth yield on glucose')
labels_nosplit = ['24', '40']
labelsMu = ['WT', r'$\Delta$Mae1', r'$\Delta$Adh3']

fluxValues = yields.loc[yields['Limitation'] == 'C-limited']
for j in [['WT', -1.0, labels_nosplit[0]], ['dMae1', 0.0, labels_nosplit[1]], ['dAdh3', +1.0, labels_nosplit[2]]]:
	ax[1].bar(x + (j[1] * width), fluxValues['Yxs'].loc[fluxValues['Phenotype'] == j[0]], width, label = j[2], edgecolor = 'black', color = color_scheme[1 + int(j[1])])
	ax[1].scatter([(x + (j[1] * width * 1.05))], fluxValues['Yxs_experimental'].loc[fluxValues['Phenotype'] == j[0]].values, label = None, edgecolors = 'black', color = color_scheme[1 + int(j[1])])


ax[1].set_xticks(x, labelsMu, size = 10)
ax[1].set_ylabel(r'$Y_{X/S}$ ($gDW/g Glc$)')
ax[1].set_ylim(0.0,0.15)
ax[1].legend(fontsize = 'small')


plt.setp(ax, xlim = [0.0,0.50])

for i in list(range(0,4)):
	ax[i].set_ylabel(r'$\Phi_{Mitochondrial}$ ($g\ (g\ protein)^{-1}$)')
	ax[i].set_ylim(0.0, 0.30)

for i in [2, 3, 6, 7]: ax[i].legend(title = 'GAM value', fontsize = 'small')

for i in range(len(ax)):
	ax[i].set_aspect(1./ax[i].get_data_ratio())
	ax[i].set_xlabel(r'Growth rate ($h^{-1}$)')

plt.savefig('FigureS2.pdf')
#plt.show()

