import copy
import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from matplotlib import gridspec
from scipy.stats import linregress

plt.rcParams['font.size'] = '14'
fig = plt.figure(tight_layout = True, figsize = (7,7))
ax = fig.subplots(2,2)
ax = ax.ravel()

mpl.style.use('default')

color_scheme = []
for i in range(0,5): 
	color = next(ax[0]._get_lines.prop_cycler)['color']
	color_scheme.append(color)

mappings = pd.read_excel('/home/pranas/SURFdrive/MEmodels/data/PG_annotations/AnnotationSetPG.xls', sheet_name = 'S. cerevisiae')

predP = pd.read_excel('../Figure1/Figure1_data.xlsx', sheet_name = 'predictedProteome')
measP_chemostat = pd.read_excel('../Figure1/Figure1_data.xlsx', sheet_name = 'measuredProteomeChemostat')
measP_batch = pd.read_excel('../Figure1/Figure1_data.xlsx', sheet_name = 'measuredProteomeTreGlcBatch')
measP_chxCtrl = pd.read_excel('../Figure1/Figure1_data.xlsx', sheet_name = 'measuredProteomeCHXctrl')

predictedCl = pd.DataFrame(columns = ['Pathway'] + list(predP.columns[3:]))
predictedCl.Pathway = mappings.Pathway.unique()
for i in predictedCl.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clusterPredicted = predP.loc[predP['Protein'].isin(clusterMapped['Protein'])]
	for j in predictedCl.columns[1:]:
		predictedCl.loc[predictedCl.Pathway == i, j] = sum(clusterPredicted[j])

measuredCl_chemostat = pd.DataFrame(columns = ['Pathway'] + list(measP_chemostat.columns[1:]))
measuredCl_chemostat.Pathway = mappings.Pathway.unique()
for i in measuredCl_chemostat.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clustermeasured = measP_chemostat.loc[measP_chemostat['Protein'].isin(clusterMapped['Protein'])]
	for j in measuredCl_chemostat.columns[1:]:
		measuredCl_chemostat.loc[measuredCl_chemostat.Pathway == i, j] = sum(clustermeasured[j])

measuredCl_batch = pd.DataFrame(columns = ['Pathway'] + list(measP_batch.columns[1:]))
measuredCl_batch.Pathway = mappings.Pathway.unique()
for i in measuredCl_batch.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clustermeasured = measP_batch.loc[measP_batch['Protein'].isin(clusterMapped['Protein'])]
	for j in measuredCl_batch.columns[1:]:
		measuredCl_batch.loc[measuredCl_batch.Pathway == i, j] = sum(clustermeasured[j])

measuredCl_chxCtrl = pd.DataFrame(columns = ['Pathway'] + list(measP_chxCtrl.columns[1:]))
measuredCl_chxCtrl.Pathway = mappings.Pathway.unique()
for i in measuredCl_chxCtrl.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clustermeasured = measP_chxCtrl.loc[measP_chxCtrl['Protein'].isin(clusterMapped['Protein'])]
	for j in measuredCl_chxCtrl.columns[1:]:
		measuredCl_chxCtrl.loc[measuredCl_chxCtrl.Pathway == i, j] = sum(clustermeasured[j])

clustersToPlot = ['Ribosome', 'Translation initiation factors', 'Translation elongation factors', 'Mitochondrial ribosome']

for i in zip(clustersToPlot, range(len(ax)), [0.30, 0.05, 0.03, 0.01]):
	ax[i[1]] = measuredCl_chemostat.set_index('Pathway').T[i[0]].plot(ax = ax[i[1]], ls='', color = color_scheme[0], marker='o', markeredgecolor = 'black', markersize = 9, label = 'Chemostat')
	ax[i[1]] = measuredCl_batch.set_index('Pathway').T[i[0]].plot(ax = ax[i[1]], ls='', color = color_scheme[0], marker='v', markeredgecolor = 'black', markersize = 9, label = 'Batch')
	ax[i[1]] = measuredCl_chxCtrl.set_index('Pathway').T[i[0]].plot(ax = ax[i[1]], ls='', color = color_scheme[0], marker='s', markeredgecolor = 'black', markersize = 9, label = 'CHX control')
	ax[i[1]] = predictedCl.set_index('Pathway').T[i[0]].plot(label = 'Model simulation', color = color_scheme[0], lw = 3.0, ax = ax[i[1]])
	ax[i[1]].set_title(i[0])
	ax[i[1]].set_ylim(0.0, i[2])
	ax[i[1]].set_xlabel(r'Growth rate ($h^{-1}$)')
	ax[i[1]].set_ylabel('Proteome fraction')



########### GENERAL
for i in range(len(ax)): 
	ax[i].set_xlim([0.0,0.5])
	ax[i].set_aspect(1./ax[i].get_data_ratio())

plt.savefig('FigureS1.pdf')
#plt.show()

