import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from matplotlib import gridspec

mpl.style.use('default')
plt.rcParams['font.size'] = '14'

fig = plt.figure(tight_layout = True, figsize = (12,6))

ax = fig.subplots(1,2)
ax = ax.ravel()

color_scheme = []
for i in range(0,3): 
	color = next(ax[0]._get_lines.prop_cycler)['color']
	color_scheme.append(color)

chemostatData = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'chemostatPred')
chemostatMeas = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'chemostatMeasured')

batchData = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'batchPred')
batchMeas = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'batchMeasured')

yields = pd.read_excel('../Figure4/Figure4_data.xlsx', sheet_name = 'yieldInfo')

########### Batch comparison
ax[0].set_title(r'Batch growth rate $\mu_{max}$')
labels = ['WT', r'$\Delta$Mae1', r'$\Delta$Adh3']

x = np.arange(len(labels))  # the label locations
width = 0.5  # the width of the bars

ax[0].bar(x, batchData['mu'], width, label = labels, edgecolor = 'black', color = color_scheme)
ax[0].scatter(x, batchMeas['mu'], label = None, edgecolors = 'black', color = color_scheme)
ax[0].set_xticks(x, labels, size = 10)
ax[0].set_ylabel(r'Growth rate ($h^{-1}$)')
ax[0].set_ylim(0.0, 0.35)

width = 0.25  # the width of the bars
ax[1].set_title('Growth yield on glucose')
labelsMu = [r'0.05 $h^{-1}$', r'0.1 $h^{-1}$', r'Batch']
labels_nosplit = ['WT', r'$\Delta$Mae1', r'$\Delta$Adh3']

fluxValues = yields.loc[yields['Limitation'] == 'C-limited']
for j in [['WT', -1.0, labels_nosplit[0]], ['dMae1', 0.0, labels_nosplit[1]], ['dAdh3_dGpd2', +1.0, labels_nosplit[2]]]:
	ax[1].bar(x + (j[1] * width), fluxValues['Yxs'].loc[fluxValues['Phenotype'] == j[0]], width, label = j[2], edgecolor = 'black', color = color_scheme[1 + int(j[1])])
	ax[1].scatter([(x + (j[1] * width * 1.05))], fluxValues['Yxs_experimental'].loc[fluxValues['Phenotype'] == j[0]].values, label = None, edgecolors = 'black', color = color_scheme[1 + int(j[1])])


ax[1].set_xticks(x, labelsMu, size = 10)
ax[1].set_ylabel(r'$Y_{X/S}$ ($gDW/g Glc$)')
ax[1].set_ylim(0.0,0.15)
ax[1].legend(fontsize = 'small')


########### GENERAL
for i in range(len(ax)): ax[i].set_aspect(1./ax[i].get_data_ratio())

plt.savefig('Figure5.pdf')
plt.show()

