import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from matplotlib import gridspec

fig = plt.figure(tight_layout = True, figsize = (16,8))

gs = gridspec.GridSpec(2,4)
gs_left = gridspec.GridSpecFromSubplotSpec(2,1, gs[0:2,0], hspace = 0.2)
gs_right = gridspec.GridSpecFromSubplotSpec(2,1, gs[0:2,2], hspace = 0.2)
#gs_middle = gridspec.GridSpecFromSubplotSpec(2,2, gs[0:2,2:4], wspace = 0.5, hspace = 0.5)


ax = list(range(4))

ax[0] = plt.subplot(gs_left[0,0])
ax[1] = plt.subplot(gs_left[1,0])
'''
ax[2] = plt.subplot(gs_middle[0,0])
ax[3] = plt.subplot(gs_middle[0,1])
ax[4] = plt.subplot(gs_middle[1,0])
ax[5] = plt.subplot(gs_middle[1,1])
'''
ax[2] = plt.subplot(gs_right[0,0])
ax[3] = plt.subplot(gs_right[1,0])

mpl.style.use('default')
plt.rcParams['font.size'] = '14'

color_scheme = []
for i in range(0,3): 
	color = next(ax[0]._get_lines.prop_cycler)['color']
	color_scheme.append(color)

pp_Clim = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_anaerobic_GAM40')
pp_Nlim = pd.read_excel('Figure4_data.xlsx', sheet_name = 'pp_Nlim_GAM40')

chemostatData = pd.read_excel('Figure4_data.xlsx', sheet_name = 'chemostatPred')
chemostatMeas = pd.read_excel('Figure4_data.xlsx', sheet_name = 'chemostatMeasured')

batchData = pd.read_excel('Figure4_data.xlsx', sheet_name = 'batchPred')
batchMeas = pd.read_excel('Figure4_data.xlsx', sheet_name = 'batchMeasured')

yields = pd.read_excel('Figure4_data.xlsx', sheet_name = 'yieldInfo')

########### Batch comparison
ax[0].set_title(r'Batch growth rate $\mu_{max}$')
labels = ['WT', r'$\Delta$Mae1', r'$\Delta$' + 'Adh3\n' + '$\Delta$Gpd2']

x = np.arange(len(labels))  # the label locations
width = 0.5  # the width of the bars

ax[0].bar(x, batchData['mu'], width, label = labels, edgecolor = 'black', color = color_scheme)
ax[0].scatter(x, batchMeas['mu'], label = None, edgecolors = 'black', color = color_scheme)
ax[0].set_xticks(x, labels, size = 10)
ax[0].set_ylabel(r'Growth rate ($h^{-1}$)')
ax[0].set_ylim(0.0, 0.35)

width = 0.25  # the width of the bars
ax[1].set_title('Growth yield on glucose')
labelsMu = [r'0.05 $h^{-1}$', r'0.1 $h^{-1}$', r'$\mu_{max}$']
labels_nosplit = ['WT', r'$\Delta$Mae1', r'$\Delta$Adh3 $\Delta$Gpd2']

fluxValues = yields.loc[yields['Limitation'] == 'C-limited']
for j in [['WT', -1.0, labels_nosplit[0]], ['dMae1', 0.0, labels_nosplit[1]], ['dAdh3_dGpd2', +1.0, labels_nosplit[2]]]:
	ax[1].bar(x + (j[1] * width), fluxValues['Yxs'].loc[fluxValues['Phenotype'] == j[0]], width, label = j[2], edgecolor = 'black', color = color_scheme[1 + int(j[1])])
	ax[1].scatter([(x + (j[1] * width * 1.05))], fluxValues['Yxs_experimental'].loc[fluxValues['Phenotype'] == j[0]].values, label = None, edgecolors = 'black', color = color_scheme[1 + int(j[1])])


ax[1].set_xticks(x, labelsMu, size = 10)
ax[1].set_ylabel(r'$Y_{X/S}$ ($gDW/g Glc$)')
ax[1].set_ylim(0.0,0.15)
ax[1].legend(fontsize = 'small')


########### C- vs N-limited
width = 0.25  # the width of the bars
ax[2].set_title(r'Fluxes for $D =$0.05 $h^{-1}$')
ax[3].set_title(r'Fluxes for $D =$0.1 $h^{-1}$')
fluxesToPlot = ['qGlc', 'qEtOH', 'qGlyc', 'qCO2']
labelsFluxes = [r'$q_{Glc}$', r'$q_{EtOH}$', r'$q_{Glyc}$', r'$q_{CO_{2}}$']
x = np.arange(len(labelsFluxes))  # the label locations

chemostatData = chemostatData[['Approx_mu', 'Limitation'] + fluxesToPlot].loc[chemostatData['Phenotype'] == 'WT']

for j in [['C-limited', -1.0, 0], ['N-limited', +1.0, 1]]:
	chData = chemostatData[chemostatData.columns[2:]].loc[(chemostatData['Limitation'] == j[0]) & (chemostatData['Approx_mu'] == 0.05)]
	ax[2].bar(x = list(x + (j[1] * width/2.0)), height = list(chData.T[chData.T.columns[0]]), width = width, edgecolor = 'black', color = color_scheme[j[2]], label = j[0])
	ax[2].scatter([x + (j[1] * width/2.0)], list(chemostatMeas[fluxesToPlot].loc[(chemostatMeas['Limitation'] == j[0]) & (chemostatMeas['Approx_mu'] == 0.05) & (chemostatMeas['Phenotype'] == 'WT')].values[0]), label = None, edgecolors = 'black', color = color_scheme[j[2]])
	chData = chemostatData[chemostatData.columns[2:]].loc[(chemostatData['Limitation'] == j[0]) & (chemostatData['Approx_mu'] == 0.1)]
	ax[3].bar(x = list(x + (j[1] * width/2.0)), height = list(chData.T[chData.T.columns[0]]), width = width, edgecolor = 'black', color = color_scheme[j[2]], label = j[0])
	ax[3].scatter([x + (j[1] * width/2.0)], list(chemostatMeas[fluxesToPlot].loc[(chemostatMeas['Limitation'] == j[0]) & (chemostatMeas['Approx_mu'] == 0.1) & (chemostatMeas['Phenotype'] == 'WT')].values[0]), label = None, edgecolors = 'black', color = color_scheme[j[2]])

ax[2].legend(fontsize = 'small')
for i in [2, 3]:
	ax[i].set_xticks(x, labelsFluxes, size = 10)
	ax[i].set_ylim(0.0,15.0)
	ax[i].set_ylabel(r'Specific flux ($mmol\ gDW^{-1}\ h^{-1}$')
	

########### GENERAL
for i in range(len(ax)): ax[i].set_aspect(1./ax[i].get_data_ratio())

plt.savefig('Figure4.pdf')
#plt.show()

