import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from matplotlib import gridspec

mpl.style.use('default')
plt.rcParams['font.size'] = '14'

fig = plt.figure(tight_layout = True, figsize = (10, 5))

ax = fig.subplots(1,2)
ax = ax.ravel()

pp_Clim_WT = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'pp_anaerobic_GAM40')
pp_Clim_dAdh3 = pd.read_excel('Figure4_data.xlsx', sheet_name = 'pp_Clim_GAM24_dAdh3_dGpd2')
AAmeasurements = pd.read_excel('../Figure2/Figure2_data.xlsx', sheet_name = 'experimentalData_anaerobic')

########### Plotting the fluxes
ax[0].set_title(r'WT, GAM = 40, UP$_{min}$ = 0.32')
ax[1].set_title(r'$\Delta Adh3$, naïve parameters')

for i in [['qGlc', r'$qGlc$'], ['qO2', r'$qO_{2}$'], ['qEtOH', r'$qEtOH$'], ['qCO2', r'$qCO_{2}$'], ['qGlyc', r'$qGlyc$']]:
	color = next(ax[0]._get_lines.prop_cycler)['color']
	ax[0] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CEN.PK'].plot(x = 'mu', y = i[0], ax = ax[0], ls='', c = color, marker='o', markeredgecolor = 'black', markersize = 9, legend = None)
	ax[0] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CBS8066'].plot(x = 'mu', y = i[0], ax = ax[0], ls='', c = color, marker='v', markeredgecolor = 'black', markersize = 9, legend = None, label = None)
	ax[1] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CEN.PK'].plot(x = 'mu', y = i[0], ax = ax[1], ls='', c = color, marker='o', markeredgecolor = 'black', markersize = 9, legend = None)
	ax[1] = AAmeasurements.loc[AAmeasurements['Strain'] == 'CBS8066'].plot(x = 'mu', y = i[0], ax = ax[1], ls='', c = color, marker='v', markeredgecolor = 'black', markersize = 9, legend = None, label = None)
	ax[0] = pp_Clim_WT.plot(x = 'mu', y = i[0], ax = ax[0], c = color, lw = 2.5, label = i[1])
	ax[1] = pp_Clim_dAdh3.plot(x = 'mu', y = i[0], ax = ax[1], c = color, lw = 2.5, legend = None)

h, l = ax[0].get_legend_handles_labels()
h = h[0:3] + h[6:]
l = l[0:3] + l[6:]
ax[0].legend(handles=zip(h[0::3], h[1::3]), labels=l[2::3], handler_map = {tuple: mpl.legend_handler.HandlerTuple(None)}, title = 'Flux', fontsize = 'medium')

########### GENERAL
for i in range(len(ax)): 
	ax[i].set_xlim(0.0,0.4)
	ax[i].set_ylim(0.0,30.0)
	ax[i].set_aspect(1./ax[i].get_data_ratio())
	ax[i].set_xlabel(r'Growth rate ($h^{-1}$)')
	ax[i].set_ylabel('Specific flux ($mmol\ gDW^{-1}\ h^{-1}$)')

plt.savefig('Figure4.pdf')
#plt.show()
