import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
from matplotlib import rc
from matplotlib import gridspec

plt.rcParams['font.size'] = '14'
fig = plt.figure(tight_layout = True, figsize = (12,9))

gs = gridspec.GridSpec(2,2)
gs_main = gridspec.GridSpecFromSubplotSpec(1,1, gs[0,0], wspace = 0.2)
gs_ribo = gridspec.GridSpecFromSubplotSpec(2,2, gs[0,1], wspace = 0.5, hspace = 0.5)
gs_prot = gridspec.GridSpecFromSubplotSpec(1,4, gs[1,0:2], wspace = 0.5)

ax = list(range(9))

ax[0] = plt.subplot(gs_main[0,0])

ax[1] = plt.subplot(gs_ribo[0,0])
ax[2] = plt.subplot(gs_ribo[0,1])
ax[3] = plt.subplot(gs_ribo[1,0])
ax[4] = plt.subplot(gs_ribo[1,1])

ax[5] = plt.subplot(gs_prot[0,0])
ax[6] = plt.subplot(gs_prot[0,1])
ax[7] = plt.subplot(gs_prot[0,2])
ax[8] = plt.subplot(gs_prot[0,3])

mpl.style.use('default')

pp_aerobic = pd.read_excel('Figure3_data.xlsx', sheet_name = 'physiologicalParameters_aerobic')
pp_anaerobic = pd.read_excel('Figure3_data.xlsx', sheet_name = 'pp_anaerobic')

color_scheme = []
for i in range(0,2): 
	color = next(ax[0]._get_lines.prop_cycler)['color']
	color_scheme.append(color)

xref = [0.3,0.5]
yref = [0.3,0.5]
ax[0].plot(xref, yref, color = 'black', lw = 1.0, ls = 'dashed')

for i in pp_aerobic.index:
	ax[0].scatter(pp_aerobic['experimentalMu'][i], pp_aerobic['mu'][i], marker='o', color = color_scheme[i], edgecolors = 'black', s = 81, label = 'Aerobic')
	ax[0].scatter(pp_anaerobic['experimentalMu'][i], pp_anaerobic['mu24'][i], marker='v', color = color_scheme[i], edgecolors = 'black', s = 81, label = 'Anaerobic')
	ax[0].scatter(pp_anaerobic['experimentalMu'][i], pp_anaerobic['mu'][i], marker='v', color = 'grey', edgecolors = 'black', s = 81, label = 'Anaerobic GAM = 40')

h, l = ax[0].get_legend_handles_labels()

ax[0].legend(handles=zip(h[0:3], h[3:6]), labels=['Aerobic', 'Anaerobic', 'Anaerobic GAM = 40'], 
	handler_map = {tuple: mpl.legend_handler.HandlerTuple(None)}, 
	title = 'Condition', fontsize = 'large')

########### PROTEOME
mappings = pd.read_excel('/home/pranas/SURFdrive/MEmodels/data/PG_annotations/AnnotationSetPG.xls', sheet_name = 'S. cerevisiae')

predP = pd.read_excel('Figure3_data.xlsx', sheet_name = 'predictedProteome')
measP = pd.read_excel('Figure3_data.xlsx', sheet_name = 'measuredProteome')
measP = measP.fillna(0)

predictedCl = pd.DataFrame(columns = ['Pathway'] + list(predP.columns[3:]))
predictedCl.Pathway = mappings.Pathway.unique()
for i in predictedCl.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clusterPredicted = predP.loc[predP['Protein'].isin(clusterMapped['Protein'])]
	for j in predictedCl.columns[1:]:
		predictedCl.loc[predictedCl.Pathway == i, j] = sum(clusterPredicted[j])

measuredCl = pd.DataFrame(columns = ['Pathway'] + list(measP.columns[3:]))
measuredCl.Pathway = mappings.Pathway.unique()
for i in measuredCl.Pathway:
	clusterMapped = mappings.loc[mappings['Pathway'] == i]
	clustermeasured = measP.loc[measP['Gene'].isin(clusterMapped['Protein'])]
	for j in measuredCl.columns[1:]:
		measuredCl.loc[measuredCl.Pathway == i, j] = sum(clustermeasured[j])

clustersToPlot = ['Ribosome', 'Translation initiation factors', 'Translation elongation factors', 'Ribosome assembly factors', 'Amino acid biosynthesis', 'Glycolysis', 'TCA cycle', 'Pentose phosphate pathway']

labels = ['Aerobic', 'Anaerobic']
x = np.arange(len(labels))  # the label locations
width = 0.35  # the width of the bars

for i in zip(clustersToPlot, range(1,9), [0.4, 0.03, 0.12, 0.03, 0.1, 0.25, 0.01, 0.02]):
	for j in [['Min', -1.0, 0], ['Rich', +1.0, 1]]:
		predCluster = predictedCl[[x for x in predictedCl.columns if x.find(j[0]) >= 0]].loc[predictedCl['Pathway'] == i[0]]
		measCluster = measuredCl[[x for x in measuredCl.columns if x.find(j[0]) >= 0]].loc[measuredCl['Pathway'] == i[0]]
		ax[i[1]].bar(x + (j[1] * width/2.0), predCluster.values.tolist()[0], width, label = j[0], edgecolor = 'black')
		for k in [['_aerobic', 0], ['_anaerobic', 1]]:
			mC = measCluster[[x for x in measCluster.columns if x.find(k[0]) >= 0]]
			ax[i[1]].scatter([(x + (j[1] * width/2.0))[k[1]]] * len(mC.columns), mC.values.tolist()[0], label = None, color = color_scheme[j[2]], edgecolors = 'black')
	ax[i[1]].set_xticks(x, labels)
	ax[i[1]].set_title(i[0])
	ax[i[1]].axvline(0.5, lw = 1.0, color = 'grey')
	ax[i[1]].set_ylabel('Proteome fraction')
	ax[i[1]].set_ylim(0.0, i[2])

########### GENERAL
ax[0].set_xlabel(r'Experimental growth rate ($h^{-1}$)')
ax[0].set_ylabel(r'Predicted growth rate ($h^{-1}$)')
ax[0].set_xlim(0.3,0.5)
ax[0].set_ylim(0.3,0.5)
ax[0].set_xticks(np.arange(0.3,0.51,0.05))
ax[0].set_yticks(np.arange(0.3,0.51,0.05))

ax[3].set_yticks(np.arange(0.0,0.125,0.04))

for i in [6,7]: ax[i].legend()

for i in range(len(ax)): ax[i].set_aspect(1./ax[i].get_data_ratio())

plt.savefig('Figure3.pdf')
#plt.show()

